/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.cataloggen.servlet.CatGenServletConfig;
import thredds.cataloggen.servlet.CatGenTimerTask;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DataRootHandler;
import thredds.servlet.ServletUtil;

public class CatGenServlet
extends AbstractServlet {
    private String configFileName;
    private File catGenContentPath;
    private File catGenConfigPath;
    private File catGenResultPath;
    private File catGenStaticContentPath;
    private String servletName = "cataloggen";
    private String catGenDocDirName = "doc";
    private String catGenConfigDirName = "config";
    private String catGenResultCatalogsDirName = "catalogs";
    private String adminPath = "/admin";
    private String adminAddTaskPath = "/admin/addTask";
    private String adminEditTaskPath = "/admin/editTask-";
    private String adminDeleteTaskPath = "/admin/deleteTask-";
    private String adminDoAddTaskPath = "/admin/doAddTask";
    private String adminDoEditTaskPath = "/admin/doEditTask-";
    private String adminDoDeleteTaskPath = "/admin/doDeleteTask-";
    private CatGenServletConfig mainConfig = null;

    protected String getPath() {
        return this.servletName + "/";
    }

    protected void makeDebugActions() {
    }

    public void init() throws ServletException {
        super.init();
        this.catGenStaticContentPath = new File(this.rootPath, this.servletName);
        this.catGenContentPath = new File(this.contentPath);
        this.catGenConfigPath = new File(this.catGenContentPath, this.catGenConfigDirName);
        this.catGenResultPath = new File(this.catGenContentPath, this.catGenResultCatalogsDirName);
        this.configFileName = this.getInitParameter("configFile");
        this.log.debug("init(): CatGen static content path = " + this.catGenStaticContentPath.toString());
        this.log.debug("init(): CatGen content path = " + this.catGenContentPath.toString());
        this.log.debug("init(): CatGen config path = " + this.catGenConfigPath.toString());
        this.log.debug("init(): CatGenServlet config file = " + this.configFileName);
        this.log.debug("init(): CatGen result path = " + this.catGenResultPath.toString());
        try {
            this.mainConfig = new CatGenServletConfig(this.catGenResultPath, this.catGenConfigPath, this.configFileName);
        }
        catch (IOException e) {
            String tmpMsg = "Reading config file failed";
            this.log.error("init(): " + tmpMsg, (Throwable)e);
            throw new ServletException(tmpMsg + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        this.log.debug("destroy()");
        this.mainConfig.cancelTimer();
        super.destroy();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        String path = req.getPathInfo();
        this.log.info("doGet(): path = " + path);
        PrintWriter out = null;
        if (path == null) {
            res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + req.getServletPath() + "/"));
            ServletUtil.logServerAccess(301, 0L);
            return;
        }
        if (path.equals("/")) {
            out = res.getWriter();
            res.setContentType("text/html");
            res.setStatus(200);
            String resString = this.getHtmlRootRequest(req);
            out.print(resString);
            ServletUtil.logServerAccess(200, resString.length());
            return;
        }
        if (path.startsWith("/" + this.catGenDocDirName + "/") || path.startsWith("/" + this.catGenConfigDirName + "/") || path.startsWith("/" + this.catGenResultCatalogsDirName + "/")) {
            if (DataRootHandler.getInstance().processReqForCatalog(req, res)) {
                return;
            }
            this.doGetFiles(path, req, res);
            return;
        }
        if (path.startsWith(this.adminPath)) {
            this.doGetHtmlUI(path, req, res);
            return;
        }
        String tmpMsg = "Request not understood(" + path + ").";
        this.log.debug("doGet(): " + tmpMsg);
        out = res.getWriter();
        res.setContentType("text/html");
        res.setStatus(200);
        String responseString = this.getHtmlReturnMessage(req, tmpMsg);
        out.print(responseString);
        ServletUtil.logServerAccess(200, responseString.length());
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        File tmpFile = null;
        String tmpMsg = null;
        String path = req.getPathInfo();
        if (path != null) {
            if (path.startsWith("/" + this.catGenConfigDirName + "/")) {
                tmpFile = new File(this.catGenContentPath, path);
                this.log.debug("doPut(): putting CatGenConfig file - " + path);
                if (path.equals("/" + this.catGenConfigDirName + "/" + this.configFileName)) {
                    if (ServletUtil.saveFile(this, this.catGenContentPath.getAbsolutePath(), path, req, res)) {
                        this.mainConfig.cancelTimer();
                        try {
                            this.mainConfig = new CatGenServletConfig(this.catGenResultPath, this.catGenConfigPath, this.configFileName);
                            res.setStatus(200);
                            ServletUtil.logServerAccess(200, 0L);
                            return;
                        }
                        catch (IOException e) {
                            tmpMsg = "Reading config file failed";
                            String tmpMsg2 = tmpMsg + ": " + e.getMessage();
                            this.log.error("doPut(): " + tmpMsg, (Throwable)e);
                            res.sendError(202, tmpMsg2);
                            ServletUtil.logServerAccess(202, tmpMsg2.length());
                            return;
                        }
                    }
                    tmpMsg = "Failed to save file <" + path + ">";
                    this.log.error("doPut(): " + tmpMsg);
                    res.sendError(500, tmpMsg);
                    ServletUtil.logServerAccess(500, tmpMsg.length());
                    return;
                }
                boolean creatingNewFile = true;
                if (tmpFile.exists()) {
                    creatingNewFile = false;
                }
                if (ServletUtil.saveFile(this, this.catGenContentPath.getAbsolutePath(), path, req, res)) {
                    this.log.debug("doPut(): file saved <" + path + ">.");
                    this.mainConfig.notifyNewConfigDoc(tmpFile.getName());
                    if (creatingNewFile) {
                        res.setStatus(201);
                        ServletUtil.logServerAccess(201, 0L);
                        return;
                    }
                    res.setStatus(200);
                    ServletUtil.logServerAccess(200, 0L);
                    return;
                }
                tmpMsg = "Failed to save file <" + path + ">";
                this.log.error("doPut(): " + tmpMsg);
                res.sendError(500, tmpMsg);
                ServletUtil.logServerAccess(500, tmpMsg.length());
                return;
            }
            tmpMsg = "Cannot PUT a document outside the " + this.catGenConfigDirName + "directory";
            this.log.warn("doPut(): " + tmpMsg);
            res.sendError(404, tmpMsg);
            ServletUtil.logServerAccess(404, tmpMsg.length());
            return;
        }
        tmpMsg = "Cannot PUT a document here (empty request path)";
        this.log.warn("doPut(): " + tmpMsg);
        res.sendError(404, tmpMsg);
        ServletUtil.logServerAccess(404, tmpMsg.length());
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        String path = req.getPathInfo();
        PrintWriter out = null;
        if (path != null) {
            if (path.equals(this.adminDoAddTaskPath)) {
                this.log.debug("doPost(): adding Task.");
                CatGenTimerTask newTask = new CatGenTimerTask(req.getParameter("taskName"), req.getParameter("fileName"), req.getParameter("resultFileName"), Integer.parseInt(req.getParameter("period")), Integer.parseInt(req.getParameter("delay")));
                newTask.init(this.catGenResultPath, this.catGenConfigPath);
                StringBuffer messages = new StringBuffer();
                if (newTask.isValid(messages)) {
                    this.log.debug("doPost():     task is valid - " + messages.toString());
                    if (this.mainConfig.addTask(newTask)) {
                        this.log.debug("doPost():     task added.");
                        out = res.getWriter();
                        res.setContentType("text/html");
                        String resMsg = this.getHtmlAddTaskResultSuccess(req, newTask, messages);
                        res.setStatus(200);
                        out.print(resMsg);
                        ServletUtil.logServerAccess(200, resMsg.length());
                        return;
                    }
                    this.log.debug("doPost():     duplicate task.");
                    out = res.getWriter();
                    res.setContentType("text/html");
                    String resMsg = this.getHtmlAddTaskResultDuplicate(req, newTask, messages);
                    res.setStatus(200);
                    out.print(resMsg);
                    ServletUtil.logServerAccess(200, resMsg.length());
                    return;
                }
                this.log.debug("doPost():     task is invalid - " + messages.toString());
                out = res.getWriter();
                res.setContentType("text/html");
                String resMsg = this.getHtmlAddTaskResultInvalid(req, newTask, messages);
                res.setStatus(200);
                out.print(resMsg);
                ServletUtil.logServerAccess(200, resMsg.length());
                return;
            }
            if (path.startsWith(this.adminDoEditTaskPath)) {
                String taskIdConfigDocName = path.substring(path.indexOf(this.adminDoEditTaskPath) + this.adminDoEditTaskPath.length());
                this.log.debug("doPost(): editing Task - " + taskIdConfigDocName);
                CatGenTimerTask oldTask = this.mainConfig.findTaskByConfigDocName(taskIdConfigDocName);
                this.mainConfig.removeTask(oldTask);
                CatGenTimerTask newTask = new CatGenTimerTask(req.getParameter("taskName"), req.getParameter("fileName"), req.getParameter("resultFileName"), Integer.parseInt(req.getParameter("period")), Integer.parseInt(req.getParameter("delay")));
                newTask.init(this.catGenResultPath, this.catGenConfigPath);
                StringBuffer messages = new StringBuffer();
                if (newTask.isValid(messages)) {
                    if (this.mainConfig.addTask(newTask)) {
                        this.log.debug("doPost(): task added (" + newTask.getName() + ").");
                        out = res.getWriter();
                        res.setContentType("text/html");
                        String resMsg = this.getHtmlEditTaskResultSuccess(req, oldTask, newTask, messages);
                        res.setStatus(200);
                        out.print(resMsg);
                        ServletUtil.logServerAccess(200, resMsg.length());
                        return;
                    }
                    this.log.debug("doPost(): no task added, duplicate (" + newTask.getName() + ").");
                    out = res.getWriter();
                    res.setContentType("text/html");
                    String resMsg = this.getHtmlEditTaskResultDuplicate(req, oldTask, newTask, messages);
                    res.setStatus(200);
                    out.print(resMsg);
                    ServletUtil.logServerAccess(200, resMsg.length());
                    return;
                }
                this.log.debug("doPost(): no task added, invalid (" + newTask.getName() + ").");
                out = res.getWriter();
                res.setContentType("text/html");
                String resMsg = this.getHtmlEditTaskResultInvalid(req, oldTask, newTask, messages);
                res.setStatus(200);
                out.print(resMsg);
                ServletUtil.logServerAccess(200, resMsg.length());
                return;
            }
            if (path.startsWith(this.adminDoDeleteTaskPath)) {
                String fileName = path.substring(path.indexOf(this.adminDoDeleteTaskPath) + this.adminDoDeleteTaskPath.length());
                this.log.debug("doPost(): deleteing Task - " + fileName);
                CatGenTimerTask oldTask = this.mainConfig.findTaskByConfigDocName(fileName);
                if (oldTask == null) {
                    this.log.debug("doPost(): task to delete not in list (" + fileName + ").");
                    out = res.getWriter();
                    res.setContentType("text/html");
                    String resMsg = this.getHtmlReturnMessage(req, "Task to delete not in list (" + fileName + ")");
                    res.setStatus(200);
                    out.print(resMsg);
                    ServletUtil.logServerAccess(200, resMsg.length());
                    return;
                }
                if (this.mainConfig.removeTask(oldTask)) {
                    this.log.debug("doPost(): task deleted (" + oldTask.getName() + ").");
                    out = res.getWriter();
                    res.setContentType("text/html");
                    String resMsg = this.getHtmlDeleteTaskResultSuccess(req, oldTask);
                    res.setStatus(200);
                    out.print(resMsg);
                    ServletUtil.logServerAccess(200, resMsg.length());
                    return;
                }
                this.log.debug("doPost(): failed to delete task (" + oldTask.getName() + ").");
                out = res.getWriter();
                res.setContentType("text/html");
                String resMsg = this.getHtmlDeleteTaskResultFail(req, oldTask);
                res.setStatus(200);
                out.print(resMsg);
                ServletUtil.logServerAccess(200, resMsg.length());
                return;
            }
        }
        this.log.debug("doPost(): no path given for POST.");
        out = res.getWriter();
        res.setContentType("text/html");
        String resMsg = this.getHtmlReturnMessage(req, "No path given for POST action.");
        res.setStatus(200);
        out.print(resMsg);
        ServletUtil.logServerAccess(200, resMsg.length());
    }

    private void doGetFiles(String path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String tmpMsg = null;
        File tmpFile = null;
        String fileType = null;
        if (path.startsWith("/" + this.catGenDocDirName + "/")) {
            tmpFile = new File(this.catGenStaticContentPath, path);
        } else if (path.startsWith("/" + this.catGenConfigDirName + "/")) {
            tmpFile = new File(this.catGenContentPath, path);
        } else if (path.startsWith("/" + this.catGenResultCatalogsDirName + "/")) {
            tmpFile = new File(this.catGenContentPath, path);
        } else {
            tmpMsg = "Illegal request <" + path + "> (doGet() should not have passed in the request).";
            this.log.debug("doGetFiles(): " + tmpMsg);
            res.sendError(400, tmpMsg);
            ServletUtil.logServerAccess(400, tmpMsg.length());
            return;
        }
        if (tmpFile.exists() && tmpFile.isFile()) {
            this.log.debug("doGetFiles(): sending file <" + tmpFile.getName() + "> in directory <" + tmpFile.getParent() + "> to returnFile()");
            ServletUtil.returnFile(this, tmpFile.getParent(), tmpFile.getName(), req, res, fileType);
            return;
        }
        tmpMsg = "doGetFiles(): Requested file does not exist or is a directory <" + path + ">";
        this.log.debug(tmpMsg);
        res.sendError(404, tmpMsg);
        ServletUtil.logServerAccess(404, tmpMsg.length());
    }

    private void doGetHtmlUI(String path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        PrintWriter out = null;
        if (path.equals(this.adminPath + "/")) {
            this.log.debug("doGetHtmlUI(): listing all tasks");
            out = res.getWriter();
            res.setContentType("text/html");
            String responseString = this.getHtmlListTasks(req, this.mainConfig);
            res.setStatus(200);
            out.print(responseString);
            ServletUtil.logServerAccess(200, responseString.length());
            return;
        }
        if (!path.equals(this.adminPath)) {
            if (path.startsWith(this.adminEditTaskPath)) {
                String fileName = path.substring(path.indexOf(this.adminEditTaskPath) + this.adminEditTaskPath.length());
                this.log.debug("doGetHtmlUI(): edit task - " + fileName);
                CatGenTimerTask task = this.mainConfig.findTaskByConfigDocName(fileName);
                out = res.getWriter();
                res.setContentType("text/html");
                String responseString = this.getHtmlEditTask(req, task);
                res.setStatus(200);
                out.print(responseString);
                ServletUtil.logServerAccess(200, responseString.length());
                return;
            }
            if (path.equals(this.adminAddTaskPath)) {
                this.log.debug("doGetHtmlUI(): add task");
                out = res.getWriter();
                res.setContentType("text/html");
                String responseString = this.getHtmlAddTask(req);
                res.setStatus(200);
                out.print(responseString);
                ServletUtil.logServerAccess(200, responseString.length());
                return;
            }
            if (path.startsWith(this.adminDeleteTaskPath)) {
                String fileName = path.substring(path.indexOf(this.adminDeleteTaskPath) + this.adminDeleteTaskPath.length());
                this.log.debug("doGetHtmlUI(): delete task - " + fileName);
                CatGenTimerTask task = this.mainConfig.findTaskByConfigDocName(fileName);
                this.log.debug("doGetHtmlUI(): return form for editing task - \"" + task.getName() + "\".");
                out = res.getWriter();
                res.setContentType("text/html");
                String responseString = this.getHtmlDeleteTask(req, task);
                res.setStatus(200);
                out.print(responseString);
                ServletUtil.logServerAccess(200, responseString.length());
                return;
            }
            String tmpMsg = "Request <" + path + "> not understood";
            this.log.error("doGetHtmlUI(): " + tmpMsg);
            res.sendError(404, tmpMsg);
            ServletUtil.logServerAccess(404, tmpMsg.length());
            return;
        }
        res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + req.getServletPath() + this.adminPath + "/"));
        ServletUtil.logServerAccess(301, 0L);
    }

    public String getHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n").toString();
    }

    public String getXHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n").append("        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">").toString();
    }

    private String getHtmlRootRequest(HttpServletRequest req) {
        this.log.debug("htmlRootRequest(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet</h1>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlReturnMessage(HttpServletRequest req, String message) {
        this.log.debug("getHtmlReturnMessage(): start (" + message + ")");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet</h1>\n");
        retValue.append("<p>\n");
        retValue.append(message);
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlListTasks(HttpServletRequest req, CatGenServletConfig config) {
        this.log.debug("htmlListTasks(): starting");
        StringBuffer retVal = new StringBuffer();
        retVal.append(this.getHtmlDoctypeAndOpenTag());
        retVal.append("<head><title>Catalog Generator Servlet Config</title></head>\n");
        retVal.append("<body>\n");
        retVal.append("<h1>Catalog Generator Servlet Config</h1>\n");
        retVal.append("<hr>\n");
        retVal.append("<h2>Currently Scheduled Tasks</h2>\n");
        retVal.append("<table border=\"1\">\n");
        retVal.append("<tr>\n");
        retVal.append("<th> Task Name</th>\n");
        retVal.append("<th> Configuration Document</th>\n");
        retVal.append("<th>\n");
        retVal.append("Resulting Catalog\n");
        retVal.append("</th>\n");
        retVal.append("<th> Period (minutes)</th>\n");
        retVal.append("<th> Initial Delay (minutes)</th>\n");
        retVal.append("<th> Edit/Delete Task</th>\n");
        retVal.append("</tr>\n");
        CatGenTimerTask curTask = null;
        Iterator iter = config.getUnmodTaskIterator();
        while (iter.hasNext()) {
            curTask = (CatGenTimerTask)iter.next();
            retVal.append("<tr>\n");
            retVal.append("<td>").append(curTask.getName()).append("</td>\n");
            retVal.append("<td> <a href=\"").append(req.getContextPath()).append(req.getServletPath()).append("/").append(this.catGenConfigDirName).append("/").append(curTask.getConfigDocName()).append("\">").append(curTask.getConfigDocName()).append("</a></td>\n");
            retVal.append("<td> <a href=\"").append(req.getContextPath()).append(req.getServletPath()).append("/").append(this.catGenResultCatalogsDirName).append("/").append(curTask.getResultFileName()).append("\">").append(curTask.getResultFileName()).append("</a></td>\n");
            retVal.append("</td>\n");
            retVal.append("<td>").append(curTask.getPeriodInMinutes()).append("</td>\n");
            retVal.append("<td>").append(curTask.getDelayInMinutes()).append("</td>\n");
            retVal.append("<td>\n");
            retVal.append("[<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminEditTaskPath).append(curTask.getConfigDocName()).append("\">Edit</a>][<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminDeleteTaskPath).append(curTask.getConfigDocName()).append("\">Delete</a>]\n");
            retVal.append("</td>\n");
            retVal.append("</tr>\n");
        }
        retVal.append("</table>\n");
        retVal.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminAddTaskPath).append("\">Add a new task</a>\n");
        retVal.append("<hr>\n");
        retVal.append("<p>Note: If period is zero (0), the task will not be scheduled to run.</p>\n");
        retVal.append("<hr>\n");
        retVal.append("</body>\n");
        retVal.append("</html>");
        return retVal.toString();
    }

    private String getHtmlEditTask(HttpServletRequest req, CatGenTimerTask task) {
        this.log.debug("htmlEditTask(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Edit Task</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Edit Task</h1>\n");
        retValue.append("<hr>\n");
        retValue.append(this.getHtmlEditForm(req, task));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTask(HttpServletRequest req) {
        this.log.debug("htmlAddTask(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Add Task</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Add Task</h1>\n");
        retValue.append("<hr>\n");
        retValue.append(this.getHtmlAddForm(req, null));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlDeleteTask(HttpServletRequest req, CatGenTimerTask task) {
        this.log.debug("getHtmlDeleteTask(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Delete Task</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Delete Task</h1>\n");
        retValue.append("<hr>\n");
        retValue.append("<form method=\"POST\" action=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminDoDeleteTaskPath).append(task.getConfigDocName()).append("\">\n");
        retValue.append("<h2>Task to Delete</h2>\n");
        retValue.append(this.getHtmlListTable(task));
        retValue.append("<p>\n");
        retValue.append("To delete this task, click on the \"Submit\" button.\n");
        retValue.append("To stop this task but not delete it, <a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminEditTaskPath).append(task.getConfigDocName()).append("\">edit the task</a> and set \n");
        retValue.append("the value of \"Period\" to zero.\n");
        retValue.append("</p>\n");
        retValue.append("<input type=\"submit\" value=\"Submit\">\n");
        retValue.append("</form>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlEditTaskResultDuplicate(HttpServletRequest req, CatGenTimerTask oldTask, CatGenTimerTask newTask, StringBuffer messages) {
        this.log.debug("htmlEditTaskResultDuplicate(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Edit Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Edit Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Resulting task is duplicate (in name and/or config doc name)\n");
        retValue.append("of a different existing task. Change the task below and\n");
        retValue.append("try adding again, or go back to the\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/").append("\">list of tasks (minus this task)</a>.\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlEditTaskResultInvalid(HttpServletRequest req, CatGenTimerTask oldTask, CatGenTimerTask newTask, StringBuffer messages) {
        this.log.debug("htmlEditTaskResultInvalid(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Edit Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Edit Results</h1>\n");
        retValue.append("<p>Resulting task is invalid.</p>\n");
        retValue.append("<p>Message: ").append(messages.toString()).append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("Change the task below and");
        retValue.append("try adding it again, or go back to the");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/").append("\">list of tasks (minus this task)</a>.\n");
        retValue.append("To keep this task and edit the configuration, change the period to zero (0).\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>\n");
        return retValue.toString();
    }

    private String getHtmlEditTaskResultSuccess(HttpServletRequest req, CatGenTimerTask oldTask, CatGenTimerTask newTask, StringBuffer messages) {
        this.log.debug("htmlEditTaskResultSuccess(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Edit Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Edit Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Task Successfully edited.\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/").append("\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTaskResultDuplicate(HttpServletRequest req, CatGenTimerTask newTask, StringBuffer messages) {
        this.log.debug("htmlAddTaskResultDuplicate(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Add Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Add Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Resulting task is a duplicate (in name and/or config doc name)\n");
        retValue.append("of a different existing task. Change the task below and\n");
        retValue.append("try adding it again, or go back to the\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/\">list of current tasks</a>.\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTaskResultInvalid(HttpServletRequest req, CatGenTimerTask newTask, StringBuffer messages) {
        this.log.debug("htmlAddTaskResultInvalid(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Add Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Add Results</h1>\n");
        retValue.append("<p>Resulting task is invalid.</p>\n");
        retValue.append("<p>Message: ").append(messages.toString()).append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("Change the task below and\n");
        retValue.append("try adding it again, or go back to the\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/\">list of tasks (minus this task)</a>.\n");
        retValue.append("To keep this task and edit the configuration, change the period to zero (0).\n");
        retValue.append("</p>\n");
        retValue.append(this.getHtmlAddForm(req, newTask));
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddTaskResultSuccess(HttpServletRequest req, CatGenTimerTask newTask, StringBuffer messages) {
        this.log.debug("htmlAddTaskResultSuccess(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Add Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Add Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Task Successfully added.\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlDeleteTaskResultFail(HttpServletRequest req, CatGenTimerTask oldTask) {
        this.log.debug("htmlDeleteTaskResultFail(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Delete Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Delete Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Deletion of task failed. (This shouldn't happen! We found\n");
        retValue.append("the task in the list so we should be able to remove it)\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlDeleteTaskResultSuccess(HttpServletRequest req, CatGenTimerTask oldTask) {
        this.log.debug("htmlDeleteTaskResultSuccess(): start");
        StringBuffer retValue = new StringBuffer();
        retValue.append(this.getHtmlDoctypeAndOpenTag());
        retValue.append("<head><title>Catalog Generator Servlet - Task Delete Results</title></head>\n");
        retValue.append("<body>\n");
        retValue.append("<h1>Catalog Generator Servlet - Task Delete Results</h1>\n");
        retValue.append("<p>\n");
        retValue.append("Task Successfully deleted.\n");
        retValue.append("</p>\n");
        retValue.append("<p>\n");
        retValue.append("<a href=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminPath).append("/\">List Current Tasks</a>\n");
        retValue.append("</p>\n");
        retValue.append("</body>\n");
        retValue.append("</html>");
        return retValue.toString();
    }

    private String getHtmlAddForm(HttpServletRequest req, CatGenTimerTask task) {
        StringBuffer buf = new StringBuffer();
        this.log.debug("getHtmlAddForm(): start");
        String taskName = "";
        String taskConfigDocName = "";
        String taskResultFileName = "";
        String taskPeriodInMinutes = "";
        String taskDelayInMinutes = "";
        if (task != null) {
            taskName = task.getName();
            taskConfigDocName = task.getConfigDocName();
            taskResultFileName = task.getResultFileName();
            taskPeriodInMinutes = Integer.toString(task.getPeriodInMinutes());
            taskDelayInMinutes = Integer.toString(task.getDelayInMinutes());
        }
        buf.append("<form method=\"POST\" action=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminDoAddTaskPath).append("\">").append("\n");
        buf.append("<h2>Task to Add</h2>").append("\n");
        buf.append("<table border=\"1\">").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Task Name</th>").append("\n");
        buf.append("<td> <input name=\"taskName\" size=\"40\" value=\"").append(taskName).append("\"></td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Configuration Document</th>").append("\n");
        buf.append("<td> <input name=\"fileName\" size=\"40\" value=\"").append(taskConfigDocName).append("\"></td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th>Resulting Catalog</th>").append("\n");
        buf.append("<td> <input name=\"resultFileName\" size=\"80\" value=\"").append(taskResultFileName).append("\"></td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Period (minutes)</th>").append("\n");
        buf.append("<td> <input name=\"period\" size=\"10\" value=\"").append(taskPeriodInMinutes).append("\"></td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Initial Delay (minutes)</th>").append("\n");
        buf.append("<td> <input name=\"delay\" size=\"10\" value=\"").append(taskDelayInMinutes).append("\"></td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("</table>").append("\n");
        buf.append("<input type=\"submit\" value=\"Submit\">").append("\n");
        buf.append("<input type=\"reset\" value=\"Reset Values\">").append("\n");
        buf.append("</form>").append("\n");
        return buf.toString();
    }

    private String getHtmlEditForm(HttpServletRequest req, CatGenTimerTask task) {
        StringBuffer buf = new StringBuffer();
        this.log.debug("getHtmlEditForm(): start");
        buf.append("<form method=\"POST\" action=\"").append(req.getContextPath()).append(req.getServletPath()).append(this.adminDoEditTaskPath).append(task.getConfigDocName()).append("\">\n");
        buf.append("<h2>Task to Edit</h2>\n");
        buf.append("<table border=\"1\">\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Task Name</th>\n");
        buf.append("<td> <input name=\"taskName\" size=\"40\" value=\"").append(task.getName()).append("\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Configuration Document</th>\n");
        buf.append("<td> <input name=\"fileName\" size=\"40\" value=\"").append(task.getConfigDocName()).append("\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th>Resultin Catalog</th>\n");
        buf.append("<td> <input name=\"resultFileName\" size=\"80\" value=\"").append(task.getResultFileName()).append("\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Period (minutes)</th>\n");
        buf.append("<td> <input name=\"period\" size=\"10\" value=\"").append(task.getPeriodInMinutes()).append("\"></td>\n");
        buf.append("</tr>\n");
        buf.append("<tr>\n");
        buf.append("<th> Initial Delay (minutes)</th>\n");
        buf.append("<td> <input name=\"delay\" size=\"10\" value=\"").append(task.getDelayInMinutes()).append("\"></td>\n");
        buf.append("</tr>\n");
        buf.append("</table>\n");
        buf.append("<input type=\"submit\" value=\"Submit\">\n");
        buf.append("<input type=\"reset\" value=\"Reset Values\">\n");
        buf.append("</form>\n");
        return buf.toString();
    }

    private String getHtmlListTable(CatGenTimerTask task) {
        StringBuffer buf = new StringBuffer();
        this.log.debug("getHtmlListTable(): start");
        buf.append("<table border=\"1\">").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Task Name</th>").append("\n");
        buf.append("<td>").append(task.getName()).append("</td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Configuration Document</th>").append("\n");
        buf.append("<td>").append(task.getConfigDocName()).append("</td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th>Resulting Catalog</th>").append("\n");
        buf.append("<td>").append(task.getResultFileName()).append("</td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Period (minutes)</th>").append("\n");
        buf.append("<td>").append(task.getPeriodInMinutes()).append("</td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("<tr>").append("\n");
        buf.append("<th> Initial Delay (minutes)</th>").append("\n");
        buf.append("<td>").append(task.getDelayInMinutes()).append("</td>").append("\n");
        buf.append("</tr>").append("\n");
        buf.append("</table>").append("\n");
        return buf.toString();
    }
}

