/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.cataloggen.servlet.CatGenTimerTask;

class CatGenServletConfig {
    private static Logger log = LoggerFactory.getLogger(CatGenServletConfig.class);
    private final File resultPath;
    private final File configPath;
    private final String servletConfigDocName;
    private final ConfigDocumentParser configDocParser;
    private List configTasks;
    private HashMap configTaskHash = new HashMap();
    private HashMap configTaskHashByConfigDocName = new HashMap();
    private Timer timer;

    CatGenServletConfig(File resultPath, File configPath, String servletConfigDocName) throws IOException {
        this.resultPath = resultPath;
        this.configPath = configPath;
        this.servletConfigDocName = servletConfigDocName;
        this.configDocParser = new ConfigDocumentParser();
        if (!this.resultPath.exists() && !this.resultPath.mkdirs()) {
            String tmpMsg = "Creation of results directory failed";
            log.error("CatGenServletConfig(): " + tmpMsg + " <" + this.resultPath.getAbsolutePath() + ">");
            throw new IOException(tmpMsg);
        }
        if (!this.configPath.exists() && !this.configPath.mkdirs()) {
            String tmpMsg = "Creation of config directory failed";
            log.error("CatGenServletConfig(): " + tmpMsg + " <" + this.configPath.getAbsolutePath() + ">");
            throw new IOException(tmpMsg);
        }
        File configFile = new File(this.configPath, this.servletConfigDocName);
        log.debug("CatGenServletConfig(): reading config file <" + configFile.getPath() + ">.");
        if (configFile.createNewFile()) {
            log.debug("CatGenServletConfig(): no config file exists, writing empty config file <" + configFile.getAbsolutePath() + ">.");
            this.configDocParser.writeXML(configFile, Collections.EMPTY_LIST);
        }
        this.configTasks = this.configDocParser.parseXML(configFile);
        this.timer = new Timer("CatGenServletConfig");
        if (this.configTasks == null) {
            log.error("CatGenServletConfig(): invalid config file.");
            this.configTasks = Collections.EMPTY_LIST;
        } else if (this.configTasks.isEmpty()) {
            log.debug("CatGenServletConfig(): task list empty");
        } else {
            log.debug("CatGenServletConfig(): at least one task in config file.");
            for (CatGenTimerTask curTask : this.configTasks) {
                curTask.init(this.resultPath, this.configPath);
                this.configTaskHash.put(curTask.getName(), curTask);
                this.configTaskHashByConfigDocName.put(curTask.getConfigDocName(), curTask);
                log.debug("CatGenServletConfig(): task name = " + curTask.getName());
                StringBuffer msg = new StringBuffer();
                if (!curTask.isValid(msg)) {
                    log.warn("ctor(): not scheduling invalid task <" + curTask.getName() + ">: " + msg.toString());
                    continue;
                }
                this.scheduleTask(curTask);
            }
        }
    }

    void cancelTimer() {
        this.timer.cancel();
    }

    String getServletConfigDocName() {
        return this.servletConfigDocName;
    }

    synchronized List getUnmodTasks() {
        return Collections.unmodifiableList(this.configTasks);
    }

    synchronized Iterator getUnmodTaskIterator() {
        List unModList = Collections.unmodifiableList(this.configTasks);
        return unModList.iterator();
    }

    synchronized CatGenTimerTask findTask(String taskName) {
        return (CatGenTimerTask)this.configTaskHash.get(taskName);
    }

    synchronized CatGenTimerTask findTaskByConfigDocName(String configDocName) {
        return (CatGenTimerTask)this.configTaskHashByConfigDocName.get(configDocName);
    }

    synchronized boolean addTask(CatGenTimerTask task) throws IOException {
        log.debug("addTask(): start.");
        if (task == null) {
            log.debug("addTask(): task to add is null.");
            return false;
        }
        if (this.findTask(task.getName()) != null) {
            log.debug("addTask(): task with same name alread exists (" + task.getName() + ").");
            return false;
        }
        if (this.findTaskByConfigDocName(task.getConfigDocName()) != null) {
            log.debug("addTask(): task with same config doc alread exists (" + task.getConfigDocName() + ").");
            return false;
        }
        task.init(this.resultPath, this.configPath);
        this.configTasks.add(task);
        this.configTaskHash.put(task.getName(), task);
        this.configTaskHashByConfigDocName.put(task.getConfigDocName(), task);
        this.writeConfig();
        log.debug("addTask(): added task <" + task.getName() + "> to config.");
        StringBuffer msg = new StringBuffer();
        if (!task.isValid(msg)) {
            log.warn("addTask(): invalid task <" + task.getName() + ">, not scheduling: " + msg.toString());
        } else {
            this.scheduleTask(task);
        }
        return true;
    }

    synchronized boolean removeTask(CatGenTimerTask task) throws IOException {
        log.debug("removeTask(): start.");
        if (this.findTask(task.getName()) != null) {
            this.unScheduleTask(task);
            this.configTaskHashByConfigDocName.remove(task.getConfigDocName());
            this.configTaskHash.remove(task.getName());
            this.configTasks.remove(task);
            this.writeConfig();
            log.debug("removeTask(): task removed (" + task.getName() + ").");
            return true;
        }
        log.debug("removeTask(): task not in list.");
        return false;
    }

    synchronized boolean removeTask(String taskName) throws IOException {
        return this.removeTask(this.findTask(taskName));
    }

    synchronized void notifyNewConfigDoc(String configDocName) {
        log.debug("notifyNewConfigDoc(): start.");
        CatGenTimerTask task = this.findTaskByConfigDocName(configDocName);
        if (task != null) {
            this.unScheduleTask(task);
            CatGenTimerTask newTask = new CatGenTimerTask(task);
            newTask.init(this.resultPath, this.configPath);
            StringBuffer msg = new StringBuffer();
            if (!newTask.isValid(msg)) {
                log.warn("notifyNewConfigDoc(): invalid task <" + newTask.getName() + ">, not scheduling: " + msg.toString());
            } else {
                this.scheduleTask(newTask);
            }
            log.debug("notifyNewConfigDoc(): done.");
        }
    }

    private synchronized boolean scheduleTask(CatGenTimerTask task) {
        log.debug("scheduleTask(): start.");
        if (task == null) {
            return false;
        }
        log.debug("scheduleTask(): start (" + task.getName() + ").");
        int periodInMillis = task.getPeriodInMinutes() * 60 * 1000;
        int delayInMins = task.getDelayInMinutes();
        log.debug("periodInMillis=" + periodInMillis + " - delayInMins=" + delayInMins + "");
        if (periodInMillis == 0) {
            log.debug("scheduleTask(): period set to zero, do not schedule.");
            return false;
        }
        log.debug("scheduleTask(): scheduling task.");
        Calendar cal = Calendar.getInstance();
        if (delayInMins != 0) {
            cal.add(12, delayInMins);
        }
        Date date = cal.getTime();
        this.timer.scheduleAtFixedRate(task.getTimerTask(), date, (long)periodInMillis);
        log.debug("scheduleTask(): task scheduled.");
        return true;
    }

    private synchronized boolean unScheduleTask(CatGenTimerTask task) {
        log.debug("unScheduleTask(): start: (" + task.getName() + ").");
        return task.getTimerTask().cancel();
    }

    void writeConfig() throws IOException {
        log.debug("writeConfig(): start.");
        File configFile = new File(this.configPath, this.servletConfigDocName);
        if (!configFile.canWrite()) {
            log.error("CatGenServletConfig(): cannot write to config file <" + configFile.getPath() + ">.");
            return;
        }
        this.configDocParser.writeXML(configFile, this.getUnmodTasks());
    }

    void writeConfig(OutputStream os) throws IOException {
        log.debug("writeConfig(): writing config to XMLStore (OutputStream).");
        this.configDocParser.writeXML(os, this.getUnmodTasks());
    }

    String toHtml() {
        StringBuffer tmpString = new StringBuffer();
        log.debug("toHtml(): start.");
        tmpString.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n");
        tmpString.append("<head><title>Catalog Generator Servlet Config</title></head>");
        tmpString.append("<body>");
        tmpString.append("<h1>Catalog Generator Servlet Config</h1>");
        tmpString.append("<hr>");
        tmpString.append("<h2>Currently Scheduled Tasks</h2>");
        tmpString.append("<table border=\"1\">");
        tmpString.append("<tr>");
        tmpString.append("<th> Task Name</th>");
        tmpString.append("<th> Config Filename</th>");
        tmpString.append("<th>");
        tmpString.append("Results Filename");
        tmpString.append("</th>");
        tmpString.append("<th> Period (minutes)</th>");
        tmpString.append("<th> Initial Delay (minutes)</th>");
        tmpString.append("<th> Edit/Delete Task</th>");
        tmpString.append("</tr>");
        Iterator it = this.getUnmodTaskIterator();
        while (it.hasNext()) {
            CatGenTimerTask curTask = (CatGenTimerTask)it.next();
            tmpString.append("<tr>");
            tmpString.append("<td>").append(curTask.getName()).append("</td>");
            tmpString.append("<td> <a href=\"./").append(curTask.getConfigDocName()).append("\">").append(curTask.getConfigDocName()).append("</a></td>");
            tmpString.append("<td>");
            tmpString.append(curTask.getResultFileName());
            tmpString.append("</td>");
            tmpString.append("<td>").append(curTask.getPeriodInMinutes()).append("</td>");
            tmpString.append("<td>").append(curTask.getDelayInMinutes()).append("</td>");
            tmpString.append("<td>");
            tmpString.append("[<a href=\"./editTask-").append(curTask.getConfigDocName()).append("\">Edit</a>]");
            tmpString.append("[<a href=\"./deleteTask-").append(curTask.getConfigDocName()).append("\">Delete</a>]");
            tmpString.append("</td>");
            tmpString.append("</tr>");
        }
        tmpString.append("</table>");
        tmpString.append("<a href=\"./addTask\">Add a new task</a>");
        tmpString.append("<hr>");
        tmpString.append("</body>");
        tmpString.append("</html>");
        log.debug("toHtml(): start.");
        return tmpString.toString();
    }

    private class ConfigDocumentParser {
        private String rootElemName = "preferences";
        private String extXmlVerAttName = "EXTERNAL_XML_VERSION";
        private String extXmlVerAttVal = "1.0";
        private String rootUserElemName = "root";
        private String rootUserAttName = "type";
        private String rootUserAttVal = "user";
        private String mapElemName = "map";
        private String beanCollElemName = "beanCollection";
        private String beanCollKeyAttName = "key";
        private String beanCollKeyAttVal = "config";
        private String beanCollClassAttName = "class";
        private String beanCollClassAttVal = "thredds.cataloggen.servlet.CatGenTimerTask";
        private String beanElemName = "bean";
        private String beanNameAttName = "name";
        private String beanConfigDocNameAttName = "configDocName";
        private String beanResultFileNameAttName = "resultFileName";
        private String beanDelayAttName = "delayInMinutes";
        private String beanPeriodAttName = "periodInMinutes";

        private ConfigDocumentParser() {
        }

        List parseXML(File inFile) throws IOException {
            FileInputStream inStream = new FileInputStream(inFile);
            List config = this.parseXML(inStream, inFile.getPath());
            inStream.close();
            return config;
        }

        List parseXML(InputStream inStream, String docId) throws IOException {
            Document doc;
            SAXBuilder builder = new SAXBuilder();
            log.debug("parseXML(): Parsing latest config doc \"" + docId + "\".");
            try {
                doc = builder.build(inStream);
            }
            catch (JDOMException e) {
                log.error("parseXML(): Bad config doc <" + docId + ">: " + e.getMessage());
                return null;
            }
            List config = this.readConfig(doc.getRootElement());
            if (config == null) {
                log.error("parseXML(): Config doc <" + docId + "> not in valid format.");
            } else if (config.isEmpty()) {
                log.warn("parseXML(): Empty config file <" + docId + ">.");
            }
            return config;
        }

        private List readConfig(Element rootElem) {
            if (!rootElem.getName().equals(this.rootElemName)) {
                log.error("readConfig(): Root element <" + rootElem.getName() + "> not as expected <" + this.rootElemName + ">.");
                return null;
            }
            Element rootUserElem = rootElem.getChild(this.rootUserElemName);
            Element mapElem = rootUserElem.getChild(this.mapElemName);
            Element beanColElem = mapElem.getChild(this.beanCollElemName);
            if (beanColElem == null) {
                return null;
            }
            String keyAttVal = beanColElem.getAttributeValue(this.beanCollKeyAttName);
            String classAttVal = beanColElem.getAttributeValue(this.beanCollClassAttName);
            if (!keyAttVal.equals(this.beanCollKeyAttVal)) {
                log.error("readConfig(): bean collection element key attribute <" + keyAttVal + "> not as expected <" + this.beanCollKeyAttVal + ">.");
                return null;
            }
            if (!classAttVal.equals(this.beanCollClassAttVal)) {
                log.error("readConfig(): bean collection element class attribute <" + classAttVal + "> not as expected <" + this.beanCollClassAttVal + ">.");
                return null;
            }
            ArrayList<CatGenTimerTask> configList = new ArrayList<CatGenTimerTask>();
            List list = beanColElem.getChildren(this.beanElemName);
            for (Element curBeanElem : list) {
                int periodInMinutes;
                int delayInMinutes;
                String name = curBeanElem.getAttributeValue(this.beanNameAttName);
                String configDocName = curBeanElem.getAttributeValue(this.beanConfigDocNameAttName);
                String resultFileName = curBeanElem.getAttributeValue(this.beanResultFileNameAttName);
                try {
                    delayInMinutes = curBeanElem.getAttribute(this.beanDelayAttName).getIntValue();
                    periodInMinutes = curBeanElem.getAttribute(this.beanPeriodAttName).getIntValue();
                }
                catch (DataConversionException e) {
                    log.error("readConfig(): bean element delay or period attribute not an integer value: " + e.getMessage());
                    return null;
                }
                configList.add(new CatGenTimerTask(name, configDocName, resultFileName, periodInMinutes, delayInMinutes));
            }
            return configList;
        }

        void writeXML(File outFile, List configList) throws IOException {
            FileOutputStream outStream = new FileOutputStream(outFile);
            this.writeXML(outStream, configList);
            outStream.close();
        }

        void writeXML(OutputStream outStream, List configList) throws IOException {
            Element rootElem = new Element(this.rootElemName);
            rootElem.setAttribute(this.extXmlVerAttName, this.extXmlVerAttVal);
            Document doc = new Document(rootElem);
            Element rootUserElem = new Element(this.rootUserElemName);
            rootUserElem.setAttribute(this.rootUserAttName, this.rootUserAttVal);
            rootElem.addContent((Content)rootUserElem);
            Element mapElem = new Element(this.mapElemName);
            rootUserElem.addContent((Content)mapElem);
            Element beanCollElem = new Element(this.beanCollElemName);
            beanCollElem.setAttribute(this.beanCollKeyAttName, this.beanCollKeyAttVal);
            beanCollElem.setAttribute(this.beanCollClassAttName, this.beanCollClassAttVal);
            mapElem.addContent((Content)beanCollElem);
            for (CatGenTimerTask curItem : configList) {
                Element curItemElem = new Element(this.beanElemName);
                curItemElem.setAttribute(this.beanNameAttName, curItem.getName());
                curItemElem.setAttribute(this.beanConfigDocNameAttName, curItem.getConfigDocName());
                curItemElem.setAttribute(this.beanResultFileNameAttName, curItem.getResultFileName());
                curItemElem.setAttribute(this.beanDelayAttName, Integer.toString(curItem.getDelayInMinutes()));
                curItemElem.setAttribute(this.beanPeriodAttName, Integer.toString(curItem.getPeriodInMinutes()));
                beanCollElem.addContent((Content)curItemElem);
            }
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(doc, outStream);
        }
    }
}

