/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.servlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.cataloggen.CatalogGen;
import thredds.datatype.DateType;

class CatGenTimerTask {
    private static Logger logger = LoggerFactory.getLogger(CatGenTimerTask.class);
    private final String name;
    private final String configDocName;
    private final String resultFileName;
    private final int periodInMinutes;
    private final int delayInMinutes;
    private File configDoc = null;
    private URL configDocURL = null;
    private File resultFile = null;
    private MyTimerTask timerTask = null;

    CatGenTimerTask(String name, String configDocName, String resultFileName, int periodInMinutes, int delayInMinutes) {
        if (name == null || name.equals("")) {
            logger.error("ctor(): The name cannot be null or empty string.");
            throw new IllegalArgumentException("The name cannot be null or empty string.");
        }
        if (configDocName == null || configDocName.equals("")) {
            logger.error("ctor(): The config doc name cannot be null or empty string.");
            throw new IllegalArgumentException("The config doc name cannot be null or empty string.");
        }
        if (resultFileName == null || resultFileName.equals("")) {
            logger.error("ctor(): The result file name cannot be null or empty string.");
            throw new IllegalArgumentException("The result file name cannot be null or empty string.");
        }
        this.name = name;
        this.configDocName = configDocName;
        this.resultFileName = resultFileName;
        this.periodInMinutes = periodInMinutes;
        this.delayInMinutes = delayInMinutes;
    }

    CatGenTimerTask(CatGenTimerTask task) {
        this.name = task.getName();
        this.configDocName = task.getConfigDocName();
        this.resultFileName = task.getResultFileName();
        this.periodInMinutes = task.getPeriodInMinutes();
        this.delayInMinutes = task.getDelayInMinutes();
    }

    String getName() {
        return this.name;
    }

    String getConfigDocName() {
        return this.configDocName;
    }

    String getResultFileName() {
        return this.resultFileName;
    }

    int getPeriodInMinutes() {
        return this.periodInMinutes;
    }

    int getDelayInMinutes() {
        return this.delayInMinutes;
    }

    synchronized TimerTask getTimerTask() {
        if (this.timerTask == null) {
            logger.error("getTimerTask(): CatGenTimerTask <" + this.name + "> has not been initialized.");
            throw new IllegalStateException("Must call init() first.");
        }
        return this.timerTask;
    }

    synchronized void init(File resultPath, File configDocPath) {
        if (this.timerTask != null) {
            logger.error("init(): CatGenTimerTask <" + this.name + "> has already been initialized.");
            throw new IllegalStateException("init() has already been called.");
        }
        this.configDoc = new File(configDocPath, this.configDocName);
        try {
            URI tmpURI = this.configDoc.toURI();
            this.configDocURL = tmpURI.toURL();
        }
        catch (MalformedURLException e) {
            logger.error("init(): Bad URL for config File <" + this.configDoc.getPath() + ">: " + e.getMessage());
            throw new IllegalArgumentException("init(): config file doesn't convert to valid URI: " + e.getMessage());
        }
        this.resultFile = new File(resultPath, this.resultFileName);
        if (!this.resultFile.exists() && !this.resultFile.getParentFile().exists()) {
            if (this.resultFile.getParentFile().mkdirs()) {
                logger.debug("init(): Created directory \"" + this.resultFile.getParentFile().getAbsolutePath() + "\".");
            } else {
                logger.error("init(): Could not create directory \"" + this.resultFile.getParentFile().getAbsolutePath() + "\", result file " + "(" + this.resultFile.getAbsolutePath() + ")invalid.");
                throw new IllegalArgumentException("Result file directory doesn't exist and couldn't be created.");
            }
        }
        logger.debug("init(): result path is " + resultPath.toString());
        logger.debug("init(): config doc path is " + configDocPath.toString());
        logger.debug("init(): config doc URL is " + this.configDocURL.toString());
        logger.debug("init(): config doc is " + this.configDoc.toString());
        logger.debug("init(): result file is " + this.resultFile.toString());
        this.timerTask = new MyTimerTask(this.configDocURL, this.resultFile, this.periodInMinutes);
    }

    synchronized boolean isValid(StringBuffer messages) {
        if (this.timerTask == null) {
            logger.error("isValid(): CatGenTimerTask <" + this.name + "> has not been initialized.");
            return false;
        }
        boolean isValid = true;
        if (this.getPeriodInMinutes() == 0) {
            messages.append("CatGenTimerTask.isValid() - period set to zero, skipping all but \"task name\" validity tests.\n");
        } else {
            CatalogGen catGen = new CatalogGen(this.configDocURL);
            if (!catGen.isValid(messages)) {
                logger.debug("isValid(): config doc <" + this.configDocURL + "> is not valid.");
                isValid = false;
            }
            if (this.resultFile.exists() && !this.resultFile.canWrite()) {
                messages.append("CatGenTimerTask.isValid() - result file not writeable.\n");
                logger.warn("isValid(): Result file is not writable.");
                isValid = false;
            }
            if (this.getPeriodInMinutes() < 0) {
                messages.append("CatGenTimerTask.isValid() - period must be zero or above.\n");
                isValid = false;
            }
            if (this.getDelayInMinutes() < 0) {
                messages.append("CatGenTimerTask.isValid() - delay must be zero or above.\n");
                isValid = false;
            }
        }
        if (isValid) {
            logger.debug("Config doc valid (" + this.configDoc.toString() + "): " + messages.toString());
        } else {
            logger.debug("Invalid config doc (" + this.configDoc.toString() + "): " + messages.toString());
        }
        return isValid;
    }

    private class MyTimerTask
    extends TimerTask {
        private final int periodInMinutes;
        private final URL configDocURL;
        private final File resultFile;

        private MyTimerTask(URL configDocURL, File resultFile, int periodInMinutes) {
            this.configDocURL = configDocURL;
            this.resultFile = resultFile;
            this.periodInMinutes = periodInMinutes;
        }

        public void run() {
            logger.info("run(): generating catalog <" + this.resultFile.toString() + "> from config doc, " + this.configDocURL.toString());
            CatalogGen catGen = new CatalogGen(this.configDocURL);
            StringBuffer messages = new StringBuffer();
            if (catGen.isValid(messages)) {
                catGen.expand();
                long expireMillis = System.currentTimeMillis() + (long)(this.periodInMinutes * 60 * 1000);
                Date expireDate = new Date(expireMillis);
                DateType expireDateType = new DateType(false, expireDate);
                catGen.setCatalogExpiresDate(expireDateType);
                try {
                    catGen.writeCatalog(this.resultFile.toString());
                }
                catch (IOException e) {
                    logger.error("run(): couldn't write catalog: " + e.getMessage());
                    return;
                }
                logger.debug("run(): Catalog written (" + this.resultFile.toString() + ").");
            } else {
                logger.error("run(): Tried running CatalogGen with invalid config doc, " + this.configDocURL.toString() + "\n" + messages.toString());
                this.cancel();
            }
        }
    }
}

