/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.dqc.server.DqcHandler;
import thredds.dqc.server.DqcHandlerInstantiationException;
import thredds.dqc.server.DqcServletConfig;
import thredds.dqc.server.DqcServletConfigItem;
import thredds.servlet.AbstractServlet;
import thredds.servlet.ServletUtil;

public class DqcServlet
extends AbstractServlet {
    private File dqcRootPath;
    private File dqcContentPath;
    private File dqcConfigPath;
    private String configFileName;
    private DqcServletConfig mainConfig = null;
    private String servletName = "dqcServlet";
    private String dqcDocDirName = "doc";
    private String dqcConfigDirName = "config";
    private String dqcCatalog = "catalog.xml";

    protected String getPath() {
        return this.servletName + "/";
    }

    protected void makeDebugActions() {
    }

    public void init() throws ServletException {
        super.init();
        this.dqcRootPath = new File(this.rootPath, this.servletName);
        this.dqcContentPath = new File(this.contentPath);
        this.dqcConfigPath = new File(this.dqcContentPath, this.dqcConfigDirName);
        this.configFileName = this.getInitParameter("configFile");
        this.log.debug("init(): dqc root path    = " + this.dqcRootPath.toString());
        this.log.debug("init(): dqc content path = " + this.dqcContentPath.toString());
        this.log.debug("init(): dqc config path  = " + this.dqcConfigPath.toString());
        this.log.debug("init(): config file      = " + this.configFileName);
        try {
            this.mainConfig = this.readInConfigDoc();
        }
        catch (IOException e) {
            String tmpMsg = "IOException thrown while reading DqcServlet config: " + e.getMessage();
            this.log.error("init():" + tmpMsg, (Throwable)e);
            throw new ServletException(tmpMsg, (Throwable)e);
        }
        this.log.debug("init() done");
    }

    private DqcServletConfig readInConfigDoc() throws IOException {
        DqcServletConfig retValue = null;
        retValue = new DqcServletConfig(this.dqcConfigPath, this.configFileName);
        return retValue;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        String tmpMsg = null;
        PrintWriter out = null;
        DqcServletConfigItem reqHandlerInfo = null;
        DqcHandler reqHandler = null;
        String reqPath = req.getPathInfo();
        if (reqPath == null) {
            res.sendRedirect(res.encodeRedirectURL(req.getContextPath() + req.getServletPath() + "/"));
            ServletUtil.logServerAccess(301, 0L);
            return;
        }
        if (reqPath.equals("/")) {
            out = res.getWriter();
            res.setContentType("text/html");
            String resString = this.htmlOfConfig(req.getContextPath() + req.getServletPath());
            res.setStatus(200);
            out.print(resString);
            ServletUtil.logServerAccess(200, resString.length());
            return;
        }
        if (reqPath.startsWith("/" + this.dqcDocDirName + "/")) {
            ServletUtil.returnFile(this, this.dqcRootPath.getAbsolutePath(), reqPath, req, res, null);
        } else if (reqPath.startsWith("/" + this.dqcConfigDirName + "/")) {
            ServletUtil.returnFile(this, this.dqcContentPath.getAbsolutePath(), reqPath, req, res, null);
        } else {
            if (reqPath.equals("/" + this.dqcCatalog)) {
                InvCatalogFactory catFactory = new InvCatalogFactory("default", true);
                String catalogAsString = catFactory.writeXML_1_0((InvCatalogImpl)this.mainConfig.createCatalogRepresentation(req.getContextPath() + req.getServletPath()));
                out = res.getWriter();
                res.setContentType("text/xml");
                res.setStatus(200);
                out.print(catalogAsString);
                ServletUtil.logServerAccess(200, catalogAsString.length());
                return;
            }
            String handlerName = reqPath = reqPath.substring(1);
            this.log.debug("doGet(): Attempt to find \"" + handlerName + "\" handler (1).");
            reqHandlerInfo = this.mainConfig.findItem(handlerName);
            if (reqHandlerInfo == null && reqPath.endsWith(".xml")) {
                handlerName = reqPath.substring(0, reqPath.length() - 4);
                this.log.debug("doGet(): Attempt to find \"" + handlerName + "\" handler (2).");
                reqHandlerInfo = this.mainConfig.findItem(handlerName);
            }
            if (reqHandlerInfo == null && reqPath.indexOf(47) != -1) {
                handlerName = reqPath.substring(0, reqPath.indexOf(47));
                this.log.debug("doGet(): Attempt to find \"" + handlerName + "\" handler. (3)");
                reqHandlerInfo = this.mainConfig.findItem(handlerName);
            }
            if (reqHandlerInfo == null) {
                tmpMsg = "No DQC Handler available for path <" + reqPath + ">.";
                this.log.warn("doGet(): " + tmpMsg);
                res.sendError(400, tmpMsg);
                ServletUtil.logServerAccess(400, 0L);
                return;
            }
            this.log.debug("doGet(): creating handler for " + reqHandlerInfo.getHandlerClassName());
            try {
                reqHandler = DqcHandler.factory(reqHandlerInfo, this.dqcConfigPath.getAbsolutePath());
            }
            catch (DqcHandlerInstantiationException e) {
                tmpMsg = "Handler could not be constructed for " + reqHandlerInfo.getHandlerClassName() + ": " + e.getMessage();
                this.log.error("doGet(): " + tmpMsg, (Throwable)e);
                res.sendError(500, tmpMsg);
                ServletUtil.logServerAccess(500, 0L);
                return;
            }
            if (reqHandler != null) {
                this.log.debug("doGet(): handing query to handler");
                reqHandler.handleRequest(req, res);
                return;
            }
            tmpMsg = "No handler for " + reqHandlerInfo.getHandlerClassName();
            this.log.error("doGet(): " + tmpMsg);
            res.sendError(500, tmpMsg);
            ServletUtil.logServerAccess(500, 0L);
            return;
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ServletUtil.logServerAccessSetup(req);
        File tmpFile = null;
        String tmpMsg = null;
        String reqPath = req.getPathInfo();
        if (reqPath == null) {
            tmpMsg = "PUT to empty path (\"\") not allowed.";
            this.log.debug("doPut(): " + tmpMsg);
            res.setHeader("Allow", "GET");
            res.sendError(405, tmpMsg);
            ServletUtil.logServerAccess(405, 0L);
            return;
        }
        if (!reqPath.startsWith("/" + this.dqcConfigDirName + "/")) {
            tmpMsg = "Cannot PUT a document outside the " + this.dqcConfigDirName + "/ directory";
            this.log.debug("doPut(): " + tmpMsg);
            res.sendError(403, tmpMsg);
            ServletUtil.logServerAccess(403, 0L);
            return;
        }
        tmpFile = new File(this.dqcContentPath, reqPath);
        this.log.debug("doPut(): putting DqcServlet Config file - " + reqPath);
        if (reqPath.equals("/" + this.dqcConfigDirName + "/" + this.configFileName)) {
            if (ServletUtil.saveFile(this, this.dqcContentPath.getAbsolutePath(), reqPath, req, res)) {
                this.log.debug("doPut(): file saved <" + reqPath + ">.");
                try {
                    this.mainConfig = this.readInConfigDoc();
                }
                catch (IOException e) {
                    tmpMsg = "IOException thrown while reading newly PUT DqcServlet config file: " + e.getMessage();
                    this.log.error("initConfig():" + tmpMsg, (Throwable)e);
                    res.sendError(500, tmpMsg);
                    ServletUtil.logServerAccess(500, 0L);
                    return;
                }
                res.setStatus(200);
                ServletUtil.logServerAccess(200, -1L);
                return;
            }
            tmpMsg = "File not saved <" + reqPath + ">";
            this.log.error("doPut(): " + tmpMsg);
            res.sendError(500, tmpMsg);
            ServletUtil.logServerAccess(500, 0L);
            return;
        }
        boolean creatingNewFile = true;
        if (tmpFile.exists()) {
            creatingNewFile = false;
        }
        if (ServletUtil.saveFile(this, this.dqcContentPath.getAbsolutePath(), reqPath, req, res)) {
            this.log.debug("doPut(): file saved <" + reqPath + ">.");
            if (creatingNewFile) {
                res.setStatus(201);
                ServletUtil.logServerAccess(201, 0L);
            } else {
                res.setStatus(200);
                ServletUtil.logServerAccess(200, 0L);
            }
            return;
        }
        tmpMsg = "File not saved <" + reqPath + ">";
        this.log.error("doPut(): " + tmpMsg);
        res.sendError(500, tmpMsg);
        ServletUtil.logServerAccess(500, 0L);
    }

    private String htmlOfConfig(String contextServletPath) {
        StringBuffer buf = new StringBuffer();
        buf.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n");
        buf.append("<head><title>DQC Servlet - Available Datasets</title></head>\n");
        buf.append("<body>\n");
        buf.append("<h1>DQC Servlet - Available Datasets</h1>\n");
        buf.append("<table border=\"1\">\n");
        buf.append("<tr>\n");
        buf.append("<th> Name</th>\n");
        buf.append("<th> Description</th>\n");
        buf.append("<th> DQC Document</th>\n");
        buf.append("</tr>\n");
        Iterator iter = null;
        DqcServletConfigItem curItem = null;
        iter = this.mainConfig.getIterator();
        while (iter.hasNext()) {
            curItem = (DqcServletConfigItem)iter.next();
            buf.append("<tr>\n").append("  <td>").append(curItem.getName()).append("</td>\n").append("  <td>").append(curItem.getDescription()).append("</td>\n").append("  <td><a href=\"").append(contextServletPath).append("/").append(curItem.getName()).append(".xml\">").append(curItem.getName()).append("</a></td>\n").append("<tr>\n");
        }
        buf.append("<table>\n");
        buf.append("<p>\n");
        buf.append("This listing is also available as a <a href=\"catalog.xml\">THREDDS catalog</a>.\n");
        buf.append("</p>\n");
        buf.append("</body>\n");
        buf.append("</html>\n");
        return buf.toString();
    }
}

