/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.dqc.server.DqcServletConfigItem;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.XMLStore;

public class DqcServletConfig {
    private static Logger log = LoggerFactory.getLogger(DqcServletConfig.class);
    private String configPath = null;
    private String configDocName = null;
    private XMLStore configStore = null;
    private PreferencesExt configPrefs = null;
    private Collection configItems = null;
    private HashMap configHash = new HashMap();
    private String dqcServletTitle = null;

    public DqcServletConfig(File configPath, String configFileName) throws IOException {
        if (configPath == null || configFileName == null) {
            log.error("DqcServletConfig(): Config path or filename arguments were null.");
            throw new NullPointerException("Config path or filename arguments were null.");
        }
        this.configPath = configPath.getAbsolutePath();
        this.configDocName = configFileName;
        File configFile = new File(configPath, configFileName);
        if (!configFile.exists()) {
            log.error("DqcServletConfig(File): Config file <" + configFile.getAbsolutePath() + "> does not exist.");
            throw new IOException("Config file <" + configFileName + "> does not exist.");
        }
        if (!configFile.canRead()) {
            log.error("DqcServletConfig(File): Can't read config file <" + configFile.getAbsolutePath() + ">.");
            throw new IOException("Can't read config file <" + configFileName + ">.");
        }
        log.debug("DqcServletConfig(File): Opening XMLStore with given file <" + configFile.getAbsolutePath() + ">.");
        this.configStore = XMLStore.createFromFile((String)configFile.getAbsolutePath(), null);
        if (this.configStore == null) {
            log.error("DqcServletConfig(): Config XMLStore is null after createFromFile(<" + configFile.getAbsolutePath() + ">).");
            throw new RuntimeException("Config XMLStore is null after createFromFile(<" + configFileName + ">).");
        }
        this.setup();
    }

    protected DqcServletConfig(String configDocResourcePath, String configDocResourceName) throws IOException {
        if (configDocResourcePath == null || configDocResourceName == null) {
            log.error("DqcServletConfig(): Config document argument was null.");
            throw new NullPointerException("Config document argument was null.");
        }
        this.configPath = configDocResourcePath;
        this.configDocName = configDocResourceName;
        String resourceName = this.configPath + "/" + this.configDocName;
        log.debug("DqcServletConfig(String): Opening XMLStore with given resource <" + resourceName + ">.");
        this.configStore = XMLStore.createFromResource((String)resourceName, null);
        if (this.configStore == null) {
            String tmpString = "Config XMLStore is null after createFromResource(\"" + resourceName + "\", null).";
            log.error("DqcServletConfig(): " + tmpString);
            throw new RuntimeException(tmpString);
        }
        this.setup();
    }

    private void setup() {
        log.debug("setup(): get root preferences node from XMLStore.");
        this.configPrefs = this.configStore.getPreferences();
        if (this.configPrefs == null) {
            String tmpString = "Config XMLStore's root preferences is null.";
            log.error("setup(): " + tmpString);
            throw new RuntimeException(tmpString);
        }
        log.debug("setup(): get \"config\" preference items.");
        this.configItems = (Collection)this.configPrefs.getBean("config", new ArrayList());
        if (this.configItems.isEmpty()) {
            log.debug("setup(): Config doc has no DqcServletConfigItem entries.");
            return;
        }
        log.debug("setup(): Config doc has one or more DqcServletConfigItem entries.");
        DqcServletConfigItem curItem2 = null;
        for (DqcServletConfigItem curItem2 : this.configItems) {
            log.debug("Add config item <" + curItem2.getName() + ">.");
            this.configHash.put(curItem2.getName(), curItem2);
        }
    }

    public String getDqcServletTitle() {
        return "dqcServletTitle unknown (TODO: add title to config";
    }

    public Iterator getIterator() {
        return this.configItems.iterator();
    }

    public DqcServletConfigItem findItem(String itemName) {
        return (DqcServletConfigItem)this.configHash.get(itemName);
    }

    public boolean addItem(DqcServletConfigItem item) {
        log.debug("addItem( item): start.");
        if (item.getName() == null) {
            log.debug("addItem( item): item name is null.");
            return false;
        }
        if (this.findItem(item.getName()) != null) {
            log.debug("addItem( item): item with same name alread exists (" + item.getName() + ").");
            return false;
        }
        this.configItems.add(item);
        this.configHash.put(item.getName(), item);
        log.debug("addItem( item): item added (" + item.getName() + ").");
        return true;
    }

    public boolean addItem(String name, String description, String handlerName, String handlerConfigFileName) {
        log.debug("addItem( name, ...): start.");
        DqcServletConfigItem item = null;
        item = new DqcServletConfigItem(name, description, handlerName, handlerConfigFileName);
        log.debug("addItem( name, ...): passing to addItem( item).");
        return this.addItem(item);
    }

    public void writeConfig(OutputStream os) throws IOException {
        log.debug("writeConfig(): Create \"config\" preferences.");
        this.configPrefs.putBeanCollection("config", this.configItems);
        log.debug("writeConfig() Write \"config\" preferences to XMLStore (OutputStream).");
        this.configStore.save(os);
    }

    public static void writeExampleConfig(String fileName, String name, String description, String handlerName, String handlerConfigFileName) throws IOException {
        log.debug("Write example \"config\" preferences to (new) XMLStore.");
        XMLStore configStore = XMLStore.createFromFile((String)fileName, null);
        PreferencesExt configPrefs = configStore.getPreferences();
        DqcServletConfigItem item = null;
        ArrayList<DqcServletConfigItem> itemList = new ArrayList<DqcServletConfigItem>();
        item = new DqcServletConfigItem(name, description, handlerName, handlerConfigFileName);
        itemList.add(item);
        configPrefs.putBeanCollection("config", itemList);
        configStore.save();
    }

    public InvCatalog createCatalogRepresentation(String servletURL) {
        String serviceName = "myDqcServlet";
        InvCatalogImpl catalog = new InvCatalogImpl(null, null, null);
        InvService myService = new InvService(serviceName, ServiceType.RESOLVER.toString(), servletURL, null, null);
        InvDatasetImpl topDs = new InvDatasetImpl(null, "DqcServlet Available Datasets");
        catalog.addService(myService);
        catalog.addDataset(topDs);
        DqcServletConfigItem curItem = null;
        Iterator it = this.getIterator();
        InvDatasetImpl curDs = null;
        InvDocumentation curDoc = null;
        StringBuffer docContent = null;
        while (it.hasNext()) {
            curItem = (DqcServletConfigItem)it.next();
            curDs = new InvDatasetImpl(topDs, curItem.getDescription(), null, serviceName, curItem.getName() + ".xml");
            docContent = new StringBuffer();
            docContent.append(curItem.getDescription() + "\n").append("Using the DqcHandler " + curItem.getHandlerClassName()).append(" with config file " + curItem.getHandlerConfigFileName() + ".");
            curDoc = new InvDocumentation(null, null, null, null, docContent.toString());
            curDs.addDocumentation(curDoc);
            topDs.addDataset(curDs);
        }
        catalog.finish();
        return catalog;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DqcServletConfig (");
        DqcServletConfigItem curItem = null;
        Iterator it = this.getIterator();
        String prefix = "";
        while (it.hasNext()) {
            curItem = (DqcServletConfigItem)it.next();
            buf.append(prefix);
            buf.append(curItem.toString());
            prefix = ", ";
        }
        buf.append(")");
        return buf.toString();
    }
}

