/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;

public class DqcServletRedirect
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(DqcServletRedirect.class);
    private File rootPath;
    private File dqcRootPath;
    private File contentPath;
    private File dqcContentPath;
    private String servletName = "dqcServlet";
    private String targetContextPath = "/thredds";
    private String targetServletPath = "/dqc";
    private String testTargetContextPath = "/dqcServlet";
    private String testTargetServletPath = "/dqc";
    private String testRedirectPath = "/redirect-test";
    private String testRedirectStopPath = "/redirect-stop-test";

    public void init() throws ServletException {
        ServletUtil.initLogging(this);
        this.rootPath = new File(ServletUtil.getRootPath(this));
        this.dqcRootPath = new File(this.rootPath, this.servletName);
        this.contentPath = new File(ServletUtil.getContentPath(this));
        this.dqcContentPath = new File(this.contentPath, this.servletName);
        log.debug("init(): root path        = " + this.rootPath.toString());
        log.debug("init(): dqc root path    = " + this.dqcRootPath.toString());
        log.debug("init(): content path     = " + this.contentPath.toString());
        log.debug("init(): dqc content path = " + this.dqcContentPath.toString());
        String initialContentPath = ServletUtil.getInitialContentPath(this);
        try {
            ServletUtil.copyDir(initialContentPath, this.contentPath.getAbsolutePath());
            log.debug("init(): copied initial content directory <" + initialContentPath + "> to the content directory <" + this.contentPath + ">.");
        }
        catch (IOException ioe) {
            String tmpMsg = "Failed to copy " + initialContentPath + " to " + this.contentPath + ":" + ioe.getMessage();
            log.error("init(): " + tmpMsg, (Throwable)ioe);
            throw new ServletException(tmpMsg, (Throwable)ioe);
        }
        log.debug("init() done");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        String reqPath = req.getPathInfo();
        if (reqPath == null) {
            this.doDispatch(req, res, false);
        } else if (reqPath.startsWith(this.testRedirectPath)) {
            this.handleGetRequestForRedirectTest(res, req);
        } else if (reqPath.startsWith(this.testRedirectStopPath)) {
            this.handleGetRequestForRedirectStopTest(res, req);
        } else {
            this.doDispatch(req, res, false);
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ServletUtil.logServerAccessSetup(req);
        this.doDispatch(req, res, false);
    }

    private void doDispatch(HttpServletRequest req, HttpServletResponse res, boolean useTestContext) throws IOException, ServletException {
        String requestURIPath = new StringBuffer().append(req.getContextPath()).append(req.getServletPath()).append(req.getPathInfo()).toString();
        String targetURIPath = this.convertRequestURLToResponseURL(requestURIPath, req, useTestContext);
        String targetURIPathNoContext = targetURIPath.substring(useTestContext ? this.testTargetContextPath.length() : this.targetContextPath.length());
        String queryString = req.getQueryString();
        String reqURL = requestURIPath;
        String targetURL = targetURIPath;
        if (queryString != null) {
            reqURL = reqURL + "?" + queryString;
        }
        if (queryString != null) {
            targetURL = targetURL + "?" + queryString;
        }
        log.info("doDispatch(): " + req.getRemoteHost() + " - dispatching request for URL \"" + reqURL + "\" to \"" + targetURL + "\".");
        ServletContext context = this.getServletContext();
        ServletContext targetContext = context.getContext(useTestContext ? this.testTargetContextPath : this.targetContextPath);
        if (targetContext == null) {
            String tmpMsg = "Null ServletContext for \"" + (useTestContext ? this.testTargetContextPath : this.targetContextPath) + "\".";
            log.warn("doDispatch(): " + tmpMsg);
            res.sendError(404, tmpMsg);
            ServletUtil.logServerAccess(404, tmpMsg.length());
            return;
        }
        RequestDispatcher dispatcher = targetContext.getRequestDispatcher(targetURIPathNoContext);
        if (dispatcher == null) {
            String tmpMsg = "Null RequestDispatcher for \"" + targetURIPath + "\".";
            log.warn("doDispatch(): " + tmpMsg);
            res.sendError(404, tmpMsg);
            ServletUtil.logServerAccess(404, tmpMsg.length());
            return;
        }
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        ServletUtil.logServerAccess(200, -1L);
    }

    private void handleGetRequestForRedirectTest(HttpServletResponse res, HttpServletRequest req) throws IOException, ServletException {
        String reqPath = req.getPathInfo();
        String queryString = req.getQueryString();
        log.debug("handleGetRequestForRedirectTest(): handle GET path \"" + reqPath + "\") with query \"" + queryString + "\">.");
        if (reqPath.equals(this.testRedirectPath)) {
            if (queryString == null) {
                log.warn("handleGetRequestForRedirectTest(): request not understood <" + reqPath + ">.");
                res.setStatus(400);
                ServletUtil.logServerAccess(400, 0L);
            } else if (queryString.equals("301")) {
                this.doRedirect301(req, res, true);
            } else if (queryString.equals("302")) {
                this.doRedirect302(req, res, true);
            } else if (queryString.equals("305")) {
                this.doUseProxy305(req, res, true);
            } else if (queryString.equals("dispatch")) {
                this.doDispatch(req, res, true);
            } else {
                log.warn("handleGetRequestForRedirectTest(): request not understood <" + reqPath + " -- " + queryString + ">.");
                res.setStatus(400);
                ServletUtil.logServerAccess(400, 0L);
            }
        } else if (reqPath.equals(this.testRedirectPath + "/")) {
            if (queryString == null) {
                log.debug("handleGetRequestForRedirectTest(): redirect \"" + reqPath + "\") to index.html.");
                ServletUtil.returnFile(this, this.rootPath.getAbsolutePath(), "index.html", req, res, null);
            } else {
                log.warn("handleGetRequestForRedirectTest(): request not understood <" + reqPath + " -- " + queryString + ">.");
                res.setStatus(400);
                ServletUtil.logServerAccess(400, 0L);
            }
        } else if (reqPath.equals(this.testRedirectPath + "/301") && queryString == null) {
            this.doRedirect301(req, res, true);
        } else if (reqPath.equals(this.testRedirectPath + "/302") && queryString == null) {
            this.doRedirect302(req, res, true);
        } else if (reqPath.equals(this.testRedirectPath + "/305") && queryString == null) {
            this.doUseProxy305(req, res, true);
        } else if (reqPath.equals(this.testRedirectPath + "/dispatch") && queryString == null) {
            this.doDispatch(req, res, true);
        } else {
            log.warn("handleGetRequestForRedirectTest(): request not understood <" + reqPath + " -- " + queryString + ">.");
            res.setStatus(400);
            ServletUtil.logServerAccess(400, 0L);
        }
    }

    private void handleGetRequestForRedirectStopTest(HttpServletResponse res, HttpServletRequest req) throws IOException {
        String reqPath = req.getPathInfo();
        String queryString = req.getQueryString();
        log.debug("handleGetRequestForRedirectStopTest(): handle GET path \"" + reqPath + "\") with query \"" + queryString + "\">.");
        String title = "The Resource";
        String htmlResp = new StringBuffer().append(this.getHtmlDoctypeAndOpenTag()).append("<head><title>").append(title).append("</title></head><body>").append("<h1>").append(title).append("</h1>").append("<ul>").append("<li>").append("Path : ").append(reqPath).append("</li>").append("<li>").append("Query: ").append(queryString).append("</li>").append("</ul>").append("</body></html>").toString();
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        res.setStatus(200);
        out.print(htmlResp);
        ServletUtil.logServerAccess(200, htmlResp.length());
    }

    private void doRedirect301(HttpServletRequest req, HttpServletResponse res, boolean useTestContext) throws IOException {
        String requestURIPath = new StringBuffer().append(req.getContextPath()).append(req.getServletPath()).append(req.getPathInfo()).toString();
        String targetURIPath = this.convertRequestURLToResponseURL(requestURIPath, req, useTestContext);
        String targetURIPathNoContext = targetURIPath.substring(useTestContext ? this.testTargetContextPath.length() : this.targetContextPath.length());
        String queryString = req.getQueryString();
        if (queryString != null) {
            targetURIPath = targetURIPath + "?" + queryString;
        }
        targetURIPath = res.encodeRedirectURL(targetURIPath);
        log.info("doRedirect301(): " + req.getRemoteHost() + " - requested URL \"" + requestURIPath + "\" permanently moved, redirect to \"" + targetURIPath + "\".");
        res.setStatus(301);
        res.addHeader("Location", targetURIPath);
        String title = "Permanently Moved - 301";
        String body = new StringBuffer().append("<p>").append("The requested URL <").append(req.getRequestURL()).append("> has been permanently moved (HTTP status code 301).").append(" Instead, please use the following URL: <a href=\"").append(targetURIPath).append("\">").append(targetURIPath).append("</a>.").append("</p>").toString();
        String htmlResp = new StringBuffer().append(this.getHtmlDoctypeAndOpenTag()).append("<head><title>").append(title).append("</title></head><body>").append("<h1>").append(title).append("</h1>").append(body).append("</body></html>").toString();
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        out.print(htmlResp);
        ServletUtil.logServerAccess(301, 0L);
    }

    private void doRedirect302(HttpServletRequest req, HttpServletResponse res, boolean useTestContext) throws IOException {
        String requestURIPath = new StringBuffer().append(req.getContextPath()).append(req.getServletPath()).append(req.getPathInfo()).toString();
        String targetURIPath = this.convertRequestURLToResponseURL(requestURIPath, req, useTestContext);
        String targetURIPathNoContext = targetURIPath.substring(useTestContext ? this.testTargetContextPath.length() : this.targetContextPath.length());
        String queryString = req.getQueryString();
        if (queryString != null) {
            targetURIPath = targetURIPath + "?" + queryString;
        }
        targetURIPath = res.encodeRedirectURL(targetURIPath);
        log.info("doRedirect302(): " + req.getRemoteHost() + " - requested URL \"" + requestURIPath + "\" temporarily moved, redirect to \"" + targetURIPath + "\".");
        String title = "Temporarily Moved - 302";
        String body = new StringBuffer().append("<p>").append("The requested URL <").append(req.getRequestURL()).append("> has been temporarily moved (HTTP status code 302).").append(" Instead, please use the following URL: <a href=\"").append(targetURIPath).append("\">").append(targetURIPath).append("</a>.").append("</p>").toString();
        String htmlResp = new StringBuffer().append(this.getHtmlDoctypeAndOpenTag()).append("<head><title>").append(title).append("</title></head><body>").append("<h1>").append(title).append("</h1>").append(body).append("</body></html>").toString();
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        out.print(htmlResp);
        res.sendRedirect(targetURIPath);
        ServletUtil.logServerAccess(302, 0L);
    }

    private void doUseProxy305(HttpServletRequest req, HttpServletResponse res, boolean useTestContext) throws IOException {
        String reqURL = req.getRequestURL().toString();
        String targetURL = res.encodeRedirectURL(this.convertRequestURLToResponseURL(reqURL, req, useTestContext));
        String queryString = req.getQueryString();
        if (queryString != null) {
            reqURL = reqURL + "?" + queryString;
        }
        if (queryString != null) {
            targetURL = targetURL + "?" + queryString;
        }
        log.info("doUseProxy305(): " + req.getRemoteHost() + " - proxy requested URI \"" + reqURL + "\" to \"" + targetURL + "\".");
        res.addHeader("Location", targetURL);
        String title = "Use Proxy - 305";
        String body = new StringBuffer().append("<ul>").append("<li>").append("request URL : ").append(req.getRequestURL()).append("</li>").append("<li>").append("proxy URL   : <a href=\"").append(targetURL).append("\">").append(targetURL).append("</a></li>").append("</ul>").toString();
        String htmlResp = new StringBuffer().append(this.getHtmlDoctypeAndOpenTag()).append("<head><title>").append(title).append("</title></head><body>").append("<h1>").append(title).append("</h1>").append(body).append("</body></html>").toString();
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        res.setStatus(305);
        out.print(htmlResp);
        ServletUtil.logServerAccess(305, 0L);
    }

    private String convertRequestURLToResponseURL(String reqURL, HttpServletRequest req, boolean useTestContext) {
        StringBuffer reqURLBuffer = new StringBuffer(reqURL);
        String strToReplace = useTestContext ? (req.getPathInfo().length() > this.testRedirectPath.length() ? this.testRedirectPath : req.getPathInfo()) : req.getContextPath() + req.getServletPath();
        int strToReplaceStart = reqURL.indexOf(strToReplace);
        int strToReplaceEnd = strToReplaceStart + strToReplace.length();
        reqURLBuffer.replace(strToReplaceStart, strToReplaceEnd, useTestContext ? this.testRedirectStopPath : this.targetContextPath + this.targetServletPath);
        return reqURLBuffer.toString();
    }

    private String getHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n").toString();
    }

    private String getXHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n").append("        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">").toString();
    }
}

