/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.jplQuikSCAT;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.Query;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectRange;
import thredds.catalog.query.SelectRangeDate;
import thredds.catalog.query.SelectService;
import thredds.catalog.query.Selector;
import thredds.dqc.SelectFromRange;
import thredds.dqc.server.DqcHandler;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatCalendar;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatDodsFileServer;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatEntry;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatEntryComparator;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatUserQuery;
import thredds.servlet.ServletUtil;

public class JplQuikSCAT
extends DqcHandler {
    private static Logger log = LoggerFactory.getLogger(JplQuikSCAT.class);
    protected String dqcServletUrl = "http://dods.jpl.nasa.gov/dqcServlet/quikscat";
    protected JplQuikScatDodsFileServer jplQsDfs = null;
    protected SelectFromRange allowedDateRange = null;
    protected SelectFromRange allowedLongitudeRange = null;
    protected List resultSortedList = null;
    protected Comparator comparator = null;
    protected String epochStartDateTimeString = "1999-01-01T00:00:00.000GMT";
    protected JplQuikScatCalendar jplQuikScatCalendar = null;

    public void initWithHandlerConfigDoc(URL configDocURL) throws IOException {
        log.debug("initWithHandlerConfigDoc(): start.");
        this.jplQsDfs = new JplQuikScatDodsFileServer();
        this.allowedDateRange = new SelectFromRange();
        this.allowedLongitudeRange = new SelectFromRange();
        this.resultSortedList = new ArrayList();
        this.jplQuikScatCalendar = new JplQuikScatCalendar(this.epochStartDateTimeString);
        log.debug("initWithHandlerConfigDoc(): epoch start date set <" + this.jplQuikScatCalendar.getEpochStartDate().toString() + ">.");
        this.allowedDateRange.setTitle("Select Date Range");
        this.allowedDateRange.setMultiple(false);
        this.allowedDateRange.setRequired(false);
        this.allowedDateRange.setAllowedRange(this.jplQuikScatCalendar.getSecondsSinceEpochFromDate(this.jplQsDfs.getAllowedDateRangeMin()), this.jplQuikScatCalendar.getSecondsSinceEpochFromDate(this.jplQsDfs.getAllowedDateRangeMax()));
        this.allowedDateRange.setUnits("seconds since " + this.jplQuikScatCalendar.getEpochStartDateString());
        this.allowedDateRange.setTemplate("minDate={minDate}&amp;maxDate={maxDate}");
        this.allowedDateRange.setModulo(false);
        log.debug("initWithHandlerConfigDoc(): allowed date range info set: title=\"" + this.allowedDateRange.getTitle() + "\"; " + "multiple=\"" + this.allowedDateRange.isMultiple() + "\"; " + "required=\"" + this.allowedDateRange.isRequired() + "\";" + " min=\"" + this.allowedDateRange.getAllowedRangeMin() + "\";" + " max=\"" + this.allowedDateRange.getAllowedRangeMax() + "\"; " + "units=\"" + this.allowedDateRange.getUnits() + "\"; " + "modulo=\"" + this.allowedDateRange.isModulo() + "\"; " + "template=\"" + this.allowedDateRange.getTemplate() + "\".");
        this.allowedLongitudeRange.setTitle("Northerly Equatorial Crossing (longitude)");
        this.allowedLongitudeRange.setDescription("The longitude at which the satellite crosses the equator from thesouthern into the northern hemisphere.");
        this.allowedLongitudeRange.setMultiple(true);
        this.allowedLongitudeRange.setRequired(false);
        this.allowedLongitudeRange.setAllowedRange(this.jplQsDfs.getAllowedLongitudeRangeMin(), this.jplQsDfs.getAllowedLongitudeRangeMax());
        this.allowedLongitudeRange.setUnits("degree_east");
        this.allowedLongitudeRange.setTemplate("minCross={minCross}&amp;maxCross={maxCross}");
        this.allowedLongitudeRange.setModulo(true);
        log.debug("initWithHandlerConfigDoc(): allowed longitude range info set: title=\"" + this.allowedLongitudeRange.getTitle() + "\"; " + "multiple=\"" + this.allowedLongitudeRange.isMultiple() + "\"; " + "required=\"" + this.allowedLongitudeRange.isRequired() + "\";" + " min=\"" + this.allowedLongitudeRange.getAllowedRangeMin() + "\";" + " max=\"" + this.allowedLongitudeRange.getAllowedRangeMax() + "\"; " + "units=\"" + this.allowedLongitudeRange.getUnits() + "\"; " + "modulo=\"" + this.allowedLongitudeRange.isModulo() + "\"; " + "template=\"" + this.allowedLongitudeRange.getTemplate() + "\".");
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        double requestedDateRangeMinSecSinceEpoch;
        String tmpMsg = null;
        String reqPath = req.getPathInfo();
        String extraPath = reqPath.substring(this.getHandlerInfo().getName().length() + 1);
        if (extraPath.equals(".xml")) {
            QueryCapability dqc = this.createDqcDocument(req.getContextPath() + req.getServletPath() + "/" + this.getHandlerInfo().getName());
            DqcFactory dqcFactory = new DqcFactory(false);
            String dqcAsString = dqcFactory.writeXML(dqc);
            PrintWriter out = res.getWriter();
            res.setContentType("text/xml");
            res.setStatus(200);
            out.print(dqcAsString);
            log.debug("handleRequest(): done writing DQC doc as response.");
            return;
        }
        if (extraPath.length() > 0) {
            tmpMsg = "Extra path information <" + extraPath + "> not understood.";
            log.error("handleRequest(): " + tmpMsg);
            res.sendError(500, tmpMsg);
            ServletUtil.logServerAccess(500, 0L);
            return;
        }
        Enumeration params = req.getParameterNames();
        StringBuffer tmp = new StringBuffer("Request parameter names: ** ");
        while (params.hasMoreElements()) {
            tmp.append(params.nextElement() + " ** ");
        }
        log.debug("handleRequest(): " + tmp.toString());
        String requestedDateRangeMin = req.getParameter("minDate");
        String requestedDateRangeMax = req.getParameter("maxDate");
        String requestedLongitudeRangeMin = req.getParameter("minCross");
        String requestedLongitudeRangeMax = req.getParameter("maxCross");
        log.debug("handleRequest(): handling request - minDate <" + requestedDateRangeMin + ">, maxDate <" + requestedDateRangeMax + ">, " + "minCross <" + requestedLongitudeRangeMin + ">, maxCross <" + requestedLongitudeRangeMax + ">.");
        InvCatalog resultingCatalog = null;
        try {
            requestedDateRangeMinSecSinceEpoch = this.jplQuikScatCalendar.getSecondsSinceEpochFromDate(this.jplQuikScatCalendar.getDateFromIsoDateTimeString(requestedDateRangeMin));
            double requestedDateRangeMaxSecSinceEpoch = this.jplQuikScatCalendar.getSecondsSinceEpochFromDate(this.jplQuikScatCalendar.getDateFromIsoDateTimeString(requestedDateRangeMax));
        }
        catch (ParseException e) {
            tmpMsg = "Requested date range <" + requestedDateRangeMin + "-" + requestedDateRangeMax + "> " + "could not be parsed: " + e.getMessage();
            log.debug("handleRequest(): " + tmpMsg, (Throwable)e);
            res.sendError(500, tmpMsg);
            ServletUtil.logServerAccess(500, 0L);
            return;
        }
        try {
            resultingCatalog = this.buildCatalogFromRequest(String.valueOf(requestedDateRangeMinSecSinceEpoch), String.valueOf(requestedDateRangeMax), requestedLongitudeRangeMin, requestedLongitudeRangeMax);
        }
        catch (IOException e) {
            tmpMsg = "Failed to read needed information from backing store: " + e.getMessage();
            log.debug("handleRequest(): " + tmpMsg, (Throwable)e);
            res.sendError(500, tmpMsg);
            ServletUtil.logServerAccess(500, 0L);
            return;
        }
        catch (IllegalArgumentException e) {
            tmpMsg = "Invalid Request - requested date range <" + requestedDateRangeMin + "-" + requestedDateRangeMax + "> " + "outside allowed <" + this.allowedDateRange.getAllowedRangeMin() + "-" + this.allowedDateRange.getAllowedRangeMax() + "> " + "or min greater than max - requested longitude range <" + requestedLongitudeRangeMin + "-" + requestedLongitudeRangeMax + "> " + "outside allowed <" + this.allowedLongitudeRange.getAllowedRangeMin() + "-" + this.allowedLongitudeRange.getAllowedRangeMax() + ">: " + e.getMessage();
            log.debug("handleRequest(): " + tmpMsg, (Throwable)e);
            res.sendError(500, tmpMsg);
            ServletUtil.logServerAccess(500, 0L);
            return;
        }
        log.debug("handleRequest(): successfully built catalog, writing response.");
        PrintWriter out = res.getWriter();
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)true);
        String catalogAsString = fac.writeXML_1_0((InvCatalogImpl)resultingCatalog);
        res.setContentType("text/xml");
        res.setStatus(200);
        out.print(catalogAsString);
        ServletUtil.logServerAccess(200, catalogAsString.length());
    }

    protected QueryCapability createDqcDocument(String baseURI) {
        QueryCapability dqc = new QueryCapability(null, "NASA Jet Propulsion Lab, Global Level-2B QuikSCAT Archive", "0.3");
        Query query = new Query(baseURI + "?", null, null);
        dqc.setQuery(query);
        SelectService selectService = new SelectService("serviceType", "Select service type.");
        selectService.addServiceChoice("OpenDAP", "OPeNDAP/DODS", null, null, null);
        selectService.setRequired("false");
        dqc.addUniqueSelector((Selector)selectService);
        dqc.setServiceSelector((Selector)selectService);
        SelectRangeDate selectDateRange = new SelectRangeDate(this.jplQuikScatCalendar.getIsoDateTimeStringFromDate(this.jplQuikScatCalendar.getDateFromSecondsSinceEpoch(this.allowedDateRange.getAllowedRangeMin())), "present", null, "100 minutes", null);
        selectDateRange.setId("dateRange");
        selectDateRange.setTitle("Select Date Range");
        selectDateRange.setTemplate("minDate={start}&maxDate={end}&");
        dqc.addUniqueSelector((Selector)selectDateRange);
        SelectRange selectCrossingLongRange = new SelectRange("0.0", "360.0", "degree_east", "true", null, null);
        selectCrossingLongRange.setId("crossRange");
        selectCrossingLongRange.setTitle("Northerly Equatorial Crossing (longitude)");
        selectCrossingLongRange.setTemplate("minCross={min}&maxCross={max}&");
        dqc.addUniqueSelector((Selector)selectCrossingLongRange);
        return dqc;
    }

    protected InvCatalog buildCatalogFromRequest(String requestedDateRangeStart, String requestedDateRangeEnd, String requestedLongitudeRangeStart, String requestedLongitudeRangeEnd) throws IOException {
        String tmpMsg;
        Iterator dsIt1 = null;
        Iterator dsIt2 = null;
        JplQuikScatEntry curEntry = null;
        JplQuikScatUserQuery request = new JplQuikScatUserQuery(this.jplQuikScatCalendar);
        request.setDateRange(requestedDateRangeStart, requestedDateRangeEnd);
        request.setLongitudeRange(requestedLongitudeRangeStart, requestedLongitudeRangeEnd);
        log.debug("buildCatalogFromRequest(): request isDateSet <" + request.isDateRangeSet() + ">, " + "minDate <" + request.getDateRangeMin() + ">, maxDate <" + request.getDateRangeMax() + ">, " + "isCrossSet <" + request.isLongitudeRangeSet() + ">, " + "minCross <" + request.getLongitudeRangeMin() + ">, maxCross <" + request.getLongitudeRangeMax() + ">.");
        if (!this.validateRequest(request)) {
            String tmpMsg2 = "Invalid request: minDate <" + request.getDateRangeMin() + "> " + "maxDate <" + request.getDateRangeMax() + "> minCross <" + request.getLongitudeRangeMin() + "> " + "maxCross <" + request.getLongitudeRangeMax() + ">.";
            log.debug("buildCatalogFromRequest(): " + tmpMsg2);
            throw new IllegalArgumentException(tmpMsg2);
        }
        if (request.isDateRangeSet() && !request.isLongitudeRangeSet()) {
            this.comparator = new JplQuikScatEntryComparator(JplQuikScatEntryComparator.JplQuikScatEntryComparatorType.DATE_REVERSE);
            tmpMsg = "buildCatalogFromRequest(): date range set, not long range - sort by date.";
        } else if (request.isLongitudeRangeSet() && !request.isDateRangeSet()) {
            this.comparator = new JplQuikScatEntryComparator(JplQuikScatEntryComparator.JplQuikScatEntryComparatorType.LONGITUDE);
            tmpMsg = "buildCatalogFromRequest(): long range set, not date range - sort by longitude.";
        } else if (request.isDateRangeSet() && request.isLongitudeRangeSet()) {
            this.comparator = new JplQuikScatEntryComparator(JplQuikScatEntryComparator.JplQuikScatEntryComparatorType.LONGITUDE);
            tmpMsg = "buildCatalogFromRequest(): long and date ranges set - sort by longitude.";
        } else {
            this.comparator = new JplQuikScatEntryComparator(JplQuikScatEntryComparator.JplQuikScatEntryComparatorType.DATE_REVERSE);
            tmpMsg = "buildCatalogFromRequest(): neither long nor date ranges set - sort by date.";
        }
        log.debug(tmpMsg);
        if (request.isLongitudeRangeSet() && this.allowedLongitudeRange.isModulo() && request.getLongitudeRangeMin() > request.getLongitudeRangeMax()) {
            log.debug("buildCatalogFromRequest(): longitude crosses modulo range boundary - dealing with minRequest to maxAllowed section.");
            JplQuikScatUserQuery request1 = new JplQuikScatUserQuery(this.jplQuikScatCalendar);
            if (request.isDateRangeSet()) {
                request1.setDateRange(request.getDateRangeMin(), request.getDateRangeMax());
            }
            request1.setLongitudeRange(request.getLongitudeRangeMin(), this.allowedLongitudeRange.getAllowedRangeMax());
            dsIt1 = this.jplQsDfs.findMatchingCatalogEntries(request1);
            while (dsIt1.hasNext()) {
                curEntry = (JplQuikScatEntry)dsIt1.next();
                curEntry.setLongitudeMinusModulo();
                this.addToResultsList(curEntry, this.comparator);
            }
            log.debug("buildCatalogFromRequest(): longitude crosses modulo range boundary - dealing with minAllowed to maxRequested section.");
            JplQuikScatUserQuery request2 = new JplQuikScatUserQuery(this.jplQuikScatCalendar);
            if (request.isDateRangeSet()) {
                request2.setDateRange(request.getDateRangeMin(), request.getDateRangeMax());
            }
            request2.setLongitudeRange(this.allowedLongitudeRange.getAllowedRangeMin(), request.getLongitudeRangeMax());
            dsIt2 = this.jplQsDfs.findMatchingCatalogEntries(request2);
            while (dsIt2.hasNext()) {
                curEntry = (JplQuikScatEntry)dsIt2.next();
                this.addToResultsList(curEntry, this.comparator);
            }
        } else {
            log.debug("buildCatalogFromRequest(): longitude does not cross modulo range boundary.");
            JplQuikScatUserQuery reqPart1 = new JplQuikScatUserQuery(this.jplQuikScatCalendar);
            if (request.isDateRangeSet()) {
                reqPart1.setDateRange(request.getDateRangeMin(), request.getDateRangeMax());
            }
            if (request.isLongitudeRangeSet()) {
                reqPart1.setLongitudeRange(request.getLongitudeRangeMin(), request.getLongitudeRangeMax());
            }
            dsIt1 = this.jplQsDfs.findMatchingCatalogEntries(reqPart1);
            while (dsIt1.hasNext()) {
                curEntry = (JplQuikScatEntry)dsIt1.next();
                this.addToResultsList(curEntry, this.comparator);
            }
        }
        log.debug("buildCatalogFromRequest(): list has " + this.resultSortedList.size() + " entries.");
        return this.createCatalog(this.resultSortedList);
    }

    protected boolean validateRequest(JplQuikScatUserQuery request) {
        log.debug("validateRequest(): validate the user request - requested date range minimum <" + request.getDateRangeMin() + ">, " + "requested date range maximum <" + request.getDateRangeMax() + ">, " + "requested longitude range minimum <" + request.getLongitudeRangeMin() + ">, " + "requested longitude range maximum <" + request.getLongitudeRangeMax() + ">.");
        if (request.isDateRangeSet()) {
            if (request.getDateRangeMin() < this.allowedDateRange.getAllowedRangeMin()) {
                String tmp = "validateRequest(): requested date range minimum <" + request.getDateRangeMin() + "> falls before the allowed date range minimum <" + this.allowedDateRange.getAllowedRangeMin() + ">.";
                log.debug(tmp);
                return false;
            }
            if (request.getDateRangeMin() > this.allowedDateRange.getAllowedRangeMax()) {
                String tmp = "validateRequest(): requested date range minimum <" + request.getDateRangeMin() + "> falls after the allowed date range maximum <" + this.allowedDateRange.getAllowedRangeMax() + ">.";
                log.debug(tmp);
                return false;
            }
            if (request.getDateRangeMax() < this.allowedDateRange.getAllowedRangeMin()) {
                String tmp = "validateRequest(): requested date range maximum <" + request.getDateRangeMax() + "> falls before the allowed date range minimum <" + this.allowedDateRange.getAllowedRangeMin() + ">.";
                log.debug(tmp);
                return false;
            }
            if (request.getDateRangeMax() > this.allowedDateRange.getAllowedRangeMax()) {
                String tmp = "validateRequest(): requested date range maximum <" + request.getDateRangeMax() + "> falls after the allowed date range maximum <" + this.allowedDateRange.getAllowedRangeMax() + ">.";
                log.debug(tmp);
                return false;
            }
            if (!(request.getDateRangeMin() < request.getDateRangeMax())) {
                String tmp = "validateRequest(): requested date range minimum <" + request.getDateRangeMin() + "> is greater than the requested date range maximum <" + request.getDateRangeMax() + ">.";
                log.debug(tmp);
                return false;
            }
        }
        if (request.isLongitudeRangeSet()) {
            if (request.getLongitudeRangeMin() < this.allowedLongitudeRange.getAllowedRangeMin()) {
                String tmp = "validateRequest(): the requested longitude range minimum <" + request.getLongitudeRangeMin() + "> is less than the allowed longitude range minimum <" + this.allowedLongitudeRange.getAllowedRangeMin() + ">.";
                log.debug(tmp);
                return false;
            }
            if (request.getLongitudeRangeMin() > this.allowedLongitudeRange.getAllowedRangeMax()) {
                String tmp = "validateRequest(): the requested longitude range minimum <" + request.getLongitudeRangeMin() + "> is greater than the allowed longitude range maximum <" + this.allowedLongitudeRange.getAllowedRangeMax() + ">.";
                log.debug(tmp);
                return false;
            }
            if (request.getLongitudeRangeMax() < this.allowedLongitudeRange.getAllowedRangeMin()) {
                String tmp = "validateRequest(): the requested longitude range maximum <" + request.getLongitudeRangeMax() + "> is less than the allowed longitude range minimum<" + this.allowedLongitudeRange.getAllowedRangeMin() + ">.";
                log.debug(tmp);
                return false;
            }
            if (request.getLongitudeRangeMax() > this.allowedLongitudeRange.getAllowedRangeMax()) {
                String tmp = "validateRequest(): the requested longitude range maximum <" + request.getLongitudeRangeMax() + "> is greater than the allowed longitude range maximum <" + this.allowedLongitudeRange.getAllowedRangeMax() + ">.";
                log.debug(tmp);
                return false;
            }
        }
        return true;
    }

    protected void addToResultsList(JplQuikScatEntry entry, Comparator comparator) {
        if (entry == null) {
            return;
        }
        if (comparator == null) {
            this.resultSortedList.add(entry);
            return;
        }
        int index = Collections.binarySearch(this.resultSortedList, entry, comparator);
        if (index < 0) {
            this.resultSortedList.add(-index - 1, entry);
        } else {
            this.resultSortedList.add(index, entry);
        }
    }

    protected InvCatalog createCatalog(List entries) {
        log.debug("createCatalog(): allowedRangeMin - create resulting catalog.");
        String serviceName = "jplQuikSCAT";
        String serviceTypeName = ServiceType.DODS.toString();
        String serviceBaseURL = "http://dods.jpl.nasa.gov/cgi-bin/nph-dods/pub/ocean_wind/quikscat/L2B/data";
        InvCatalogImpl catalog = new InvCatalogImpl(null, null, null);
        InvService myService = new InvService(serviceName, serviceTypeName, serviceBaseURL, null, null);
        InvDatasetImpl topDs = new InvDatasetImpl(null, this.jplQsDfs.getCatalogTitle());
        catalog.addService(myService);
        catalog.addDataset(topDs);
        JplQuikScatEntry curEntry = null;
        InvDatasetImpl curDs = null;
        String curDsName = null;
        String curDsDodsUrl = null;
        Date curDsDate = null;
        String curDsDateString = null;
        InvProperty property = null;
        for (int i = 0; i < entries.size(); ++i) {
            curEntry = (JplQuikScatEntry)entries.get(i);
            curDsDodsUrl = curEntry.getDodsUrl();
            curDsDodsUrl = curDsDodsUrl.substring(curDsDodsUrl.indexOf(serviceBaseURL));
            curDsDate = curEntry.getDate();
            curDsDateString = this.jplQuikScatCalendar.getIsoDateTimeStringFromDate(curDsDate);
            float curDsLongitude = curEntry.getLongitude();
            int curDsRevNum = curEntry.getRevNum();
            int curDsWvcRows = curEntry.getWvcRows();
            curDsName = "QuikSCAT Level-2B - " + curDsDateString + " - longitude " + curDsLongitude;
            curDs = new InvDatasetImpl(topDs, curDsName, null, serviceName, curDsDodsUrl);
            property = new InvProperty("Date", curDsDateString);
            curDs.addProperty(property);
            property = new InvProperty("Longitude", Float.toString(curDsLongitude));
            curDs.addProperty(property);
            property = new InvProperty("Rev Number", Integer.toString(curDsRevNum));
            curDs.addProperty(property);
            property = new InvProperty("WVC Rows", Integer.toString(curDsWvcRows));
            curDs.addProperty(property);
        }
        return catalog;
    }
}

