/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.jplQuikSCAT;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatEntry;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatUserQuery;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Structure;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;

public class JplQuikScatDodsFileServer {
    private static Logger log = LoggerFactory.getLogger(JplQuikScatDodsFileServer.class);
    protected String dfsUrl = null;
    protected DODSNetcdfFile theDfsCatalog = null;
    protected DODSStructure catalogSeq = null;
    protected Attribute catTitleAtt = null;
    protected Attribute catAllowedDateRangeStartAtt = null;
    protected Attribute catAllowedDateRangeEndAtt = null;
    protected String catSeqName = null;
    protected String catTitleAttName = null;
    protected String catAllowedDateRangeStartAttName = null;
    protected String catAllowedDateRangeEndAttName = null;
    protected String catTitle = null;
    protected Date allowedDateRangeMin = null;
    protected Date allowedDateRangeMax = null;
    protected double allowedLongitudeRangeMin = 0.0;
    protected double allowedLongitudeRangeMax = 0.0;
    protected String dfsDateStringFormat = "yyyy/MM/dd";
    protected String dfsDateTimeFunctionParameterFormat = "yyyy-MM-dd:HH:mm";
    protected String dfsDateTimeStringFormat = "yyyy/MM/dd:HH:mm:ss z";
    protected String dfsYearDayStringFormat = "yyyy/DDD";
    protected Calendar calendar = null;

    public JplQuikScatDodsFileServer() throws IOException {
        String tmpMsg = null;
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        this.dfsUrl = "http://dods.jpl.nasa.gov/dods-bin/nph-dods/catalogs/quikscat/L2B/quikscat_L2.dat";
        this.catSeqName = "QuikSCAT_L2B";
        this.catTitleAttName = "DODS_Global.DODS_Title";
        this.catAllowedDateRangeStartAttName = "DODS_Global.DODS_StartDate";
        this.catAllowedDateRangeEndAttName = "DODS_Global.DODS_EndDate";
        this.allowedLongitudeRangeMin = 0.0;
        this.allowedLongitudeRangeMax = 360.0;
        log.debug("JplQuikScatDodsFileServer(): opening DODS dataset for this DFS catalog <" + this.dfsUrl + ">.");
        try {
            this.theDfsCatalog = new DODSNetcdfFile(this.dfsUrl);
        }
        catch (IOException e) {
            tmpMsg = "JplQuikScatDodsFileServer(): IO exception thrown while opening DODS dataset <" + this.dfsUrl + "> for this DFS catalog: " + e.getMessage();
            log.debug(tmpMsg, (Throwable)e);
            throw (IOException)new IOException(tmpMsg).initCause(e);
        }
        log.debug("JplQuikScatDodsFileServer(): getting DODS sequence <" + this.catSeqName + "> for this DFS catalog.");
        this.catalogSeq = (DODSStructure)this.theDfsCatalog.findVariable(this.catSeqName);
        if (this.catalogSeq == null) {
            tmpMsg = "JplQuikScatDodsFileServer(): DODS Sequence <" + this.catSeqName + "> not found.";
            log.debug(tmpMsg);
            throw new IOException(tmpMsg);
        }
        this.catTitleAtt = this.theDfsCatalog.findGlobalAttribute(this.catTitleAttName);
        log.debug("JplQuikScatDodsFileServer(): getting DODS attrib info for this DFS catalog, title and allowed date range.");
        this.catTitleAtt = this.theDfsCatalog.findGlobalAttribute(this.catTitleAttName);
        this.catAllowedDateRangeStartAtt = this.theDfsCatalog.findGlobalAttribute(this.catAllowedDateRangeStartAttName);
        this.catAllowedDateRangeEndAtt = this.theDfsCatalog.findGlobalAttribute(this.catAllowedDateRangeEndAttName);
        if (this.catTitleAtt == null || this.catAllowedDateRangeStartAtt == null || this.catAllowedDateRangeEndAtt == null) {
            tmpMsg = "JplQuikScatDodsFileServer(): title <" + this.catTitleAtt.getStringValue() + ">, allowed date range" + " minimum <" + this.catAllowedDateRangeStartAtt.getStringValue() + "> or" + " maximum <" + this.catAllowedDateRangeEndAtt.getStringValue() + "> is null.";
            log.debug(tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
        this.catTitle = this.catTitleAtt.getStringValue();
        this.allowedDateRangeMin = this.getDateFromDfsDateString(this.catAllowedDateRangeStartAtt.getStringValue());
        this.allowedDateRangeMax = this.getDateFromDfsDateString(this.catAllowedDateRangeEndAtt.getStringValue());
        log.debug("JplQuikScatDodsFileServer(): done.");
    }

    public String getCatalogTitle() {
        return this.catTitle;
    }

    public Date getAllowedDateRangeMin() {
        return this.allowedDateRangeMin;
    }

    public Date getAllowedDateRangeMax() {
        return this.allowedDateRangeMax;
    }

    public double getAllowedLongitudeRangeMin() {
        return this.allowedLongitudeRangeMin;
    }

    public double getAllowedLongitudeRangeMax() {
        return this.allowedLongitudeRangeMax;
    }

    String buildConstraintExpression(JplQuikScatUserQuery request) {
        log.debug("buildConstraintExpression(): requested date range minimum <" + request.getDateRangeMinDate().toString() + ">, requested date range maximum <" + request.getDateRangeMaxDate().toString() + ">, " + "requested longitude range minimum <" + request.getLongitudeRangeMin() + ">, " + "requested longitude range maximum <" + request.getLongitudeRangeMax() + ">.");
        String ce = null;
        StringBuffer ceSel = new StringBuffer();
        String dateSelCE = null;
        String longSelCE = null;
        if (request.isDateRangeSet()) {
            String startDateString = this.getDfsDateTimeFunctionParameterStringFromDate(request.getDateRangeMinDate());
            String endDateString = this.getDfsDateTimeFunctionParameterStringFromDate(request.getDateRangeMaxDate());
            log.debug("buildConstraintExpression(): date range as ISO date string, from " + startDateString + " to " + endDateString + ".");
            dateSelCE = "date_time(\"" + startDateString + "\",\"" + endDateString + "\")";
        }
        if (request.isLongitudeRangeSet() && request.getLongitudeRangeMin() != request.getLongitudeRangeMax() && request.getLongitudeRangeMin() != this.allowedLongitudeRangeMin && request.getLongitudeRangeMax() != this.allowedLongitudeRangeMin) {
            longSelCE = this.catSeqName + ".longitude>" + request.getLongitudeRangeMin() + "&" + this.catSeqName + ".longitude<" + request.getLongitudeRangeMax();
            log.debug("buildConstraintExpression(): got requested longitude range CE <" + longSelCE + ">.");
        }
        if (dateSelCE != null) {
            ceSel.append(dateSelCE);
        }
        if (longSelCE != null) {
            if (ceSel.length() == 0) {
                ceSel.append(longSelCE);
            } else {
                ceSel.append("&").append(longSelCE);
            }
        }
        if (ceSel.length() > 0) {
            ce = "&" + ceSel.toString();
        }
        log.debug("buildConstraintExpression(): the CE is <" + ce + ">.");
        return ce;
    }

    public Iterator findMatchingCatalogEntries(JplQuikScatUserQuery request) throws IOException {
        DfsIterator retIt = null;
        String ce = null;
        log.debug("findMatchingCatalogEntries(): build DODS CE.");
        ce = this.buildConstraintExpression(request);
        log.debug("findMatchingCatalogEntries(): request catalog entries with DODS CE <" + ce + ">.");
        Structure.Iterator dodsIt = this.catalogSeq.getStructureIterator();
        retIt = new DfsIterator(dodsIt);
        return retIt;
    }

    protected Date getDateFromDfsDateString(String theDateString) {
        Date theDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dfsDateStringFormat, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            theDate = dateFormat.parse(theDateString);
        }
        catch (ParseException e) {
            log.debug("getDateFromDfsDateString(): parsing of date string threw exception: " + e.getMessage());
            return null;
        }
        this.calendar.clear();
        this.calendar.setTime(theDate);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        theDate = this.calendar.getTime();
        return theDate;
    }

    protected Date getDateFromDfsDateTimeString(String dfsDateString) {
        if (dfsDateString == null) {
            throw new IllegalArgumentException();
        }
        log.debug("getDateFromDfsDateTimeString(): allowedRangeMin - format <" + this.dfsDateTimeStringFormat + ">.");
        Date theDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dfsDateTimeStringFormat, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        log.debug("getDateFromDfsDateTimeString(): parsing date string <" + dfsDateString + ">.");
        try {
            theDate = dateFormat.parse(dfsDateString);
        }
        catch (ParseException e) {
            log.debug("getDateFromDfsDateTimeString(): parsing of date string threw exception: " + e.getMessage());
            return null;
        }
        this.calendar.clear();
        this.calendar.setTime(theDate);
        this.calendar.set(14, 0);
        theDate = this.calendar.getTime();
        log.debug("getDateFromDfsDateTimeString(): date is " + dateFormat.format(theDate));
        return theDate;
    }

    protected String getDfsDateTimeFunctionParameterStringFromDate(Date theDate) {
        log.debug("getDfsDateTimeFunctionParameterStringFromDate(): format the given date <" + theDate.toString() + "> with the DFS date_time() server-side function string format <" + this.dfsDateTimeFunctionParameterFormat + ">.");
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dfsDateTimeFunctionParameterFormat, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateString = dateFormat.format(theDate);
        log.debug("getDfsDateTimeFunctionParameterStringFromDate(): done <" + dateString + ">.");
        return dateString;
    }

    private class DfsIterator
    implements Iterator {
        private Structure.Iterator dfsIterator = null;
        private JplQuikScatEntry nextEntry = null;
        private boolean done = false;
        private int curItemNumFromBackingStore = 0;
        private int curItemNum = 0;

        protected DfsIterator(Structure.Iterator dfsIterator) {
            this.dfsIterator = dfsIterator;
            if (this.dfsIterator == null) {
                this.done = true;
            }
        }

        public boolean hasNext() {
            String tmpMsg = null;
            if (this.done) {
                return false;
            }
            if (this.nextEntry != null) {
                return true;
            }
            while (this.dfsIterator.hasNext()) {
                StructureData ds = null;
                try {
                    ++this.curItemNumFromBackingStore;
                    ds = this.dfsIterator.next();
                }
                catch (IOException e) {
                    tmpMsg = "IOException accessing next item in iterator < item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">: " + e.getMessage();
                    log.debug(tmpMsg);
                    continue;
                }
                catch (ClassCastException e) {
                    tmpMsg = "DfsIterator.next(): item not a DODSStructure < item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">: " + e.getMessage();
                    log.debug(tmpMsg);
                    continue;
                }
                if (ds == null) {
                    tmpMsg = "DfsIterator.next(): entry was null < item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">.";
                    log.debug(tmpMsg);
                    continue;
                }
                try {
                    this.nextEntry = new JplQuikScatEntry(ds);
                }
                catch (IllegalArgumentException e) {
                    tmpMsg = "DfsIterator.next(): IllegalArgumentException while reading entry (i.e., entry not a JPL QuikSCAT DFS DODSStructure catalog entry)< item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">: " + e.getMessage();
                    log.debug(tmpMsg);
                    continue;
                }
                catch (Exception e) {
                    tmpMsg = "DfsIterator.next(): Exception while creating entry < item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">: " + e.getMessage();
                    log.debug(tmpMsg);
                    continue;
                }
                ++this.curItemNum;
                return true;
            }
            this.done = true;
            this.nextEntry = null;
            tmpMsg = "DfsIterator.next(): no more items in backing iterator < item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">.";
            log.debug(tmpMsg);
            return false;
        }

        public Object next() {
            String tmpMsg = null;
            if (this.done) {
                tmpMsg = "DfsIterator.next(): iteration is done < item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">, throwing NoSuchElementException.";
                log.debug(tmpMsg);
                throw new NoSuchElementException(tmpMsg);
            }
            JplQuikScatEntry retVal = null;
            if (this.nextEntry != null) {
                retVal = this.nextEntry;
                this.nextEntry = null;
                return retVal;
            }
            if (this.hasNext()) {
                retVal = this.nextEntry;
                this.nextEntry = null;
                return retVal;
            }
            this.done = true;
            tmpMsg = "DfsIterator.next(): iteration is done <item numbers - " + this.curItemNum + " - " + this.curItemNumFromBackingStore + ">, throwing NoSuchElementException.";
            log.debug(tmpMsg);
            throw new NoSuchElementException(tmpMsg);
        }

        public void remove() {
            String tmpMsg = "DfsIterator.remove(): unsupported operation - backing store unknown (part of ucar.nc2.dods package).";
            log.debug(tmpMsg);
            throw new UnsupportedOperationException(tmpMsg);
        }
    }
}

