/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc.server.jplQuikSCAT;

import java.util.Comparator;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.server.jplQuikSCAT.JplQuikScatEntry;

public class JplQuikScatEntryComparator
implements Comparator {
    private static Logger log = LoggerFactory.getLogger(JplQuikScatEntryComparator.class);
    private JplQuikScatEntryComparatorType type = null;

    public JplQuikScatEntryComparator(JplQuikScatEntryComparatorType type) {
        this.type = type;
    }

    public int compare(Object obj1, Object obj2) {
        if (!(obj1 instanceof JplQuikScatEntry) || !(obj2 instanceof JplQuikScatEntry)) {
            String tmp = "compare(): both objects should be JPL QuikSCAT entries <" + obj1.getClass().getName() + " - " + obj2.getClass().getName() + "> but are not.";
            log.debug(tmp);
            throw new ClassCastException(tmp);
        }
        JplQuikScatEntry entry1 = (JplQuikScatEntry)obj1;
        JplQuikScatEntry entry2 = (JplQuikScatEntry)obj2;
        if (this.type == JplQuikScatEntryComparatorType.DATE) {
            return entry1.getDate().compareTo(entry2.getDate());
        }
        if (this.type == JplQuikScatEntryComparatorType.DATE_REVERSE) {
            return entry2.getDate().compareTo(entry1.getDate());
        }
        if (this.type == JplQuikScatEntryComparatorType.LONGITUDE) {
            return Float.compare(entry1.getLongitude(), entry2.getLongitude());
        }
        if (this.type == JplQuikScatEntryComparatorType.LONGITUDE_REVERSE) {
            return Float.compare(entry2.getLongitude(), entry1.getLongitude());
        }
        return entry1.getDate().compareTo(entry2.getDate());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JplQuikScatEntryComparator)) {
            return false;
        }
        return this.type.equals(((JplQuikScatEntryComparator)obj).type);
    }

    public static final class JplQuikScatEntryComparatorType {
        private static HashMap hash = new HashMap(20);
        public static final JplQuikScatEntryComparatorType DATE = new JplQuikScatEntryComparatorType("Date");
        public static final JplQuikScatEntryComparatorType DATE_REVERSE = new JplQuikScatEntryComparatorType("DateReverse");
        public static final JplQuikScatEntryComparatorType LONGITUDE = new JplQuikScatEntryComparatorType("Longitude");
        public static final JplQuikScatEntryComparatorType LONGITUDE_REVERSE = new JplQuikScatEntryComparatorType("LongitudeReverse");
        private String name;

        private JplQuikScatEntryComparatorType(String name) {
            this.name = name;
            hash.put(this.name, this);
        }

        public static JplQuikScatEntryComparatorType getType(String name) {
            if (name == null) {
                return null;
            }
            return (JplQuikScatEntryComparatorType)hash.get(name);
        }

        public String toString() {
            return this.name;
        }
    }
}

