/*
 * Decompiled with CFR 0.152.
 */
package thredds.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDatasetScan;
import thredds.examples.MockOpendapDSP;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.Debug;
import thredds.servlet.DebugHandler;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import thredds.util.IO;

public class ExampleThreddsServlet
extends HttpServlet {
    protected Logger log;
    protected String rootPath;
    protected String contentPath;
    protected DataRootHandler dataRootHandler;

    protected String getVersion() {
        return "ETS version 0.1";
    }

    protected String getDocsPath() {
        return "docs/";
    }

    protected String getUserCssPath() {
        return "upc.css";
    }

    protected String getContextLogoPath() {
        return "thredds.jpg";
    }

    protected String getContextLogoAlt() {
        return "thredds";
    }

    protected String getInstituteLogoPath() {
        return "unidataLogo.gif";
    }

    protected String getInstituteLogoAlt() {
        return "unidata";
    }

    protected String getFolderIconPath() {
        return "folder.gif";
    }

    protected String getFolderIconAlt() {
        return "folder";
    }

    public void init() throws ServletException {
        ServletUtil.setContextPath(this);
        ServletUtil.initDebugging(this);
        this.rootPath = ServletUtil.getRootPath(this);
        this.contentPath = ServletUtil.getContentPath(this);
        ServletUtil.initLogging(this);
        ServletUtil.logServerSetup(((Object)((Object)this)).getClass().getName() + ".init()");
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.log.info("servlet context name= " + this.getServletContext().getServletContextName());
        this.log.info("servlet context path= " + ServletUtil.getContextPath());
        this.log.info("rootPath= " + this.rootPath);
        this.log.info("contentPath= " + this.contentPath);
        String initialContentPath = ServletUtil.getInitialContentPath(this);
        File initialContentFile = new File(initialContentPath);
        if (initialContentFile.exists()) {
            try {
                if (ServletUtil.copyDir(initialContentPath, this.contentPath)) {
                    this.log.info("copyDir " + initialContentPath + " to " + this.contentPath);
                }
            }
            catch (IOException ioe) {
                this.log.error("failed to copyDir " + initialContentPath + " to " + this.contentPath, (Throwable)ioe);
            }
        }
        InvDatasetScan.setContext((String)ServletUtil.getContextPath());
        InvDatasetScan.setCatalogServletName((String)"");
        DataRootHandler.init(this.contentPath, ServletUtil.getContextPath());
        this.dataRootHandler = DataRootHandler.getInstance();
        ArrayList<String> cats = new ArrayList<String>();
        cats.add("catalog.xml");
        cats.add("extraCatalog.xml");
        try {
            this.dataRootHandler.initCatalogs(cats);
        }
        catch (Throwable e) {
            this.log.error("Error initializing catalog: " + e.getMessage(), e);
        }
        this.makeDebugActions();
        this.dataRootHandler.makeDebugActions();
        DatasetHandler.makeDebugActions();
        HtmlWriter.init(ServletUtil.getContextPath(), this.getServletContext().getServletContextName(), this.getVersion(), this.getDocsPath(), this.getUserCssPath(), this.getContextLogoPath(), this.getContextLogoAlt(), this.getInstituteLogoPath(), this.getContextLogoAlt(), this.getFolderIconPath(), this.getFolderIconAlt());
        this.log.info("--- initialized " + ((Object)((Object)this)).getClass().getName());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        String path = req.getPathInfo();
        if (path == null || path.equals("")) {
            String newPath = req.getRequestURL().append("/").toString();
            ServletUtil.sendPermanentRedirect(newPath, req, res);
            return;
        }
        if (path.startsWith("/content/")) {
            ServletUtil.handleRequestForContentFile(path, this, req, res);
            return;
        }
        if (path.startsWith("/root/")) {
            ServletUtil.handleRequestForRootFile(path, this, req, res);
            return;
        }
        if (path.equals("/debug") || path.equals("/debug/")) {
            DebugHandler.doDebug(this, req, res);
            return;
        }
        if (this.dataRootHandler.processReqForCatalog(req, res)) {
            return;
        }
        if (this.dataRootHandler.hasDataRootMatch(path)) {
            this.dataRootHandler.handleRequestForDataset(path, new MockOpendapDSP(), req, res);
            return;
        }
        ServletUtil.handleRequestForRawFile(path, this, req, res);
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("General");
        DebugHandler.Action act = new DebugHandler.Action("showVersion", "Show Build Version"){

            public void doAction(DebugHandler.Event e) {
                try {
                    IO.copyFile((String)(ExampleThreddsServlet.this.rootPath + "README.txt"), (OutputStream)e.pw);
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRuntime", "Show Runtime info"){

            public void doAction(DebugHandler.Event e) {
                Runtime runt = Runtime.getRuntime();
                double scale = 1.0E-6;
                e.pw.println(" freeMemory= " + scale * (double)runt.freeMemory() + " Mb");
                e.pw.println(" totalMemory= " + scale * (double)runt.totalMemory() + " Mb");
                e.pw.println(" maxMemory= " + scale * (double)runt.maxMemory() + " Mb");
                e.pw.println(" availableProcessors= " + runt.availableProcessors());
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showFlags", "Show Debugging Flags"){

            public void doAction(DebugHandler.Event e) {
                ExampleThreddsServlet.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("toggleFlag", null){

            public void doAction(DebugHandler.Event e) {
                if (e.target != null) {
                    String flag;
                    Debug.set(flag, !Debug.isSet(flag = e.target));
                } else {
                    e.pw.println(" Must be toggleFlag=<flagName>");
                }
                ExampleThreddsServlet.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showLoggers", "Show Log4J info"){

            public void doAction(DebugHandler.Event e) {
                ExampleThreddsServlet.this.showLoggers(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("setLogger", null){

            public void doAction(DebugHandler.Event e) {
                if (e.target == null) {
                    e.pw.println(" Must be setLogger=loggerName");
                    return;
                }
                StringTokenizer stoker = new StringTokenizer(e.target, "&=");
                if (stoker.countTokens() < 3) {
                    e.pw.println(" Must be setLogger=loggerName&setLevel=levelName");
                    return;
                }
                String loggerName = stoker.nextToken();
                stoker.nextToken();
                String levelName = stoker.nextToken();
                boolean isRootLogger = loggerName.equals("root");
                if (!isRootLogger && LogManager.exists((String)loggerName) == null) {
                    e.pw.println(" Unknown logger=" + loggerName);
                    return;
                }
                if (Level.toLevel((String)levelName, null) == null) {
                    e.pw.println(" Unknown level=" + levelName);
                    return;
                }
                org.apache.log4j.Logger log = isRootLogger ? LogManager.getRootLogger() : LogManager.getLogger((String)loggerName);
                log.setLevel(Level.toLevel((String)levelName));
                e.pw.println(loggerName + " set to " + levelName);
                ExampleThreddsServlet.this.showLoggers(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRequest", "Show HTTP Request info"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println(ServletUtil.showRequestDetail(ExampleThreddsServlet.this, e.req));
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showServerInfo", "Show Server info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showServerInfo(ExampleThreddsServlet.this, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showServletInfo", "Show Servlet info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showServletInfo(ExampleThreddsServlet.this, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSession", "Show HTTP Session info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showSession(e.req, e.res, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSecurity", "Show Security info"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println(ServletUtil.showSecurity(e.req, "admin"));
            }
        };
        debugHandler.addAction(act);
    }

    void showFlags(HttpServletRequest req, PrintStream pw) {
        for (Object o : Debug.keySet()) {
            String key = (String)o;
            String url = req.getRequestURI() + "?toggleFlag=" + key;
            pw.println("  <a href='" + url + "'>" + key + " = " + Debug.isSet(key) + "</a>");
        }
    }

    void showLoggers(HttpServletRequest req, PrintStream pw) {
        org.apache.log4j.Logger root = LogManager.getRootLogger();
        this.showLogger(req, root, pw);
        Enumeration logEnums = LogManager.getCurrentLoggers();
        ArrayList<org.apache.log4j.Logger> loggersSorted = Collections.list(logEnums);
        Collections.sort(loggersSorted, new LoggerComparator());
        for (org.apache.log4j.Logger logger : loggersSorted) {
            this.showLogger(req, logger, pw);
        }
    }

    private void showLogger(HttpServletRequest req, org.apache.log4j.Logger logger, PrintStream pw) {
        pw.print(" logger = " + logger.getName() + " level= ");
        String url = req.getRequestURI() + "?setLogger=" + logger.getName() + "&level=";
        this.showLevel(url, Level.ALL, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.DEBUG, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.INFO, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.WARN, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.ERROR, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.FATAL, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.OFF, logger.getEffectiveLevel(), pw);
        pw.println();
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            AppenderSkeleton skapp;
            Appender app = (Appender)appenders.nextElement();
            pw.println("  appender= " + app.getName() + " " + app.getClass().getName());
            if (app instanceof AppenderSkeleton && (skapp = (AppenderSkeleton)app).getThreshold() != null) {
                pw.println("    threshold=" + skapp.getThreshold());
            }
            if (!(app instanceof FileAppender)) continue;
            FileAppender fapp = (FileAppender)app;
            pw.println("    file=" + fapp.getFile());
        }
    }

    private void showLevel(String baseUrl, Level show, Level current, PrintStream pw) {
        if (show.toInt() != current.toInt()) {
            pw.print(" <a href='" + baseUrl + show + "'>" + show + "</a>");
        } else {
            pw.print(" " + show);
        }
    }

    private class LoggerComparator
    implements Comparator {
        private LoggerComparator() {
        }

        public int compare(Object o1, Object o2) {
            org.apache.log4j.Logger l1 = (org.apache.log4j.Logger)o1;
            org.apache.log4j.Logger l2 = (org.apache.log4j.Logger)o2;
            return l1.getName().compareTo(l2.getName());
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }
}

