/*
 * Decompiled with CFR 0.152.
 */
package thredds.examples;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.servlet.DataServiceProvider;
import thredds.servlet.ServletUtil;

public class MockOpendapDSP
implements DataServiceProvider {
    public DataServiceProvider.DatasetRequest getRecognizedDatasetRequest(String path, HttpServletRequest req) {
        MyDsReq dsReq = path.endsWith(".dds") ? new MyDsReq(path.substring(0, path.lastIndexOf(".dds")), ".dds", req.getQueryString()) : (path.endsWith(".das") ? new MyDsReq(path.substring(0, path.lastIndexOf(".das")), ".das", req.getQueryString()) : (path.endsWith(".dods") ? new MyDsReq(path.substring(0, path.lastIndexOf(".dods")), ".dods", req.getQueryString()) : (path.endsWith(".ddx") ? new MyDsReq(path.substring(0, path.lastIndexOf(".ddx")), ".ddx", req.getQueryString()) : (path.endsWith(".info") ? new MyDsReq(path.substring(0, path.lastIndexOf(".info")), ".info", req.getQueryString()) : (path.endsWith(".html") ? new MyDsReq(path.substring(0, path.lastIndexOf(".html")), ".html", req.getQueryString()) : (path.endsWith(".ver") ? new MyDsReq(path.substring(0, path.lastIndexOf(".ver")), ".ver", req.getQueryString()) : (path.endsWith("/version") ? new MyDsReq(path.substring(0, path.lastIndexOf("/version")), "/version", req.getQueryString()) : (path.endsWith("/version/") ? new MyDsReq(path.substring(0, path.lastIndexOf("/version/")), "/version/", req.getQueryString()) : null))))))));
        return dsReq;
    }

    public void handleRequestForDataset(DataServiceProvider.DatasetRequest dsReq, CrawlableDataset crDs, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (dsReq == null) {
            throw new IllegalArgumentException("DatasetRequest must not be null.");
        }
        if (crDs == null) {
            throw new IllegalArgumentException("CrawlableDataset must not be null.");
        }
        String path = dsReq.getDatasetPath();
        String ext = ((MyDsReq)dsReq).getDatasetExt();
        String ce = ((MyDsReq)dsReq).getDatasetCe();
        if (crDs instanceof CrawlableDatasetFile) {
            File crDsFile = ((CrawlableDatasetFile)crDs).getFile();
            if (crDsFile.exists()) {
                PrintWriter out = res.getWriter();
                res.setContentType("text/html");
                res.setStatus(200);
                StringBuffer responseString = new StringBuffer();
                responseString.append(this.getHtmlDoctypeAndOpenTag()).append("<head><title>Test Response to Data Request</title></head><body>\n").append("<h1>Test Response to Data Request</h1>\n").append("<ul>\n").append("<li>Dataset requested: ").append(path).append("</li>\n").append("<li>File to serve: ").append(crDsFile.getPath()).append("</li>\n").append("<li>OPeNDAP request: ").append(ext).append("</li>\n").append("<li>OPeNDAP ce: ").append(ce).append("</li>\n").append("</p>\n").append("</body></html>");
                out.print(responseString.toString());
                out.flush();
                ServletUtil.logServerAccess(200, responseString.length());
                return;
            }
            ServletUtil.logServerAccess(500, -1L);
            res.sendError(500, "Valid CrawlableDatasetFile but File returned by getFile() does not exist.");
            return;
        }
        ServletUtil.logServerAccess(500, 0L);
        res.sendError(500, "Type of CrawlableDataset <> not undersood.");
    }

    public void handleUnrecognizedRequestForCollection(CrawlableDataset crDs, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String newPath = req.getRequestURL().append("/catalog.html").toString();
        ServletUtil.sendPermanentRedirect(newPath, req, res);
    }

    public void handleUnrecognizedRequest(CrawlableDataset crDs, HttpServletRequest req, HttpServletResponse res) throws IOException {
        StringBuffer responseString = new StringBuffer();
        responseString.append(this.getHtmlDoctypeAndOpenTag()).append("<head><title>Not an OPeNDAP Request</title></head><body>\n").append("<h1>Not an OPeNDAP Request</h1>\n").append("<p>Expected URL to end in \".dds\", \".das\", \".dods\", \".html\",etc.\n").append("</p>\n").append("</body></html>");
        ServletUtil.logServerAccess(400, responseString.length());
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        res.setStatus(400);
        out.print(responseString.toString());
        out.flush();
    }

    private String getHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n").toString();
    }

    private String getXHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n").append("        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">").toString();
    }

    private class MyDsReq
    implements DataServiceProvider.DatasetRequest {
        private String _path;
        private String _ext;
        private String _ce;

        private MyDsReq(String path, String ext, String ce) {
            this._path = path;
            this._ext = ext;
            this._ce = ce;
        }

        public String getDatasetPath() {
            return this._path;
        }

        public String getDatasetExt() {
            return this._ext;
        }

        public String getDatasetCe() {
            return this._ce;
        }
    }
}

