/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.datatype.DateType;
import thredds.server.ncSubset.QueryParams;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.Station;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.point.WriterProfileObsDataset;
import ucar.nc2.dt.point.WriterStationObsDataset;
import ucar.nc2.units.DateFormatter;

public class GridPointWriter {
    private static Logger log = LoggerFactory.getLogger(GridPointWriter.class);
    private static boolean debug = false;
    private static long timeToScan = 0L;
    private DateFormatter format = new DateFormatter();
    private ucar.nc2.dt.GridDataset gds;

    public GridPointWriter(ucar.nc2.dt.GridDataset gds) {
        this.gds = gds;
    }

    public File write(QueryParams qp, PrintWriter pw) throws IOException, InvalidRangeException {
        Writer w;
        long starting = System.currentTimeMillis();
        Limit counter = new Limit();
        ArrayList<GridDatatype> grids = new ArrayList<GridDatatype>();
        for (String gridName : qp.vars) {
            GridDatatype grid = this.gds.findGridDatatype(gridName);
            if (grid == null) continue;
            grids.add(grid);
        }
        GridAsPointDataset gap = new GridAsPointDataset(grids);
        List dates = gap.getDates();
        double[] zValues = null;
        CoordinateAxis1D zAxis = null;
        GridDatatype useForZ = null;
        for (GridDatatype grid : grids) {
            zAxis = grid.getCoordinateSystem().getVerticalAxis();
            useForZ = grid;
            if (zAxis == null) continue;
            break;
        }
        boolean hasZ = zAxis != null;
        List<Date> wantDates = new ArrayList();
        if (qp.hasTimePoint) {
            long want = qp.time.getDate().getTime();
            int best_index = 0;
            long best_diff = Long.MAX_VALUE;
            for (int i = 0; i < dates.size(); ++i) {
                Date date = (Date)dates.get(i);
                long diff = Math.abs(date.getTime() - want);
                if (diff >= best_diff) continue;
                best_index = i;
                best_diff = diff;
            }
            wantDates.add((Date)dates.get(best_index));
        } else if (qp.hasDateRange) {
            Date start = qp.getDateRange().getStart().getDate();
            Date end = qp.getDateRange().getEnd().getDate();
            for (Date date : dates) {
                if (date.before(start) || date.after(end)) continue;
                wantDates.add(date);
            }
        } else {
            wantDates = dates;
        }
        boolean hasMultipleTimes = wantDates.size() > 1;
        StructureMembers members = new StructureMembers("");
        int[] scalarShape = new int[]{};
        ArrayObject.D0 stnData = new ArrayObject.D0(String.class);
        StructureMembers.Member timeMember = members.addMember("date", null, null, DataType.STRING, scalarShape);
        ArrayObject.D0 timeData = new ArrayObject.D0(String.class);
        StructureMembers.Member latMember = members.addMember("lat", null, "degrees_north", DataType.DOUBLE, scalarShape);
        ArrayDouble.D0 latData = new ArrayDouble.D0();
        StructureMembers.Member lonMember = members.addMember("lon", null, "degrees_east", DataType.DOUBLE, scalarShape);
        ArrayDouble.D0 lonData = new ArrayDouble.D0();
        StructureDataW sdata = new StructureDataW(members);
        sdata.setMemberData(timeMember, (Array)timeData);
        sdata.setMemberData(latMember, (Array)latData);
        sdata.setMemberData(lonMember, (Array)lonData);
        ArrayDouble.D0 zData = new ArrayDouble.D0();
        if (hasZ) {
            StructureMembers.Member zMember = members.addMember("vertCoord", null, zAxis.getUnitsString(), DataType.DOUBLE, scalarShape);
            sdata.setMemberData(zMember, (Array)zData);
            zValues = qp.hasVerticalCoord ? new double[]{qp.vertCoord} : zAxis.getCoordValues();
        }
        for (GridDatatype grid : grids) {
            StructureMembers.Member m = members.addMember(grid.getName(), null, grid.getUnitsString(), grid.getDataType(), scalarShape);
            Array data = Array.factory((DataType)grid.getDataType(), (int[])scalarShape);
            sdata.setMemberData(m, data);
        }
        String stnName = "GridPoint";
        StationImpl s = new StationImpl(stnName, "Grid Point at lat/lon=" + qp.lat + "," + qp.lon, qp.lat, qp.lon, Double.NaN);
        ArrayList<Station> stnList = new ArrayList<Station>();
        stnList.add((Station)s);
        stnData.set((Object)stnName);
        if (qp.acceptType.equals("application/xml")) {
            w = new WriterXML(qp, qp.vars, pw);
        } else if (qp.acceptType.equals("text/csv")) {
            w = new WriterCSV(qp, qp.vars, pw);
        } else if (qp.acceptType.equals("application/x-netcdf")) {
            w = hasZ ? new WriterNetcdfProfiler(qp, qp.vars, wantDates.size(), zAxis.getName(), pw) : new WriterNetcdfStation(qp, qp.vars, pw);
        } else {
            log.error("Unknown writer type = " + qp.acceptType);
            return null;
        }
        w.header(members, stnList);
        if (hasZ) {
            for (Date date : wantDates) {
                timeData.set((Object)this.format.toDateTimeStringISO(date));
                for (int i = 0; i < zValues.length; ++i) {
                    double zCoord = zValues[i];
                    for (GridDatatype grid : grids) {
                        Array mdata = sdata.getArray(grid.getName());
                        if (!gap.hasVert(grid, zCoord)) {
                            mdata.setDouble(mdata.getIndex(), gap.getMissingValue(grid));
                            continue;
                        }
                        if (!gap.hasTime(grid, date)) {
                            mdata.setDouble(mdata.getIndex(), gap.getMissingValue(grid));
                            continue;
                        }
                        GridAsPointDataset.Point p = gap.readData(grid, date, zCoord, qp.lat, qp.lon);
                        latData.set(p.lat);
                        lonData.set(p.lon);
                        if (grid == useForZ) {
                            zData.set(p.z);
                        }
                        mdata.setDouble(mdata.getIndex(), p.dataValue);
                    }
                    w.write(stnName, date, (StructureData)sdata);
                }
            }
        } else {
            for (Date date : wantDates) {
                timeData.set((Object)this.format.toDateTimeStringISO(date));
                for (GridDatatype grid : grids) {
                    Array mdata = sdata.getArray(grid.getName());
                    if (!gap.hasTime(grid, date)) {
                        mdata.setDouble(mdata.getIndex(), gap.getMissingValue(grid));
                        continue;
                    }
                    GridAsPointDataset.Point p = gap.readData(grid, date, qp.lat, qp.lon);
                    latData.set(p.lat);
                    lonData.set(p.lon);
                    mdata.setDouble(mdata.getIndex(), p.dataValue);
                }
                w.write(stnName, date, (StructureData)sdata);
            }
        }
        w.trailer();
        if (pw != null) {
            pw.flush();
        }
        if (debug) {
            long took = System.currentTimeMillis() - starting;
            System.out.println("\nread " + counter.count + " records; match and write " + counter.matches + " raw records");
            System.out.println("that took = " + took + " msecs");
            if (timeToScan > 0L) {
                long writeTime = took - timeToScan;
                double mps = (long)(1000 * counter.matches) / writeTime;
                System.out.println("  writeTime = " + writeTime + " msecs; write messages/sec = " + mps);
            }
        }
        return w.getNetcdfFile();
    }

    public static void main(String[] args) throws IOException, InvalidRangeException, ParseException {
        String fileIn = "C:/data/grib/nam/conus80/NAM_CONUS_80km_20060812_0000.grib1";
        GridDataset gds = GridDataset.open((String)fileIn);
        GridPointWriter writer = new GridPointWriter((ucar.nc2.dt.GridDataset)gds);
        QueryParams qp = new QueryParams();
        qp.acceptType = "application/x-netcdf";
        qp.vars = new ArrayList<String>();
        qp.vars.add("Temperature");
        qp.vars.add("Absolute_vorticity");
        qp.hasLatlonPoint = true;
        qp.lat = 40.0;
        qp.lon = -105.0;
        qp.hasTimePoint = false;
        DateFormatter format = new DateFormatter();
        qp.time = new DateType(false, format.isoDateTimeFormat("2005-12-07T06:00:00Z"));
        qp.hasVerticalCoord = true;
        qp.vertCoord = 223.0;
        PrintWriter pw = new PrintWriter(System.out);
        writer.write(qp, pw);
        qp.acceptType = "text/csv";
        writer.write(qp, pw);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterNetcdfProfiler
    extends Writer {
        File netcdfResult;
        WriterProfileObsDataset pobsWriter;
        List<VariableSimpleIF> varList;
        int nprofilers;
        String altVarName;

        WriterNetcdfProfiler(QueryParams qp, List<String> varNames, int nprofilers, String altVarName, PrintWriter writer) throws IOException {
            super(qp, varNames, writer);
            this.nprofilers = nprofilers;
            this.altVarName = altVarName;
            this.netcdfResult = File.createTempFile("ncss", ".nc");
            this.pobsWriter = new WriterProfileObsDataset(this.netcdfResult.getAbsolutePath(), "Extract Profiler data from Grid file " + GridPointWriter.this.gds.getLocationURI());
            NetcdfDataset ncfile = (NetcdfDataset)GridPointWriter.this.gds.getNetcdfFile();
            System.out.println("write to  " + this.netcdfResult.getPath());
            this.varList = new ArrayList<VariableSimpleIF>(varNames.size());
            List grids = GridPointWriter.this.gds.getGrids();
            for (GridDatatype grid : grids) {
                if (!varNames.contains(grid.getName())) continue;
                VariableEnhanced ve = grid.getVariable();
                String dims = "";
                VariableDS want = new VariableDS(ncfile, null, null, ve.getShortName(), ve.getDataType(), dims, ve.getUnitsString(), ve.getDescription());
                this.varList.add((VariableSimpleIF)want);
            }
            VariableDS vertCoord = (VariableDS)ncfile.findVariable(altVarName);
            if (vertCoord != null) {
                VariableDS want = new VariableDS(ncfile, null, null, vertCoord.getShortName(), vertCoord.getDataType(), "", vertCoord.getUnitsString(), vertCoord.getDescription());
                this.varList.add((VariableSimpleIF)want);
            }
        }

        @Override
        public File getNetcdfFile() {
            return this.netcdfResult;
        }

        @Override
        public void header(StructureMembers sm, List<Station> stnList) {
            try {
                this.pobsWriter.writeHeader(stnList, this.varList, this.nprofilers, this.altVarName);
            }
            catch (IOException e) {
                log.error("GridPointWriter.NetcdfWriter.header", (Throwable)e);
            }
        }

        @Override
        public void trailer() {
            try {
                this.pobsWriter.finish();
            }
            catch (IOException e) {
                log.error("GridPointWriter.WriterNetcdf.trailer", (Throwable)e);
            }
        }

        @Override
        public void write(String stnName, Date obsDate, StructureData sdata) throws IOException {
            this.pobsWriter.writeRecord(stnName, obsDate, sdata);
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterNetcdfStation
    extends Writer {
        File netcdfResult;
        WriterStationObsDataset sobsWriter;
        List<VariableSimpleIF> varList;

        WriterNetcdfStation(QueryParams qp, List<String> varNames, PrintWriter writer) throws IOException {
            super(qp, varNames, writer);
            this.netcdfResult = File.createTempFile("ncss", ".nc");
            this.sobsWriter = new WriterStationObsDataset(this.netcdfResult.getAbsolutePath(), "Extract Points data from Grid file " + GridPointWriter.this.gds.getLocationURI());
            NetcdfDataset ncfile = (NetcdfDataset)GridPointWriter.this.gds.getNetcdfFile();
            System.out.println("write to  " + this.netcdfResult.getPath());
            this.varList = new ArrayList<VariableSimpleIF>(varNames.size());
            List grids = GridPointWriter.this.gds.getGrids();
            for (GridDatatype grid : grids) {
                if (!varNames.contains(grid.getName())) continue;
                VariableEnhanced ve = grid.getVariable();
                String dims = "";
                VariableDS want = new VariableDS(ncfile, null, null, ve.getShortName(), ve.getDataType(), dims, ve.getUnitsString(), ve.getDescription());
                this.varList.add((VariableSimpleIF)want);
            }
        }

        @Override
        public File getNetcdfFile() {
            return this.netcdfResult;
        }

        @Override
        public void header(StructureMembers sm, List<Station> stnList) {
            try {
                this.sobsWriter.writeHeader(stnList, this.varList);
            }
            catch (IOException e) {
                log.error("GridPointWriter.NetcdfWriter.header", (Throwable)e);
            }
        }

        @Override
        public void trailer() {
            try {
                this.sobsWriter.finish();
            }
            catch (IOException e) {
                log.error("GridPointWriter.WriterNetcdf.trailer", (Throwable)e);
            }
        }

        @Override
        public void write(String stnName, Date obsDate, StructureData sdata) throws IOException {
            this.sobsWriter.writeRecord(stnName, obsDate, sdata);
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterCSV
    extends Writer {
        boolean headerWritten;
        List<VariableSimpleIF> validVars;

        WriterCSV(QueryParams qp, List<String> stns, PrintWriter writer) {
            super(qp, stns, writer);
            this.headerWritten = false;
        }

        @Override
        public void header(StructureMembers sm, List<Station> stnList) {
            boolean first = true;
            List members = sm.getMembers();
            for (StructureMembers.Member m : members) {
                if (!first) {
                    this.writer.print(",");
                }
                this.writer.print(m.getName());
                if (null != m.getUnitsString()) {
                    this.writer.print("[unit=\"" + m.getUnitsString() + "\"]");
                }
                first = false;
            }
            this.writer.println();
        }

        @Override
        public void trailer() {
        }

        @Override
        public void write(String stnName, Date obsDate, StructureData sdata) throws IOException {
            boolean first = true;
            List members = sdata.getStructureMembers().getMembers();
            for (StructureMembers.Member m : members) {
                if (!first) {
                    this.writer.print(",");
                }
                this.writer.print(sdata.getScalarObject(m));
                first = false;
            }
            this.writer.println();
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterXML
    extends Writer {
        WriterXML(QueryParams qp, List<String> vars, PrintWriter writer) {
            super(qp, vars, writer);
        }

        @Override
        public void header(StructureMembers members, List<Station> stnList) {
            this.writer.println("<?xml version='1.0' encoding='UTF-8'?>");
            this.writer.println("<grid dataset='" + GridPointWriter.this.gds.getLocationURI() + "'>");
        }

        @Override
        public void trailer() {
            this.writer.println("</grid>");
        }

        @Override
        public void write(String stnName, Date obsDate, StructureData sdata) throws IOException {
            this.writer.println("  <point>");
            List members = sdata.getStructureMembers().getMembers();
            for (StructureMembers.Member m : members) {
                this.writer.print("    <data name='" + m.getName());
                if (m.getUnitsString() != null) {
                    this.writer.print("' units='" + m.getUnitsString());
                }
                this.writer.print("'>");
                this.writer.print(sdata.getScalarObject(m));
                this.writer.println("</data>");
            }
            this.writer.println("  </point>");
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Writer {
        QueryParams qp;
        List<String> varNames;
        PrintWriter writer;
        DateFormatter format = new DateFormatter();
        int count = 0;

        abstract void header(StructureMembers var1, List<Station> var2);

        abstract void write(String var1, Date var2, StructureData var3) throws IOException;

        abstract void trailer();

        public File getNetcdfFile() {
            return null;
        }

        Writer(QueryParams qp, List<String> varNames, PrintWriter writer) {
            this.qp = qp;
            this.varNames = varNames;
            this.writer = writer;
        }

        List<VariableSimpleIF> getVars(List<String> varNames, List<VariableSimpleIF> dataVariables) {
            ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>();
            for (VariableSimpleIF v : dataVariables) {
                if (varNames != null && !varNames.contains(v.getName())) continue;
                result.add(v);
            }
            return result;
        }
    }

    private class Limit {
        int count;
        int limit = Integer.MAX_VALUE;
        int matches;

        private Limit() {
        }
    }
}

