/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import thredds.server.ncSubset.GridPointWriter;
import thredds.server.ncSubset.QueryParams;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridDatasetInfo;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public class GridServlet
extends AbstractServlet {
    private DiskCache2 diskCache = null;
    private boolean allow = false;
    private boolean debug = false;

    protected String getPath() {
        return "ncss/grid/";
    }

    protected void makeDebugActions() {
    }

    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("NetcdfSubsetService.allow", false);
        String cache = ThreddsConfig.get("NetcdfSubsetService.dir", this.contentPath + "/cache");
        File cacheDir = new File(cache);
        cacheDir.mkdirs();
        int scourSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
    }

    public void destroy() {
        if (this.diskCache != null) {
            this.diskCache.exit();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        ServletUtil.logServerAccessSetup(req);
        String pathInfo = req.getPathInfo();
        boolean wantXML = pathInfo.endsWith("/dataset.xml");
        boolean showForm = pathInfo.endsWith("/dataset.html");
        boolean showPointForm = pathInfo.endsWith("/pointDataset.html");
        if (wantXML || showForm || showPointForm) {
            int len = pathInfo.length();
            if (wantXML) {
                pathInfo = pathInfo.substring(0, len - 12);
            } else if (showForm) {
                pathInfo = pathInfo.substring(0, len - 13);
            } else if (showPointForm) {
                pathInfo = pathInfo.substring(0, len - 18);
            }
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            GridDataset gds = null;
            try {
                gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                if (null == gds) {
                    return;
                }
                this.showForm(res, gds, pathInfo, wantXML, showPointForm);
            }
            catch (SecurityException e) {
                ServletUtil.logServerAccess(403, -1L);
                res.sendError(403, e.getMessage());
            }
            catch (Exception e) {
                this.log.error("GridServlet.showForm", (Throwable)e);
                ServletUtil.logServerAccess(500, 0L);
                res.sendError(500);
            }
            finally {
                if (null != gds) {
                    try {
                        gds.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed to close = " + pathInfo);
                    }
                }
            }
            return;
        }
        String point = ServletUtil.getParameterIgnoreCase(req, "point");
        if (point != null && point.equalsIgnoreCase("true")) {
            this.processGridAsPoint(req, res, pathInfo);
            return;
        }
        this.processGrid(req, res, pathInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGridAsPoint(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        long start = System.currentTimeMillis();
        GridDataset gds = null;
        try {
            QueryParams qp;
            block54: {
                qp = new QueryParams();
                if (!qp.parseQuery(req, res, new String[]{"text/csv", "application/xml", "application/x-netcdf"})) {
                    return;
                }
                gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                if (null == gds) {
                    return;
                }
                if (qp.vars == null || qp.vars.size() == 0) {
                    qp.errs.append("No Grid variables selected\n");
                    qp.writeErr(res, qp.errs.toString(), 400);
                    return;
                }
                if (qp.vars != null) {
                    int count = 0;
                    StringBuffer buff = new StringBuffer();
                    for (String varName : qp.vars) {
                        if (null != gds.findGridDatatype(varName)) continue;
                        buff.append(varName);
                        if (count > 0) {
                            buff.append(";");
                        }
                        ++count;
                    }
                    if (buff.length() != 0) {
                        qp.errs.append("Grid variable(s) not found in dataset=" + buff + "\n");
                        qp.writeErr(res, qp.errs.toString(), 400);
                        return;
                    }
                } else {
                    qp.errs.append("You must specify at least one variable\n");
                    qp.writeErr(res, qp.errs.toString(), 400);
                    return;
                }
                if (qp.hasLatlonPoint) {
                    LatLonPoint pt;
                    LatLonRect bb = gds.getBoundingBox();
                    if (!bb.contains(pt = qp.getPoint())) {
                        qp.errs.append("Requested Lat/Lon Point (+" + pt + ") is not contained in the Data\n" + "Data Bounding Box = " + bb.toString2() + "\n");
                        qp.writeErr(res, qp.errs.toString(), 400);
                        return;
                    }
                } else {
                    qp.errs.append("Must specify a Lat/Lon Point\n");
                    qp.writeErr(res, qp.errs.toString(), 400);
                    return;
                }
                GridPointWriter writer = new GridPointWriter(gds);
                String contentType = qp.acceptType;
                if (qp.acceptType.equals("text/csv")) {
                    contentType = "text/plain";
                }
                res.setContentType(contentType);
                if (qp.acceptType.equals("application/x-netcdf")) break block54;
                writer.write(qp, res.getWriter());
                if (this.debug) {
                    long took = System.currentTimeMillis() - start;
                    System.out.println("\ntotal response took = " + took + " msecs");
                }
                return;
            }
            try {
                this.sendPointFile(req, res, gds, qp);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                ServletUtil.logServerAccess(400, 0L);
                res.sendError(400, "Invalid Lat/Lon or Time Range");
            }
        }
        catch (SecurityException e) {
            ServletUtil.logServerAccess(403, -1L);
            res.sendError(403, e.getMessage());
        }
        finally {
            if (null != gds) {
                try {
                    gds.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + pathInfo);
                }
            }
        }
        if (this.debug) {
            long took = System.currentTimeMillis() - start;
            System.out.println("\ntotal response took = " + took + " msecs");
        }
    }

    private void sendPointFile(HttpServletRequest req, HttpServletResponse res, GridDataset gds, QueryParams qp) throws IOException, InvalidRangeException {
        File result;
        String filename = req.getRequestURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.diskCache.getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = "/thredds/ncServer/cache/" + pathname;
        try {
            GridPointWriter writer = new GridPointWriter(gds);
            PrintWriter pw = !qp.acceptType.equals("application/x-netcdf") ? res.getWriter() : null;
            result = writer.write(qp, pw);
        }
        catch (IOException ioe) {
            this.log.error("Writing to " + cacheFilename, (Throwable)ioe);
            ServletUtil.logServerAccess(500, 0L);
            res.sendError(500, ioe.getMessage());
            return;
        }
        res.addHeader("Content-Location", url);
        res.setHeader("Content-Disposition", "attachment; filename=" + filename);
        ServletUtil.returnFile(this, "", result.getPath(), req, res, "application/x-netcdf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processGrid(HttpServletRequest req, HttpServletResponse res, String pathInfo) throws IOException {
        QueryParams qp;
        GridDataset gds;
        long start;
        block36: {
            block37: {
                block34: {
                    block35: {
                        start = System.currentTimeMillis();
                        gds = null;
                        qp = new QueryParams();
                        if (qp.parseQuery(req, res, new String[]{"application/x-netcdf"})) break block34;
                        if (null == gds) break block35;
                        try {
                            gds.close();
                        }
                        catch (IOException ioe) {
                            this.log.error("Failed to close = " + pathInfo);
                        }
                    }
                    return;
                }
                gds = DatasetHandler.openGridDataset(req, res, pathInfo);
                if (null != gds) break block36;
                if (null == gds) break block37;
                try {
                    gds.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + pathInfo);
                }
            }
            return;
        }
        try {
            block39: {
                break block39;
                catch (Exception e) {
                    ServletUtil.logServerAccess(404, 0L);
                    res.sendError(404, "Cant find " + pathInfo);
                }
            }
            if (qp.vars == null || qp.vars.size() == 0) {
                qp.errs.append("No Grid variables selected\n");
                qp.writeErr(res, qp.errs.toString(), 400);
                return;
            }
            if (qp.vars != null) {
                int count = 0;
                StringBuffer buff = new StringBuffer();
                for (String varName : qp.vars) {
                    if (null != gds.findGridDatatype(varName)) continue;
                    buff.append(varName);
                    if (count > 0) {
                        buff.append(";");
                    }
                    ++count;
                }
                if (buff.length() != 0) {
                    qp.errs.append("Grid variable(s) not found in dataset=" + buff + "\n");
                    qp.writeErr(res, qp.errs.toString(), 400);
                    return;
                }
            }
            boolean hasBB = false;
            if (qp.hasBB) {
                LatLonRect maxBB = gds.getBoundingBox();
                boolean bl = hasBB = !Misc.closeEnough((double)qp.north, (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)qp.south, (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)qp.east, (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)qp.west, (double)maxBB.getLowerLeftPoint().getLongitude());
                if (maxBB.intersect(qp.getBB()) == null) {
                    qp.errs.append("Request Bounding Box does not intersect the Data\nData Bounding Box = " + maxBB.toString2() + "\n");
                    qp.writeErr(res, qp.errs.toString(), 400);
                    return;
                }
            }
            boolean addLatLon = ServletUtil.getParameterIgnoreCase(req, "addLatLon") != null;
            try {
                this.sendFile(req, res, gds, qp, hasBB, addLatLon);
            }
            catch (InvalidRangeException e) {
                ServletUtil.logServerAccess(400, 0L);
                res.sendError(400, "Invalid Lat/Lon or Time Range");
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (null != gds) {
                try {
                    gds.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + pathInfo);
                }
            }
        }
        if (this.debug) {
            long took = System.currentTimeMillis() - start;
            System.out.println("\ntotal response took = " + took + " msecs");
        }
    }

    private void sendFile(HttpServletRequest req, HttpServletResponse res, GridDataset gds, QueryParams qp, boolean useBB, boolean addLatLon) throws IOException, InvalidRangeException {
        String filename = req.getRequestURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.diskCache.getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = "/thredds/ncServer/cache/" + pathname;
        try {
            NetcdfCFWriter writer = new NetcdfCFWriter();
            writer.makeFile(cacheFilename, gds, qp.vars, useBB ? qp.getBB() : null, qp.hasDateRange ? qp.getDateRange() : null, addLatLon, qp.horizStride, qp.vertStride, qp.timeStride);
        }
        catch (IOException ioe) {
            this.log.error("Writing to " + cacheFilename, (Throwable)ioe);
            ServletUtil.logServerAccess(500, 0L);
            res.sendError(500, ioe.getMessage());
            return;
        }
        res.addHeader("Content-Location", url);
        res.setHeader("Content-Disposition", "attachment; filename=" + filename);
        ServletUtil.returnFile(this, "", cacheFilename, req, res, "application/x-netcdf");
    }

    private void showForm(HttpServletResponse res, GridDataset gds, String path, boolean wantXml, boolean isPoint) throws IOException {
        String infoString;
        GridDatasetInfo writer = new GridDatasetInfo(gds, "path");
        if (wantXml) {
            infoString = writer.writeXML(writer.makeDatasetDescription());
        } else {
            InputStream xslt = this.getXSLT(isPoint ? "ncssGridAsPoint.xsl" : "ncssGrid.xsl");
            Document doc = writer.makeGridForm();
            Element root = doc.getRootElement();
            root.setAttribute("location", "/thredds/" + this.getPath() + path);
            try {
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (Exception e) {
                this.log.error("ForecastModelRunServlet internal error", (Throwable)e);
                ServletUtil.logServerAccess(500, 0L);
                res.sendError(500, "ForecastModelRunServlet internal error");
                return;
            }
        }
        res.setContentLength(infoString.length());
        if (wantXml) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=iso-8859-1");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes());
        out.flush();
        ServletUtil.logServerAccess(200, infoString.length());
    }

    private InputStream getXSLT(String xslName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/resources/xsl/" + xslName);
    }
}

