/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataType;
import thredds.catalog.XMLEntityResolver;
import thredds.datatype.DateRange;
import thredds.datatype.DateType;
import thredds.server.ncSubset.CollectionManager;
import thredds.server.ncSubset.QueryParams;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.Station;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.point.StationObsDatasetInfo;
import ucar.nc2.dt.point.WriterStationObsDataset;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StationObsCollection {
    private static Logger log = LoggerFactory.getLogger(StationObsCollection.class);
    private static Logger cacheLogger = LoggerFactory.getLogger((String)"cacheLogger");
    private static boolean debug = false;
    private static boolean debugDetail = false;
    private static long timeToScan = 0L;
    private String archiveDir;
    private String realtimeDir;
    private ArrayList<Dataset> datasetList;
    private List<VariableSimpleIF> variableList;
    private DateFormatter format = new DateFormatter();
    private boolean isRealtime;
    private boolean isReady;
    private Date start;
    private Date end;
    private Timer timer;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private String dateFormatString = "yyyyMMdd_HHmm";
    private FileFilter ff = new SuffixFileFilter(".nc");
    private String datasetName = "/thredds/ncss/metars";
    private Document datasetDesc;
    private List<Station> stationList;
    private HashMap<String, Station> stationMap;

    public StationObsCollection(String archiveDir, String realtimeDir) {
        this.archiveDir = archiveDir;
        this.realtimeDir = realtimeDir;
        boolean bl = this.isRealtime = realtimeDir != null;
        if (this.isRealtime) {
            this.timer = new Timer("StationObsCollection.Rescan");
            Calendar c = Calendar.getInstance();
            c.setTimeZone(TimeZone.getDefault());
            c.add(11, 24);
            c.set(11, 1);
            c.set(12, 0);
            c.set(13, 0);
            this.timer.schedule((TimerTask)new ReinitTask(), 5000L);
            this.timer.schedule((TimerTask)new ReinitTask(), c.getTime(), 86400000L);
            cacheLogger.info("StationObsCollection timer set to run at " + c.getTime());
        } else {
            this.initArchiveOnly();
            this.isReady = true;
        }
    }

    public void close() {
        this.closeDatasets();
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void closeDatasets() {
        if (this.datasetList == null) {
            return;
        }
        for (Dataset ds : this.datasetList) {
            try {
                ds.sod.close();
            }
            catch (IOException ioe) {
                log.warn("Couldnt close " + ds.sod, (Throwable)ioe);
            }
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public String getName() {
        return this.archiveDir + "/" + this.realtimeDir;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public ArrayList<Dataset> getDatasets() {
        return this.datasetList;
    }

    private void initArchiveOnly() {
        CollectionManager archive = new CollectionManager(this.archiveDir, this.ff, this.dateFormatString);
        this.datasetList = new ArrayList();
        this.stationList = null;
        this.variableList = null;
        int count = 0;
        long size = 0L;
        ArrayList<CollectionManager.MyFile> list = new ArrayList<CollectionManager.MyFile>(archive.getList());
        for (CollectionManager.MyFile myfile : list) {
            try {
                Dataset ds = new Dataset(myfile.file, false);
                this.datasetList.add(ds);
                ++count;
                size += myfile.file.length();
                if (null == this.stationList) {
                    this.stationList = new ArrayList<Station>(ds.sod.getStations());
                }
                if (null != this.variableList) continue;
                this.variableList = new ArrayList<VariableSimpleIF>(ds.sod.getDataVariables());
            }
            catch (IOException e) {
                cacheLogger.error("Cant open " + myfile, (Throwable)e);
            }
        }
        Collections.sort(this.datasetList);
        int n = this.datasetList.size();
        this.start = this.datasetList.get((int)0).time_start;
        this.end = this.datasetList.get((int)(n - 1)).time_end;
        size = size / 1000L / 1000L;
        cacheLogger.info("Reading directory " + archive + " # files = " + count + " size= " + size + " Mb");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        CollectionManager archive = new CollectionManager(this.archiveDir, this.ff, this.dateFormatString);
        CollectionManager realtime = new CollectionManager(this.realtimeDir, this.ff, this.dateFormatString);
        this.makeArchiveFiles(archive, realtime);
        try {
            this.lock.writeLock().lock();
            this.closeDatasets();
            ArrayList<Dataset> newList = new ArrayList<Dataset>();
            this.initArchive(archive, newList);
            this.initRealtime(archive, realtime, newList);
            Collections.sort(newList);
            this.datasetList = newList;
            int n = this.datasetList.size();
            if (n > 0) {
                this.start = this.datasetList.get((int)0).time_start;
                this.end = this.datasetList.get((int)(n - 1)).time_end;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.datasetDesc = null;
        this.isReady = true;
    }

    private void makeArchiveFiles(CollectionManager archive, CollectionManager realtime) {
        List<CollectionManager.MyFile> realtimeList = realtime.after(archive.getLatest());
        if (realtimeList.size() < 2) {
            return;
        }
        int n = realtimeList.size();
        Collections.sort(realtimeList);
        realtimeList.remove(n - 1);
        for (CollectionManager.MyFile myfile : realtimeList) {
            String filename = myfile.file.getName();
            String fileIn = this.realtimeDir + "/" + filename;
            String fileOut = this.archiveDir + "/" + filename;
            try {
                long start = System.currentTimeMillis();
                cacheLogger.info("StationObsCollection: write " + fileIn + " to archive " + fileOut);
                WriterStationObsDataset.rewrite((String)fileIn, (String)fileOut);
                archive.add(new File(fileOut), myfile.date);
                long took = System.currentTimeMillis() - start;
                cacheLogger.info("  that took= " + took / 1000L + " secs");
            }
            catch (IOException e) {
                cacheLogger.error("StationObsCollection: write failed (" + fileIn + " to archive " + fileOut + ")", (Throwable)e);
            }
        }
    }

    private void initArchive(CollectionManager archive, ArrayList<Dataset> newList) {
        this.stationList = null;
        this.variableList = null;
        Calendar c = Calendar.getInstance();
        c.add(10, -192);
        Date firstDate = c.getTime();
        cacheLogger.info("StationObsCollection: delete files before " + firstDate);
        int count = 0;
        long size = 0L;
        ArrayList<CollectionManager.MyFile> list = new ArrayList<CollectionManager.MyFile>(archive.getList());
        for (CollectionManager.MyFile myfile : list) {
            if (myfile.date.before(firstDate)) {
                myfile.file.delete();
                boolean ok = archive.remove(myfile);
                cacheLogger.info("StationObsCollection: Deleted archive file " + myfile + " ok= " + ok);
                continue;
            }
            try {
                Dataset ds = new Dataset(myfile.file, false);
                newList.add(ds);
                ++count;
                size += myfile.file.length();
                if (null == this.stationList) {
                    this.stationList = new ArrayList<Station>(ds.sod.getStations());
                }
                if (null != this.variableList) continue;
                this.variableList = new ArrayList<VariableSimpleIF>(ds.sod.getDataVariables());
            }
            catch (IOException e) {
                cacheLogger.error("Cant open " + myfile, (Throwable)e);
            }
        }
        size = size / 1000L / 1000L;
        cacheLogger.info("Reading directory " + archive + " # files = " + count + " size= " + size + " Mb");
    }

    private void initRealtime(CollectionManager archive, CollectionManager realtime, ArrayList<Dataset> newList) {
        long size = 0L;
        int count = 0;
        List<CollectionManager.MyFile> realtimeList = realtime.after(archive.getLatest());
        if (realtimeList.size() == 0) {
            return;
        }
        for (CollectionManager.MyFile myfile : realtimeList) {
            try {
                Dataset ds = new Dataset(myfile.file, true);
                newList.add(ds);
                ++count;
                size += myfile.file.length();
                if (null == this.stationList) {
                    this.stationList = new ArrayList<Station>(ds.sod.getStations());
                }
                if (null != this.variableList) continue;
                this.variableList = new ArrayList<VariableSimpleIF>(ds.sod.getDataVariables());
            }
            catch (IOException e) {
                cacheLogger.error("Cant open " + myfile, (Throwable)e);
            }
        }
        size = size / 1000L / 1000L;
        cacheLogger.info("Reading realtime directory " + realtime + " # files = " + count + " total file sizes = " + size + " Mb");
    }

    public Document getDoc() throws IOException {
        if (this.datasetDesc != null) {
            return this.datasetDesc;
        }
        Dataset ds = this.datasetList.get(0);
        if (debug) {
            System.out.println("getDoc open " + ds.filename);
        }
        StationObsDataset sod = ds.get();
        StationObsDatasetInfo info = new StationObsDatasetInfo(sod, null);
        Document doc = info.makeStationObsDatasetDocument();
        Element root = doc.getRootElement();
        root.setAttribute("location", this.datasetName);
        Element timeSpan = root.getChild("TimeSpan");
        timeSpan.removeContent();
        DateFormatter format = new DateFormatter();
        timeSpan.addContent((Content)new Element("begin").addContent(format.toDateTimeStringISO(this.start)));
        timeSpan.addContent((Content)new Element("end").addContent(this.isRealtime ? "present" : format.toDateTimeStringISO(this.end)));
        Element stnList = new Element("stationList");
        stnList.setAttribute("title", "Available Stations", XMLEntityResolver.xlinkNS);
        stnList.setAttribute("href", "/thredds/ncss/metars/stations.xml", XMLEntityResolver.xlinkNS);
        root.addContent((Content)stnList);
        this.datasetDesc = doc;
        return doc;
    }

    public Document getStationDoc() throws IOException {
        StationObsDataset sod = this.datasetList.get(0).get();
        StationObsDatasetInfo info = new StationObsDatasetInfo(sod, null);
        return info.makeStationCollectionDocument();
    }

    public boolean isStationListEmpty(List<String> stns) throws IOException {
        HashMap<String, Station> map = this.getStationMap();
        for (String stn : stns) {
            if (map.get(stn) == null) continue;
            return false;
        }
        return true;
    }

    public boolean intersect(DateRange dr) throws IOException {
        return dr.intersect(this.start, this.end);
    }

    private List<Station> getStationList() throws IOException {
        return this.stationList;
    }

    private HashMap<String, Station> getStationMap() throws IOException {
        if (null == this.stationMap) {
            this.stationMap = new HashMap();
            List<Station> list = this.getStationList();
            for (Station station : list) {
                this.stationMap.put(station.getName(), station);
            }
        }
        return this.stationMap;
    }

    public List<String> getStationNames(LatLonRect boundingBox) throws IOException {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<String> result = new ArrayList<String>();
        List<Station> stations = this.getStationList();
        for (Station s : stations) {
            latlonPt.set(s.getLatitude(), s.getLongitude());
            if (!boundingBox.contains((LatLonPoint)latlonPt)) continue;
            result.add(s.getName());
        }
        return result;
    }

    public String findClosestStation(double lat, double lon) throws IOException {
        double cos = Math.cos(Math.toRadians(lat));
        List<Station> stations = this.getStationList();
        Station min_station = stations.get(0);
        double min_dist = Double.MAX_VALUE;
        for (Station s : stations) {
            double dx;
            double lat1 = s.getLatitude();
            double lon1 = LatLonPointImpl.lonNormal((double)s.getLongitude(), (double)lon);
            double dy = Math.toRadians(lat - lat1);
            double dist = dy * dy + (dx = cos * Math.toRadians(lon - lon1)) * dx;
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            min_station = s;
        }
        return min_station.getName();
    }

    private void scanAll(Dataset ds, DateRange range, Predicate p, Action a, Limit limit) throws IOException {
        StringBuffer sbuff = new StringBuffer();
        StationObsDataset sod = ds.get();
        if (debug) {
            System.out.println("scanAll open " + ds.filename);
        }
        if (null == sod) {
            log.info("Cant open " + ds.filename + "; " + sbuff);
            return;
        }
        DataIterator iter = sod.getDataIterator(0);
        while (iter.hasNext()) {
            Date obs;
            StationObsDatatype sobs = (StationObsDatatype)iter.nextData();
            if (null != range && !range.included(obs = sobs.getObservationTimeAsDate())) continue;
            StructureData sdata = sobs.getData();
            if (p == null || p.match(sdata)) {
                a.act(sod, sobs, sdata);
                ++limit.matches;
            }
            ++limit.count;
            if (limit.count <= limit.limit) continue;
            break;
        }
    }

    private void scanStations(Dataset ds, List<String> stns, DateRange range, Predicate p, Action a, Limit limit) throws IOException {
        StringBuffer sbuff = new StringBuffer();
        StationObsDataset sod = ds.get();
        if (debug) {
            System.out.println("scanStations open " + ds.filename);
        }
        if (null == sod) {
            log.info("Cant open " + ds.filename + "; " + sbuff);
            return;
        }
        block0: for (String stn : stns) {
            Station s = sod.getStation(stn);
            if (s == null) {
                log.warn("Cant find station " + s);
                continue;
            }
            if (debugDetail) {
                System.out.println("stn " + s.getName());
            }
            DataIterator iter = sod.getDataIterator(s);
            while (iter.hasNext()) {
                Date obs;
                StationObsDatatype sobs = (StationObsDatatype)iter.nextData();
                if (null != range && !range.included(obs = sobs.getObservationTimeAsDate())) continue;
                StructureData sdata = sobs.getData();
                if (p == null || p.match(sdata)) {
                    a.act(sod, sobs, sdata);
                    ++limit.matches;
                }
                ++limit.count;
                if (limit.count <= limit.limit) continue;
                continue block0;
            }
        }
    }

    private void scanAll(Dataset ds, DateType time, Predicate p, Action a, Limit limit) throws IOException {
        StringBuffer sbuff = new StringBuffer();
        HashMap<Station, StationDataTracker> map = new HashMap<Station, StationDataTracker>();
        long wantTime = time.getDate().getTime();
        StationObsDataset sod = ds.get();
        if (debug) {
            System.out.println("scanAll open " + ds.filename);
        }
        if (null == sod) {
            log.info("Cant open " + ds.filename + "; " + sbuff);
            return;
        }
        DataIterator iter = sod.getDataIterator(0);
        while (iter.hasNext()) {
            StructureData sdata;
            StationObsDatatype sobs = (StationObsDatatype)iter.nextData();
            if (p != null && !p.match(sdata = sobs.getData())) continue;
            long obsTime = sobs.getObservationTimeAsDate().getTime();
            long diff = Math.abs(obsTime - wantTime);
            Station s = sobs.getStation();
            StationDataTracker track = (StationDataTracker)map.get(s);
            if (track == null) {
                map.put(s, new StationDataTracker(sobs, diff));
                continue;
            }
            if (diff >= track.timeDiff) continue;
            track.sobs = sobs;
            track.timeDiff = diff;
        }
        for (Station s : map.keySet()) {
            StationDataTracker track = (StationDataTracker)map.get(s);
            a.act(sod, track.sobs, track.sobs.getData());
            ++limit.matches;
            ++limit.count;
            if (limit.count <= limit.limit) continue;
            break;
        }
    }

    private void scanStations(Dataset ds, List<String> stns, DateType time, Predicate p, Action a, Limit limit) throws IOException {
        StringBuffer sbuff = new StringBuffer();
        StationObsDataset sod = ds.get();
        if (null == sod) {
            log.info("Cant open " + ds.filename + "; " + sbuff);
            return;
        }
        long wantTime = time.getDate().getTime();
        for (String stn : stns) {
            Station s = sod.getStation(stn);
            if (s == null) {
                log.warn("Cant find station " + s);
                continue;
            }
            StationObsDatatype sobsBest = null;
            long timeDiff = Long.MAX_VALUE;
            DataIterator iter = sod.getDataIterator(s);
            while (iter.hasNext()) {
                long obsTime;
                long diff;
                StructureData sdata;
                StationObsDatatype sobs = (StationObsDatatype)iter.nextData();
                if (p != null && !p.match(sdata = sobs.getData()) || (diff = Math.abs((obsTime = sobs.getObservationTimeAsDate().getTime()) - wantTime)) >= timeDiff) continue;
                sobsBest = sobs;
                timeDiff = diff;
            }
            if (sobsBest != null) {
                a.act(sod, sobsBest, sobsBest.getData());
                ++limit.matches;
            }
            ++limit.count;
            if (limit.count <= limit.limit) continue;
            break;
        }
    }

    private List<Dataset> filterDataset(DateRange range) {
        if (range == null) {
            return this.datasetList;
        }
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        for (Dataset ds : this.datasetList) {
            if (!range.intersect(ds.time_start, ds.time_end)) continue;
            result.add(ds);
        }
        return result;
    }

    Dataset filterDataset(DateType want) {
        if (want.isPresent()) {
            return this.datasetList.get(this.datasetList.size() - 1);
        }
        Date time = want.getDate();
        for (Dataset ds : this.datasetList) {
            if (time.before(ds.time_end) && time.after(ds.time_start)) {
                return ds;
            }
            if (!time.equals(ds.time_end) && !time.equals(ds.time_start)) continue;
            return ds;
        }
        return null;
    }

    public File writeNetcdf(QueryParams qp) throws IOException {
        WriterNetcdf w = (WriterNetcdf)this.write(qp, null);
        return w.netcdfResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer write(QueryParams qp, PrintWriter pw) throws IOException {
        Writer w;
        long start = System.currentTimeMillis();
        Limit counter = new Limit();
        List<String> vars = qp.vars;
        List<String> stns = qp.stns;
        DateRange range = qp.getDateRange();
        DateType time = qp.time;
        String type = qp.acceptType;
        if (type.equals("text/plain")) {
            w = new WriterRaw(qp, vars, pw);
        } else if (type.equals("application/xml")) {
            w = new WriterXML(qp, vars, pw);
        } else if (type.equals("text/csv")) {
            w = new WriterCSV(qp, vars, pw);
        } else if (type.equals("application/x-netcdf")) {
            w = new WriterNetcdf(qp, vars, pw);
        } else {
            log.error("Unknown writer type = " + type);
            return null;
        }
        Collections.sort(stns);
        w.header(stns);
        boolean useAll = stns.size() == 0;
        Action act = w.getAction();
        try {
            this.lock.readLock().lock();
            if (null == time) {
                List<Dataset> need = this.filterDataset(range);
                for (Dataset ds : need) {
                    if (useAll) {
                        this.scanAll(ds, range, null, act, counter);
                        continue;
                    }
                    this.scanStations(ds, stns, range, null, act, counter);
                }
            } else {
                Dataset ds = this.filterDataset(time);
                if (useAll) {
                    this.scanAll(ds, time, null, act, counter);
                } else {
                    this.scanStations(ds, stns, time, null, act, counter);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        w.trailer();
        if (pw != null) {
            pw.flush();
        }
        if (debug) {
            long took = System.currentTimeMillis() - start;
            System.out.println("\nread " + counter.count + " records; match and write " + counter.matches + " raw records");
            System.out.println("that took = " + took + " msecs");
            if (timeToScan > 0L) {
                long writeTime = took - timeToScan;
                double mps = (long)(1000 * counter.matches) / writeTime;
                System.out.println("  writeTime = " + writeTime + " msecs; write messages/sec = " + mps);
            }
        }
        return w;
    }

    public static void main(String[] args) throws IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterCSV
    extends Writer {
        boolean headerWritten;
        List<VariableSimpleIF> validVars;

        WriterCSV(QueryParams qp, List<String> stns, PrintWriter writer) {
            super(qp, stns, writer);
            this.headerWritten = false;
        }

        @Override
        public void header(List<String> stns) {
        }

        @Override
        public void trailer() {
        }

        @Override
        Action getAction() {
            return new Action(){

                public void act(StationObsDataset sod, StationObsDatatype sobs, StructureData sdata) throws IOException {
                    if (!WriterCSV.this.headerWritten) {
                        WriterCSV.this.writer.print("time,station,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
                        WriterCSV.this.validVars = WriterCSV.this.getVars(WriterCSV.this.varNames, sod.getDataVariables());
                        for (VariableSimpleIF var : WriterCSV.this.validVars) {
                            WriterCSV.this.writer.print(",");
                            WriterCSV.this.writer.print(var.getName());
                            if (var.getUnitsString() == null) continue;
                            WriterCSV.this.writer.print("[unit=\"" + var.getUnitsString() + "\"]");
                        }
                        WriterCSV.this.writer.println();
                        WriterCSV.this.headerWritten = true;
                    }
                    Station s = sobs.getStation();
                    WriterCSV.this.writer.print(WriterCSV.this.format.toDateTimeStringISO(sobs.getObservationTimeAsDate()));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(s.getName());
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)s.getLatitude(), (int)3));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)s.getLongitude(), (int)3));
                    for (VariableSimpleIF var : WriterCSV.this.validVars) {
                        WriterCSV.this.writer.print(',');
                        Array sdataArray = sdata.getArray(var.getName());
                        WriterCSV.this.writer.print(sdataArray.toString());
                    }
                    WriterCSV.this.writer.println();
                    ++WriterCSV.this.count;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterXML
    extends Writer {
        WriterXML(QueryParams qp, List<String> vars, PrintWriter writer) {
            super(qp, vars, writer);
        }

        @Override
        public void header(List<String> stns) {
            this.writer.println("<?xml version='1.0' encoding='UTF-8'?>");
            this.writer.println("<metarCollection dataset='" + StationObsCollection.this.datasetName + "'>\n");
        }

        @Override
        public void trailer() {
            this.writer.println("</metarCollection>");
        }

        @Override
        Action getAction() {
            return new Action(){

                public void act(StationObsDataset sod, StationObsDatatype sobs, StructureData sdata) throws IOException {
                    Station s = sobs.getStation();
                    WriterXML.this.writer.print("  <metar date='");
                    WriterXML.this.writer.print(WriterXML.this.format.toDateTimeStringISO(sobs.getObservationTimeAsDate()));
                    WriterXML.this.writer.println("'>");
                    WriterXML.this.writer.print("    <station name='" + StringUtil.quoteXmlAttribute((String)s.getName()) + "' latitude='" + Format.dfrac((double)s.getLatitude(), (int)3) + "' longitude='" + Format.dfrac((double)s.getLongitude(), (int)3));
                    if (!Double.isNaN(s.getAltitude())) {
                        WriterXML.this.writer.print("' altitude='" + Format.dfrac((double)s.getAltitude(), (int)0));
                    }
                    if (s.getDescription() != null) {
                        WriterXML.this.writer.println("'>");
                        WriterXML.this.writer.print(StringUtil.quoteXmlContent((String)s.getDescription()));
                        WriterXML.this.writer.println("</station>");
                    } else {
                        WriterXML.this.writer.println("'/>");
                    }
                    List<VariableSimpleIF> vars = WriterXML.this.getVars(WriterXML.this.varNames, sod.getDataVariables());
                    for (VariableSimpleIF var : vars) {
                        WriterXML.this.writer.print("    <data name='" + var.getName());
                        if (var.getUnitsString() != null) {
                            WriterXML.this.writer.print("' units='" + var.getUnitsString());
                        }
                        WriterXML.this.writer.print("'>");
                        Array sdataArray = sdata.getArray(var.getName());
                        String ss = sdataArray.toString();
                        WriterXML.this.writer.print(StringUtil.quoteXmlContent((String)ss));
                        WriterXML.this.writer.println("</data>");
                    }
                    WriterXML.this.writer.println("  </metar>");
                    ++WriterXML.this.count;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterRaw
    extends Writer {
        WriterRaw(QueryParams qp, List<String> vars, PrintWriter writer) {
            super(qp, vars, writer);
        }

        @Override
        public void header(List<String> stns) {
        }

        @Override
        public void trailer() {
        }

        @Override
        Action getAction() {
            return new Action(){

                public void act(StationObsDataset sod, StationObsDatatype sobs, StructureData sdata) throws IOException {
                    String report = sdata.getScalarString("report");
                    WriterRaw.this.writer.println(report);
                    ++WriterRaw.this.count;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WriterNetcdf
    extends Writer {
        File netcdfResult;
        WriterStationObsDataset sobsWriter;
        List<Station> stnList;
        List<VariableSimpleIF> varList;

        WriterNetcdf(QueryParams qp, List<String> varNames, PrintWriter writer) throws IOException {
            super(qp, varNames, writer);
            this.netcdfResult = File.createTempFile("ncss", ".nc");
            this.sobsWriter = new WriterStationObsDataset(this.netcdfResult.getAbsolutePath(), "Extracted data from Unidata/TDS Metar dataset");
            if (varNames == null || varNames.size() == 0) {
                this.varList = StationObsCollection.this.variableList;
            } else {
                this.varList = new ArrayList<VariableSimpleIF>(varNames.size());
                for (VariableSimpleIF v : StationObsCollection.this.variableList) {
                    if (!varNames.contains(v.getName())) continue;
                    this.varList.add(v);
                }
            }
        }

        @Override
        public void header(List<String> stns) {
            try {
                StationObsCollection.this.getStationMap();
                if (stns.size() == 0) {
                    this.stnList = StationObsCollection.this.stationList;
                } else {
                    this.stnList = new ArrayList<Station>(stns.size());
                    for (String s : stns) {
                        this.stnList.add((Station)StationObsCollection.this.stationMap.get(s));
                    }
                }
                this.sobsWriter.writeHeader(this.stnList, this.varList);
            }
            catch (IOException e) {
                log.error("WriterNetcdf.header", (Throwable)e);
            }
        }

        @Override
        public void trailer() {
            try {
                this.sobsWriter.finish();
            }
            catch (IOException e) {
                log.error("WriterNetcdf.trailer", (Throwable)e);
            }
        }

        @Override
        Action getAction() {
            return new Action(){

                public void act(StationObsDataset sod, StationObsDatatype sobs, StructureData sdata) throws IOException {
                    WriterNetcdf.this.sobsWriter.writeRecord(sobs, sdata);
                    ++WriterNetcdf.this.count;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Writer {
        QueryParams qp;
        List<String> varNames;
        PrintWriter writer;
        DateFormatter format = new DateFormatter();
        int count = 0;

        abstract void header(List<String> var1);

        abstract Action getAction();

        abstract void trailer();

        Writer(QueryParams qp, List<String> varNames, PrintWriter writer) {
            this.qp = qp;
            this.varNames = varNames;
            this.writer = writer;
        }

        List<VariableSimpleIF> getVars(List<String> varNames, List<VariableSimpleIF> dataVariables) {
            ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>();
            for (VariableSimpleIF v : dataVariables) {
                if (varNames != null && !varNames.contains(v.getName())) continue;
                result.add(v);
            }
            return result;
        }
    }

    private class Limit {
        int count;
        int limit = Integer.MAX_VALUE;
        int matches;

        private Limit() {
        }
    }

    private static interface Action {
        public void act(StationObsDataset var1, StationObsDatatype var2, StructureData var3) throws IOException;
    }

    private static interface Predicate {
        public boolean match(StructureData var1);
    }

    private class StationDataTracker {
        StationObsDatatype sobs;
        long timeDiff = Long.MAX_VALUE;

        StationDataTracker(StationObsDatatype sobs, long timeDiff) {
            this.sobs = sobs;
            this.timeDiff = timeDiff;
        }
    }

    class Dataset
    implements Comparable {
        String filename;
        String name;
        StationObsDataset sod;
        Date time_start;
        Date time_end;
        boolean mayChange;

        Dataset(File file, boolean mayChange) throws IOException {
            this.filename = file.getAbsolutePath();
            this.name = file.getName();
            this.mayChange = mayChange;
            this.sod = this.get();
            this.time_start = this.sod.getStartDate();
            this.time_end = this.sod.getEndDate();
            if (debug) {
                System.out.println(" add " + this);
            }
        }

        StationObsDataset get() throws IOException {
            if (this.sod == null) {
                StringBuffer sbuff = new StringBuffer();
                if (debug) {
                    System.out.println("StationObsDataset open " + this.filename);
                }
                this.sod = (StationObsDataset)TypedDatasetFactory.open((DataType)DataType.STATION, (String)this.filename, null, (StringBuffer)sbuff);
                if (null == this.sod) {
                    log.info("Cant open " + this.filename + "; " + sbuff);
                    return null;
                }
            } else if (this.mayChange) {
                NetcdfFile ncfile = this.sod.getNetcdfFile();
                ncfile.syncExtend();
            }
            return this.sod;
        }

        public int compareTo(Object o) {
            Dataset od = (Dataset)o;
            return this.time_start.compareTo(od.time_start);
        }

        public String toString() {
            return "StationObsDataset " + this.filename + " start= " + StationObsCollection.this.format.toDateTimeString(this.time_start) + " end= " + StationObsCollection.this.format.toDateTimeString(this.time_end);
        }
    }

    private class ReinitTask
    extends TimerTask {
        private ReinitTask() {
        }

        public void run() {
            cacheLogger.info("StationObsCollection.reinit to " + StationObsCollection.this.archiveDir + " from " + StationObsCollection.this.realtimeDir + " at " + StationObsCollection.this.format.toDateTimeString(new Date()));
            StationObsCollection.this.init();
        }
    }
}

