/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import thredds.datatype.DateRange;
import thredds.server.ncSubset.QueryParams;
import thredds.server.ncSubset.StationObsCollection;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;

public class StationObsServlet
extends AbstractServlet {
    private boolean allow = false;
    private StationObsCollection soc;
    private boolean debug = false;
    private boolean showResponseTime = false;

    protected String getPath() {
        return "ncss/metars/";
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("NetcdfSubsetServer");
        DebugHandler.Action act = new DebugHandler.Action("showMetarFiles", "Show Metar Files"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println("Metar Files\n");
                ArrayList<StationObsCollection.Dataset> list = StationObsServlet.this.soc.getDatasets();
                for (StationObsCollection.Dataset ds : list) {
                    e.pw.println(" " + ds);
                }
            }
        };
        debugHandler.addAction(act);
    }

    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("NetcdfSubsetService.allow", false);
        if (!this.allow) {
            return;
        }
        String metarDir = ThreddsConfig.get("NetcdfSubsetService.metarDataDir", "/opt/tomcat/content/thredds/public/stn/");
        File dir = new File(metarDir);
        if (!dir.exists()) {
            this.allow = false;
            return;
        }
        String metarRawDir = ThreddsConfig.get("NetcdfSubsetService.metarRawDir", "/data/ldm/pub/decoded/netcdf/surface/metar/");
        File rawDir = new File(metarRawDir);
        if (!rawDir.exists()) {
            metarRawDir = null;
        }
        this.soc = new StationObsCollection(metarDir, metarRawDir);
    }

    public void destroy() {
        super.destroy();
        if (null != this.soc) {
            this.soc.close();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean useAllTimes;
        DateRange dr;
        boolean useAllStations;
        String pathInfo;
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        if (!this.soc.isReady()) {
            res.sendError(503, "Service Temporarily Unavailable");
            return;
        }
        long start = System.currentTimeMillis();
        ServletUtil.logServerAccessSetup(req);
        if (this.debug) {
            System.out.println(req.getQueryString());
        }
        if ((pathInfo = req.getPathInfo()) == null) {
            pathInfo = "";
        }
        boolean wantXML = pathInfo.endsWith("dataset.xml");
        boolean showForm = pathInfo.endsWith("dataset.html");
        boolean wantStationXML = pathInfo.endsWith("stations.xml");
        if (wantXML || showForm || wantStationXML) {
            this.showForm(res, wantXML, wantStationXML);
            return;
        }
        QueryParams qp = new QueryParams();
        if (!qp.parseQuery(req, res, new String[]{"text/plain", "text/csv", "application/xml", "application/x-netcdf"})) {
            return;
        }
        if (qp.hasBB) {
            qp.stns = this.soc.getStationNames(qp.getBB());
            if (qp.stns.size() == 0) {
                qp.errs.append("ERROR: Bounding Box contains no stations\n");
                qp.writeErr(res, qp.errs.toString(), 400);
                return;
            }
        }
        if (qp.hasStns && this.soc.isStationListEmpty(qp.stns)) {
            qp.errs.append("ERROR: No valid stations specified\n");
            qp.writeErr(res, qp.errs.toString(), 400);
            return;
        }
        if (qp.hasLatlonPoint) {
            qp.stns = new ArrayList<String>();
            qp.stns.add(this.soc.findClosestStation(qp.lat, qp.lon));
        } else if (qp.fatal) {
            qp.errs.append("ERROR: No valid stations specified\n");
            qp.writeErr(res, qp.errs.toString(), 400);
            return;
        }
        boolean bl = useAllStations = !qp.hasBB && !qp.hasStns && !qp.hasLatlonPoint;
        if (useAllStations) {
            qp.stns = new ArrayList<String>();
        }
        if (qp.hasTimePoint && this.soc.filterDataset(qp.time) == null) {
            qp.errs.append("ERROR: This dataset does not contain the time point= " + qp.time + " \n");
            qp.writeErr(res, qp.errs.toString(), 400);
            return;
        }
        if (qp.hasDateRange && !this.soc.intersect(dr = qp.getDateRange())) {
            qp.errs.append("ERROR: This dataset does not contain the time range= " + qp.time + " \n");
            qp.writeErr(res, qp.errs.toString(), 400);
            return;
        }
        boolean bl2 = useAllTimes = !qp.hasTimePoint && !qp.hasDateRange;
        if (useAllStations && useAllTimes) {
            qp.errs.append("ERROR: You must subset by space or time\n");
            qp.writeErr(res, qp.errs.toString(), 400);
            return;
        }
        String contentType = qp.acceptType;
        if (qp.acceptType.equals("text/csv")) {
            contentType = "text/plain";
        }
        res.setContentType(contentType);
        if (qp.acceptType.equals("application/x-netcdf")) {
            res.setHeader("Content-Disposition", "attachment; filename=metarSubset.nc");
            File file = this.soc.writeNetcdf(qp);
            ServletUtil.returnFile(this, req, res, file, "application/x-netcdf");
            file.delete();
            long took = System.currentTimeMillis() - start;
            if (this.showResponseTime) {
                System.out.println("\ntotal response took = " + took + " msecs");
            }
            return;
        }
        this.soc.write(qp, res.getWriter());
        long took = System.currentTimeMillis() - start;
        if (this.showResponseTime) {
            System.out.println("\ntotal response took = " + took + " msecs");
        }
    }

    private void showForm(HttpServletResponse res, boolean wantXml, boolean wantStationXml) throws IOException {
        String infoString;
        Document doc;
        if (wantXml) {
            doc = this.soc.getDoc();
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            infoString = fmt.outputString(doc);
        } else if (wantStationXml) {
            doc = this.soc.getStationDoc();
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            infoString = fmt.outputString(doc);
        } else {
            InputStream xslt = this.getXSLT("ncssSobs.xsl");
            Document doc2 = this.soc.getDoc();
            try {
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc2);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (Exception e) {
                this.log.error("SobsServlet internal error", (Throwable)e);
                ServletUtil.logServerAccess(500, 0L);
                res.sendError(500, "SobsServlet internal error");
                return;
            }
        }
        res.setContentLength(infoString.length());
        if (wantXml || wantStationXml) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=iso-8859-1");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes());
        out.flush();
        ServletUtil.logServerAccess(200, infoString.length());
    }

    private InputStream getXSLT(String xslName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/resources/xsl/" + xslName);
    }
}

