/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.Server.SDArray;
import opendap.dap.Server.ServerDDS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.NcSDArray;
import thredds.server.opendap.NcSDByte;
import thredds.server.opendap.NcSDCharArray;
import thredds.server.opendap.NcSDFloat32;
import thredds.server.opendap.NcSDFloat64;
import thredds.server.opendap.NcSDGrid;
import thredds.server.opendap.NcSDInt16;
import thredds.server.opendap.NcSDInt32;
import thredds.server.opendap.NcSDString;
import thredds.server.opendap.NcSDStructure;
import thredds.server.opendap.NcSDUInt16;
import thredds.server.opendap.NcSDUInt32;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.unidata.util.StringUtil;

public class NcDDS
extends ServerDDS
implements Cloneable {
    protected static Logger log = LoggerFactory.getLogger(NcDDS.class);
    static String DODScharset = "_!~*'-\"";
    private HashMap<String, BaseType> dimHash = new HashMap(50);

    NcDDS(String name, NetcdfFile ncfile) {
        super(StringUtil.escape((String)name, (String)""));
        for (Dimension o : ncfile.getDimensions()) {
            Dimension dim = o;
            List cvs = dim.getCoordinateVariables();
            if (cvs.size() <= 0) continue;
            Variable cv = (Variable)cvs.get(0);
            SDArray bt = new NcSDArray(cv, this.createScalarVariable(cv));
            if (cv.getDataType() == DataType.CHAR && cv.getRank() > 1) {
                bt = new NcSDCharArray(cv);
            }
            this.dimHash.put(dim.getName(), (BaseType)bt);
            if (!log.isDebugEnabled()) continue;
            log.debug(" NcDDS adding coordinate variable " + cv.getName() + " for dimension " + dim.getName());
        }
        Iterator i$ = ncfile.getVariables().iterator();
        while (i$.hasNext()) {
            Variable o1;
            Variable v = o1 = (Variable)i$.next();
            BaseType bt = null;
            if (v.getCoordinateDimension() != null && (bt = this.dimHash.get(v.getName())) == null) {
                log.error("NcDDS: Variable " + v.getName() + " missing coordinate variable in hash; dataset=" + name);
            }
            if (bt == null) {
                bt = this.createVariable(v);
            }
            this.addVariable(bt);
        }
    }

    private BaseType createVariable(Variable v) {
        Object bt = v.getRank() == 0 ? this.createScalarVariable(v) : (v.getDataType() == DataType.CHAR ? (v.getRank() > 1 ? new NcSDCharArray(v) : new NcSDString(v)) : (v.getDataType() == DataType.STRING ? (v.getRank() == 0 ? new NcSDString(v) : new NcSDArray(v, (BaseType)new NcSDString(v))) : this.createArray(v)));
        return bt;
    }

    private BaseType createScalarVariable(Variable v) {
        DataType dt = v.getDataType();
        if (dt == DataType.DOUBLE) {
            return new NcSDFloat64(v);
        }
        if (dt == DataType.FLOAT) {
            return new NcSDFloat32(v);
        }
        if (dt == DataType.INT) {
            return v.isUnsigned() ? new NcSDUInt32(v) : new NcSDInt32(v);
        }
        if (dt == DataType.SHORT) {
            return v.isUnsigned() ? new NcSDUInt16(v) : new NcSDInt16(v);
        }
        if (dt == DataType.BYTE) {
            return new NcSDByte(v);
        }
        if (dt == DataType.CHAR) {
            return new NcSDString(v);
        }
        if (dt == DataType.STRING) {
            return new NcSDString(v);
        }
        if (dt == DataType.STRUCTURE) {
            return this.createStructure((Structure)v);
        }
        throw new UnsupportedOperationException("NcDDS Variable data type = " + dt);
    }

    private BaseType createArray(Variable v) {
        boolean isGrid = v.getRank() > 1 && v.getDataType() != DataType.STRUCTURE && v.getParentStructure() == null;
        Iterator iter = v.getDimensions().iterator();
        while (isGrid && iter.hasNext()) {
            Dimension dim = (Dimension)iter.next();
            if (dim.getCoordinateVariables().size() == 0) {
                isGrid = false;
                continue;
            }
            Variable cv = (Variable)dim.getCoordinateVariables().get(0);
            if (cv.getName().equals(dim.getName())) continue;
            isGrid = false;
        }
        NcSDArray arr = new NcSDArray(v, this.createScalarVariable(v));
        if (!isGrid) {
            return arr;
        }
        ArrayList<NcSDArray> list = new ArrayList<NcSDArray>();
        list.add(arr);
        for (Dimension dim : v.getDimensions()) {
            list.add((NcSDArray)this.dimHash.get(dim.getName()));
        }
        return new NcSDGrid(v.getShortName(), list);
    }

    private BaseType createStructure(Structure s) {
        ArrayList<BaseType> list = new ArrayList<BaseType>();
        for (Object o : s.getVariables()) {
            Variable nested = (Variable)o;
            list.add(this.createVariable(nested));
        }
        return new NcSDStructure(s, list);
    }

    public static String escapeName(String vname) {
        return StringUtil.escape((String)vname, (String)DODScharset);
    }
}

