/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import opendap.dap.DAP2Exception;
import opendap.dap.parser.ParseException;
import opendap.servlet.AbstractServlet;
import opendap.servlet.GuardedDataset;
import opendap.servlet.ReqState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.GuardedDatasetImpl;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.Debug;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.NetcdfFile;

public class NcDODSServlet
extends AbstractServlet {
    static final String GDATASET = "guarded_dataset";
    private Logger log;
    private boolean debugInit = false;
    private String serviceId;
    private String serviceTitle;
    private String latestServiceId;
    private String latestServiceTitle;
    private int maxNetcdfFilesCached = 100;
    private URI baseURI = null;

    public void init() throws ServletException {
        super.init();
        this.allowDeflate = false;
        try {
            String p;
            ServletUtil.initDebugging((HttpServlet)this);
            ServletUtil.initLogging((HttpServlet)this);
            this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            this.debugInit |= Debug.isSet("ncdods/init");
            if (this.debugInit || Debug.isSet("ncdods/showServerInfo")) {
                ServletUtil.showServletInfo((HttpServlet)this, System.out);
            }
            this.serviceId = this.getInitParameter("serviceId");
            if (this.serviceId == null) {
                this.serviceId = "ncdods";
            }
            this.serviceTitle = this.getInitParameter("serviceTitle");
            if (this.serviceTitle == null) {
                this.serviceTitle = "netCDF-OpenDAP Server 3.0a";
            }
            this.latestServiceId = this.getInitParameter("latestServiceId");
            if (this.latestServiceId == null) {
                this.latestServiceId = "latest";
            }
            this.latestServiceTitle = this.getInitParameter("latestServiceTitle");
            if (this.latestServiceTitle == null) {
                this.latestServiceTitle = "netCDF-OpenDAP Server 3.0a";
            }
            if ((p = this.getInitParameter("maxNetcdfFilesCached")) != null) {
                try {
                    this.maxNetcdfFilesCached = Integer.parseInt(p);
                    if (this.debugInit) {
                        this.log.debug(" maxNetcdfFilesCached = " + this.maxNetcdfFilesCached);
                    }
                }
                catch (NumberFormatException e) {
                    this.log.error(" maxNetcdfFilesCached bad number format in web.xml; use value " + this.maxNetcdfFilesCached);
                }
            }
            this.makeDebugActions();
            this.log.info(" initialized");
        }
        catch (Throwable t) {
            this.log.error("CatalogServlet init", t);
            t.printStackTrace();
        }
    }

    public String getServerVersion() {
        return "opendap/3.7";
    }

    protected long getLastModified(HttpServletRequest req) {
        String query = req.getQueryString();
        if (query != null) {
            return -1L;
        }
        String path = req.getPathInfo();
        if (path == null) {
            return -1L;
        }
        if (path.endsWith(".asc")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".ascii")) {
            path = path.substring(0, path.length() - 6);
        } else if (path.endsWith(".das")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".dds")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".ddx")) {
            path = path.substring(0, path.length() - 4);
        } else if (path.endsWith(".dods")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".html")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".info")) {
            path = path.substring(0, path.length() - 5);
        } else if (path.endsWith(".opendap")) {
            path = path.substring(0, path.length() - 5);
        } else {
            return -1L;
        }
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(path);
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    private void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("ncdodsServer");
        DebugHandler.Action act = new DebugHandler.Action("showStatus", "Show ncdods status"){

            public void doAction(DebugHandler.Event e) {
                try {
                    NcDODSServlet.this.doGetStatus(e.req, e.res);
                }
                catch (Exception ioe) {
                    NcDODSServlet.this.log.error("ShowStatus", (Throwable)ioe);
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("help", "Show help page"){

            public void doAction(DebugHandler.Event e) {
                try {
                    NcDODSServlet.this.doGetHELP(e.req, e.res);
                }
                catch (Exception ioe) {
                    NcDODSServlet.this.log.error("ShowHelp", (Throwable)ioe);
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("version", "Show server version"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println("  version= " + NcDODSServlet.this.getServerVersion());
            }
        };
        debugHandler.addAction(act);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ServletUtil.logServerAccessSetup(req);
        try {
            String path = req.getPathInfo();
            if (this.log.isDebugEnabled()) {
                this.log.debug("doGet path=" + path);
                if (Debug.isSet("showRequestDetail")) {
                    this.log.debug(ServletUtil.showRequestDetail((HttpServlet)this, req));
                }
            }
            if (path == null) {
                ServletUtil.logServerAccess(404, -1L);
                res.sendError(404);
                return;
            }
            if (this.baseURI == null) {
                URI reqURI = ServletUtil.getRequestURI(req);
                this.baseURI = reqURI.resolve("/thredds/dodsC/");
                this.log.debug(" baseURI was set = " + this.baseURI);
            }
            if (path.endsWith(".close")) {
                this.closeSession(req, res);
                res.setContentLength(0);
                ServletUtil.logServerAccess(200, 0L);
                return;
            }
            if (path.endsWith("latest.xml")) {
                DataRootHandler.getInstance().processReqForLatestDataset((HttpServlet)this, req, res);
                return;
            }
            if ((path.endsWith("catalog.xml") || path.endsWith("catalog.html") || path.endsWith("/")) && DataRootHandler.getInstance().processReqForCatalog(req, res)) {
                return;
            }
            super.doGet(req, res);
            ServletUtil.logServerAccess(200, -1L);
        }
        catch (FileNotFoundException e) {
            ServletUtil.logServerAccess(404, -1L);
            res.sendError(404, e.getMessage());
        }
        catch (IOException ioe) {
            ServletUtil.handleException(ioe, res);
        }
        catch (SecurityException e) {
            ServletUtil.logServerAccess(403, -1L);
            res.sendError(403, e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            ServletUtil.handleException(t, res);
        }
    }

    public void doGetDIR(HttpServletRequest req, HttpServletResponse res, ReqState rs) throws IOException, ServletException {
        if (rs.getRequestSuffix() == null || rs.getRequestSuffix().length() == 0) {
            ServletUtil.forwardToCatalogServices(req, res);
            return;
        }
        this.badURL(req, res);
    }

    private void closeSession(HttpServletRequest req, HttpServletResponse res) {
        HttpSession session = req.getSession();
        session.invalidate();
    }

    protected GuardedDataset getDataset(ReqState preq) throws DAP2Exception, IOException, ParseException {
        NetcdfFile ncd;
        GuardedDatasetImpl gdataset;
        HttpServletRequest req = preq.getRequest();
        boolean acceptSession = false;
        String s = req.getHeader("X-Accept-Session");
        if (s != null && s.equalsIgnoreCase("true")) {
            acceptSession = true;
        }
        HttpSession session = null;
        if (acceptSession && !(session = req.getSession()).isNew() && null != (gdataset = (GuardedDatasetImpl)session.getAttribute(GDATASET))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(" found gdataset " + gdataset + " in session " + session.getId());
            }
            return gdataset;
        }
        String reqPath = preq.getDataSet();
        try {
            ncd = DatasetHandler.getNetcdfFile(req, preq.getResponse(), reqPath);
            if (ncd == null) {
                return null;
            }
        }
        catch (FileNotFoundException fne) {
            throw new DAP2Exception(1, "Cant find " + reqPath);
        }
        catch (Throwable e) {
            this.log.error("Error ", e);
            throw new DAP2Exception(-1, "Server Error on dataset " + reqPath);
        }
        if (null == ncd) {
            return null;
        }
        GuardedDatasetImpl gdataset2 = new GuardedDatasetImpl(reqPath, ncd, acceptSession);
        if (acceptSession) {
            session.setAttribute(GDATASET, (Object)gdataset2);
            if (this.log.isDebugEnabled()) {
                this.log.debug(" added gdataset " + gdataset2 + " in session " + session.getId());
            }
        }
        return gdataset2;
    }
}

