/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import opendap.dap.BaseType;
import opendap.dap.DArrayDimension;
import opendap.dap.PrimitiveVector;
import opendap.dap.Server.InvalidParameterException;
import opendap.dap.Server.SDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcDDS;
import thredds.server.opendap.NcSDString;
import thredds.server.opendap.NcSDStructure;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class NcSDArray
extends SDArray
implements HasNetcdfVariable {
    private static Logger log = LoggerFactory.getLogger(NcSDArray.class);
    private boolean debug = false;
    private boolean debugRead = false;
    private Variable ncVar = null;
    protected BaseType elemType;

    NcSDArray(Variable v, BaseType bt) {
        super(NcDDS.escapeName(v.getShortName()));
        this.ncVar = v;
        for (Dimension dim : v.getDimensions()) {
            this.appendDim(dim.getLength(), dim.getName());
        }
        this.addVariable(bt);
        this.elemType = bt;
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws IOException, EOFException {
        Array a;
        long tstart = System.currentTimeMillis();
        try {
            if (log.isDebugEnabled()) {
                log.debug(this.getRequestedRange());
            }
            int n = this.numDimensions();
            ArrayList<Range> ranges = new ArrayList<Range>(n);
            for (int i = 0; i < n; ++i) {
                ranges.add(new Range(this.getStart(i), this.getStop(i), this.getStride(i)));
            }
            try {
                a = this.ncVar.read(ranges);
            }
            catch (ArrayIndexOutOfBoundsException t) {
                log.error(this.getRequestedRange(), (Throwable)t);
                throw new RuntimeException("NcSDArray ArrayIndexOutOfBoundsException=" + t.getMessage());
            }
            if (this.debug) {
                System.out.println("  NcSDArray Read " + this.getName() + " " + a.getSize() + " elems of type = " + a.getElementType());
            }
            if (this.debugRead) {
                System.out.println("  Read = " + a.getSize() + " elems of type = " + a.getElementType());
            }
            if (log.isDebugEnabled()) {
                long tookTime = System.currentTimeMillis() - tstart;
                log.debug("NcSDArray read array: " + (double)tookTime * 0.001 + " seconds");
            }
        }
        catch (InvalidParameterException e) {
            log.error(this.getRequestedRange(), (Throwable)e);
            throw new IllegalStateException("NcSDArray InvalidParameterException=" + e.getMessage());
        }
        catch (InvalidRangeException e) {
            log.error(this.getRequestedRange(), (Throwable)e);
            throw new IllegalStateException("NcSDArray InvalidRangeException=" + e.getMessage());
        }
        this.setData(a);
        if (this.debugRead) {
            System.out.println(" PrimitiveVector len = " + this.getPrimitiveVector().getLength() + " type = " + this.getPrimitiveVector().getTemplate());
        }
        return false;
    }

    private String getRequestedRange() {
        try {
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("NcSDArray read " + this.ncVar.getName());
            for (int i = 0; i < this.numDimensions(); ++i) {
                DArrayDimension d = this.getDimension(i);
                sbuff.append(" " + d.getName() + "(" + this.getStart(i) + "," + this.getStride(i) + "," + this.getStop(i) + ")");
            }
            return sbuff.toString();
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public void setData(Array data) {
        PrimitiveVector pv = this.getPrimitiveVector();
        if (this.debugRead) {
            System.out.println(" PrimitiveVector type = " + pv.getTemplate() + " pv type = " + pv.getClass().getName());
        }
        if (this.ncVar.getDataType() == DataType.STRING) {
            int size = (int)data.getSize();
            NcSDString[] dodsBT = new NcSDString[size];
            IndexIterator ii = data.getIndexIterator();
            int count = 0;
            while (ii.hasNext()) {
                dodsBT[count++] = new NcSDString(this.ncVar.getShortName(), (String)ii.getObjectNext());
            }
            pv.setInternalStorage((Object)dodsBT);
        } else if (this.ncVar.getDataType() == DataType.STRUCTURE) {
            NcSDStructure sds = (NcSDStructure)pv.getTemplate();
            int size = (int)data.getSize();
            NcSDStructure[] dodsBT = new NcSDStructure[size];
            IndexIterator ii = data.getIndexIterator();
            int count = 0;
            while (ii.hasNext()) {
                StructureData sdata = (StructureData)ii.getObjectNext();
                dodsBT[count] = new NcSDStructure(sds, sdata);
                ++count;
            }
            pv.setInternalStorage((Object)dodsBT);
        } else {
            Object pa = data.get1DJavaArray(data.getElementType());
            pv.setInternalStorage(pa);
        }
        this.setRead(true);
    }

    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        long tstart = System.currentTimeMillis();
        this.setData(sdata.getArray(m));
        this.externalize(sink);
        if (log.isDebugEnabled()) {
            long tookTime = System.currentTimeMillis() - tstart;
            log.debug("NcSDArray serialize: " + (double)tookTime * 0.001 + " seconds");
        }
    }
}

