/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import opendap.dap.Server.SDByte;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcDDS;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDByte
extends SDByte
implements HasNetcdfVariable {
    private Variable ncVar;

    NcSDByte(Variable ncVar) {
        super(NcDDS.escapeName(ncVar.getShortName()));
        this.ncVar = ncVar;
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    public void setData(Array data) {
        ArrayByte.D0 a = (ArrayByte.D0)data;
        this.setValue(a.get());
        this.setRead(true);
    }

    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarByte(m));
        this.externalize(sink);
    }
}

