/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DArrayDimension;
import opendap.dap.PrimitiveVector;
import opendap.dap.Server.InvalidParameterException;
import opendap.dap.Server.SDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcDDS;
import thredds.server.opendap.NcSDString;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class NcSDCharArray
extends SDArray
implements HasNetcdfVariable {
    private static Logger log = LoggerFactory.getLogger(NcSDCharArray.class);
    private boolean debugRead = false;
    private boolean debugReadDetail = false;
    private Variable ncVar = null;
    private int strLen = 1;

    NcSDCharArray(Variable v) {
        super(NcDDS.escapeName(v.getShortName()));
        this.ncVar = v;
        if (v.getRank() < 1) {
            throw new IllegalArgumentException("NcSDCharArray: rank must be > 1, var = " + v.getName());
        }
        List dims = v.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = (Dimension)dims.get(i);
            if (i < dims.size() - 1) {
                this.appendDim(dim.getLength(), dim.getName());
                continue;
            }
            this.strLen = dim.getLength();
        }
        this.addVariable((BaseType)new NcSDString(v.getShortName(), null));
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws IOException, EOFException {
        Array a;
        boolean hasStride = false;
        try {
            if (this.debugRead) {
                System.out.println("NcSDCharArray read " + this.ncVar.getName());
                for (int i = 0; i < this.numDimensions(); ++i) {
                    DArrayDimension d = this.getDimension(i);
                    System.out.println(" " + d.getName() + " " + this.getStart(i) + " " + this.getStop(i) + " " + this.getStride(i));
                }
            }
            int n = this.numDimensions();
            int[] origin = new int[n + 1];
            int[] shape = new int[n + 1];
            for (int i = 0; i < n; ++i) {
                origin[i] = this.getStart(i);
                shape[i] = this.getStop(i) - this.getStart(i) + 1;
                hasStride = hasStride || this.getStride(i) > 1;
            }
            origin[n] = 0;
            shape[n] = this.strLen;
            a = this.ncVar.read(origin, shape);
            if (this.debugRead) {
                System.out.println("  Read = " + a.getSize() + " elems of type = " + a.getElementType());
            }
            if (hasStride) {
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int i = 0; i < n; ++i) {
                    int s = this.getStride(i);
                    if (s <= 1) continue;
                    ranges.add(new Range(0, shape[i], s));
                    if (!this.debugRead) continue;
                    System.out.println(" Section dim " + i + " stride = " + s);
                }
                ranges.add(null);
                a = a.section(ranges);
                if (this.debugRead) {
                    System.out.println("   section size " + a.getSize());
                }
            }
        }
        catch (InvalidParameterException e) {
            log.error("read char array", (Throwable)e);
            throw new IllegalStateException("NcSDCharArray InvalidParameterException");
        }
        catch (InvalidRangeException e) {
            log.error("read char array", (Throwable)e);
            throw new IllegalStateException("NcSDCharArray InvalidRangeException");
        }
        this.setData(a);
        return false;
    }

    public void setData(Array data) {
        PrimitiveVector pv = this.getPrimitiveVector();
        if (this.debugRead) {
            System.out.println(" PrimitiveVector type = " + pv.getTemplate() + " pv type = " + pv.getClass().getName());
        }
        ArrayChar ca = (ArrayChar)data;
        ArrayChar.StringIterator siter = ca.getStringIterator();
        int nelems = siter.getNumElems();
        if (this.debugRead) {
            System.out.println(" set Strings = " + nelems);
        }
        BaseTypePrimitiveVector btpv = (BaseTypePrimitiveVector)pv;
        btpv.setLength(nelems);
        for (int i = 0; i < nelems; ++i) {
            String val = siter.next();
            NcSDString ds = new NcSDString("", val);
            btpv.setValue(i, (BaseType)ds);
            if (!this.debugReadDetail) continue;
            System.out.println("  s = " + val + " == " + ds.getValue());
        }
        if (this.debugRead) {
            System.out.println("  PrimitiveVector len = " + pv.getLength() + " type = " + pv.getTemplate());
        }
        this.setRead(true);
    }

    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setData(sdata.getArray(m));
        this.externalize(sink);
    }
}

