/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import opendap.dap.Server.SDFloat32;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcDDS;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDFloat32
extends SDFloat32
implements HasNetcdfVariable {
    private Variable ncVar;

    NcSDFloat32(Variable v) {
        super(NcDDS.escapeName(v.getShortName()));
        this.ncVar = v;
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    public void setData(Array data) {
        ArrayFloat.D0 a = (ArrayFloat.D0)data;
        this.setValue(a.get());
        this.setRead(true);
    }

    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarFloat(m));
        this.externalize(sink);
    }
}

