/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import opendap.dap.Server.SDString;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcDDS;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDString
extends SDString
implements HasNetcdfVariable {
    private Variable ncVar;
    private String localVal = null;

    NcSDString(Variable v) {
        super(NcDDS.escapeName(v.getShortName()));
        this.ncVar = v;
    }

    NcSDString(String name, String val) {
        super(name);
        this.localVal = val;
        if (val != null) {
            this.setValue(val);
        }
    }

    public boolean read(String datasetName, Object specialO) throws IOException {
        if (this.localVal == null) {
            this.setData(this.ncVar.read());
        }
        this.setValue(this.localVal);
        this.setRead(true);
        return false;
    }

    public void setData(Array data) {
        if (this.ncVar.getDataType() == DataType.STRING) {
            this.localVal = (String)data.getObject(data.getIndex());
        } else if (this.ncVar.getRank() == 0) {
            ArrayChar.D0 a = (ArrayChar.D0)data;
            byte[] b = new byte[]{(byte)a.get()};
            this.localVal = new String(b);
        } else {
            ArrayChar.D1 a = (ArrayChar.D1)data;
            this.localVal = a.getString(a.getIndex());
        }
        this.setValue(this.localVal);
        this.setRead(true);
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.localVal = sdata.getScalarString(m);
        this.setValue(this.localVal);
        this.externalize(sink);
    }
}

