/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.NoSuchVariableException;
import opendap.dap.Server.CEEvaluator;
import opendap.dap.Server.DAP2ServerSideException;
import opendap.dap.Server.SDStructure;
import opendap.dap.Server.ServerMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcDDS;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class NcSDStructure
extends SDStructure {
    private static Logger log = LoggerFactory.getLogger(NcSDStructure.class);
    private Structure ncVar = null;
    protected List memberBTlist;
    protected NcSDStructure org;
    protected StructureData sdata;

    public NcSDStructure(Structure s, List list) {
        super(NcDDS.escapeName(s.getShortName()));
        this.ncVar = s;
        for (int i = 0; i < list.size(); ++i) {
            this.addVariable((BaseType)list.get(i), 0);
        }
        this.memberBTlist = list;
    }

    public NcSDStructure(NcSDStructure org, StructureData sdata) {
        super(org.getName());
        this.org = org;
        this.sdata = sdata;
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws NoSuchVariableException, IOException, EOFException {
        StructureData sdata = this.ncVar.readStructure();
        this.setData(sdata);
        return false;
    }

    public void setData(StructureData sdata) {
        int count = 0;
        StructureMembers sm = sdata.getStructureMembers();
        Enumeration vars = this.getVariables();
        while (vars.hasMoreElements()) {
            HasNetcdfVariable hasNetcdf = (HasNetcdfVariable)vars.nextElement();
            StructureMembers.Member m = sm.getMember(count++);
            Array data = sdata.getArray(m);
            hasNetcdf.setData(data);
        }
        this.setRead(true);
    }

    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        if (this.org == null) {
            super.serialize(dataset, sink, ce, specialO);
            return;
        }
        Enumeration vars = this.org.getVariables();
        StructureMembers sm = this.sdata.getStructureMembers();
        int count = 0;
        while (vars.hasMoreElements()) {
            HasNetcdfVariable sm_org = (HasNetcdfVariable)vars.nextElement();
            boolean isProjected = ((ServerMethods)sm_org).isProject();
            if (isProjected) {
                StructureMembers.Member m = sm.getMember(count);
                sm_org.serialize(sink, this.sdata, m);
            }
            ++count;
        }
    }
}

