/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import opendap.dap.Server.SDUInt16;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.NcDDS;
import ucar.ma2.Array;
import ucar.ma2.ArrayShort;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDUInt16
extends SDUInt16
implements HasNetcdfVariable {
    private Variable ncVar;

    NcSDUInt16(Variable v) {
        super(NcDDS.escapeName(v.getShortName()));
        this.ncVar = v;
    }

    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    public void setData(Array data) {
        ArrayShort.D0 a = (ArrayShort.D0)data;
        this.setValue(a.get());
        this.setRead(true);
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarShort(m));
        this.externalize(sink);
    }
}

