/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import thredds.catalog.XMLEntityResolver;
import thredds.catalog.query.Station;
import thredds.datatype.DateRange;
import thredds.datatype.DateType;
import thredds.server.ncSubset.QueryParams;
import thredds.server.radarServer.RadarServer;
import thredds.server.radarServer.ServerMethods;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.util.Format;

public class RadarLevel2Server {
    public static List<Station> stationList = null;
    public static HashMap<String, Station> stationMap;
    public static String radarStations;
    protected ServerMethods sm;
    private boolean debug = false;
    private PrintWriter pw = null;

    public RadarLevel2Server() {
    }

    public RadarLevel2Server(String contentPath) {
        this.sm = new ServerMethods();
        if (stationList == null) {
            stationList = this.sm.getStations(contentPath + this.getPath() + radarStations);
            stationMap = this.sm.getStationMap(stationList);
        }
    }

    public Document stationsXML(Document doc, Element rootElem, String path) {
        String[] stations = this.stationsDS(path);
        doc = this.makeStationDocument(doc, rootElem, stations);
        return doc;
    }

    protected String getPath() {
        return "servers/";
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("NetcdfSubsetServer");
        DebugHandler.Action act = new DebugHandler.Action("showRadarLevel2Files", "Show RadarLevel2 Files"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println("RadarLevel2 Files\n");
            }
        };
        debugHandler.addAction(act);
    }

    public void radarLevel2Query(HttpServletRequest req, HttpServletResponse res, String radarDir) throws ServletException, IOException {
        String serviceName = "OPENDAP";
        String serviceType = "OPENDAP";
        String serviceBase = "/thredds/dodsC";
        Object start = null;
        Object end = null;
        try {
            String accept;
            boolean useAllStations;
            if (this.debug) {
                System.out.println(req.getQueryString());
            }
            this.sm.setPW(this.pw);
            String pathInfo = req.getPathInfo();
            if (pathInfo == null) {
                pathInfo = "";
            }
            Boolean level2 = pathInfo.contains("level2");
            if (radarDir == null) {
                radarDir = RadarServer.dataLocation.get("nexrad/level2/IDD");
            }
            String dirStructure = "STN/DAY";
            QueryParams qp = new QueryParams();
            if (!qp.parseQuery(req, res, new String[]{"application/xml", "text/csv", "text/plain", "application/x-netcdf"})) {
                return;
            }
            if (qp.hasBB) {
                qp.stns = this.sm.getStationNames(qp.getBB(), stationList);
                if (qp.stns.size() == 0) {
                    qp.errs.append("<documentation>ERROR: Bounding Box contains no stations</documentation>\n");
                    qp.writeErr(res, qp.errs.toString(), 400);
                    return;
                }
            }
            if (qp.hasStns && this.sm.isStationListEmpty(qp.stns, stationMap)) {
                qp.errs.append("<documentation>ERROR: No valid stations specified</documentation>\n");
                qp.writeErr(res, qp.errs.toString(), 400);
                return;
            }
            if (qp.hasLatlonPoint) {
                qp.stns = new ArrayList<String>();
                qp.stns.add(this.sm.findClosestStation(qp.lat, qp.lon, stationList));
            } else if (qp.fatal) {
                qp.errs.append("<documentation>ERROR: No valid stations specified</documentation>\n");
                qp.writeErr(res, qp.errs.toString(), 400);
                return;
            }
            boolean bl = useAllStations = !qp.hasBB && !qp.hasStns && !qp.hasLatlonPoint;
            if (useAllStations) {
                qp.stns = this.sm.getStationNames(stationList);
            }
            boolean latest = false;
            if (qp.hasTimePoint) {
                if (qp.time.isPresent()) {
                    latest = true;
                    try {
                        qp.time_end = new DateType("present", null, null);
                        qp.time_start = new DateType("1970-01-01T00:00:00", null, null);
                    }
                    catch (ParseException e) {
                        qp.errs.append("Illegal param= 'time' must be valid ISO Duration\n");
                    }
                } else {
                    qp.time_end = qp.time;
                    qp.time_start = qp.time;
                }
            } else if (qp.hasDateRange) {
                DateRange dr = qp.getDateRange();
                qp.time_start = dr.getStart();
                qp.time_end = dr.getEnd();
            } else {
                try {
                    qp.time_end = new DateType("present", null, null);
                    qp.time_start = new DateType("1970-01-01T00:00:00", null, null);
                }
                catch (ParseException e) {
                    qp.errs.append("Illegal param= 'time' must be valid ISO Duration\n");
                }
            }
            if (!level2.booleanValue()) {
                // empty if block
            }
            if ((accept = ServletUtil.getParameterIgnoreCase(req, "accept")) == null) {
                accept = "xml";
            }
            if (ServerMethods.p_html_i.matcher(accept).find()) {
                res.setContentType("text/html");
            }
            serviceBase = serviceBase + pathInfo + "/";
            if (serviceType.equals("OPENDAP")) {
                int level = 2;
                if (!level2.booleanValue()) {
                    level = 3;
                }
                this.pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.pw.print("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"");
                this.pw.println(" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"Radar Level" + level + " datasets in near real time\" version=\"" + "1.0.1\">");
                this.pw.println("");
                this.pw.print("  <service name=\"" + serviceName + "\" serviceType=\"" + serviceType + "\"");
                this.pw.println(" base=\"" + serviceBase + "\"/>");
                this.pw.print("    <dataset name=\"RadarLevel" + level + " datasets for available stations and times\" collectionType=\"TimeSeries\" ID=\"" + "accept=" + accept + "&amp;");
                if (useAllStations) {
                    this.pw.print("stn=all&amp;");
                } else if (qp.hasStns && !this.sm.isStationListEmpty(qp.stns, stationMap)) {
                    for (String station : qp.stns) {
                        this.pw.print("stn=" + station + "&amp;");
                    }
                } else if (qp.hasBB) {
                    this.pw.print("south=" + qp.south + "&amp;north=" + qp.north + "&amp;");
                    this.pw.print("west=" + qp.west + "&amp;east=" + qp.east + "&amp;");
                }
                if (qp.hasDateRange) {
                    this.pw.println("time_start=" + qp.time_start.toDateTimeString() + "&amp;time_end=" + qp.time_end.toDateTimeString() + "\">");
                } else if (latest) {
                    this.pw.println("time=present\">");
                } else if (qp.hasTimePoint) {
                    this.pw.println("time=" + qp.time.toDateTimeString() + "\">");
                } else {
                    this.pw.println("\">");
                }
                this.pw.println("    <metadata inherited=\"true\">");
                this.pw.println("      <dataType>Radial</dataType>");
                this.pw.print("      <dataFormat>");
                if (level2.booleanValue()) {
                    this.pw.print("NEXRAD2");
                } else {
                    this.pw.print("NIDS");
                }
                this.pw.println("</dataFormat>");
                this.pw.println("      <serviceName>" + serviceName + "</serviceName>");
                this.pw.println("    </metadata>");
                this.pw.println();
            } else if (ServerMethods.p_html_i.matcher(accept).find()) {
                this.pw.println("<Head><Title>THREDDS RadarLevel2 Server</Title></Head>");
                this.pw.println("<body bgcolor=\"lightblue\" link=\"red\" alink=\"red\" vlink=\"red\">");
                this.pw.println("<center><H1>RadarLevel2 Selection Results</H1></center>");
            } else if (!ServerMethods.p_ascii_i.matcher(accept).find() && ServerMethods.p_xml_i.matcher(accept).find()) {
                this.pw.println("<reports>");
            }
            if (this.sm.isStationListEmpty(qp.stns, stationMap)) {
                this.pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                this.pw.println("    </dataset>");
                this.pw.println("</catalog>");
                return;
            }
            String yyyymmddStart = qp.time_start.toDateString();
            yyyymmddStart = yyyymmddStart.replace("-", "");
            String yyyymmddEnd = qp.time_end.toDateString();
            yyyymmddEnd = yyyymmddEnd.replace("-", "");
            String dateStart = yyyymmddStart + "_" + this.sm.hhmm(qp.time_start.toDateTimeString());
            String dateEnd = yyyymmddEnd + "_" + this.sm.hhmm(qp.time_end.toDateTimeString());
            boolean dataFound = false;
            boolean done = false;
            if (dirStructure.startsWith("STN")) {
                for (String station : qp.stns) {
                    done = false;
                    String[] DAYS = this.sm.getDAYS(radarDir + "/" + station, this.pw);
                    if (DAYS == null || DAYS.length == 0) continue;
                    for (int i = 0; i < DAYS.length && !done; ++i) {
                        if (!this.sm.isValidDay(DAYS[i], yyyymmddStart, yyyymmddEnd)) continue;
                        ArrayList<String> files = new ArrayList<String>();
                        File dir = new File(radarDir + "/" + station + "/" + DAYS[i]);
                        String[] FILES = dir.list();
                        for (int t = 0; t < FILES.length; ++t) {
                            if (!this.sm.isValidDate(FILES[t], dateStart, dateEnd)) continue;
                            files.add(FILES[t]);
                        }
                        if (files.size() <= 0) continue;
                        dataFound = true;
                        done = qp.hasTimePoint;
                        this.processDS(files, DAYS[i], accept, station, latest, this.pw);
                    }
                }
            } else if (dirStructure.startsWith("DAY")) {
                String[] DAYS = this.sm.getDAYS(radarDir, this.pw);
                for (int i = 0; i < DAYS.length; ++i) {
                    if (!this.sm.isValidDay(DAYS[i], yyyymmddStart, yyyymmddEnd)) continue;
                    for (String station : qp.stns) {
                        ArrayList<String> files = new ArrayList<String>();
                        File dir = new File(radarDir + "/" + DAYS[i] + "/" + station);
                        if (!dir.exists()) continue;
                        String[] FILES = dir.list();
                        for (int t = 0; t < FILES.length; ++t) {
                            if (!this.sm.isValidDate(FILES[t], dateStart, dateEnd)) continue;
                            files.add(FILES[t]);
                        }
                        if (files.size() <= 0) continue;
                        dataFound = true;
                        done = qp.hasTimePoint;
                        this.processDS(files, DAYS[i], accept, station, latest, this.pw);
                    }
                }
            }
            if (ServerMethods.p_xml_i.matcher(accept).find()) {
                if (!dataFound) {
                    this.pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                }
                this.pw.println("    </dataset>");
                this.pw.println("</catalog>");
            } else if (ServerMethods.p_html_i.matcher(accept).find()) {
                this.pw.println("</html>");
            }
        }
        catch (Throwable t) {
            ServletUtil.handleException(t, res);
        }
        ServletUtil.logServerAccess(200, -1L);
    }

    protected void processDS(ArrayList files, String day, String accept, String station, Boolean latest, PrintWriter pw) {
        Collections.sort(files, new CompareKeyDescend());
        boolean firstTime = true;
        for (int t = 0; t < files.size(); ++t) {
            if (ServerMethods.p_html_i.matcher(accept).find()) {
                if (firstTime) {
                    pw.println("<h3>Report(s) for station " + station + "</h3>");
                    firstTime = false;
                }
                pw.println(files.get(t) + "</a></p>\n");
            } else if (ServerMethods.p_xml_i.matcher(accept).find()) {
                this.catalogOut((String)files.get(t), station, day, pw);
            } else if (ServerMethods.p_ascii_i.matcher(accept).find()) {
                pw.println(files.get(t));
            } else if (accept.equals("data")) {
                // empty if block
            }
            if (latest.booleanValue()) break;
        }
    }

    public void catalogOut(String product, String stn, String day, PrintWriter pw) {
        pw.println("      <dataset name=\"" + product + "\" ID=\"" + product.hashCode() + "\"");
        String pDate = this.sm.getObTimeISO(product);
        pw.print("        urlPath=\"");
        pw.println(stn + "/" + day + "/" + product + "\">");
        pw.println("        <date type=\"start of ob\">" + pDate + "</date>");
        pw.println("      </dataset>");
    }

    public Document getDoc() throws IOException {
        Element root = new Element("RadarLevel2");
        Document doc = new Document(root);
        root.setAttribute("location", "/thredds/radarServer/nexrad/level2");
        Element LatLonBox = new Element("LatLonBox");
        LatLonBox.addContent((Content)new Element("north").addContent("75.0000"));
        LatLonBox.addContent((Content)new Element("south").addContent("19.0000"));
        LatLonBox.addContent((Content)new Element("east").addContent("-75.0000"));
        LatLonBox.addContent((Content)new Element("west").addContent("-175.0000"));
        root.addContent((Content)LatLonBox);
        Element timeSpan = new Element("TimeSpan");
        DateFormatter format = new DateFormatter();
        Calendar now = Calendar.getInstance();
        Date end = now.getTime();
        now.add(10, -120);
        Date startNow = now.getTime();
        timeSpan.addContent((Content)new Element("begin").addContent(format.toDateTimeStringISO(startNow)));
        timeSpan.addContent((Content)new Element("end").addContent("present"));
        root.addContent((Content)timeSpan);
        Element stnList = new Element("stationList");
        stnList.setAttribute("title", "Available Stations", XMLEntityResolver.xlinkNS);
        stnList.setAttribute("href", "/thredds/idd/radarLevel2/stations.xml", XMLEntityResolver.xlinkNS);
        root.addContent((Content)stnList);
        Element a = new Element("AcceptList");
        a.addContent((Content)new Element("accept").addContent("xml"));
        root.addContent((Content)a);
        return doc;
    }

    public Document makeStationDocument(Document doc, Element rootElem, String[] stns) {
        for (int i = 0; i < stns.length; ++i) {
            if (stns[i].length() == 3) {
                stns[i] = "K" + stns[i];
            }
            Station s = stationMap.get(stns[i]);
            Element sElem = new Element("station");
            if (s == null) {
                sElem.setAttribute("id", stns[i]);
                sElem.setAttribute("state", "XXX");
                sElem.setAttribute("country", "XX");
                sElem.addContent((Content)new Element("name").addContent("Unknown"));
                sElem.addContent((Content)new Element("longitude").addContent("0.0"));
                sElem.addContent((Content)new Element("latitude").addContent("0.0"));
                sElem.addContent((Content)new Element("elevation").addContent("0"));
                rootElem.addContent((Content)sElem);
                continue;
            }
            sElem.setAttribute("id", s.getValue());
            if (s.getState() != null) {
                sElem.setAttribute("state", s.getState());
            }
            if (s.getCountry() != null) {
                sElem.setAttribute("country", s.getCountry());
            }
            if (s.getName() != null) {
                sElem.addContent((Content)new Element("name").addContent(s.getName()));
            }
            sElem.addContent((Content)new Element("longitude").addContent(Format.d((double)s.getLocation().getLongitude(), (int)6)));
            sElem.addContent((Content)new Element("latitude").addContent(Format.d((double)s.getLocation().getLatitude(), (int)6)));
            if (!Double.isNaN(s.getLocation().getElevation())) {
                sElem.addContent((Content)new Element("elevation").addContent(Format.d((double)s.getLocation().getElevation(), (int)6)));
            }
            rootElem.addContent((Content)sElem);
        }
        return doc;
    }

    public String[] stationsDS(String path) {
        String[] stations = null;
        if (path != null) {
            File files = new File(path);
            stations = files.list();
            for (int i = 0; i < stations.length; ++i) {
                if (!stations[i].equals("N0R")) continue;
                path = path + "/N0R";
                files = new File(path);
                stations = files.list();
                break;
            }
        }
        if (stations == null || stations.length == 0) {
            stations = new String[1];
            stations = stationMap.keySet().toArray(stations);
        }
        return stations;
    }

    public void printStations(Document doc, String root) {
    }

    public void printStations(String[] stations) {
        for (String s : stations) {
            Station stn;
            if (s.length() == 3) {
                s = "K" + s;
            }
            if ((stn = stationMap.get(s)) == null) {
                this.pw.println("   <station id=\"" + s + "\" state=\"XX\" country=\"XX\">");
                this.pw.println("      <name>Unknown</name>");
                this.pw.println("      <latitude>0.0</latitude>");
                this.pw.println("      <longitude>0.0</longitude>");
                this.pw.println("      <elevation>0.0</elevation>");
                this.pw.println("   </station>");
                continue;
            }
            this.pw.println("   <station id=\"" + stn.getValue() + "\" state=\"" + stn.getState() + "\" country=\"" + stn.getCountry() + "\">");
            this.pw.println("      <name>" + stn.getName() + "</name>");
            this.pw.println("      <latitude>" + Format.d((double)stn.getLocation().getLatitude(), (int)6) + "</latitude>");
            this.pw.println("      <longitude>" + Format.d((double)stn.getLocation().getLongitude(), (int)6) + "</longitude>");
            if (!Double.isNaN(stn.getLocation().getElevation())) {
                this.pw.println("      <elevation>" + Format.d((double)stn.getLocation().getElevation(), (int)6) + "</elevation>");
            }
            this.pw.println("   </station>");
        }
    }

    public void outputData(String fileName, PrintWriter pw) {
    }

    public void setPW(PrintWriter pw) {
        this.pw = pw;
    }

    static {
        radarStations = "RadarNexradStations.xml";
    }

    protected class CompareKeyDescend
    implements Comparator {
        protected CompareKeyDescend() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s2.compareTo(s1);
        }
    }
}

