/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import thredds.catalog.XMLEntityResolver;
import thredds.catalog.query.Station;
import thredds.datatype.DateRange;
import thredds.datatype.DateType;
import thredds.server.ncSubset.QueryParams;
import thredds.server.radarServer.RadarServer;
import thredds.server.radarServer.ServerMethods;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.util.Format;

public class RadarNexradServer {
    public static List<Station> stationList = null;
    public static HashMap<String, Station> stationMap;
    public static String radarStations;
    public static ArrayList<String> allVars;
    protected ServerMethods sm;
    private boolean debug = false;
    private PrintWriter pw = null;

    public RadarNexradServer() {
    }

    public RadarNexradServer(String contentPath) {
        this.sm = new ServerMethods();
        if (stationList == null) {
            stationList = this.sm.getStations(contentPath + this.getPath() + radarStations);
            stationMap = this.sm.getStationMap(stationList);
            allVars.add("DPA");
            allVars.add("DHR");
            allVars.add("N1P");
            allVars.add("N0R");
            allVars.add("N1R");
            allVars.add("N2R");
            allVars.add("N3R");
            allVars.add("N0S");
            allVars.add("N1S");
            allVars.add("N2S");
            allVars.add("N3S");
            allVars.add("N0V");
            allVars.add("N1V");
            allVars.add("N0Z");
            allVars.add("NCR");
            allVars.add("NET");
            allVars.add("NMD");
            allVars.add("NTP");
            allVars.add("NVL");
            allVars.add("NVW");
            allVars.add("BREF1");
            allVars.add("BREF2");
            allVars.add("BREF248");
            allVars.add("BREF3");
            allVars.add("BREF4");
            allVars.add("LREF1");
            allVars.add("LREF2");
            allVars.add("LREF3");
            allVars.add("CREF");
            allVars.add("BVEL1");
            allVars.add("BVEL2");
            allVars.add("VEL1");
            allVars.add("VEL2");
            allVars.add("VEL3");
            allVars.add("VEL4");
            allVars.add("LREF1");
            allVars.add("PRECIP1");
            allVars.add("PRECIPTOT");
            allVars.add("SRMV1");
            allVars.add("SRMV2");
            allVars.add("SRVEL1");
            allVars.add("SRVEL2");
            allVars.add("SRVEL3");
            allVars.add("SRVEL4");
            allVars.add("TOPS");
            allVars.add("VIL");
            allVars.add("PRE1");
            allVars.add("PRET");
            allVars.add("PREA");
            allVars.add("VAD");
        }
    }

    public Document stationsXML(Document doc, Element rootElem, String path) {
        String[] stations = this.stationsDS(RadarServer.dataLocation.get(path));
        if (path.contains("level3") && stations[0].length() == 4) {
            for (int i = 0; i < stations.length; ++i) {
                stations[i] = stations[i].substring(1);
            }
        }
        doc = this.makeStationDocument(doc, rootElem, stations);
        return doc;
    }

    protected String getPath() {
        return "servers/";
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("NetcdfSubsetServer");
        DebugHandler.Action act = new DebugHandler.Action("showRadarNexradFiles", "Show RadarNexrad Files"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println("RadarNexrad Files\n");
            }
        };
        debugHandler.addAction(act);
    }

    public void radarNexradQuery(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String serviceName = "OPENDAP";
        String serviceType = "OPENDAP";
        String serviceBase = "/thredds/dodsC/";
        String radarDir = null;
        try {
            boolean useAllStations;
            QueryParams qp;
            if (this.debug) {
                System.out.println(req.getQueryString());
            }
            this.sm.setPW(this.pw);
            String pathInfo = req.getPathInfo();
            if (pathInfo == null) {
                pathInfo = "";
            }
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            Boolean level2 = pathInfo.contains("level2");
            radarDir = RadarServer.dataLocation.get(pathInfo);
            if (radarDir == null) {
                radarDir = RadarServer.dataLocation.get("nexrad/level2/IDD");
            }
            if (!(qp = new QueryParams()).parseQuery(req, res, new String[]{"application/xml", "text/csv", "text/plain", "application/x-netcdf"})) {
                return;
            }
            if (qp.hasBB) {
                qp.stns = this.sm.getStationNames(qp.getBB(), stationList);
                if (!level2.booleanValue()) {
                    qp.stns = this.sm.convert4to3stations(qp.stns);
                }
                if (qp.stns.size() == 0) {
                    qp.errs.append("<documentation>ERROR: Bounding Box contains no stations</documentation>\n");
                    qp.writeErr(res, qp.errs.toString(), 400);
                    return;
                }
            }
            if (qp.hasStns && this.sm.isStationListEmpty(qp.stns, stationMap)) {
                qp.errs.append("<documentation>ERROR: No valid stations specified</documentation>\n");
                qp.writeErr(res, qp.errs.toString(), 400);
                return;
            }
            if (qp.hasLatlonPoint) {
                qp.stns = new ArrayList<String>();
                qp.stns.add(this.sm.findClosestStation(qp.lat, qp.lon, stationList));
                if (!level2.booleanValue()) {
                    qp.stns = this.sm.convert4to3stations(qp.stns);
                }
            } else if (qp.fatal) {
                qp.errs.append("<documentation>ERROR: No valid stations specified</documentation>\n");
                qp.writeErr(res, qp.errs.toString(), 400);
                return;
            }
            if (useAllStations = qp.stns.get(0).toUpperCase().equals("ALL")) {
                qp.stns = this.sm.getStationNames(stationList);
                if (!level2.booleanValue()) {
                    qp.stns = this.sm.convert4to3stations(qp.stns);
                }
            }
            boolean latest = false;
            if (qp.hasTimePoint) {
                if (qp.time.isPresent()) {
                    latest = true;
                    try {
                        qp.time_end = new DateType("present", null, null);
                        qp.time_start = new DateType("1970-01-01T00:00:00", null, null);
                    }
                    catch (ParseException e) {
                        qp.errs.append("Illegal param= 'time' must be valid ISO Duration\n");
                    }
                } else {
                    qp.time_end = qp.time;
                    qp.time_start = qp.time;
                }
            } else if (qp.hasDateRange) {
                DateRange dr = qp.getDateRange();
                qp.time_start = dr.getStart();
                qp.time_end = dr.getEnd();
            } else {
                try {
                    qp.time_end = new DateType("present", null, null);
                    qp.time_start = new DateType("1970-01-01T00:00:00", null, null);
                }
                catch (ParseException e) {
                    qp.errs.append("Illegal param= 'time' must be valid ISO Duration\n");
                }
            }
            String accept = ServletUtil.getParameterIgnoreCase(req, "accept");
            if (accept == null) {
                accept = "xml";
            }
            if (ServerMethods.p_html_i.matcher(accept).find()) {
                res.setContentType("text/html");
            }
            serviceBase = serviceBase + pathInfo + "/";
            if (serviceType.equals("OPENDAP")) {
                int level = 2;
                if (!level2.booleanValue()) {
                    level = 3;
                }
                this.pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.pw.print("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"");
                this.pw.println(" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"Radar Level" + level + " datasets in near real time\" version=\"" + "1.0.1\">");
                this.pw.println("");
                this.pw.print("  <service name=\"" + serviceName + "\" serviceType=\"" + serviceType + "\"");
                this.pw.println(" base=\"" + serviceBase + "\"/>");
                this.pw.print("    <dataset name=\"RadarLevel" + level + " datasets for available stations and times\" collectionType=\"TimeSeries\" ID=\"" + "accept=" + accept + "&amp;");
                if (!level2.booleanValue() && qp.vars != null) {
                    this.pw.print("var=");
                    for (int i = 0; i < qp.vars.size(); ++i) {
                        this.pw.print(qp.vars.get(i));
                        if (i >= qp.vars.size() - 1) continue;
                        this.pw.print(",");
                    }
                    this.pw.print("&amp;");
                }
                if (useAllStations) {
                    this.pw.print("stn=ALL&amp;");
                } else if (qp.hasStns && !this.sm.isStationListEmpty(qp.stns, stationMap)) {
                    for (String station : qp.stns) {
                        this.pw.print("stn=" + station + "&amp;");
                    }
                } else if (qp.hasBB) {
                    this.pw.print("south=" + qp.south + "&amp;north=" + qp.north + "&amp;");
                    this.pw.print("west=" + qp.west + "&amp;east=" + qp.east + "&amp;");
                }
                if (qp.hasDateRange) {
                    this.pw.println("time_start=" + qp.time_start.toDateTimeStringISO() + "&amp;time_end=" + qp.time_end.toDateTimeStringISO() + "\">");
                } else if (latest) {
                    this.pw.println("time=present\">");
                } else if (qp.hasTimePoint) {
                    this.pw.println("time=" + qp.time.toDateTimeStringISO() + "\">");
                } else {
                    this.pw.println("\">");
                }
                this.pw.println("    <metadata inherited=\"true\">");
                this.pw.println("      <dataType>Radial</dataType>");
                this.pw.print("      <dataFormat>");
                if (level2.booleanValue()) {
                    this.pw.print("NEXRAD2");
                } else {
                    this.pw.print("NIDS");
                }
                this.pw.println("</dataFormat>");
                this.pw.println("      <serviceName>" + serviceName + "</serviceName>");
                this.pw.println("    </metadata>");
                this.pw.println();
            } else if (ServerMethods.p_html_i.matcher(accept).find()) {
                this.pw.println("<Head><Title>THREDDS RadarNexrad Server</Title></Head>");
                this.pw.println("<body bgcolor=\"lightblue\" link=\"red\" alink=\"red\" vlink=\"red\">");
                this.pw.println("<center><H1>RadarNexrad Selection Results</H1></center>");
            } else if (!ServerMethods.p_ascii_i.matcher(accept).find() && ServerMethods.p_xml_i.matcher(accept).find()) {
                this.pw.println("<reports>");
            }
            if (this.sm.isStationListEmpty(qp.stns, stationMap)) {
                this.pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                this.pw.println("    </dataset>");
                this.pw.println("</catalog>");
                return;
            }
            boolean dataFound = this.processQuery(radarDir, qp);
            if (ServerMethods.p_xml_i.matcher(accept).find()) {
                if (!dataFound) {
                    this.pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                }
                this.pw.println("    </dataset>");
                this.pw.println("</catalog>");
            } else if (ServerMethods.p_html_i.matcher(accept).find()) {
                this.pw.println("</html>");
            }
        }
        catch (Throwable t) {
            ServletUtil.handleException(t, res);
        }
        ServletUtil.logServerAccess(200, -1L);
    }

    protected Boolean processQuery(String tdir, QueryParams qp) {
        String yyyymmddStart = qp.time_start.toDateString();
        yyyymmddStart = yyyymmddStart.replace("-", "");
        String yyyymmddEnd = qp.time_end.toDateString();
        yyyymmddEnd = yyyymmddEnd.replace("-", "");
        String dateStart = yyyymmddStart + "_" + this.sm.hhmm(qp.time_start.toDateTimeString());
        String dateEnd = yyyymmddEnd + "_" + this.sm.hhmm(qp.time_end.toDateTimeString());
        Boolean dataFound = false;
        try {
            File files = new File(tdir);
            String[] tdirs = files.list();
            if (tdirs == null) {
                return false;
            }
            Boolean isStns = false;
            isStns = tdirs[0].length() == 3 ? Boolean.valueOf(stationMap.get("K" + tdirs[0]) != null) : Boolean.valueOf(stationMap.get(tdirs[0]) != null);
            Boolean isDates = ServerMethods.p_yyyymmdd.matcher(tdirs[0]).find();
            Boolean isVars = allVars.contains(tdirs[0].toUpperCase());
            if (!(isStns.booleanValue() || isDates.booleanValue() || isVars.booleanValue())) {
                return false;
            }
            if (isStns.booleanValue()) {
                block2: for (String station : qp.stns) {
                    String sDir = tdir + '/' + station;
                    files = new File(sDir);
                    String[] sdirs = files.list();
                    if (sdirs == null) continue;
                    File file = new File(sDir + "/" + sdirs[0]);
                    if (file.isFile()) {
                        dataFound = sdirs.length > 0;
                        this.processProducts(sdirs, sDir.replaceFirst(tdir, "").substring(1), qp.hasTimePoint, dateStart, dateEnd);
                        continue;
                    }
                    if (ServerMethods.p_yyyymmdd.matcher(sdirs[0]).find()) {
                        Arrays.sort(sdirs, new CompareKeyDescend());
                        for (int j = 0; j < sdirs.length; ++j) {
                            if (!this.sm.isValidDay(sdirs[j], yyyymmddStart, yyyymmddEnd)) continue;
                            String dDir = sDir + "/" + sdirs[j];
                            files = new File(dDir);
                            String[] ndirs = files.list();
                            file = new File(dDir + "/" + ndirs[0]);
                            if (file.isFile()) {
                                dataFound = ndirs.length > 0;
                                this.processProducts(ndirs, dDir.replaceFirst(tdir, "").substring(1), qp.hasTimePoint, dateStart, dateEnd);
                                if (!qp.hasTimePoint) continue;
                                continue block2;
                            }
                            if (!allVars.contains(ndirs[0].toUpperCase())) continue;
                        }
                        continue;
                    }
                    if (!allVars.contains(sdirs[0].toUpperCase())) continue;
                    if (qp.vars == null) {
                        return false;
                    }
                    for (String variable : qp.vars) {
                        String vDir = sDir + '/' + variable;
                        files = new File(vDir);
                        String[] vdirs = files.list();
                        file = new File(vDir + "/" + vdirs[0]);
                        if (!file.isFile()) continue;
                        dataFound = vdirs.length > 0;
                        this.processProducts(vdirs, vDir.replaceFirst(tdir, "").substring(1), qp.hasTimePoint, dateStart, dateEnd);
                    }
                }
            } else if (!isDates.booleanValue()) {
                if (isVars.booleanValue()) {
                    if (qp.vars == null) {
                        return false;
                    }
                    for (String variable : qp.vars) {
                        String vDir = tdir + '/' + variable;
                        files = new File(vDir);
                        String[] vdirs = files.list();
                        File file = new File(vDir + "/" + vdirs[0]);
                        if (file.isFile()) {
                            dataFound = vdirs.length > 0;
                            this.processProducts(vdirs, vDir.replaceFirst(tdir, "").substring(1), qp.hasTimePoint, dateStart, dateEnd);
                            continue;
                        }
                        if (stationMap.get("K" + vdirs[0]) == null) continue;
                        block6: for (String station : qp.stns) {
                            String sDir = vDir + '/' + station;
                            files = new File(sDir);
                            String[] sdirs = files.list();
                            if (sdirs == null) continue;
                            file = new File(sDir + "/" + sdirs[0]);
                            if (file.isFile()) {
                                dataFound = sdirs.length > 0;
                                this.processProducts(sdirs, sDir.replaceFirst(tdir, "").substring(1), qp.hasTimePoint, dateStart, dateEnd);
                                continue;
                            }
                            if (!ServerMethods.p_yyyymmdd.matcher(sdirs[0]).find()) continue;
                            Arrays.sort(sdirs, new CompareKeyDescend());
                            for (int k = 0; k < sdirs.length; ++k) {
                                if (!this.sm.isValidDay(sdirs[k], yyyymmddStart, yyyymmddEnd)) continue;
                                String dDir = sDir + "/" + sdirs[k];
                                files = new File(dDir);
                                String[] ddirs = files.list();
                                dataFound = ddirs.length > 0;
                                this.processProducts(ddirs, dDir.replaceFirst(tdir, "").substring(1), qp.hasTimePoint, dateStart, dateEnd);
                                if (qp.hasTimePoint) continue block6;
                            }
                        }
                    }
                } else {
                    return dataFound;
                }
            }
            return dataFound;
        }
        catch (Exception e) {
            this.pw.println("<documentation>\n");
            this.pw.println("Query can't be satisfied :" + qp.toString() + "\n");
            this.pw.println("</documentation>\n");
            return dataFound;
        }
    }

    protected void processProducts(String[] products, String rPath, Boolean latest, String dateStart, String dateEnd) {
        Arrays.sort(products, new CompareKeyDescend());
        for (int t = 0; t < products.length; ++t) {
            if (products[t].startsWith(".") || !this.sm.isValidDate(products[t], dateStart, dateEnd)) continue;
            this.datasetOut(products[t], rPath);
            if (latest.booleanValue()) break;
        }
    }

    public void datasetOut(String product, String rPath) {
        this.pw.println("      <dataset name=\"" + product + "\" ID=\"" + product.hashCode() + "\"");
        String pDate = this.sm.getObTimeISO(product);
        this.pw.print("        urlPath=\"");
        this.pw.println(rPath + "/" + product + "\">");
        this.pw.println("        <date type=\"start of ob\">" + pDate + "</date>");
        this.pw.println("      </dataset>");
    }

    public Document getDoc() throws IOException {
        Element root = new Element("RadarNexrad");
        Document doc = new Document(root);
        root.setAttribute("location", "/thredds/radarServer/nexrad/level2");
        Element LatLonBox = new Element("LatLonBox");
        LatLonBox.addContent((Content)new Element("north").addContent("75.0000"));
        LatLonBox.addContent((Content)new Element("south").addContent("19.0000"));
        LatLonBox.addContent((Content)new Element("east").addContent("-75.0000"));
        LatLonBox.addContent((Content)new Element("west").addContent("-175.0000"));
        root.addContent((Content)LatLonBox);
        Element timeSpan = new Element("TimeSpan");
        DateFormatter format = new DateFormatter();
        Calendar now = Calendar.getInstance();
        Date end = now.getTime();
        now.add(10, -120);
        Date startNow = now.getTime();
        timeSpan.addContent((Content)new Element("begin").addContent(format.toDateTimeStringISO(startNow)));
        timeSpan.addContent((Content)new Element("end").addContent("present"));
        root.addContent((Content)timeSpan);
        Element stnList = new Element("stationList");
        stnList.setAttribute("title", "Available Stations", XMLEntityResolver.xlinkNS);
        stnList.setAttribute("href", "/thredds/idd/radarNexrad/stations.xml", XMLEntityResolver.xlinkNS);
        root.addContent((Content)stnList);
        Element a = new Element("AcceptList");
        a.addContent((Content)new Element("accept").addContent("xml"));
        root.addContent((Content)a);
        return doc;
    }

    public Document makeStationDocument(Document doc, Element rootElem, String[] stations) {
        for (String s : stations) {
            Station stn = s.length() == 3 ? stationMap.get("K" + s) : stationMap.get(s);
            Element sElem = new Element("station");
            if (stn == null) {
                sElem.setAttribute("id", s);
                sElem.setAttribute("state", "XXX");
                sElem.setAttribute("country", "XX");
                sElem.addContent((Content)new Element("name").addContent("Unknown"));
                sElem.addContent((Content)new Element("longitude").addContent("0.0"));
                sElem.addContent((Content)new Element("latitude").addContent("0.0"));
                sElem.addContent((Content)new Element("elevation").addContent("0"));
                rootElem.addContent((Content)sElem);
                continue;
            }
            sElem.setAttribute("id", s);
            if (stn.getState() != null) {
                sElem.setAttribute("state", stn.getState());
            }
            if (stn.getCountry() != null) {
                sElem.setAttribute("country", stn.getCountry());
            }
            if (stn.getName() != null) {
                sElem.addContent((Content)new Element("name").addContent(stn.getName()));
            }
            sElem.addContent((Content)new Element("longitude").addContent(Format.d((double)stn.getLocation().getLongitude(), (int)6)));
            sElem.addContent((Content)new Element("latitude").addContent(Format.d((double)stn.getLocation().getLatitude(), (int)6)));
            if (!Double.isNaN(stn.getLocation().getElevation())) {
                sElem.addContent((Content)new Element("elevation").addContent(Format.d((double)stn.getLocation().getElevation(), (int)6)));
            }
            rootElem.addContent((Content)sElem);
        }
        return doc;
    }

    public String[] stationsDS(String path) {
        File files;
        String[] stations = null;
        if (path != null && (stations = (files = new File(path)).list())[0].length() == 3 && allVars.contains(stations[0].toUpperCase())) {
            path = path + "/" + stations[0];
            files = new File(path);
            stations = files.list();
        }
        if (stations == null || stations.length == 0) {
            stations = new String[1];
            stations = stationMap.keySet().toArray(stations);
        }
        return stations;
    }

    public void printStations(String[] stations) {
        for (String s : stations) {
            Station stn = s.length() == 3 ? stationMap.get("K" + s) : stationMap.get(s);
            if (stn == null) {
                this.pw.println("   <station id=\"" + s + "\" state=\"XX\" country=\"XX\">");
                this.pw.println("      <name>Unknown</name>");
                this.pw.println("      <latitude>0.0</latitude>");
                this.pw.println("      <longitude>0.0</longitude>");
                this.pw.println("      <elevation>0.0</elevation>");
                this.pw.println("   </station>");
                continue;
            }
            this.pw.println("   <station id=\"" + s + "\" state=\"" + stn.getState() + "\" country=\"" + stn.getCountry() + "\">");
            this.pw.println("      <name>" + stn.getName() + "</name>");
            this.pw.println("      <latitude>" + Format.d((double)stn.getLocation().getLatitude(), (int)6) + "</latitude>");
            this.pw.println("      <longitude>" + Format.d((double)stn.getLocation().getLongitude(), (int)6) + "</longitude>");
            if (!Double.isNaN(stn.getLocation().getElevation())) {
                this.pw.println("      <elevation>" + Format.d((double)stn.getLocation().getElevation(), (int)6) + "</elevation>");
            }
            this.pw.println("   </station>");
        }
    }

    public void setPW(PrintWriter pw) {
        this.pw = pw;
    }

    static {
        radarStations = "RadarNexradStations.xml";
        allVars = new ArrayList();
    }

    protected class CompareKeyDescend
    implements Comparator {
        protected CompareKeyDescend() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s2.compareTo(s1);
        }
    }
}

