/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.datatype.DateRange;
import thredds.server.radarServer.RadarNexradServer;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.StringUtil;

public class RadarServer
extends AbstractServlet {
    public static InvCatalogImpl cat = null;
    public static List datasets;
    public static final String catName = "radarCollections.xml";
    public static HashMap<String, String> dataLocation;
    private boolean allow = false;
    private RadarNexradServer rns = null;
    private boolean debug = false;

    protected long getLastModified(HttpServletRequest req) {
        this.contentPath = ServletUtil.getContentPath(this);
        File file = new File(this.contentPath + this.getPath() + catName);
        return file.lastModified();
    }

    protected String getPath() {
        return "servers/";
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("NetcdfSubsetServer");
        DebugHandler.Action act = new DebugHandler.Action("showRadar Files", "Show Radar Files"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println("Radar  Files\n");
                for (int j = 0; j < datasets.size(); ++j) {
                    InvDatasetScan ds = (InvDatasetScan)datasets.get(j);
                    e.pw.println(" " + ds);
                }
            }
        };
        debugHandler.addAction(act);
    }

    public void init() throws ServletException {
        super.init();
        this.contentPath = ServletUtil.getContentPath(this);
        this.rns = new RadarNexradServer(this.contentPath);
        if (cat != null) {
            return;
        }
        this.initCat();
        List parents = cat.getDatasets();
        for (int i = 0; i < parents.size(); ++i) {
            InvDataset top = (InvDataset)parents.get(i);
            datasets = top.getDatasets();
            for (int j = 0; j < datasets.size(); ++j) {
                InvDatasetScan ds = (InvDatasetScan)datasets.get(j);
                if (ds.getPath() != null) {
                    dataLocation.put(ds.getPath(), ds.getScanLocation());
                }
                ds.setXlinkHref(ds.getPath() + "/dataset.xml");
            }
        }
    }

    private void initCat() {
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
        cat = this.readCatalog(factory, this.getPath() + catName, this.contentPath + this.getPath() + catName);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block29: {
            try {
                ServletUtil.logServerAccessSetup(req);
                if (this.debug) {
                    System.out.println("<documentation>\n" + req.getQueryString() + "</documentation>\n");
                }
                PrintWriter pw = res.getWriter();
                if (this.rns == null) {
                    this.init();
                }
                this.rns.setPW(pw);
                res.setContentType("text/xml; charset=iso-8859-1");
                this.contentPath = ServletUtil.getContentPath(this);
                String pathInfo = req.getPathInfo();
                if (pathInfo == null) {
                    pathInfo = "";
                }
                if (pathInfo.startsWith("/catalog.xml")) {
                    if (cat == null) {
                        this.init();
                    }
                    InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
                    String catAsString = factory.writeXML(cat);
                    res.setStatus(200);
                    pw.println(catAsString);
                    return;
                }
                if (pathInfo.startsWith("/catalog.html")) {
                    res.setContentType("text/html; charset=iso-8859-1");
                    pw.println("<documentation>\n");
                    pw.println("Request not implemented: " + pathInfo + "\n");
                    pw.println("</documentation>\n");
                    return;
                }
                if (pathInfo.startsWith("/dataset.xml")) {
                    if (cat == null) {
                        this.init();
                    }
                    pw.println("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"THREDDS Radar Server\" version=\"1.0.1\">\n");
                    pw.println("  <service name=\"radarServer\" base=\"/thredds/radarServer/\" type=\"DQC\" />\n");
                    pw.println("  <dataset name=\"NEXRAD Radar Data\">");
                    for (int i = 0; i < datasets.size(); ++i) {
                        InvDatasetScan ds = (InvDatasetScan)datasets.get(i);
                        pw.println("    <dataset name=\"" + ds.getName() + "\" ID=\"" + ds.getID() + "\" datatype=\"radial\" urlpath=\"" + ds.getPath() + "/dataset.xml\" serviceName=\"radarServer\"/>");
                    }
                    pw.println("  </dataset>");
                    pw.println("</catalog>");
                    return;
                }
                if (pathInfo.startsWith("/nexrad")) {
                    if (pathInfo.endsWith("catalog.xml")) {
                        boolean all2 = pathInfo.equalsIgnoreCase("/nexrad/level2/catalog.xml");
                        boolean all3 = pathInfo.equalsIgnoreCase("/nexrad/level3/catalog.xml");
                        try {
                            Class<?> fac1 = Class.forName("thredds.catalog.parser.jdom.InvCatalogFactory10");
                            Object fac1o = fac1.newInstance();
                            InvCatalogFactory10 fac = (InvCatalogFactory10)fac1o;
                            Document doc = fac.writeCatalog(cat);
                            Element catalogElem = doc.getRootElement();
                            List allChildren = catalogElem.getChildren();
                            for (int j = 0; j < allChildren.size(); ++j) {
                                Element e = (Element)allChildren.get(j);
                                if (!e.getName().equals("dataset")) continue;
                                ArrayList<Content> delete = new ArrayList<Content>();
                                List contents = e.getContent();
                                for (Content c : contents) {
                                    if (all2 && c.getValue().contains("NEXRAD2") || all3 && c.getValue().contains("NIDS")) continue;
                                    delete.add(c);
                                }
                                for (Content c : delete) {
                                    e.removeContent(c);
                                }
                            }
                            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                            ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
                            fmt.output(doc, (OutputStream)os);
                            pw.println(os.toString());
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("InvCatalogFactory: no implementing class found: " + e.getMessage());
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException("InvCatalogFactory: instantition failed: " + e.getMessage());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("InvCatalogFactory: access failed: " + e.getMessage());
                        }
                        return;
                    }
                    if (pathInfo.endsWith("stations.xml")) {
                        pathInfo = pathInfo.replace("/stations.xml", "");
                        Element rootElem = new Element("stationsList");
                        Document doc = new Document(rootElem);
                        doc = this.rns.stationsXML(doc, rootElem, pathInfo.substring(1));
                        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                        pw.println(fmt.outputString(doc));
                        return;
                    }
                    if (pathInfo.endsWith("dataset.xml")) {
                        pw.println("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"Radar Data\" version=\"1.0.1\">\n");
                        pw.println("  <service name=\"radarServer\" base=\"/thredds/radarServer/\" type=\"DQC\" />\n");
                        boolean all2 = pathInfo.equalsIgnoreCase("/nexrad/level2/dataset.xml");
                        boolean all3 = pathInfo.equalsIgnoreCase("/nexrad/level3/dataset.xml");
                        pathInfo = pathInfo.replace("/dataset.xml", "");
                        if (pathInfo.startsWith("/")) {
                            pathInfo = pathInfo.substring(1);
                        }
                        for (int i = 0; i < datasets.size(); ++i) {
                            InvDatasetScan ds = (InvDatasetScan)datasets.get(i);
                            if (all2 || all3) {
                                if ((!all2 || !ds.getPath().contains("level2")) && (!all3 || !ds.getPath().contains("level3"))) continue;
                            } else if (!pathInfo.equals(ds.getPath())) continue;
                            pw.println("  <dataset ID=\"" + ds.getID() + "\" datatype=\"radialCollection\" urlpath=\"" + ds.getPath() + "\" serviceName=\"radarServer\">");
                            pw.println("    <dataType>" + ds.getDataType() + "</dataType>");
                            pw.println("    <dataFormat>" + ds.getDataFormatType() + "</dataFormat>");
                            pw.println("   <serviceName>radarServer</serviceName>");
                            pw.println("    <metadata inherited=\"true\">");
                            pw.println("    <documentation type=\"summary\">" + ds.getSummary() + "</documentation>");
                            DateRange dr = ds.getTimeCoverage();
                            pw.println("      <TimeSpan>");
                            pw.println("        <start>" + dr.getStart().toDateTimeStringISO() + "</start>");
                            pw.println("        <end>" + dr.getEnd().toDateTimeStringISO() + "</end>");
                            pw.println("      </TimeSpan>");
                            ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
                            LatLonRect bb = new LatLonRect();
                            gc.setBoundingBox(bb);
                            pw.println("      <LatLonBox>");
                            pw.println("        <north>" + gc.getLatNorth() + "</north>");
                            pw.println("        <south>" + gc.getLatSouth() + "</south>");
                            pw.println("        <east>" + gc.getLonEast() + "</east>");
                            pw.println("        <west>" + gc.getLonWest() + "</west>");
                            pw.println("      </LatLonBox>");
                            ThreddsMetadata.Variables cvs = (ThreddsMetadata.Variables)ds.getVariables().get(0);
                            List vl = cvs.getVariableList();
                            pw.println("      <Variables>");
                            for (int j = 0; j < vl.size(); ++j) {
                                ThreddsMetadata.Variable v = (ThreddsMetadata.Variable)vl.get(j);
                                pw.println("        <variable name=\"" + v.getName() + "\" vocabulary_name=\"" + v.getVocabularyName() + "\" units=\"" + v.getUnits() + "\" />");
                            }
                            pw.println("      </Variables>");
                            String[] stations = this.rns.stationsDS(dataLocation.get(ds.getPath()));
                            this.rns.printStations(stations);
                            pw.println("    </metadata>");
                            pw.println("  </dataset>");
                        }
                        pw.println("</catalog>");
                        return;
                    }
                    if (req.getQueryString() != null) {
                        this.rns.radarNexradQuery(req, res);
                    } else {
                        pw.println("<documentation>\n");
                        pw.println("No Query given: " + pathInfo + "\n");
                        pw.println("</documentation>\n");
                    }
                    break block29;
                }
                pw.println("<documentation>\n");
                pw.println("Request not implemented: " + pathInfo + "\n");
                pw.println("</documentation>\n");
            }
            catch (Throwable t) {
                ServletUtil.handleException(t, res);
            }
        }
        ServletUtil.logServerAccess(200, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvCatalogImpl readCatalog(InvCatalogFactory factory, String path, String catalogFullPath) {
        InvCatalogImpl acat;
        URI uri;
        try {
            uri = new URI("file:" + StringUtil.escape((String)catalogFullPath, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            this.log.error("readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        this.log.debug("readCatalog(): full path=" + catalogFullPath + "; path=" + path);
        FileInputStream ios = null;
        try {
            ios = new FileInputStream(catalogFullPath);
            acat = factory.readXML((InputStream)ios, uri);
        }
        catch (Throwable t) {
            this.log.error("readCatalog(): Exception on catalog=" + catalogFullPath + " " + t.getMessage() + "\n log=" + cat.getLog(), t);
            InvCatalogImpl invCatalogImpl = null;
            return invCatalogImpl;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    this.log.error("readCatalog(): error closing" + catalogFullPath);
                }
            }
        }
        return acat;
    }

    static {
        dataLocation = new HashMap();
    }
}

