/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;

public abstract class AbstractServlet
extends HttpServlet {
    protected Logger log;
    protected String rootPath;
    protected String contentPath;

    protected abstract String getPath();

    protected abstract void makeDebugActions();

    public void init() throws ServletException {
        ServletUtil.setContextPath(this);
        ServletUtil.initDebugging(this);
        this.rootPath = ServletUtil.getRootPath(this);
        this.contentPath = ServletUtil.getContentPath(this) + this.getPath();
        ServletUtil.initLogging(this);
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        ServletUtil.logServerSetup(((Object)((Object)this)).getClass().getName() + ".init()");
        this.makeDebugActions();
        this.log.info("--- initialized " + ((Object)((Object)this)).getClass().getName());
    }

    protected void initContent() throws ServletException {
        String initialContentPath = ServletUtil.getInitialContentPath(this) + this.getPath();
        File initialContentFile = new File(initialContentPath);
        if (initialContentFile.exists()) {
            try {
                if (ServletUtil.copyDir(initialContentPath, this.contentPath)) {
                    this.log.info("copyDir " + initialContentPath + " to " + this.contentPath);
                }
            }
            catch (IOException ioe) {
                this.log.error("failed to copyDir " + initialContentPath + " to " + this.contentPath, (Throwable)ioe);
            }
        }
    }
}

