/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.servlet.DataRootHandler;
import thredds.servlet.Debug;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import thredds.servlet.ViewServlet;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class CatalogServicesServlet
extends HttpServlet {
    protected static Logger log;

    public void init() {
        ServletUtil.initLogging(this);
        log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        ServletUtil.logServerSetup(((Object)((Object)this)).getClass().getName() + ".init()");
        log.info("--- initialized " + ((Object)((Object)this)).getClass().getName());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        try {
            URI catURI;
            if (Debug.isSet("showRequest")) {
                System.out.println("**CatalogServices req=" + ServletUtil.getRequest(req));
            }
            if (Debug.isSet("showRequestDetail")) {
                System.out.println("**CatalogServices req=" + ServletUtil.showRequestDetail(this, req));
            }
            String htmlService = ServletUtil.getRequestBase(req);
            URI reqURI = new URI(htmlService);
            String targetCatalog = req.getParameter("catalog");
            boolean isLocalCat = false;
            InvCatalogImpl catalog = null;
            if (targetCatalog == null || targetCatalog.length() == 0) {
                isLocalCat = true;
                catURI = reqURI.resolve("catalog.xml");
                catalog = (InvCatalogImpl)DataRootHandler.getInstance().getCatalog("catalog.xml", catURI);
            } else {
                String path;
                String host;
                if (targetCatalog.endsWith("/")) {
                    targetCatalog = targetCatalog + "catalog.xml";
                } else if (targetCatalog.endsWith(".html")) {
                    int len = targetCatalog.length();
                    targetCatalog = targetCatalog.substring(0, len - 4) + "xml";
                }
                URI targetUri = new URI(targetCatalog);
                catURI = reqURI.resolve(targetUri);
                String scheme = catURI.getScheme();
                if (scheme != null && scheme.equalsIgnoreCase(reqURI.getScheme()) && (host = catURI.getHost()) != null && host.equalsIgnoreCase(reqURI.getHost()) && catURI.getPort() == reqURI.getPort() && (path = catURI.getPath()) != null && path.startsWith(req.getContextPath())) {
                    isLocalCat = true;
                    String catPath = path.substring(req.getContextPath().length() + 1);
                    if (catPath.startsWith("catalog/")) {
                        catPath = catPath.substring("catalog/".length());
                    }
                    catalog = (InvCatalogImpl)DataRootHandler.getInstance().getCatalog(catPath, catURI);
                }
            }
            if (catalog == null) {
                InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)true);
                try {
                    catalog = catFactory.readXML(catURI);
                }
                catch (Throwable t) {
                    res.sendError(400, t.getMessage());
                    return;
                }
            }
            boolean isHtmlReq = req.getServletPath().endsWith(".html");
            CatalogServicesServlet.handleCatalogServiceRequest(catalog, catURI, isHtmlReq, isLocalCat, req, res);
        }
        catch (Throwable t) {
            log.error("doGet req= " + ServletUtil.getRequest(req) + " got Exception", t);
            ServletUtil.handleException(t, res);
        }
    }

    public static void handleCatalogServiceRequest(InvCatalogImpl catalog, URI catURI, boolean isHtmlReq, boolean isLocalCat, HttpServletRequest req, HttpServletResponse res) throws IOException {
        StringBuffer validateMess = new StringBuffer();
        boolean debug = "true".equals(req.getParameter("debug"));
        catalog.check(validateMess, debug);
        boolean isFatal = catalog.hasFatalError();
        if (isFatal) {
            res.setHeader("Validate", "FAIL");
            CatalogServicesServlet.sendValidationError(catURI.toString(), validateMess.toString(), res, 404);
            return;
        }
        res.setHeader("Validate", "OK");
        String cmd = req.getParameter("cmd");
        String datasetID = req.getParameter("dataset");
        if (cmd == null) {
            String string = cmd = datasetID == null ? "show" : "subset";
        }
        if (cmd.equals("show")) {
            HtmlWriter.getInstance().writeCatalog(res, catalog, isLocalCat);
            return;
        }
        if (cmd.equals("validate")) {
            CatalogServicesServlet.sendMesssage(catURI.toString(), validateMess.toString(), res, 200);
            return;
        }
        if (cmd.equals("convert")) {
            CatalogServicesServlet.doConvert(catalog, res);
            ServletUtil.logServerAccess(200, -1L);
            return;
        }
        if (cmd.equals("subset")) {
            if (datasetID == null) {
                res.sendError(400, "Must have a dataset parameter");
                ServletUtil.logServerAccess(400, -1L);
                return;
            }
            InvDataset dataset = catalog.findDatasetByID(datasetID);
            if (dataset == null) {
                log.warn("Cant find dataset=" + datasetID + " in catalog=" + catURI);
                ServletUtil.logServerAccess(400, -1L);
                res.sendError(400, "Cant find dataset=" + datasetID);
                return;
            }
            if (isHtmlReq) {
                CatalogServicesServlet.showDataset(catURI.toString(), (InvDatasetImpl)dataset, req, res);
            } else {
                catalog.subset(dataset);
                InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
                String result = catFactory.writeXML(catalog);
                ServletUtil.logServerAccess(200, result.length());
                res.setContentLength(result.length());
                res.setContentType("text/xml");
                res.getOutputStream().write(result.getBytes());
            }
            return;
        }
        ServletUtil.logServerAccess(400, -1L);
        res.sendError(400, "Unknown command=" + cmd);
    }

    private static void doConvert(InvCatalogImpl catalog, HttpServletResponse res) {
        catalog.setCatalogConverterToVersion1();
        try {
            ServletOutputStream os = res.getOutputStream();
            res.setContentType("text/xml");
            res.setStatus(200);
            catalog.writeXML((OutputStream)os);
            os.flush();
        }
        catch (IOException ioe) {
            ServletUtil.handleException(ioe, res);
        }
    }

    private static void sendMesssage(String catURL, String mess, HttpServletResponse res, int status) throws IOException {
        res.setStatus(status);
        res.setContentType("text/html");
        StringBuffer sb = new StringBuffer(10000);
        sb.append(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<title> Catalog Services</title>\r\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html\">\r\n");
        sb.append(HtmlWriter.getInstance().getUserCSS());
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append(HtmlWriter.getInstance().getUserHead());
        sb.append("<h2> Catalog " + catURL + " :</h2>\r\n");
        sb.append("<b>\r\n");
        sb.append(StringUtil.quoteHtmlContent((String)mess));
        sb.append("</b>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
        pw.write(sb.toString());
        pw.flush();
        ServletUtil.logServerAccess(status, sb.length());
    }

    private static void sendValidationError(String catURL, String mess, HttpServletResponse res, int status) throws IOException {
        res.setStatus(status);
        res.setContentType("text/html");
        StringBuffer sb = new StringBuffer(10000);
        sb.append(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<title> Catalog Services</title>\r\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html\">\r\n");
        sb.append(HtmlWriter.getInstance().getUserCSS());
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append(HtmlWriter.getInstance().getUserHead());
        sb.append("<h2> Catalog " + catURL + " has fatal errors:</h2>\r\n");
        sb.append("<b>\r\n");
        sb.append(StringUtil.quoteHtmlContent((String)mess));
        sb.append("</b>\r\n");
        sb.append("<hr><pre>\r\n");
        String catString = IO.readURLcontents((String)catURL);
        sb.append(StringUtil.quoteHtmlContent((String)catString) + "\r\n");
        sb.append("</pre>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
        pw.write(sb.toString());
        pw.flush();
        ServletUtil.logServerAccess(status, sb.length());
    }

    private static void showDataset(String catURL, InvDatasetImpl dataset, HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setContentType("text/html");
        StringBuffer sb = new StringBuffer(10000);
        sb.append(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<title> Catalog Services</title>\r\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html\">\r\n");
        sb.append(HtmlWriter.getInstance().getUserCSS());
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append(HtmlWriter.getInstance().getUserHead());
        sb.append("<h2> Catalog " + catURL + "</h2>\r\n");
        InvDatasetImpl.writeHtmlDescription((StringBuffer)sb, (InvDatasetImpl)dataset, (boolean)false, (boolean)true, (boolean)false, (boolean)false);
        ViewServlet.showViewers(sb, dataset, req);
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
        pw.write(sb.toString());
        pw.flush();
        ServletUtil.logServerAccess(200, sb.length());
    }
}

