/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.MDC;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import thredds.servlet.AbstractServlet;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.util.StringUtil;

public class CoordSysValidatorServlet
extends AbstractServlet {
    private DiskCache2 cdmValidateCache = null;
    private DiskFileItemFactory factory;
    private File cacheDir;
    private long maxFileUploadSize;
    boolean allow = false;
    boolean deleteImmediately = true;

    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("CdmValidatorService.allow", false);
        this.maxFileUploadSize = ThreddsConfig.getBytes("CdmValidatorService.maxFileUploadSize", 1000000000L);
        String cache = ThreddsConfig.get("CdmValidatorService.dir", this.contentPath);
        int scourSecs = ThreddsConfig.getSeconds("CdmValidatorService.scour", -1);
        int maxAgeSecs = ThreddsConfig.getSeconds("CdmValidatorService.maxAge", -1);
        if (maxAgeSecs > 0) {
            this.deleteImmediately = false;
            this.cdmValidateCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
        }
        this.cacheDir = new File(cache);
        this.cacheDir.mkdirs();
        this.factory = new DiskFileItemFactory(0, this.cacheDir);
    }

    public void destroy() {
        if (this.cdmValidateCache != null) {
            this.cdmValidateCache.exit();
        }
        super.destroy();
    }

    protected String getPath() {
        return "cdmValidate/";
    }

    protected void makeDebugActions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        ServletUtil.logServerAccessSetup(req);
        String urlString = req.getParameter("URL");
        if (urlString == null) {
            ServletUtil.logServerAccess(400, 0L);
            res.sendError(400, "Must have a URL parameter");
            return;
        }
        try {
            URI uri = new URI(urlString);
            urlString = uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            ServletUtil.logServerAccess(400, 0L);
            res.sendError(400, "URISyntaxException on URU parameter");
            return;
        }
        String xml = req.getParameter("xml");
        boolean wantXml = xml != null && xml.equals("true");
        NetcdfDataset ncd = null;
        try {
            try {
                ncd = NetcdfDataset.openDataset((String)urlString, (boolean)true, null);
            }
            catch (IOException e) {
                ServletUtil.logServerAccess(400, 0L);
                res.sendError(400, e.getMessage());
                if (null != ncd) {
                    try {
                        ncd.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed to close = " + urlString);
                    }
                }
                return;
            }
            try {
                int len = this.showValidatorResults(res, ncd, wantXml);
                this.log.info("URL = " + urlString);
                ServletUtil.logServerAccess(200, len);
            }
            catch (Exception e) {
                this.log.error("Validator internal error", (Throwable)e);
                ServletUtil.logServerAccess(500, 0L);
                res.sendError(500, "Validator internal error");
            }
        }
        finally {
            if (null != ncd) {
                try {
                    ncd.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + urlString);
                }
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        List fileItems;
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        ServletUtil.logServerAccessSetup(req);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if (!isMultipart) {
            ServletUtil.logServerAccess(400, 0L);
            res.sendError(400);
            return;
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)this.factory);
        upload.setSizeMax(this.maxFileUploadSize);
        try {
            fileItems = upload.parseRequest(req);
        }
        catch (FileUploadException e) {
            this.log.info("Validator FileUploadException", (Throwable)e);
            ServletUtil.logServerAccess(400, 0L);
            res.sendError(400);
            return;
        }
        String username = null;
        boolean wantXml = false;
        for (FileItem item : fileItems) {
            if (!item.isFormField()) continue;
            if ("username".equals(item.getFieldName())) {
                username = item.getString();
            }
            if (!"xml".equals(item.getFieldName())) continue;
            wantXml = item.getString().equals("true");
        }
        for (FileItem item : fileItems) {
            if (item.isFormField()) continue;
            try {
                this.processUploadedFile(req, res, (DiskFileItem)item, username, wantXml);
                return;
            }
            catch (Exception e) {
                this.log.info("Validator processUploadedFile", (Throwable)e);
                ServletUtil.logServerAccess(400, 0L);
                res.sendError(400, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUploadedFile(HttpServletRequest req, HttpServletResponse res, DiskFileItem item, String username, boolean wantXml) throws Exception {
        if (username == null || username.length() == 0) {
            username = "none";
        }
        username = StringUtil.filter((String)username, (String)"_");
        String filename = item.getName();
        filename = StringUtil.replace((String)filename, (String)"/", (String)"-");
        filename = StringUtil.filter((String)filename, (String)".-_");
        File uploadedFile = new File(this.cacheDir + "/" + username + "/" + filename);
        uploadedFile.getParentFile().mkdirs();
        item.write(uploadedFile);
        NetcdfDataset ncd = null;
        int len = -1;
        try {
            ncd = NetcdfDataset.openDataset((String)uploadedFile.getPath());
            ncd.setLocation(filename);
            len = this.showValidatorResults(res, ncd, wantXml);
        }
        finally {
            if (null != ncd) {
                try {
                    ncd.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + uploadedFile.getPath());
                }
            }
        }
        if (this.deleteImmediately) {
            try {
                uploadedFile.delete();
            }
            catch (Exception e) {
                this.log.error("Uploaded File = " + uploadedFile.getPath() + " delete failed = " + e.getMessage());
            }
        }
        if (req.getRemoteUser() == null && username != null) {
            MDC.put((String)"userid", (Object)username);
        }
        this.log.info("Uploaded File = " + item.getName() + " sent to " + uploadedFile.getPath() + " size= " + uploadedFile.length());
        ServletUtil.logServerAccess(200, len);
    }

    private int showValidatorResults(HttpServletResponse res, NetcdfDataset ncd, boolean wantXml) throws Exception {
        String infoString;
        NetcdfDatasetInfo info = ncd.getInfo();
        if (wantXml) {
            infoString = info.writeXML();
            res.setContentLength(infoString.length());
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            Document xml = info.makeDocument();
            InputStream is = this.getXSLT();
            XSLTransformer transformer = new XSLTransformer(is);
            Document html = transformer.transform(xml);
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            infoString = fmt.outputString(html);
            res.setContentType("text/html; charset=iso-8859-1");
        }
        res.setContentLength(infoString.length());
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes());
        out.flush();
        return infoString.length();
    }

    private InputStream getXSLT() {
        Class<CoordSysValidatorServlet> c = CoordSysValidatorServlet.class;
        String resource = "/resources/xsl/cdmValidation.xsl";
        InputStream is = c.getResourceAsStream(resource);
        if (null == is) {
            this.log.error("Cant load XSLT resource = " + resource);
        }
        return is;
    }
}

