/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.dl.ADNWriter;
import thredds.catalog.dl.DIFWriter;
import thredds.servlet.AbstractServlet;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class DLwriterServlet
extends AbstractServlet {
    private String adnDir;
    private String difDir;

    public void init() throws ServletException {
        super.init();
        this.adnDir = this.contentPath + "/adn/";
        this.difDir = this.contentPath + "/dif/";
        File file = new File(this.adnDir);
        file.mkdirs();
        file = new File(this.difDir);
        file.mkdirs();
    }

    protected String getPath() {
        return "DLwriter/";
    }

    protected void makeDebugActions() {
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        try {
            String type = req.getParameter("type");
            String catURL = req.getParameter("catalog");
            if (catURL == null || catURL.length() == 0) {
                catURL = "/thredds/idd/models.xml";
            }
            this.doit(req, res, catURL, type.equals("DIF"));
        }
        catch (Throwable t) {
            this.log.error("doGet req= " + ServletUtil.getRequest(req) + " got Exception", t);
            ServletUtil.handleException(t, res);
        }
    }

    private void doit(HttpServletRequest req, HttpServletResponse res, String catURL, boolean isDIF) throws IOException, URISyntaxException {
        DIFWriter writer;
        InvCatalogImpl catalog;
        String reqBase = ServletUtil.getRequestBase(req);
        URI reqURI = new URI(reqBase);
        URI catURI = reqURI.resolve(catURL);
        catURL = catURI.toString();
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
        try {
            catalog = catFactory.readXML(catURI);
        }
        catch (Exception e) {
            ServletUtil.handleException(e, res);
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (!catalog.check(sb, false)) {
            ServletUtil.logServerAccess(400, -1L);
            res.setContentType("text/html");
            res.setHeader("Validate", "FAIL");
            PrintWriter pw = new PrintWriter((OutputStream)res.getOutputStream());
            this.showValidationMesssage(catURL, sb.toString(), pw);
            pw.flush();
            return;
        }
        StringBuffer mess = new StringBuffer();
        mess.append("Catalog " + catURL + "\n\n");
        if (isDIF) {
            mess.append("DIF records:\n");
            writer = new DIFWriter();
            writer.writeDatasetEntries(catalog, this.difDir, mess);
        } else {
            mess.append("ADN records:\n");
            writer = new ADNWriter();
            mess.setLength(0);
            writer.writeDatasetEntries(catalog, this.adnDir, mess);
        }
        res.setContentType("text/plain");
        ServletOutputStream out = res.getOutputStream();
        out.write(mess.toString().getBytes());
        out.flush();
        ServletUtil.logServerAccess(200, mess.length());
    }

    private void showValidationMesssage(String catURL, String mess, PrintWriter pw) {
        pw.println(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        pw.println("<head>");
        pw.println("<title> Catalog Validation</title>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html\">");
        pw.println("</head>");
        pw.println("<body bgcolor=\"#FFF0FF\">");
        pw.println("<h2> Catalog " + catURL + " has validation errors:</h2>");
        pw.println("<b>");
        pw.println(StringUtil.quoteHtmlContent((String)mess));
        pw.println("</b>");
        pw.println("<hr><pre>");
        String catString = IO.readURLcontents((String)catURL);
        pw.println(StringUtil.quoteHtmlContent((String)catString));
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }
}

