/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFmrc;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetDods;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.datatype.DateType;
import thredds.servlet.CatalogServicesServlet;
import thredds.servlet.DataServiceProvider;
import thredds.servlet.DatasetHandler;
import thredds.servlet.DebugHandler;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import thredds.util.PathMatcher;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRootHandler {
    private static DataRootHandler singleton = null;
    private static Logger log = LoggerFactory.getLogger(DataRootHandler.class);
    private final String contentPath;
    private final String servletContextPath;
    private HashMap<String, InvCatalogImpl> staticCatalogHash;
    private HashSet<String> idHash = new HashSet();
    private volatile PathMatcher pathMatcher = new PathMatcher();
    private List<ConfigListener> configListeners = new ArrayList<ConfigListener>();
    volatile boolean isReinit = false;

    public static void init(String contentPath, String servletContextPath) {
        if (singleton != null) {
            log.warn("init(): Singleton already initialized: ignored call -- init(\"" + contentPath + "\",\"" + servletContextPath + "\"); successful call -- init(\"" + DataRootHandler.singleton.contentPath + "\",\"" + DataRootHandler.singleton.servletContextPath + "\").");
            return;
        }
        singleton = new DataRootHandler(contentPath, servletContextPath);
    }

    public static DataRootHandler getInstance() {
        if (singleton == null) {
            log.error("getInstance(): Called without init() having been called.");
            throw new IllegalStateException("init() must be called first.");
        }
        return singleton;
    }

    private DataRootHandler(String contentPath, String servletContextPath) {
        this.contentPath = contentPath;
        this.servletContextPath = servletContextPath;
        this.staticCatalogHash = new HashMap();
    }

    public boolean registerConfigListener(ConfigListener cl) {
        if (cl == null) {
            return false;
        }
        if (this.configListeners.contains(cl)) {
            return false;
        }
        return this.configListeners.add(cl);
    }

    public boolean unregisterConfigListener(ConfigListener cl) {
        if (cl == null) {
            return false;
        }
        return this.configListeners.remove(cl);
    }

    public synchronized void reinit() {
        this.isReinit = true;
        for (ConfigListener cl : this.configListeners) {
            cl.configStart();
        }
        this.staticCatalogHash = new HashMap();
        this.pathMatcher = new PathMatcher();
        this.idHash = new HashSet();
        DatasetHandler.reinit();
        log.info("\n**************************************\n**************************************\nCatalog reinit\n[" + DateUtil.getCurrentSystemTimeAsISO8601() + "]");
    }

    public synchronized void initCatalogs(List<String> configCatalogNames) {
        if (!this.isReinit) {
            for (ConfigListener cl : this.configListeners) {
                cl.configStart();
            }
        }
        this.isReinit = false;
        for (String catName : configCatalogNames) {
            try {
                this.initCatalog(catName);
            }
            catch (Throwable e) {
                log.error("Error initializing catalog " + catName + "; " + e.getMessage(), e);
            }
        }
        for (ConfigListener cl : this.configListeners) {
            cl.configEnd();
        }
    }

    synchronized void initCatalog(String path) throws IOException {
        log.info("\n**************************************\nCatalog init " + path + "\n[" + DateUtil.getCurrentSystemTimeAsISO8601() + "]");
        this.initCatalog(path, true);
    }

    private void initCatalog(String path, boolean recurse) throws IOException {
        String catalogFullPath = this.contentPath + path;
        File f = new File(catalogFullPath);
        String s1 = f.getCanonicalPath();
        if (!(catalogFullPath = StringUtil.replace((String)s1, (char)'\\', (String)"/")).startsWith(this.contentPath)) {
            log.error("initCatalog(): Path <" + path + "> points outside of content path <" + this.contentPath + "> (skip).");
            return;
        }
        if (path.matches("\\.{1,2}/.*") || path.matches(".*/\\.{1,2}/.*")) {
            path = catalogFullPath.substring(this.contentPath.length());
        }
        if (this.staticCatalogHash.containsKey(path)) {
            log.warn("DataRootHandler.initCatalog has already seen catalog=" + catalogFullPath + " possible loop (skip)");
            return;
        }
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)true);
        InvCatalogImpl cat = this.readCatalog(factory, path, catalogFullPath);
        if (cat == null) {
            log.warn("initCatalog(): failed to read catalog <" + catalogFullPath + ">.");
            return;
        }
        for (ConfigListener cl : this.configListeners) {
            cl.configCatalog((InvCatalog)cat);
        }
        for (InvProperty p : cat.getDatasetRoots()) {
            this.addRoot(p.getName(), p.getValue(), true);
        }
        for (InvService s : cat.getServices()) {
            for (InvProperty p : s.getDatasetRoots()) {
                this.addRoot(p.getName(), p.getValue(), true);
            }
        }
        int pos = path.lastIndexOf("/");
        String dirPath = pos > 0 ? path.substring(0, pos + 1) : "";
        this.initSpecialDatasets(cat.getDatasets());
        this.staticCatalogHash.put(path, cat);
        if (log.isDebugEnabled()) {
            log.debug("  add static catalog=" + path);
        }
        if (recurse) {
            this.initFollowCatrefs(dirPath, cat.getDatasets());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvCatalogImpl readCatalog(InvCatalogFactory factory, String path, String catalogFullPath) {
        URI uri;
        try {
            uri = new URI("file:" + StringUtil.escape((String)catalogFullPath, (String)"/:-_."));
        }
        catch (URISyntaxException e) {
            log.error("readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        log.debug("readCatalog(): full path=" + catalogFullPath + "; path=" + path);
        InvCatalogImpl cat = null;
        FileInputStream ios = null;
        try {
            ios = new FileInputStream(catalogFullPath);
            cat = factory.readXML((InputStream)ios, uri);
            DataRootHandler dataRootHandler = this;
            synchronized (dataRootHandler) {
                StringBuffer sbuff;
                block21: {
                    log.info("\nCatalog " + catalogFullPath);
                    sbuff = new StringBuffer();
                    if (cat.check(sbuff)) break block21;
                    log.error("readCatalog(): invalid catalog=" + catalogFullPath + "; " + sbuff.toString());
                    InvCatalogImpl invCatalogImpl = null;
                    return invCatalogImpl;
                }
                log.info(sbuff.toString());
            }
        }
        catch (Throwable t) {
            log.error("readCatalog(): Exception on catalog=" + catalogFullPath + " " + t.getMessage() + "\n log=" + cat.getLog(), t);
            InvCatalogImpl invCatalogImpl = null;
            return invCatalogImpl;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    log.error("readCatalog(): error closing" + catalogFullPath);
                }
            }
        }
        return cat;
    }

    private void initSpecialDatasets(List<InvDatasetImpl> dsList) {
        for (InvDatasetImpl invDataset : dsList) {
            String id = invDataset.getUniqueID();
            if (id != null) {
                if (this.idHash.contains(id)) {
                    log.warn("Duplicate id on  " + invDataset.getFullName() + " id= " + id);
                } else {
                    this.idHash.add(id);
                }
            }
            for (ConfigListener cl : this.configListeners) {
                cl.configDataset((InvDataset)invDataset);
            }
            if (invDataset instanceof InvDatasetScan) {
                InvDatasetScan ds = (InvDatasetScan)invDataset;
                InvService service = ds.getServiceDefault();
                if (service == null) {
                    log.error("InvDatasetScan " + ds.getFullName() + " has no default Service - skipping");
                    continue;
                }
                this.addRoot(ds);
            } else if (invDataset instanceof InvDatasetFmrc) {
                InvDatasetFmrc fmrc = (InvDatasetFmrc)invDataset;
                this.addRoot(fmrc);
            } else if (invDataset.getNcmlElement() != null) {
                DatasetHandler.putNcmlDataset(invDataset.getUrlPath(), invDataset);
            }
            if (invDataset instanceof InvCatalogRef) continue;
            this.initSpecialDatasets(invDataset.getDatasets());
        }
    }

    private void initFollowCatrefs(String dirPath, List datasets) throws IOException {
        for (InvDatasetImpl invDataset : datasets) {
            if (invDataset instanceof InvCatalogRef && !(invDataset instanceof InvDatasetScan) && !(invDataset instanceof InvDatasetFmrc)) {
                String path;
                InvCatalogRef catref = (InvCatalogRef)invDataset;
                String href = catref.getXlinkHref();
                if (log.isDebugEnabled()) {
                    log.debug("  catref.getXlinkHref=" + href);
                }
                if (href.startsWith("http:")) continue;
                if (href.startsWith("./")) {
                    href = href.substring(2);
                }
                if (href.startsWith(this.servletContextPath + "/")) {
                    path = href.substring(9);
                } else {
                    if (href.startsWith("/")) {
                        log.warn("**Warning: Skipping catalogRef <xlink:href=" + href + ">. Reference is relative to the server outside the context path <" + this.servletContextPath + "/" + ">. " + "Parent catalog info: Name=\"" + catref.getParentCatalog().getName() + "\"; Base URI=\"" + catref.getParentCatalog().getUriString() + "\"; dirPath=\"" + dirPath + "\".");
                        continue;
                    }
                    path = dirPath + href;
                }
                this.initCatalog(path, true);
                continue;
            }
            if (invDataset instanceof InvDatasetScan || invDataset instanceof InvDatasetFmrc) continue;
            this.initFollowCatrefs(dirPath, invDataset.getDatasets());
        }
    }

    private boolean addRoot(InvDatasetScan dscan) {
        String path = dscan.getPath();
        if (path == null) {
            log.error("**Error: " + dscan.getFullName() + " missing a path attribute.");
            return false;
        }
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            if (!droot.dirLocation.equals(dscan.getScanLocation())) {
                String message = "**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to map to fmrc=<" + dscan.getScanLocation() + "> in catalog " + dscan.getParentCatalog().getUriString();
                log.error(message);
            }
            return false;
        }
        if (dscan.getScanLocation().startsWith("content/")) {
            dscan.setScanLocation(this.contentPath + "public/" + dscan.getScanLocation().substring(8));
        }
        if (!dscan.isValid()) {
            log.error(dscan.getInvalidMessage());
            return false;
        }
        droot = new DataRoot(dscan);
        this.pathMatcher.put(path, (Object)droot);
        log.debug(" added rootPath=<" + path + ">  for directory= <" + dscan.getScanLocation() + ">");
        return true;
    }

    private boolean addRoot(InvDatasetFmrc fmrc) {
        File file;
        String path = fmrc.getPath();
        if (path == null) {
            log.error(fmrc.getFullName() + " missing a path attribute.");
            return false;
        }
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            log.error("**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to use by FMRC Dataset =<" + fmrc.getFullName() + ">");
            return false;
        }
        droot = new DataRoot(fmrc);
        if (droot.dirLocation != null && !(file = new File(droot.dirLocation)).exists()) {
            log.error("**Error: DatasetFmrc =" + droot.path + " directory= <" + droot.dirLocation + "> does not exist");
            return false;
        }
        this.pathMatcher.put(path, (Object)droot);
        log.debug(" added rootPath=<" + path + ">  for fmrc= <" + fmrc.getFullName() + ">");
        return true;
    }

    private boolean addRoot(String path, String dirLocation, boolean wantErr) {
        File file;
        DataRoot droot = (DataRoot)this.pathMatcher.get(path);
        if (droot != null) {
            if (wantErr) {
                log.error("**Error: already have dataRoot =<" + path + ">  mapped to directory= <" + droot.dirLocation + ">" + " wanted to map to <" + dirLocation + ">");
            }
            return false;
        }
        if (dirLocation.startsWith("content/")) {
            dirLocation = this.contentPath + "public/" + dirLocation.substring(8);
        }
        if (!(file = new File(dirLocation)).exists()) {
            log.error("**Error: Data Root =" + path + " directory= <" + dirLocation + "> does not exist");
            return false;
        }
        droot = new DataRoot(path, dirLocation);
        this.pathMatcher.put(path, (Object)droot);
        log.debug(" added rootPath=<" + path + ">  for directory= <" + dirLocation + ">");
        return true;
    }

    private DataRoot findDataRoot(String fullpath) {
        if (fullpath.length() > 0 && fullpath.charAt(0) == '/') {
            fullpath = fullpath.substring(1);
        }
        return (DataRoot)this.pathMatcher.match(fullpath);
    }

    public DataRootMatch findDataRootMatch(HttpServletRequest req) {
        String spath = req.getPathInfo();
        if (spath.length() > 0 && spath.startsWith("/")) {
            spath = spath.substring(1);
        }
        return this.findDataRootMatch(spath);
    }

    public DataRootMatch findDataRootMatch(String spath) {
        DataRoot dataRoot = this.findDataRoot(spath);
        if (dataRoot == null) {
            return null;
        }
        DataRootMatch match = new DataRootMatch();
        match.rootPath = dataRoot.path;
        match.remaining = spath.substring(match.rootPath.length());
        if (match.remaining.startsWith("/")) {
            match.remaining = match.remaining.substring(1);
        }
        match.dirLocation = dataRoot.dirLocation;
        match.dataRoot = dataRoot;
        return match;
    }

    public boolean hasDataRootMatch(String path) {
        DataRoot dataRoot;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((dataRoot = this.findDataRoot(path)) == null) {
            log.debug("hasDataRootMatch(): no InvDatasetScan for " + path);
            return false;
        }
        return true;
    }

    public CrawlableDataset getCrawlableDataset(String path) throws IOException {
        DataRoot reqDataRoot;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((reqDataRoot = this.findDataRoot(path)) == null) {
            return null;
        }
        if (reqDataRoot.scan != null) {
            return reqDataRoot.scan.requestCrawlableDataset(path);
        }
        if (reqDataRoot.fmrc != null) {
            return null;
        }
        if (reqDataRoot.dirLocation != null) {
            if (reqDataRoot.datasetRootProxy == null) {
                reqDataRoot.makeProxy();
            }
            return reqDataRoot.datasetRootProxy.requestCrawlableDataset(path);
        }
        return null;
    }

    public File getCrawlableDatasetAsFile(String path) {
        CrawlableDataset crDs;
        DataRootMatch match;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((match = this.findDataRootMatch(path)) == null) {
            return null;
        }
        if (match.dataRoot.fmrc != null) {
            return match.dataRoot.fmrc.getFile(match.remaining);
        }
        try {
            crDs = this.getCrawlableDataset(path);
        }
        catch (IOException e) {
            return null;
        }
        if (crDs == null) {
            return null;
        }
        File retFile = null;
        if (crDs instanceof CrawlableDatasetFile) {
            retFile = ((CrawlableDatasetFile)crDs).getFile();
        }
        return retFile;
    }

    public URI getCrawlableDatasetAsOpendapUri(String path) {
        CrawlableDataset crDs;
        if (path.length() > 0 && path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            crDs = this.getCrawlableDataset(path);
        }
        catch (IOException e) {
            return null;
        }
        if (crDs == null) {
            return null;
        }
        URI retUri = null;
        if (crDs instanceof CrawlableDatasetDods) {
            retUri = ((CrawlableDatasetDods)crDs).getUri();
        }
        return retUri;
    }

    public boolean isProxyDataset(String path) {
        ProxyDatasetHandler pdh = this.getMatchingProxyDataset(path);
        return pdh != null;
    }

    public boolean isProxyDatasetResolver(String path) {
        ProxyDatasetHandler pdh = this.getMatchingProxyDataset(path);
        if (pdh == null) {
            return false;
        }
        return pdh.isProxyDatasetResolver();
    }

    private ProxyDatasetHandler getMatchingProxyDataset(String path) {
        InvDatasetScan scan = this.getMatchingScan(path);
        if (null == scan) {
            return null;
        }
        int index = path.lastIndexOf("/");
        String proxyName = path.substring(index + 1);
        Map pdhMap = scan.getProxyDatasetHandlers();
        if (pdhMap == null) {
            return null;
        }
        return (ProxyDatasetHandler)pdhMap.get(proxyName);
    }

    private InvDatasetScan getMatchingScan(String path) {
        DataRoot reqDataRoot = this.findDataRoot(path);
        if (reqDataRoot == null) {
            return null;
        }
        InvDatasetScan scan = null;
        if (reqDataRoot.scan != null) {
            scan = reqDataRoot.scan;
        } else if (reqDataRoot.fmrc != null) {
            scan = reqDataRoot.fmrc.getRawFileScan();
        }
        return scan;
    }

    public InvCatalog getProxyDatasetResolverCatalog(String path, URI baseURI) {
        if (!this.isProxyDatasetResolver(path)) {
            throw new IllegalArgumentException("Not a proxy dataset resolver path <" + path + ">.");
        }
        InvDatasetScan scan = this.getMatchingScan(path);
        InvCatalogImpl cat = scan.makeProxyDsResolverCatalog(path, baseURI);
        return cat;
    }

    public void handleRequestForProxyDatasetResolverCatalog(HttpServletRequest req, HttpServletResponse res) throws IOException {
        URI baseURI;
        String path = req.getPathInfo();
        if (!this.isProxyDatasetResolver(path)) {
            String resMsg = "Request <" + path + "> not for proxy dataset resolver.";
            ServletUtil.logServerAccess(500, resMsg.length());
            log.error("handleRequestForProxyDatasetResolverCatalog(): " + resMsg);
            res.sendError(500, resMsg);
            return;
        }
        String baseUriString = req.getRequestURL().toString();
        try {
            baseURI = new URI(baseUriString);
        }
        catch (URISyntaxException e) {
            String resMsg = "Request URL <" + baseUriString + "> not a valid URI: " + e.getMessage();
            ServletUtil.logServerAccess(500, resMsg.length());
            log.error("handleRequestForProxyDatasetResolverCatalog(): " + resMsg);
            res.sendError(500, resMsg);
            return;
        }
        InvCatalogImpl cat = (InvCatalogImpl)this.getProxyDatasetResolverCatalog(path, baseURI);
        if (cat == null) {
            String resMsg = "Could not generate proxy dataset resolver catalog <" + path + ">.";
            ServletUtil.logServerAccess(500, resMsg.length());
            log.error("handleRequestForProxyDatasetResolverCatalog(): " + resMsg);
            res.sendError(500, resMsg);
            return;
        }
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
        String result = catFactory.writeXML(cat);
        ServletUtil.logServerAccess(200, result.length());
        res.setContentLength(result.length());
        res.setContentType("text/xml");
        res.getOutputStream().write(result.getBytes());
    }

    public void handleRequestForDataset(String path, DataServiceProvider dsp, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String crDsPath;
        DataServiceProvider.DatasetRequest dsReq = dsp.getRecognizedDatasetRequest(path, req);
        boolean dspCanHandle = false;
        if (dsReq != null) {
            String dsPath = dsReq.getDatasetPath();
            if (dsPath != null) {
                crDsPath = dsPath;
                dspCanHandle = true;
            } else {
                log.warn("handleRequestForDataset(): DataServiceProvider recognized request path <" + path + "> but returned a null dataset path, using request path.");
                crDsPath = path;
            }
        } else {
            crDsPath = path;
        }
        CrawlableDataset crDs = this.getCrawlableDataset(crDsPath);
        if (crDs == null) {
            res.sendError(404);
            ServletUtil.logServerAccess(404, -1L);
            return;
        }
        if (dspCanHandle) {
            dsp.handleRequestForDataset(dsReq, crDs, req, res);
            return;
        }
        if (crDs.isCollection()) {
            dsp.handleUnrecognizedRequestForCollection(crDs, req, res);
            return;
        }
        dsp.handleUnrecognizedRequest(crDs, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestForCatalog(String path) {
        String workPath = path;
        if (workPath == null) {
            return false;
        }
        if (workPath.endsWith("/")) {
            workPath = workPath + "catalog.xml";
        } else if (workPath.endsWith(".html")) {
            int len = workPath.length();
            workPath = workPath.substring(0, len - 4) + "xml";
        } else if (!workPath.endsWith(".xml")) {
            return false;
        }
        boolean hasCatalog = false;
        if (workPath.startsWith("/")) {
            workPath = workPath.substring(1);
        }
        DataRootHandler dataRootHandler = this;
        synchronized (dataRootHandler) {
            if (this.staticCatalogHash.containsKey(workPath)) {
                return true;
            }
        }
        DataRootMatch match = this.findDataRootMatch(workPath);
        if (match == null) {
            return false;
        }
        return hasCatalog;
    }

    public boolean processReqForCatalog(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        URI baseURI;
        boolean isHtmlReq = false;
        String catPath = req.getPathInfo();
        StringBuffer catBase = req.getRequestURL();
        if (catPath == null) {
            return false;
        }
        if (catPath.endsWith("/")) {
            isHtmlReq = true;
            catPath = catPath + "catalog.xml";
            catBase.append("catalog.xml");
        } else if (catPath.endsWith(".html")) {
            isHtmlReq = true;
            int len = catPath.length();
            catPath = catPath.substring(0, len - 4) + "xml";
            len = catBase.lastIndexOf(".html");
            catBase.replace(len + 1, len + 6, "xml");
        } else if (!catPath.endsWith(".xml")) {
            return false;
        }
        try {
            baseURI = new URI(catBase.toString());
        }
        catch (URISyntaxException e) {
            log.error("processReqForCatalog(): Request base <" + catBase + "> not a URI: " + e.getMessage());
            throw new ServletException("Request base <" + catBase + "> not a URI.", (Throwable)e);
        }
        InvCatalogImpl catalog = (InvCatalogImpl)this.getCatalog(catPath, baseURI);
        if (catalog == null) {
            return false;
        }
        String query = req.getQueryString();
        if (query != null) {
            CatalogServicesServlet.handleCatalogServiceRequest(catalog, baseURI, isHtmlReq, true, req, res);
            return true;
        }
        if (isHtmlReq) {
            HtmlWriter.getInstance().writeCatalog(res, catalog, true);
            return true;
        }
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
        String result = catFactory.writeXML(catalog);
        ServletUtil.logServerAccess(200, result.length());
        res.setContentLength(result.length());
        res.setContentType("text/xml");
        res.getOutputStream().write(result.getBytes());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvCatalog getCatalog(String path, URI baseURI) {
        InvCatalogImpl catalog;
        if (path == null) {
            return null;
        }
        String workPath = path;
        if (workPath.startsWith("/")) {
            workPath = workPath.substring(1);
        }
        DataRootHandler dataRootHandler = this;
        synchronized (dataRootHandler) {
            catalog = this.staticCatalogHash.get(workPath);
        }
        if (catalog != null) {
            DateType expiresDateType = catalog.getExpires();
            if (expiresDateType != null && expiresDateType.getDate().getTime() < System.currentTimeMillis()) {
                String catalogFullPath = this.contentPath + workPath;
                InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
                InvCatalogImpl reReadCat = this.readCatalog(factory, workPath, catalogFullPath);
                if (reReadCat != null) {
                    DataRootHandler dataRootHandler2 = this;
                    synchronized (dataRootHandler2) {
                        this.staticCatalogHash.put(workPath, reReadCat);
                    }
                    catalog = reReadCat;
                }
            }
            catalog.setBaseURI(baseURI);
        }
        if (catalog == null) {
            catalog = this.makeTDRDynamicCatalog(workPath, baseURI);
        }
        if (catalog == null) {
            catalog = this.makeDynamicCatalog(workPath, baseURI);
        }
        if (catalog == null && this.isProxyDatasetResolver(workPath)) {
            catalog = (InvCatalogImpl)this.getProxyDatasetResolverCatalog(workPath, baseURI);
        }
        return catalog;
    }

    private InvCatalogImpl makeDynamicCatalog(String path, URI baseURI) {
        DataRootMatch match;
        String workPath = path;
        if (!path.endsWith("/catalog.xml")) {
            return null;
        }
        int pos = workPath.lastIndexOf("/");
        if (pos >= 0) {
            workPath = workPath.substring(0, pos);
        }
        if ((match = this.findDataRootMatch(workPath)) == null) {
            log.warn("makeDynamicCatalog(): No DataRoot for = " + workPath + " request path= " + path);
            match = this.findDataRootMatch(workPath);
            return null;
        }
        if (match.dataRoot.fmrc != null) {
            return match.dataRoot.fmrc.makeCatalog(match.remaining, path, baseURI);
        }
        try {
            if (this.getCrawlableDataset(workPath) == null) {
                return null;
            }
        }
        catch (IOException e) {
            log.error("makeDynamicCatalog(): I/O error on request <" + path + ">: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (match.dataRoot.scan == null) {
            log.warn("makeDynamicCatalog(): No InvDatasetScan for =" + workPath + " request path= " + path);
            return null;
        }
        InvDatasetScan dscan = match.dataRoot.scan;
        log.debug("Calling makeCatalogForDirectory( " + baseURI + ", " + path + ").");
        InvCatalogImpl cat = dscan.makeCatalogForDirectory(path, baseURI);
        if (null == cat) {
            log.error("makeCatalogForDirectory failed = " + workPath);
        }
        return cat;
    }

    private InvCatalogImpl makeTDRDynamicCatalog(String path, URI baseURI) {
        if (!path.startsWith("tdr")) {
            return null;
        }
        String catalogFullPath = this.contentPath + path;
        File catFile = new File(catalogFullPath);
        if (!catFile.exists()) {
            return null;
        }
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogImpl cat = this.readCatalog(factory, path, catalogFullPath);
        if (cat == null) {
            log.warn("initCatalog(): failed to read tdr catalog <" + catalogFullPath + ">.");
            return null;
        }
        if (cat != null) {
            cat.setBaseURI(baseURI);
        }
        return cat;
    }

    public boolean processReqForLatestDataset(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        URI reqBaseURI;
        String path;
        int pos;
        String orgPath = req.getPathInfo();
        if (orgPath.startsWith("/")) {
            orgPath = orgPath.substring(1);
        }
        if ((pos = (path = orgPath).lastIndexOf("/")) >= 0) {
            path = path.substring(0, pos);
        }
        if (path.equals("/") || path.equals("")) {
            String resMsg = "No data at root level, \"/latest.xml\" request not available.";
            ServletUtil.logServerAccess(404, resMsg.length());
            log.debug(resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        DataRoot dataRoot = this.findDataRoot(path);
        if (dataRoot == null) {
            String resMsg = "No scan root matches requested path <" + path + ">.";
            ServletUtil.logServerAccess(404, resMsg.length());
            log.warn(resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        InvDatasetScan dscan = dataRoot.scan;
        if (dscan == null) {
            String resMsg = "Probable conflict between datasetScan and datasetRoot for path <" + path + ">.";
            ServletUtil.logServerAccess(404, resMsg.length());
            log.warn(resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        if (dscan.getProxyDatasetHandlers() == null) {
            String resMsg = "No \"addProxies\" or \"addLatest\" on matching scan root <" + path + ">.";
            ServletUtil.logServerAccess(404, resMsg.length());
            log.warn(resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        String reqBase = ServletUtil.getRequestBase(req);
        try {
            reqBaseURI = new URI(reqBase);
        }
        catch (URISyntaxException e) {
            String resMsg = "Request base URL <" + reqBase + "> not valid URI (???): " + e.getMessage();
            ServletUtil.logServerAccess(500, resMsg.length());
            log.error(resMsg);
            res.sendError(500, resMsg);
            return false;
        }
        InvCatalog cat = dscan.makeLatestCatalogForDirectory(orgPath, reqBaseURI);
        if (null == cat) {
            String resMsg = "Failed to build response catalog <" + path + ">.";
            ServletUtil.logServerAccess(404, resMsg.length());
            log.error(resMsg);
            res.sendError(404, resMsg);
            return false;
        }
        InvCatalogFactory catFactory = new InvCatalogFactory("default", true);
        String catAsString = catFactory.writeXML((InvCatalogImpl)cat);
        PrintWriter out = res.getWriter();
        res.setContentType("text/xml");
        res.setStatus(200);
        out.print(catAsString);
        ServletUtil.logServerAccess(200, catAsString.length());
        log.debug("Finished \"" + orgPath + "\".");
        return true;
    }

    public Element getNcML(String path) {
        DataRoot dataRoot;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((dataRoot = this.findDataRoot(path)) == null) {
            log.debug("_getNcML no InvDatasetScan for =" + path);
            return null;
        }
        InvDatasetScan dscan = dataRoot.scan;
        if (dscan == null) {
            dscan = dataRoot.datasetRootProxy;
        }
        if (dscan == null) {
            return null;
        }
        return dscan.getNcmlElement();
    }

    public void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("catalogs");
        DebugHandler.Action act = new DebugHandler.Action("showStatic", "Show static catalogs"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doAction(DebugHandler.Event e) {
                StringBuffer sbuff = new StringBuffer();
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    ArrayList list = new ArrayList(DataRootHandler.this.staticCatalogHash.keySet());
                    Collections.sort(list);
                    for (int i = 0; i < list.size(); ++i) {
                        String catPath = (String)list.get(i);
                        sbuff.append(" catalog= ").append(catPath).append("\n");
                    }
                }
                e.pw.println(StringUtil.quoteHtmlContent((String)("\n" + sbuff.toString())));
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRoots", "Show data roots"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doAction(DebugHandler.Event e) {
                DataRootHandler dataRootHandler = DataRootHandler.this;
                synchronized (dataRootHandler) {
                    for (DataRoot ds : DataRootHandler.this.pathMatcher) {
                        e.pw.print(" <b>" + ds.path + "</b>");
                        String url = DataRootHandler.this.servletContextPath + "/dataDir/" + ds.path + "/";
                        if (ds.fmrc == null) {
                            String type = ds.scan == null ? "root" : "scan";
                            e.pw.println(" for " + type + " directory= <a href='" + url + "'>" + ds.dirLocation + "</a> ");
                            continue;
                        }
                        if (ds.dirLocation == null) {
                            url = DataRootHandler.this.servletContextPath + "/" + ds.path;
                            e.pw.println("  for fmrc= <a href='" + url + "'>" + ds.fmrc.getXlinkHref() + "</a>");
                            continue;
                        }
                        e.pw.println("  for fmrc= <a href='" + url + "'>" + ds.dirLocation + "</a>");
                    }
                }
            }
        };
        debugHandler.addAction(act);
    }

    public static interface ConfigListener {
        public void configStart();

        public void configEnd();

        public void configCatalog(InvCatalog var1);

        public void configDataset(InvDataset var1);
    }

    public class DataRoot {
        String path;
        String dirLocation;
        InvDatasetScan scan;
        InvDatasetFmrc fmrc;
        InvDatasetScan datasetRootProxy;

        DataRoot(InvDatasetFmrc fmrc) {
            this.path = fmrc.getPath();
            this.fmrc = fmrc;
            InvDatasetFmrc.InventoryParams params = fmrc.getFmrcInventoryParams();
            if (null != params) {
                this.dirLocation = params.location;
            }
        }

        DataRoot(InvDatasetScan scan) {
            this.path = scan.getPath();
            this.scan = scan;
            this.dirLocation = scan.getScanLocation();
            this.datasetRootProxy = null;
        }

        DataRoot(String path, String dirLocation) {
            this.path = path;
            this.dirLocation = dirLocation;
            this.scan = null;
            this.makeProxy();
        }

        void makeProxy() {
            this.datasetRootProxy = new InvDatasetScan(null, "", this.path, this.dirLocation, null, null, null, null, null, false, null, null, null, null);
        }

        public String toString() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataRoot root = (DataRoot)o;
            return this.path.equals(root.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    public class DataRootMatch {
        String rootPath;
        String remaining;
        String dirLocation;
        DataRoot dataRoot;
    }
}

