/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDatasetFmrc;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetSource;
import thredds.servlet.DebugHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.restrict.RestrictedDatasetServlet;
import thredds.util.PathMatcher;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileCache;
import ucar.nc2.NetcdfFileFactory;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;

public class DatasetHandler {
    private static Logger log = LoggerFactory.getLogger(DatasetHandler.class);
    private static HashMap<String, InvDatasetImpl> ncmlDatasetHash = new HashMap();
    private static ArrayList<DatasetSource> sourceList = new ArrayList();
    private static HashMap<String, String> resourceControlHash = new HashMap();
    private static volatile PathMatcher resourceControlMatcher = new PathMatcher();
    private static boolean hasResourceControl = false;
    private static boolean debugResourceControl = false;

    static void reinit() {
        ncmlDatasetHash = new HashMap();
        resourceControlHash = new HashMap();
        resourceControlMatcher = new PathMatcher();
        sourceList = new ArrayList();
        hasResourceControl = false;
    }

    public static void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("catalogs");
        DebugHandler.Action act = new DebugHandler.Action("showNcml", "Show ncml datasets"){

            public void doAction(DebugHandler.Event e) {
                for (String key : ncmlDatasetHash.keySet()) {
                    e.pw.println(" url=" + key);
                }
            }
        };
        debugHandler.addAction(act);
    }

    public static void registerDatasetSource(String className) {
        Object instance;
        Class<?> vClass;
        try {
            vClass = DatasetHandler.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.error("Attempt to load DatasetSource class " + className + " not found");
            return;
        }
        if (!DatasetSource.class.isAssignableFrom(vClass)) {
            log.error("Attempt to load class " + className + " does not implement " + DatasetSource.class.getName());
            return;
        }
        try {
            instance = vClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Attempt to load Viewer class " + className + " cannot instantiate, probably need default Constructor.");
            return;
        }
        catch (IllegalAccessException e) {
            log.error("Attempt to load Viewer class " + className + " is not accessible.");
            return;
        }
        DatasetHandler.registerDatasetSource((DatasetSource)instance);
    }

    public static void registerDatasetSource(DatasetSource v) {
        sourceList.add(v);
        System.out.println("registerDatasetSource " + v.getClass().getName());
    }

    public static NetcdfFile getNetcdfFile(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return DatasetHandler.getNetcdfFile(req, res, req.getPathInfo());
    }

    public static NetcdfFile getNetcdfFile(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        Element netcdfElem;
        if (log.isDebugEnabled()) {
            log.debug("DatasetHandler wants " + reqPath);
        }
        if (debugResourceControl) {
            System.out.println("getNetcdfFile = " + ServletUtil.getRequest(req));
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!DatasetHandler.resourceControlOk(req, res, reqPath)) {
            return null;
        }
        InvDatasetImpl ds = ncmlDatasetHash.get(reqPath);
        if (ds != null) {
            NetcdfFile ncfile;
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found NcmlDataset= " + ds);
            }
            if ((ncfile = NetcdfFileCache.acquire((String)reqPath, (int)-1, null, null, (NetcdfFileFactory)new NcmlFileFactory(ds))) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return ncfile;
        }
        DataRootHandler.DataRootMatch match = DataRootHandler.getInstance().findDataRootMatch(reqPath);
        if (match != null && match.dataRoot.fmrc != null) {
            NetcdfDataset ncfile;
            InvDatasetFmrc fmrc = match.dataRoot.fmrc;
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found InvDatasetFmrc= " + fmrc);
            }
            if ((ncfile = fmrc.getDataset(match.remaining)) == null) {
                throw new FileNotFoundException(reqPath);
            }
            return ncfile;
        }
        NetcdfFile ncfile = null;
        for (DatasetSource datasetSource : sourceList) {
            if (!datasetSource.isMine(req) || (ncfile = datasetSource.getNetcdfFile(req, res)) != null) continue;
            return null;
        }
        if (ncfile == null) {
            File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(reqPath);
            if (file == null) {
                throw new FileNotFoundException(reqPath);
            }
            ncfile = NetcdfDataset.acquireFile((String)file.getPath(), null);
            if (ncfile == null) {
                throw new FileNotFoundException(reqPath);
            }
        }
        if ((netcdfElem = DataRootHandler.getInstance().getNcML(reqPath)) != null) {
            NetcdfDataset ncd = new NetcdfDataset(ncfile, false);
            new NcMLReader().readNetcdf(reqPath, ncd, ncd, netcdfElem, null);
            if (log.isDebugEnabled()) {
                log.debug("  -- DatasetHandler found DataRoot NcML = " + ds);
            }
            return ncd;
        }
        return ncfile;
    }

    public static ucar.nc2.dt.GridDataset openGridDataset(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        NetcdfDataset ncd;
        NetcdfFile ncfile = DatasetHandler.getNetcdfFile(req, res, reqPath);
        if (ncfile == null) {
            return null;
        }
        if (ncfile instanceof NetcdfDataset) {
            ncd = (NetcdfDataset)ncfile;
            if (!ncd.isEnhanced()) {
                ncd.enhance();
            }
        } else {
            ncd = new NetcdfDataset(ncfile, true);
        }
        return new GridDataset(ncd);
    }

    private static String findResourceControl(String path) {
        String rc;
        if (!hasResourceControl) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (null == (rc = resourceControlHash.get(path))) {
            rc = (String)resourceControlMatcher.match(path);
        }
        return rc;
    }

    public static boolean resourceControlOk(HttpServletRequest req, HttpServletResponse res, String reqPath) throws IOException {
        String rc;
        if (null == reqPath) {
            reqPath = req.getPathInfo();
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if ((rc = DatasetHandler.findResourceControl(reqPath)) != null) {
            if (debugResourceControl) {
                System.out.println("DatasetHandler request has resource control =" + rc + "\n" + ServletUtil.showRequestHeaders(req) + ServletUtil.showSecurity(req, rc));
            }
            try {
                if (!RestrictedDatasetServlet.authorize(req, res, rc)) {
                    return false;
                }
            }
            catch (ServletException e) {
                throw new IOException(e.getMessage());
            }
            if (debugResourceControl) {
                System.out.println("ResourceControl granted = " + rc);
            }
        }
        return true;
    }

    static void putResourceControl(InvDatasetImpl ds) {
        if (log.isDebugEnabled()) {
            log.debug("putResourceControl " + ds.getRestrictAccess() + " for " + ds.getName());
        }
        if (ds instanceof InvDatasetScan) {
            InvDatasetScan scan = (InvDatasetScan)ds;
            if (debugResourceControl) {
                System.out.println("putResourceControl " + ds.getRestrictAccess() + " for datasetScan " + scan.getPath());
            }
            resourceControlMatcher.put(scan.getPath(), (Object)ds.getRestrictAccess());
        } else if (ds instanceof InvDatasetFmrc) {
            InvDatasetFmrc fmrc = (InvDatasetFmrc)ds;
            if (debugResourceControl) {
                System.out.println("putResourceControl " + ds.getRestrictAccess() + " for datasetFmrc " + fmrc.getPath());
            }
            resourceControlMatcher.put(fmrc.getPath(), (Object)ds.getRestrictAccess());
        } else {
            if (debugResourceControl) {
                System.out.println("putResourceControl " + ds.getRestrictAccess() + " for dataset " + ds.getUrlPath());
            }
            resourceControlHash.put(ds.getUrlPath(), ds.getRestrictAccess());
        }
        hasResourceControl = true;
    }

    static void putNcmlDataset(String path, InvDatasetImpl ds) {
        if (log.isDebugEnabled()) {
            log.debug("putNcmlDataset " + path + " for " + ds.getName());
        }
        ncmlDatasetHash.put(path, ds);
    }

    private static class NcmlFileFactory
    implements NetcdfFileFactory {
        private InvDatasetImpl ds;

        NcmlFileFactory(InvDatasetImpl ds) {
            this.ds = ds;
        }

        public NetcdfFile open(String cacheName, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            Element netcdfElem = this.ds.getNcmlElement();
            return NcMLReader.readNcML((String)cacheName, (Element)netcdfElem, (CancelTask)cancelTask);
        }
    }
}

