/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import thredds.catalog.InvDatasetFmrc;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DataRootHandler;
import thredds.servlet.Debug;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.nc2.dt.fmrc.FmrcDefinition;
import ucar.nc2.dt.fmrc.FmrcInventory;
import ucar.nc2.dt.fmrc.FmrcReport;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.util.StringUtil;

public class FmrcInventoryServlet
extends AbstractServlet {
    private DiskCache2 fmrCache = null;
    private boolean debug = false;
    private String defPath;

    public void init() throws ServletException {
        super.init();
        this.defPath = this.rootPath + "idd/modelInventory/";
    }

    protected String getPath() {
        return "modelInventory/";
    }

    protected void makeDebugActions() {
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String offsetHour;
        FmrcInventory fmr;
        DataRootHandler h;
        DataRootHandler.DataRootMatch match;
        ServletUtil.logServerAccessSetup(req);
        String path = req.getPathInfo();
        String query = req.getQueryString();
        this.debug = Debug.isSet("FmrcInventoryServlet");
        if (this.debug) {
            System.out.println("path=" + path + " query=" + query);
        }
        if ((match = (h = DataRootHandler.getInstance()).findDataRootMatch(req)) == null || match.dataRoot.fmrc == null) {
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404, path);
            return;
        }
        InvDatasetFmrc.InventoryParams params = match.dataRoot.fmrc.getFmrcInventoryParams();
        if (params == null) {
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404, path);
            return;
        }
        try {
            String fmrInvOpenType;
            int mode;
            int pos;
            if (this.debug) {
                System.out.println("  FmrcInventoryParams=" + params + " for path=" + match.rootPath);
            }
            String fmrcDefinitionPath = this.defPath;
            String collectionName = params.def;
            File file = new File(params.def);
            if (file.isAbsolute() && (pos = params.def.lastIndexOf("/")) > 0) {
                fmrcDefinitionPath = params.def.substring(0, pos + 1);
                collectionName = params.def.substring(pos + 1);
            }
            int n = mode = (fmrInvOpenType = ThreddsConfig.get("FmrcInventory.openType", "")).equalsIgnoreCase("XML_ONLY") ? 3 : 1;
            if (this.debug) {
                System.out.println("  FmrcInventory.make path=" + fmrcDefinitionPath + " name= " + collectionName + " location= " + params.location + " suffix= " + params.suffix + " mode= " + mode);
            }
            fmr = FmrcInventory.make((String)fmrcDefinitionPath, (String)collectionName, (DiskCache2)this.fmrCache, (String)params.location, (String)params.suffix, (int)mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("ForecastModelRunCollection.make", (Throwable)e);
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404, path);
            return;
        }
        if (fmr == null) {
            this.log.warn("ForecastModelRunCollection.make");
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404, path);
            return;
        }
        String define = req.getParameter("define");
        if (define != null) {
            this.showDefinition(res, fmr, define);
            return;
        }
        String report = req.getParameter("report");
        if (report != null) {
            try {
                this.report(fmr, res, report.equals("missing"));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("report", (Throwable)e);
                ServletUtil.logServerAccess(500, 0L);
                res.sendError(500);
            }
            return;
        }
        String varName = match.remaining;
        if (varName.startsWith("/")) {
            varName = varName.substring(1);
        }
        if (varName.endsWith("/")) {
            varName = varName.substring(0, varName.length() - 1);
        }
        if ((offsetHour = req.getParameter("offsetHour")) != null) {
            this.showOffsetHour(res, fmr, varName, offsetHour);
            return;
        }
        boolean wantXML = req.getParameter("wantXML") != null;
        this.showInventory(res, fmr, varName, query, wantXML);
    }

    private void showOffsetHour(HttpServletResponse res, FmrcInventory fmrc, String varName, String offsetHour) throws IOException {
        res.setContentType("text/plain; charset=iso-8859-1");
        String contents = fmrc.showOffsetHour(varName, offsetHour);
        ServletOutputStream out = res.getOutputStream();
        out.write(contents.getBytes());
        out.flush();
        ServletUtil.logServerAccess(200, contents.length());
    }

    private void report(FmrcInventory fmrc, HttpServletResponse res, boolean showMissing) throws Exception {
        res.setContentType("text/plain; charset=iso-8859-1");
        ServletOutputStream out = res.getOutputStream();
        PrintStream ps = new PrintStream((OutputStream)out);
        FmrcReport report = new FmrcReport();
        report.report(fmrc, ps, showMissing);
        ps.flush();
        ServletUtil.logServerAccess(200, -1L);
    }

    private void reportAll(HttpServletResponse res, boolean showMissing) throws Exception {
        res.setContentType("text/plain; charset=iso-8859-1");
        ServletOutputStream out = res.getOutputStream();
        PrintStream ps = new PrintStream((OutputStream)out);
        String[] paths = this.getDatasetPaths();
        for (int i = 0; i < paths.length; ++i) {
            int pos;
            String path = "http://motherlode.ucar.edu:8080" + paths[i];
            String path2 = path.substring((pos = path.indexOf("model/")) + 6);
            String name = StringUtil.replace((String)path2, (char)'/', (String)"-");
            if (name.startsWith("-")) {
                name = name.substring(1);
            }
            if (name.endsWith("-")) {
                name = name.substring(0, name.length() - 1);
            }
            String dir = "/data/ldm/pub/native/grid/" + path2;
            ps.println("\n*******Dataset" + dir);
            FmrcInventory fmrc = FmrcInventory.make((String)this.contentPath, (String)name, (DiskCache2)this.fmrCache, (String)dir, (String)".grib1", (int)3);
            if (null == fmrc) {
                ps.println("  ERROR - no files were found");
            } else {
                FmrcReport report = new FmrcReport();
                report.report(fmrc, ps, showMissing);
            }
            ps.flush();
        }
        ServletUtil.logServerAccess(200, -1L);
    }

    private void showDefinition(HttpServletResponse res, FmrcInventory fmrc, String define) throws IOException {
        FileOutputStream fos;
        res.setContentType("text/xml; charset=iso-8859-1");
        FmrcDefinition def = fmrc.getDefinition();
        if (define.equals("write")) {
            fos = new FileOutputStream(fmrc.getDefinitionPath());
            def = new FmrcDefinition();
            def.makeFromCollectionInventory(fmrc);
            def.writeDefinitionXML((OutputStream)fos);
            System.out.println(" write to " + fmrc.getDefinitionPath());
        } else if (def != null && define.equals("addVert")) {
            fos = new FileOutputStream(fmrc.getDefinitionPath());
            def.addVertCoordsFromCollectionInventory(fmrc);
            def.writeDefinitionXML((OutputStream)fos);
            System.out.println(" write to " + fmrc.getDefinitionPath());
        }
        if (def == null) {
            def = new FmrcDefinition();
            def.makeFromCollectionInventory(fmrc);
        }
        String xmlString = def.writeDefinitionXML();
        ServletOutputStream out = res.getOutputStream();
        out.write(xmlString.getBytes());
        out.flush();
        ServletUtil.logServerAccess(200, xmlString.length());
    }

    private void showInventory(HttpServletResponse res, FmrcInventory fmr, String varName, String type, boolean wantXml) throws IOException {
        String infoString;
        boolean matrix;
        if (varName.length() == 0) {
            varName = null;
        }
        boolean bl = matrix = type != null && type.equalsIgnoreCase("Matrix");
        if (wantXml) {
            infoString = fmr.writeMatrixXML(varName);
        } else {
            Document doc;
            InputStream xslt;
            if (varName == null) {
                xslt = matrix ? FmrcInventoryServlet.getXSLT("fmrMatrix.xsl") : FmrcInventoryServlet.getXSLT("fmrOffset.xsl");
                doc = fmr.makeMatrixDocument();
            } else {
                xslt = matrix ? FmrcInventoryServlet.getXSLT("fmrMatrixVariable.xsl") : FmrcInventoryServlet.getXSLT("fmrOffsetVariable.xsl");
                doc = fmr.makeMatrixDocument(varName);
            }
            try {
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (Exception e) {
                this.log.error("ForecastModelRunServlet internal error", (Throwable)e);
                ServletUtil.logServerAccess(500, 0L);
                res.sendError(500, "ForecastModelRunServlet internal error");
                return;
            }
        }
        res.setContentLength(infoString.length());
        if (wantXml) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=iso-8859-1");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes());
        out.flush();
        ServletUtil.logServerAccess(200, infoString.length());
    }

    private static InputStream getXSLT(String xslName) {
        Class<FmrcInventoryServlet> c = FmrcInventoryServlet.class;
        return c.getResourceAsStream("/resources/xsl/" + xslName);
    }

    private String[] getDatasetPaths() {
        String[] all = new String[]{"/thredds/modelInventory/fmrc/NCEP/DGEX/CONUS_12km/", "/thredds/modelInventory/fmrc/NCEP/DGEX/Alaska_12km/", "/thredds/modelInventory/fmrc/NCEP/GFS/Alaska_191km/", "/thredds/modelInventory/fmrc/NCEP/GFS/CONUS_80km/", "/thredds/modelInventory/fmrc/NCEP/GFS/CONUS_95km/", "/thredds/modelInventory/fmrc/NCEP/GFS/CONUS_191km/", "/thredds/modelInventory/fmrc/NCEP/GFS/Global_0p5deg/", "/thredds/modelInventory/fmrc/NCEP/GFS/Global_onedeg/", "/thredds/modelInventory/fmrc/NCEP/GFS/Global_2p5deg/", "/thredds/modelInventory/fmrc/NCEP/GFS/Hawaii_160km/", "/thredds/modelInventory/fmrc/NCEP/GFS/N_Hemisphere_381km/", "/thredds/modelInventory/fmrc/NCEP/GFS/Puerto_Rico_191km/", "/thredds/modelInventory/fmrc/NCEP/NAM/Alaska_11km/", "/thredds/modelInventory/fmrc/NCEP/NAM/Alaska_22km/", "/thredds/modelInventory/fmrc/NCEP/NAM/Alaska_45km/noaaport/", "/thredds/modelInventory/fmrc/NCEP/NAM/Alaska_45km/conduit/", "/thredds/modelInventory/fmrc/NCEP/NAM/Alaska_95km/", "/thredds/modelInventory/fmrc/NCEP/NAM/CONUS_12km/", "/thredds/modelInventory/fmrc/NCEP/NAM/CONUS_20km/surface/", "/thredds/modelInventory/fmrc/NCEP/NAM/CONUS_20km/selectsurface/", "/thredds/modelInventory/fmrc/NCEP/NAM/CONUS_20km/noaaport/", "/thredds/modelInventory/fmrc/NCEP/NAM/CONUS_40km/noaaport/", "/thredds/modelInventory/fmrc/NCEP/NAM/CONUS_40km/conduit/", "/thredds/modelInventory/fmrc/NCEP/NAM/CONUS_80km/", "/thredds/modelInventory/fmrc/NCEP/NAM/Polar_90km/", "/thredds/modelInventory/fmrc/NCEP/RUC2/CONUS_20km/surface/", "/thredds/modelInventory/fmrc/NCEP/RUC2/CONUS_20km/pressure/", "/thredds/modelInventory/fmrc/NCEP/RUC2/CONUS_20km/hybrid/", "/thredds/modelInventory/fmrc/NCEP/RUC2/CONUS_40km/", "/thredds/modelInventory/fmrc/NCEP/RUC/CONUS_80km/", "/thredds/modelInventory/fmrc/NCEP/NDFD/CONUS_5km/"};
        return all;
    }
}

