/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.datatype.DateType;
import thredds.servlet.ServletUtil;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil;

public class HtmlWriter {
    private static Logger log = LoggerFactory.getLogger(HtmlWriter.class);
    private static HtmlWriter singleton;
    private String contextPath;
    private String contextName;
    private String contextVersion;
    private String userCssPath;
    private String contextLogoPath;
    private String contextLogoAlt;
    private String instituteLogoPath;
    private String instituteLogoAlt;
    private String docsPath;
    private String folderIconPath;
    private String folderIconAlt;
    private DateFormatter formatter = new DateFormatter();

    public static void init(String contextPath, String contextName, String contextVersion, String docsPath, String userCssPath, String contextLogoPath, String contextLogoAlt, String instituteLogoPath, String instituteLogoAlt, String folderIconPath, String folderIconAlt) {
        if (singleton != null) {
            log.warn("init(): this method has already been called; it should only be called once.");
            return;
        }
        singleton = new HtmlWriter(contextPath, contextName, contextVersion, docsPath, userCssPath, contextLogoPath, contextLogoAlt, instituteLogoPath, instituteLogoAlt, folderIconPath, folderIconAlt);
    }

    public static HtmlWriter getInstance() {
        if (singleton == null) {
            log.warn("getInstance(): init() has not been called.");
            return null;
        }
        return singleton;
    }

    private HtmlWriter() {
    }

    private HtmlWriter(String contextPath, String contextName, String contextVersion, String docsPath, String userCssPath, String contextLogoPath, String contextLogoAlt, String instituteLogoPath, String instituteLogoAlt, String folderIconPath, String folderIconAlt) {
        this.contextPath = contextPath;
        this.contextName = contextName;
        this.contextVersion = contextVersion;
        this.docsPath = docsPath;
        this.userCssPath = userCssPath;
        this.contextLogoPath = contextLogoPath;
        this.contextLogoAlt = contextLogoAlt;
        this.instituteLogoPath = instituteLogoPath;
        this.instituteLogoAlt = instituteLogoAlt;
        this.folderIconPath = folderIconPath;
        this.folderIconAlt = folderIconAlt;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getContextVersion() {
        return this.contextVersion;
    }

    public String getContextLogoPath() {
        return this.contextLogoPath;
    }

    public String getDocsPath() {
        return this.docsPath;
    }

    public String getHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n").append("        \"http://www.w3.org/TR/html4/loose.dtd\">\n").append("<html>\n").toString();
    }

    public String getXHtmlDoctypeAndOpenTag() {
        return new StringBuffer().append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n").append("        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">").toString();
    }

    public String getUserCSS() {
        return new StringBuffer().append("<link rel='stylesheet' href='").append(this.contextPath).append("/").append(this.userCssPath).append("' type='text/css' >").toString();
    }

    public String getUserHead() {
        return new StringBuffer().append("<table width=\"100%\"><tr><td>\n").append("  <img src=\"").append(this.contextPath).append("/").append(this.instituteLogoPath).append("\"\n").append("       alt=\"").append(this.instituteLogoAlt).append("\"\n").append("       align=\"left\" valign=\"top\"\n").append("       hspace=\"10\" vspace=\"2\">\n").append("  <h3><strong>").append(this.contextName).append("</strong></h3>\n").append("</td></tr></table>\n").toString();
    }

    private String getTomcatCSS() {
        return new StringBuffer().append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} ").append("H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} ").append("H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} ").append("BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} ").append("B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} ").append("P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}").append("A {color : black;}").append("A.name {color : black;}").append("HR {color : #525D76;}").toString();
    }

    public void writeDirectory(HttpServletResponse res, File dir, String path) throws IOException {
        OutputStreamWriter osWriter;
        if (dir == null) {
            res.sendError(404);
            ServletUtil.logServerAccess(404, 0L);
            return;
        }
        if (!dir.exists() || !dir.isDirectory()) {
            res.sendError(404);
            ServletUtil.logServerAccess(404, 0L);
            return;
        }
        String dirHtmlString = this.getDirectory(path, dir);
        res.setContentLength(dirHtmlString.length());
        res.setContentType("text/html; charset=iso-8859-1");
        try {
            osWriter = new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            osWriter = new OutputStreamWriter((OutputStream)res.getOutputStream());
        }
        PrintWriter writer = new PrintWriter(osWriter);
        writer.write(dirHtmlString);
        writer.flush();
        ServletUtil.logServerAccess(200, dirHtmlString.length());
    }

    private String getDirectory(String path, File dir) {
        int slash;
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        sb.append("<title>");
        sb.append("Directory listing for ").append(path);
        sb.append("</title>\r\n");
        sb.append("<STYLE type='text/css'><!--");
        sb.append(this.getTomcatCSS());
        sb.append("--></STYLE>\r\n");
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append("<h1>");
        sb.append("Directory listing for ").append(path);
        String parentDirectory = path;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0) {
            String parent = parentDirectory.substring(0, slash);
            sb.append(" - <a href=\"");
            if (parent.equals("")) {
                parent = "/";
            }
            sb.append("../");
            sb.append("\">");
            sb.append("<b>");
            sb.append("Up to ").append(parent);
            sb.append("</b>");
            sb.append("</a>");
        }
        sb.append("</h1>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Filename");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
        sb.append("Size");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
        sb.append("Last Modified");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        boolean shade = false;
        File[] children = dir.listFiles();
        List<File> fileList = Arrays.asList(children);
        Collections.sort(fileList);
        for (int i = 0; i < fileList.size(); ++i) {
            File child = fileList.get(i);
            String childname = child.getName();
            if (childname.equalsIgnoreCase("WEB-INF") || childname.equalsIgnoreCase("META-INF")) continue;
            if (child.isDirectory()) {
                childname = childname + "/";
            }
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor=\"#eeeeee\"");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
            sb.append("<a href=\"");
            sb.append(childname);
            sb.append("\"><tt>");
            sb.append(childname);
            sb.append("</tt></a></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            if (child.isDirectory()) {
                sb.append("&nbsp;");
            } else {
                sb.append(this.renderSize(child.length()));
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            sb.append(this.formatter.toDateTimeString(new Date(child.lastModified())));
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<h3>").append(this.contextVersion);
        sb.append(" <a href='").append(this.docsPath).append("'> Documentation</a></h3>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return "" + leftSide + "." + rightSide + " kb";
    }

    public void writeCatalog(HttpServletResponse res, InvCatalogImpl cat, boolean isLocalCatalog) throws IOException {
        OutputStreamWriter osWriter;
        String catHtmlAsString = this.convertCatalogToHtml(cat, isLocalCatalog);
        res.setContentLength(catHtmlAsString.length());
        res.setContentType("text/html; charset=iso-8859-1");
        try {
            osWriter = new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            osWriter = new OutputStreamWriter((OutputStream)res.getOutputStream());
        }
        PrintWriter writer = new PrintWriter(osWriter);
        writer.write(catHtmlAsString);
        writer.flush();
        ServletUtil.logServerAccess(200, catHtmlAsString.length());
    }

    String convertCatalogToHtml(InvCatalogImpl cat, boolean isLocalCatalog) {
        StringBuffer sb = new StringBuffer(10000);
        String catname = StringUtil.quoteHtmlContent((String)cat.getUriString());
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        sb.append("<title>");
        sb.append("Catalog ").append(catname);
        sb.append("</title>\r\n");
        sb.append("<STYLE type='text/css'><!--");
        sb.append(this.getTomcatCSS());
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append("Catalog ").append(catname);
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<th align=\"left\"><font size=\"+1\">");
        sb.append("Dataset");
        sb.append("</font></th>\r\n");
        sb.append("<th align=\"center\"><font size=\"+1\">");
        sb.append("Size");
        sb.append("</font></th>\r\n");
        sb.append("<th align=\"right\"><font size=\"+1\">");
        sb.append("Last Modified");
        sb.append("</font></th>\r\n");
        sb.append("</tr>");
        boolean shade = false;
        shade = this.doDatasets(cat, cat.getDatasets(), sb, shade, 0, isLocalCatalog);
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<h3>").append(this.contextVersion);
        sb.append(" <a href='").append(this.docsPath).append("'> Documentation</a></h3>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private boolean doDatasets(InvCatalogImpl cat, List datasets, StringBuffer sb, boolean shade, int level, boolean isLocalCatalog) {
        URI catURI;
        String catHtml;
        int pos;
        catHtml = !isLocalCatalog ? this.contextPath + "/catalog.html?cmd=subset&catalog=" + cat.getUriString() + "&" : ((pos = (catHtml = (catURI = cat.getBaseURI()).getPath()).lastIndexOf(46)) < 0 ? catHtml + "catalog.html?" : catHtml.substring(0, pos) + ".html?");
        for (int i = 0; i < datasets.size(); ++i) {
            InvDatasetImpl ds = (InvDatasetImpl)datasets.get(i);
            String name = StringUtil.quoteHtmlContent((String)ds.getName());
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor=\"#eeeeee\"");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align=\"left\">");
            for (int j = 0; j <= level; ++j) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            sb.append("\r\n");
            if (ds instanceof InvCatalogRef) {
                InvCatalogRef catref = (InvCatalogRef)ds;
                String href = catref.getXlinkHref();
                if (!isLocalCatalog) {
                    URI hrefUri = cat.getBaseURI().resolve(href);
                    href = hrefUri.toString();
                }
                try {
                    URI uri = new URI(href);
                    if (uri.isAbsolute()) {
                        href = this.contextPath + "/catalogServices?catalog=" + href;
                    } else {
                        int pos2 = href.lastIndexOf(46);
                        href = href.substring(0, pos2) + ".html";
                    }
                }
                catch (URISyntaxException e) {
                    log.error(href, (Throwable)e);
                }
                sb.append("<img src='").append(this.contextPath).append("/").append(this.folderIconPath).append("' alt='").append(this.folderIconAlt).append("'> &nbsp;");
                sb.append("<a href=\"");
                sb.append(StringUtil.quoteHtmlContent((String)href));
                sb.append("\"><tt>");
                sb.append(name);
                sb.append("/</tt></a></td>\r\n");
            } else {
                if (ds.hasNestedDatasets()) {
                    sb.append("<img src='").append(this.contextPath).append("/").append(this.folderIconPath).append("' alt='").append(this.folderIconAlt).append("'> &nbsp;");
                }
                if (ds.getAccess().size() == 1 && ((InvAccess)ds.getAccess().get(0)).getService().getServiceType().equals((Object)ServiceType.RESOLVER)) {
                    InvAccess access = (InvAccess)ds.getAccess().get(0);
                    String accessUrlName = access.getUnresolvedUrlName();
                    int pos3 = accessUrlName.lastIndexOf(".xml");
                    if (pos3 != -1) {
                        accessUrlName = accessUrlName.substring(0, pos3) + ".html";
                    }
                    sb.append("<a href=\"");
                    sb.append(StringUtil.quoteHtmlContent((String)accessUrlName));
                    sb.append("\"><tt>");
                    String tmpName = name;
                    if (tmpName.endsWith(".xml")) {
                        tmpName = tmpName.substring(0, tmpName.lastIndexOf(46));
                    }
                    sb.append(tmpName);
                    sb.append("</tt></a></td>\r\n");
                } else if (ds.getID() != null) {
                    sb.append("<a href=\"");
                    sb.append(StringUtil.quoteHtmlContent((String)catHtml));
                    sb.append("dataset=");
                    sb.append(StringUtil.replace((String)ds.getID(), (char)'+', (String)"%2B"));
                    sb.append("\"><tt>");
                    sb.append(name);
                    sb.append("</tt></a></td>\r\n");
                } else {
                    sb.append("<tt>");
                    sb.append(name);
                    sb.append("</tt></td>\r\n");
                }
            }
            sb.append("<td align=\"right\"><tt>");
            double size = ds.getDataSize();
            if (size != 0.0 && !Double.isNaN(size)) {
                sb.append(Format.formatByteSize((double)size));
            } else {
                sb.append("&nbsp;");
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            DateType lastModDateType = ds.getLastModifiedDate();
            if (lastModDateType == null) {
                if (!ds.hasAccess()) {
                    sb.append("--");
                } else {
                    sb.append("--");
                }
            } else {
                if (lastModDateType.isPresent()) {
                    sb.append(this.formatter.toDateTimeString(new Date()));
                }
                if (lastModDateType.getDate() != null) {
                    sb.append(this.formatter.toDateTimeString(lastModDateType.getDate()));
                }
            }
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
            if (ds instanceof InvCatalogRef) continue;
            shade = this.doDatasets(cat, ds.getDatasets(), sb, shade, level + 1, isLocalCatalog);
        }
        return shade;
    }

    public void showCDM(HttpServletResponse res, NetcdfDataset ds) throws IOException {
        OutputStreamWriter osWriter;
        String cdmAsString = this.getCDM(ds);
        res.setContentLength(cdmAsString.length());
        res.setContentType("text/html; charset=iso-8859-1");
        try {
            osWriter = new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            osWriter = new OutputStreamWriter((OutputStream)res.getOutputStream());
        }
        PrintWriter writer = new PrintWriter(osWriter);
        writer.write(cdmAsString);
        writer.flush();
        ServletUtil.logServerAccess(200, cdmAsString.length());
    }

    private String getCDM(NetcdfDataset ds) {
        StringBuffer sb = new StringBuffer(10000);
        String name = StringUtil.quoteHtmlContent((String)ds.getLocation());
        sb.append(this.getHtmlDoctypeAndOpenTag());
        sb.append("<head>\r\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        sb.append("<title>");
        sb.append("Common Data Model");
        sb.append("</title>\r\n");
        sb.append("<STYLE type='text/css'><!--");
        sb.append(this.getTomcatCSS());
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append("Dataset ").append(name);
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Axis");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Type");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Units");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        boolean shade = false;
        List axes = ds.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)axes.get(i);
            this.showAxis(axis, sb, shade);
            shade = !shade;
        }
        GridDataset gds = new GridDataset(ds);
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("GeoGrid");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Description");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Units");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        shade = false;
        List grids = gds.getGrids();
        for (int i = 0; i < grids.size(); ++i) {
            GridDatatype grid = (GridDatatype)grids.get(i);
            this.showGrid(grid, sb, shade);
            shade = !shade;
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<h3>").append(this.contextVersion);
        sb.append(" <a href='").append(this.docsPath).append("'> Documentation</a></h3>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        return sb.toString();
    }

    private void showAxis(CoordinateAxis axis, StringBuffer sb, boolean shade) {
        sb.append("<tr");
        if (shade) {
            sb.append(" bgcolor=\"#eeeeee\"");
        }
        sb.append(">\r\n");
        shade = !shade;
        sb.append("<td align=\"left\">");
        sb.append("\r\n");
        StringBuffer sbuff = new StringBuffer();
        axis.getNameAndDimensions(sbuff, false, true);
        String name = StringUtil.quoteHtmlContent((String)sbuff.toString());
        sb.append("&nbsp;");
        sb.append(name);
        sb.append("</tt></a></td>\r\n");
        sb.append("<td align=\"left\"><tt>");
        AxisType type = axis.getAxisType();
        String stype = type == null ? "" : StringUtil.quoteHtmlContent((String)type.toString());
        sb.append(stype);
        sb.append("</tt></td>\r\n");
        sb.append("<td align=\"left\"><tt>");
        String units = axis.getUnitsString();
        String sunits = units == null ? "" : units;
        sb.append(sunits);
        sb.append("</tt></td>\r\n");
        sb.append("</tr>\r\n");
    }

    private void showGrid(GridDatatype grid, StringBuffer sb, boolean shade) {
        sb.append("<tr");
        if (shade) {
            sb.append(" bgcolor=\"#eeeeee\"");
        }
        sb.append(">\r\n");
        shade = !shade;
        sb.append("<td align=\"left\">");
        sb.append("\r\n");
        VariableEnhanced ve = grid.getVariable();
        StringBuffer sbuff = new StringBuffer();
        ve.getNameAndDimensions(sbuff, false, true);
        String name = StringUtil.quoteHtmlContent((String)sbuff.toString());
        sb.append("&nbsp;");
        sb.append(name);
        sb.append("</tt></a></td>\r\n");
        sb.append("<td align=\"left\"><tt>");
        String desc = ve.getDescription();
        String sdesc = desc == null ? "" : StringUtil.quoteHtmlContent((String)desc);
        sb.append(sdesc);
        sb.append("</tt></td>\r\n");
        sb.append("<td align=\"left\"><tt>");
        String units = ve.getUnitsString();
        String sunits = units == null ? "" : units;
        sb.append(sunits);
        sb.append("</tt></td>\r\n");
        sb.append("</tr>\r\n");
    }
}

