/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import thredds.servlet.Debug;

public class Log {
    private static Log globalLog = new Log("globalLog", true);
    private static String logPath = "./";
    private String loggerName;
    private boolean isLogging = false;
    private Logger logger = null;
    private StringBuffer sb = new StringBuffer();

    public static void setGlobalLogName(String name) {
        globalLog = new Log(name.replace('/', '-'), true);
    }

    public static void printG(String s) {
        globalLog.print(s);
    }

    public static void printlnG(String s) {
        globalLog.println(s);
    }

    public static void printIfSetG(String flagName, String s) {
        globalLog.printIfSet(flagName, s);
    }

    public static void errorG(String s) {
        globalLog.error(s);
    }

    public static void errorG(String s, Throwable e) {
        globalLog.error(s, e);
    }

    public static void setLogPath(String logPathS) {
        logPath = logPathS;
        File logPathFile = new File(logPath);
        if (!logPathFile.exists() && !logPathFile.mkdirs()) {
            throw new RuntimeException("Log.setLogPath: cant create directory " + logPath);
        }
        Log.setGlobalLogName("globalLog");
        Log.printG("Log.setLogPath = " + logPathS);
        System.out.println("Log.setLogPath = " + logPathS);
    }

    public Log(String loggerName) {
        this.loggerName = loggerName.replace('/', '-');
    }

    public Log(String loggerName, boolean isLogging) {
        this(loggerName);
        this.setLogging(isLogging);
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public void setLogging(boolean isLogging) {
        this.isLogging = isLogging;
    }

    private void init() {
        String filename = logPath + "/" + this.loggerName + ".log";
        this.logger = Logger.getLogger((String)this.loggerName);
        this.logger.setLevel(Level.DEBUG);
        PatternLayout layout = new PatternLayout("%p: %m (%d{yy-MM-dd HH:mm:ss} )%n");
        try {
            FileAppender fa = new FileAppender((Layout)layout, filename, false);
            this.logger.addAppender((Appender)fa);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Log creation got IOException", ioe);
        }
        ConsoleAppender ca = new ConsoleAppender((Layout)layout);
        this.logger.addAppender((Appender)ca);
    }

    public void println(String s) {
        if (!this.isLogging()) {
            return;
        }
        if (this.logger == null) {
            this.init();
        }
        if (this.sb.length() == 0) {
            this.logger.debug(s);
        } else {
            this.logger.debug(this.sb.toString() + s);
            this.sb.setLength(0);
        }
    }

    public void print(String s) {
        if (!this.isLogging()) {
            return;
        }
        this.sb.append(s);
    }

    public void printIfSet(String flagName, String s) {
        if (!Debug.isSet(flagName)) {
            return;
        }
        this.println(flagName + ": " + s);
    }

    public void error(String s) {
        if (!this.isLogging()) {
            return;
        }
        if (this.logger == null) {
            this.init();
        }
        this.logger.error(s);
    }

    public void error(String s, Throwable e) {
        if (!this.isLogging()) {
            return;
        }
        if (this.logger == null) {
            this.init();
        }
        this.logger.error(s, e);
    }
}

