/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.apache.log4j.Category;

public class LogUtil {
    static Category log_ = Category.getInstance((String)LogUtil.class.getName());
    private static boolean testMode = false;
    private static ArrayList exceptions = new ArrayList();
    private static ArrayList msgs = new ArrayList();
    public static StringBuffer buff = new StringBuffer();
    private static final Object mutex = new Object();
    public static boolean displayMsg = false;
    private static Hashtable ticks = new Hashtable();
    private static Hashtable mems = new Hashtable();
    private static Hashtable tabs = new Hashtable();
    private static Hashtable traceMsgs = new Hashtable();
    private static String lastThreadName = "";
    private static long initMemory = 0L;
    public static long lastMemory = 0L;
    public static long lastTime = 0L;
    public static Hashtable counters = new Hashtable();
    public static List counterList = new ArrayList();
    private static JFrame consoleWindow;
    private static JTextArea consoleText;
    private static ArrayList messageLogs;
    private static String lastMessageString;
    public static int printlncnt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(String s) {
        Object object = mutex;
        synchronized (object) {
            buff.append(s);
            buff.append("\n");
        }
    }

    static StringBuffer getBuffer() {
        Thread t = Thread.currentThread();
        StringBuffer sb = (StringBuffer)traceMsgs.get(t);
        if (sb == null) {
            sb = new StringBuffer();
            traceMsgs.put(t, sb);
        }
        return sb;
    }

    static Integer getTab() {
        Thread t = Thread.currentThread();
        Integer tab = (Integer)tabs.get(t);
        if (tab == null) {
            tab = new Integer(0);
            tabs.put(t, tab);
        }
        return tab;
    }

    static int getCurrentTab() {
        return LogUtil.getTab();
    }

    public static void startTrace() {
        displayMsg = true;
        initMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static void stopTrace() {
        displayMsg = false;
    }

    public static void deltaCurrentTab(int delta) {
        if (!displayMsg) {
            return;
        }
        int v = LogUtil.getCurrentTab();
        tabs.put(Thread.currentThread(), new Integer(v + delta));
    }

    public static void tabPlus() {
        LogUtil.deltaCurrentTab(1);
    }

    public static void tabMinus() {
        LogUtil.deltaCurrentTab(-1);
    }

    public static void call1(String m) {
        LogUtil.call1(m, "", true);
    }

    public static void call1(String m, boolean print) {
        LogUtil.call1(m, "", print);
    }

    public static void call1(String m, String extra) {
        LogUtil.call1(m, extra, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void call1(String m, String extra, boolean print) {
        if (!displayMsg) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            if (print) {
                LogUtil.writeTrace(">" + m + extra);
            }
            LogUtil.deltaCurrentTab(1);
            ticks.put(m, new Long(System.currentTimeMillis()));
            mems.put(m, new Long(LogUtil.usedMemory()));
        }
    }

    public static void call2(String m) {
        LogUtil.call2(m, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void call2(String m, String extra) {
        if (!displayMsg) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            LogUtil.deltaCurrentTab(-1);
            long now = System.currentTimeMillis();
            Long lastTime = (Long)ticks.get(m);
            Long lastMemory = (Long)mems.get(m);
            if (lastTime != null && lastMemory != null) {
                long memDiff = LogUtil.usedMemory() - lastMemory;
                long then = lastTime;
                LogUtil.writeTrace("<" + m + " ms: " + (now - then) + extra);
                ticks.remove(m);
                mems.remove(m);
            } else {
                LogUtil.writeTrace(m + " NO LAST TIME");
            }
        }
    }

    public static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static void clearMsgs() {
        tabs = new Hashtable();
        traceMsgs = new Hashtable();
    }

    public static void printMsgs() {
        Enumeration keys = traceMsgs.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            System.out.println(key);
            System.out.println(traceMsgs.get(key));
        }
        LogUtil.clearMsgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void before(String m) {
        if (!displayMsg) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            LogUtil.writeTrace(m);
            LogUtil.deltaCurrentTab(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void after(String m) {
        if (!displayMsg) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            LogUtil.deltaCurrentTab(-1);
            LogUtil.writeTrace(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void msg(String m) {
        if (!displayMsg) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            LogUtil.writeTrace(m);
        }
    }

    private static void writeTrace(String msg) {
        Thread t = Thread.currentThread();
        String crntThreadName = t.getName();
        if (!crntThreadName.equals(lastThreadName)) {
            System.out.println("Thread:" + crntThreadName);
            lastThreadName = crntThreadName;
        }
        StringBuffer sb = LogUtil.getBuffer();
        LogUtil.printTabs(sb);
        System.out.print(msg + "\n");
        sb.append(msg + "\n");
    }

    private static void printTabs(StringBuffer sb) {
        if (!displayMsg) {
            return;
        }
        int tabs = LogUtil.getCurrentTab();
        long usedMemory2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (initMemory == 0L) {
            initMemory = usedMemory2;
        }
        long currentTime = System.currentTimeMillis();
        String ts = "" + (currentTime - lastTime);
        while (ts.length() < 3) {
            ts = ts + " ";
        }
        String prefix = "";
        String ms = "" + (int)((double)(usedMemory2 - lastMemory) / 1000.0);
        while (ms.length() < 5) {
            ms = ms + " ";
        }
        String tms = "" + (int)((double)(usedMemory2 - initMemory) / 1000.0);
        while (tms.length() < 5) {
            tms = tms + " ";
        }
        prefix = lastTime == 0L ? "S   D     T" : ts + " " + ms + " ";
        while (prefix.length() < 10) {
            prefix = prefix + " ";
        }
        System.out.print(prefix);
        sb.append(prefix);
        lastMemory = usedMemory2;
        for (int i = 0; i < tabs; ++i) {
            sb.append("  ");
            System.out.print("  ");
        }
        lastTime = currentTime;
    }

    public static void count(String name) {
        Integer i = (Integer)counters.get(name);
        if (i == null) {
            i = new Integer(0);
            counters.put(name, i);
            counterList.add(name);
        }
        i = new Integer(i + 1);
        counters.put(name, i);
    }

    public static void printAndClearCount() {
        for (int i = 0; i < counterList.size(); ++i) {
            String name = (String)counterList.get(i);
            Integer theCount = (Integer)counters.get(name);
            System.out.println("Count:" + name + "=" + theCount);
        }
        counterList = new ArrayList();
        counters = new Hashtable();
    }

    public static boolean anyErrors() {
        return exceptions.size() > 0;
    }

    public static List getExceptions() {
        return exceptions;
    }

    public static List getMessages() {
        return msgs;
    }

    public static void setTestMode(boolean v) {
        testMode = v;
    }

    public static void logException(String xmsg, Throwable exc) {
    }

    private static void printExceptionsNoGui(List errorMessages, List exceptions) {
        if (exceptions == null) {
            return;
        }
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception exc = (Exception)exceptions.get(i);
            String message = (String)errorMessages.get(i);
            LogUtil.logException(message, exc);
        }
    }

    public static String getStackTrace() {
        return LogUtil.getStackTrace(new IllegalArgumentException(""));
    }

    public static String getStackTrace(Throwable exc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exc.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    private static void checkConsole() {
        if (consoleText == null) {
            consoleText = new JTextArea(10, 30);
            consoleText.setEditable(false);
        }
    }

    public static void consoleMessage(String msg) {
        LogUtil.checkConsole();
        consoleText.append(msg);
    }

    public static void printExceptionNoGui(Category log_, String xmsg, Throwable exc) {
        if (exc instanceof InvocationTargetException) {
            exc = ((InvocationTargetException)exc).getTargetException();
        }
        exc.printStackTrace(System.err);
        if (testMode) {
            exceptions.add(exc);
            msgs.add(xmsg);
        }
    }

    public static void userMessage(String msg) {
        LogUtil.userMessage(null, msg, false);
    }

    public static void userMessage(Category log_, String msg) {
        LogUtil.userMessage(log_, msg, false);
    }

    public static void userMessage(Category log_, String msg, String consoleMsg) {
        LogUtil.userMessage(log_, msg);
        log_.error(consoleMsg);
    }

    public static void userMessage(Category log_, String msg, boolean andLog) {
        if (andLog && log_ != null) {
            log_.error(msg);
        }
        if (!testMode) {
            LogUtil.consoleMessage(msg);
            JOptionPane.showMessageDialog(null, msg);
        }
    }

    public static void userErrorMessage(Category log_, String msg) {
        if (log_ != null) {
            log_.error(msg);
        }
        if (!testMode) {
            LogUtil.consoleMessage(msg);
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        }
    }

    public static void userErrorMessage(String msg) {
        LogUtil.userErrorMessage(null, msg);
    }

    public static void addMessageLogger(JTextArea t) {
        messageLogs.add(t);
    }

    public static void addMessageLogger(JLabel t) {
        messageLogs.add(t);
    }

    public static void removeMessageLogger(Object t) {
        messageLogs.remove(t);
    }

    public static void clearMessage(String message) {
        if (lastMessageString != null && message.equals(lastMessageString)) {
            LogUtil.message("");
        }
    }

    public static void message(String msg) {
        lastMessageString = msg;
        if (msg.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < messageLogs.size(); ++i) {
            Object logger = messageLogs.get(i);
            if (logger instanceof JTextArea) {
                ((JTextArea)logger).append(msg + "\n");
                ((JTextArea)logger).repaint();
                continue;
            }
            if (!(logger instanceof JLabel)) continue;
            ((JLabel)logger).setText(msg);
            ((JLabel)logger).repaint();
        }
    }

    public static void tracePrintlns() {
        System.setErr(new PrintStream(new ByteArrayOutputStream()){

            public void println(String s) {
                this.doit(s);
            }

            public void println(Object x) {
                this.doit("" + x);
            }

            private void doit(String s) {
                if (printlncnt > 0) {
                    System.out.println("Recurse:" + s);
                    super.println(s);
                    return;
                }
                ++printlncnt;
                System.out.println("PRINT:" + s);
                IllegalArgumentException exc = new IllegalArgumentException("");
                exc.printStackTrace();
                --printlncnt;
            }
        });
    }

    static {
        messageLogs = new ArrayList();
        lastMessageString = "";
        printlncnt = 0;
    }
}

