/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.StringUtil;

public class NetcdfServlet
extends AbstractServlet {
    private DiskCache2 diskCache = null;
    private boolean allow = false;
    private boolean deleteImmediately = true;
    private long maxFileDownloadSize;

    protected String getPath() {
        return "ncServer/";
    }

    protected void makeDebugActions() {
    }

    public void init() throws ServletException {
        super.init();
        this.allow = ThreddsConfig.getBoolean("NetcdfSubsetService.allow", false);
        this.maxFileDownloadSize = ThreddsConfig.getBytes("NetcdfSubsetService.maxFileDownloadSize", 1000000000L);
        String cache = ThreddsConfig.get("NetcdfSubsetService.dir", this.contentPath + "/cache");
        File cacheDir = new File(cache);
        cacheDir.mkdirs();
        int scourSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
    }

    public void destroy() {
        if (this.diskCache != null) {
            this.diskCache.exit();
        }
        super.destroy();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        ServletUtil.logServerAccessSetup(req);
        ServletUtil.showRequestDetail(this, req);
        String pathInfo = req.getPathInfo();
        String showRequest = req.getParameter("showRequest");
        if (showRequest != null) {
            ServletOutputStream out = res.getOutputStream();
            PrintStream ps = new PrintStream((OutputStream)out);
            ps.println("**NetcdfService req=" + pathInfo);
            ps.println(ServletUtil.showRequestDetail(this, req));
            ps.flush();
            return;
        }
        if (pathInfo.startsWith("/cache/")) {
            pathInfo = pathInfo.substring(7);
            File ncFile = this.diskCache.getCacheFile(pathInfo);
            res.setHeader("Content-Disposition", "attachment; filename=");
            ServletUtil.returnFile(this, "", ncFile.getPath(), req, res, "application/x-netcdf");
            if (this.deleteImmediately) {
                ncFile.delete();
            }
            return;
        }
        ForecastModelRunInventory fmr = null;
        try {
            boolean haveSome;
            GridDataset gds = DatasetHandler.openGridDataset(req, res, pathInfo);
            if (gds == null) {
                return;
            }
            fmr = ForecastModelRunInventory.open((GridDataset)gds, null);
            int pos = pathInfo.lastIndexOf("/");
            String name = pos <= 1 ? pathInfo : pathInfo.substring(pos + 1);
            fmr.setName(name);
            String wantXML = req.getParameter("wantXML");
            String showForm = req.getParameter("showForm");
            if (showForm != null) {
                try {
                    this.showForm(res, fmr, wantXML != null);
                }
                catch (Exception e) {
                    this.log.error("showForm", (Throwable)e);
                    ServletUtil.logServerAccess(500, 0L);
                    res.sendError(500);
                }
                return;
            }
            ArrayList<String> varList = new ArrayList<String>();
            String[] vars = ServletUtil.getParameterValuesIgnoreCase(req, "grid");
            if (vars != null) {
                for (int i = 0; i < vars.length; ++i) {
                    StringTokenizer stoke = new StringTokenizer(vars[i], ";");
                    while (stoke.hasMoreTokens()) {
                        String gridName = StringUtil.unescape((String)stoke.nextToken());
                        varList.add(gridName);
                    }
                }
            }
            int count = 0;
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < varList.size(); ++i) {
                String varName = (String)varList.get(i);
                if (null != gds.findGridDatatype(varName)) continue;
                buff.append(varName);
                if (count > 0) {
                    buff.append(";");
                }
                ++count;
            }
            if (buff.length() != 0) {
                ServletUtil.logServerAccess(400, 0L);
                res.sendError(400, "Grid(s) not found in dataset=" + buff);
                return;
            }
            boolean hasBB = false;
            double north = 0.0;
            double south = 0.0;
            double west = 0.0;
            double east = 0.0;
            String bb = ServletUtil.getParameterIgnoreCase(req, "bb");
            if (bb != null) {
                boolean err = false;
                StringTokenizer stoke = new StringTokenizer(bb, ",");
                if (stoke.countTokens() != 4) {
                    err = true;
                } else {
                    try {
                        north = Double.parseDouble(stoke.nextToken());
                        south = Double.parseDouble(stoke.nextToken());
                        west = Double.parseDouble(stoke.nextToken());
                        east = Double.parseDouble(stoke.nextToken());
                        hasBB = true;
                    }
                    catch (NumberFormatException e) {
                        err = true;
                    }
                }
                if (err) {
                    ServletUtil.logServerAccess(400, 0L);
                    res.sendError(400, "BoundingBox parameter must be 'north,south,west,east'");
                    return;
                }
            } else {
                boolean haveSome2;
                String northS = ServletUtil.getParameterIgnoreCase(req, "north");
                String southS = ServletUtil.getParameterIgnoreCase(req, "south");
                String eastS = ServletUtil.getParameterIgnoreCase(req, "west");
                String westS = ServletUtil.getParameterIgnoreCase(req, "east");
                boolean bl = haveSome2 = northS != null && northS.trim().length() > 0 || southS != null && southS.trim().length() > 0 || eastS != null && eastS.trim().length() > 0 || westS != null && westS.trim().length() > 0;
                if (haveSome2) {
                    boolean haveAll;
                    boolean err = false;
                    boolean bl2 = haveAll = northS != null && northS.trim().length() > 0 && southS != null && southS.trim().length() > 0 && eastS != null && eastS.trim().length() > 0 && westS != null && westS.trim().length() > 0;
                    if (!haveAll) {
                        err = true;
                    } else {
                        try {
                            north = Double.parseDouble(northS);
                            south = Double.parseDouble(southS);
                            west = Double.parseDouble(eastS);
                            east = Double.parseDouble(westS);
                            LatLonRect maxBB = fmr.getBB();
                            hasBB = null == maxBB ? true : !Misc.closeEnough((double)north, (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)south, (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)east, (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)west, (double)maxBB.getLowerLeftPoint().getLongitude());
                        }
                        catch (NumberFormatException e) {
                            err = true;
                        }
                    }
                    if (err) {
                        ServletUtil.logServerAccess(400, 0L);
                        res.sendError(400, "Must have valid north, south, west, east parameters");
                        return;
                    }
                }
            }
            LatLonRect llbb = hasBB ? new LatLonRect((LatLonPoint)new LatLonPointImpl(south, west), (LatLonPoint)new LatLonPointImpl(north, east)) : null;
            boolean hasTimeRange = false;
            double time_start = -1.0;
            double time_end = -1.0;
            String startS = ServletUtil.getParameterIgnoreCase(req, "time_start");
            String endS = ServletUtil.getParameterIgnoreCase(req, "time_end");
            boolean bl = haveSome = startS != null && startS.trim().length() > 0 || endS != null && endS.trim().length() > 0;
            if (haveSome) {
                boolean haveAll;
                boolean err = false;
                boolean bl3 = haveAll = startS != null && startS.trim().length() > 0 && endS != null && endS.trim().length() > 0;
                if (!haveAll) {
                    err = true;
                } else {
                    time_start = Double.parseDouble(startS);
                    time_end = Double.parseDouble(endS);
                    hasTimeRange = true;
                }
                if (err) {
                    ServletUtil.logServerAccess(400, 0L);
                    res.sendError(400, "Must have time_start and time_end parameters as offsets in hours");
                    return;
                }
            }
            boolean hasStride = false;
            int stride_xy = -1;
            String s = ServletUtil.getParameterIgnoreCase(req, "stride_xy");
            if (s != null) {
                try {
                    stride_xy = Integer.parseInt(s);
                    hasStride = true;
                }
                catch (NumberFormatException e) {
                    ServletUtil.logServerAccess(400, 0L);
                    res.sendError(400, "stride_xy must have valid integer argument");
                    if (null != fmr) {
                        try {
                            fmr.close();
                        }
                        catch (IOException ioe) {
                            this.log.error("Failed to close = " + pathInfo);
                        }
                    }
                    return;
                }
            }
            int stride_z = -1;
            s = ServletUtil.getParameterIgnoreCase(req, "stride_z");
            if (s != null) {
                try {
                    stride_z = Integer.parseInt(s);
                    hasStride = true;
                }
                catch (NumberFormatException e) {
                    ServletUtil.logServerAccess(400, 0L);
                    res.sendError(400, "stride_z must have valid integer argument");
                    if (null != fmr) {
                        try {
                            fmr.close();
                        }
                        catch (IOException ioe) {
                            this.log.error("Failed to close = " + pathInfo);
                        }
                    }
                    return;
                }
            }
            int stride_time = -1;
            s = ServletUtil.getParameterIgnoreCase(req, "stride_time");
            if (s != null) {
                try {
                    stride_time = Integer.parseInt(s);
                    hasStride = true;
                }
                catch (NumberFormatException e) {
                    ServletUtil.logServerAccess(400, 0L);
                    res.sendError(400, "stride_time must have valid integer argument");
                    if (null != fmr) {
                        try {
                            fmr.close();
                        }
                        catch (IOException ioe) {
                            this.log.error("Failed to close = " + pathInfo);
                        }
                    }
                    return;
                }
            }
            boolean addLatLon = ServletUtil.getParameterIgnoreCase(req, "addLatLon") != null;
            try {
                this.sendFile(req, res, gds, varList, llbb, hasTimeRange, time_start, time_end, addLatLon, stride_xy, stride_z, stride_time);
            }
            catch (InvalidRangeException e) {
                ServletUtil.logServerAccess(400, 0L);
                res.sendError(400, "Invalid Lat/Lon or Time Range");
            }
        }
        catch (FileNotFoundException e) {
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404, "File not found");
        }
        catch (IOException ioe) {
            ServletUtil.logServerAccess(400, 0L);
            res.sendError(400, "Invalid Request");
        }
        finally {
            if (null != fmr) {
                try {
                    fmr.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + pathInfo);
                }
            }
        }
    }

    private void sendFile(HttpServletRequest req, HttpServletResponse res, GridDataset gds, List gridList, LatLonRect llbb, boolean hasTime, double time_start, double time_end, boolean addLatLon, int stride_xy, int stride_z, int stride_time) throws IOException, InvalidRangeException {
        NetcdfDataset ncd = (NetcdfDataset)gds.getNetcdfFile();
        ArrayList<Variable> varList = new ArrayList<Variable>();
        ArrayList<String> varNameList = new ArrayList<String>();
        for (int i = 0; i < gridList.size(); ++i) {
            ProjectionImpl proj;
            String gridName = (String)gridList.get(i);
            if (varNameList.contains(gridName)) continue;
            varNameList.add(gridName);
            GridDatatype grid = gds.findGridDatatype(gridName);
            GridCoordSystem gcsOrg = grid.getCoordinateSystem();
            Range timeRange = null;
            if (hasTime) {
                CoordinateAxis1DTime timeAxis = gcsOrg.getTimeAxis1D();
                int startIndex = timeAxis.findCoordElement(time_start);
                int endIndex = timeAxis.findCoordElement(time_end);
                timeRange = new Range(startIndex, endIndex);
            }
            if (llbb != null || null != timeRange) {
                grid = grid.makeSubset(timeRange, null, llbb, 1, 1, 1);
            }
            Variable gridV = (Variable)grid.getVariable();
            varList.add(gridV);
            GridCoordSystem gcs = grid.getCoordinateSystem();
            List axes = gcs.getCoordinateAxes();
            for (int j = 0; j < axes.size(); ++j) {
                Variable axis = (Variable)axes.get(j);
                if (varNameList.contains(axis.getName())) continue;
                varNameList.add(axis.getName());
                varList.add(axis);
            }
            List ctList = gcs.getCoordinateTransforms();
            for (int j = 0; j < ctList.size(); ++j) {
                CoordinateTransform ct = (CoordinateTransform)ctList.get(j);
                Variable v = ncd.findVariable(ct.getName());
                if (varNameList.contains(ct.getName()) || null == v) continue;
                varNameList.add(ct.getName());
                varList.add(v);
            }
            if (!addLatLon || null == (proj = gcs.getProjection()) || proj instanceof LatLonProjection) continue;
            this.addLatLon2D((NetcdfFile)ncd, varList, (Projection)proj, gcs.getXHorizAxis(), gcs.getYHorizAxis());
            addLatLon = false;
        }
        String filename = req.getRequestURI();
        int pos = filename.lastIndexOf("/");
        if (!(filename = filename.substring(pos + 1)).endsWith(".nc")) {
            filename = filename + ".nc";
        }
        Random random = new Random(System.currentTimeMillis());
        int randomInt = random.nextInt();
        String pathname = Integer.toString(randomInt) + "/" + filename;
        File ncFile = this.diskCache.getCacheFile(pathname);
        String cacheFilename = ncFile.getPath();
        String url = "/thredds/ncServer/cache/" + pathname;
        try {
            FileWriter writer = new FileWriter(cacheFilename, true);
            writer.writeVariables(varList);
            String location = gds.getNetcdfFile().getLocation();
            writer.writeGlobalAttribute(new Attribute("History", "GridDatatype extracted from dataset " + location));
            List gatts = ncd.getGlobalAttributes();
            for (int i = 0; i < gatts.size(); ++i) {
                Attribute att = (Attribute)gatts.get(i);
                writer.writeGlobalAttribute(att);
            }
            writer.finish();
        }
        catch (IOException ioe) {
            this.log.error("Writing to " + cacheFilename, (Throwable)ioe);
            res.sendError(500, ioe.getMessage());
            return;
        }
        res.addHeader("Content-Location", url);
        res.setHeader("Content-Disposition", "attachment; filename=" + filename);
        ServletUtil.returnFile(this, "", cacheFilename, req, res, "application/x-netcdf");
    }

    private void addLatLon2D(NetcdfFile ncfile, List varList, Projection proj, CoordinateAxis xaxis, CoordinateAxis yaxis) throws IOException {
        double[] xData = (double[])xaxis.read().get1DJavaArray(Double.TYPE);
        double[] yData = (double[])yaxis.read().get1DJavaArray(Double.TYPE);
        Variable latVar = new Variable(ncfile, null, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions("y x");
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, null, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions("y x");
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                proj.projToLatLon((ProjectionPoint)projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory((Class)DataType.DOUBLE.getClassType(), (int[])new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory((Class)DataType.DOUBLE.getClassType(), (int[])new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        varList.add(latVar);
        varList.add(lonVar);
    }

    private void showForm(HttpServletResponse res, ForecastModelRunInventory fmr, boolean wantXml) throws IOException {
        String infoString;
        if (wantXml) {
            infoString = fmr.writeXML();
        } else {
            InputStream xslt = this.getXSLT("ncServerForm.xsl");
            Document doc = fmr.writeDocument();
            try {
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (Exception e) {
                this.log.error("ForecastModelRunServlet internal error", (Throwable)e);
                ServletUtil.logServerAccess(500, 0L);
                res.sendError(500, "ForecastModelRunServlet internal error");
                return;
            }
        }
        res.setContentLength(infoString.length());
        if (wantXml) {
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            res.setContentType("text/html; charset=iso-8859-1");
        }
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes());
        out.flush();
        ServletUtil.logServerAccess(200, infoString.length());
    }

    private InputStream getXSLT(String xslName) {
        String resource;
        Class<?> c = ((Object)((Object)this)).getClass();
        InputStream is = c.getResourceAsStream(resource = "/resources/xsl/" + xslName);
        if (null == is) {
            this.log.error("Cant load XSLT resource = " + resource);
        }
        return is;
    }
}

