/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import thredds.servlet.ServletUtil;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.StringUtil;

public class ParamParser {
    public StringBuffer errMessage;
    public ArrayList nameList;
    public LatLonRect llbb;
    public double time_start = -1.0;
    public double time_end = -1.0;
    public Date date_start;
    public Date date_end;

    public void parseNames(HttpServletRequest req, String paramName) {
        this.nameList = new ArrayList();
        String[] names = ServletUtil.getParameterValuesIgnoreCase(req, paramName);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                StringTokenizer stoke = new StringTokenizer(names[i], ";");
                while (stoke.hasMoreTokens()) {
                    String gridName = StringUtil.unescape((String)stoke.nextToken());
                    this.nameList.add(gridName);
                }
            }
        }
    }

    private void addMessage(String msg) {
        if (this.errMessage == null) {
            this.errMessage = new StringBuffer();
        }
        this.errMessage.append(msg);
    }

    public void parseBB(HttpServletRequest req, LatLonRect maxBB) {
        double east;
        double west;
        double south;
        double north;
        boolean hasBB;
        block13: {
            hasBB = false;
            north = 0.0;
            south = 0.0;
            west = 0.0;
            east = 0.0;
            String bb = ServletUtil.getParameterIgnoreCase(req, "bb");
            if (bb != null) {
                StringTokenizer stoke = new StringTokenizer(bb, ",");
                if (stoke.countTokens() != 4) {
                    this.addMessage("bb parameter must have 4 values: 'bb=north,south,west,east'");
                } else {
                    try {
                        north = Double.parseDouble(stoke.nextToken());
                        south = Double.parseDouble(stoke.nextToken());
                        west = Double.parseDouble(stoke.nextToken());
                        east = Double.parseDouble(stoke.nextToken());
                        if (null == maxBB) {
                            hasBB = true;
                            break block13;
                        }
                        hasBB = !Misc.closeEnough((double)north, (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)south, (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)east, (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)west, (double)maxBB.getLowerLeftPoint().getLongitude());
                    }
                    catch (NumberFormatException e) {
                        this.addMessage("bb parameter must have valid double values: 'bb=north,south,west,east'");
                    }
                }
            } else {
                boolean haveSome;
                String northS = ServletUtil.getParameterIgnoreCase(req, "north");
                String southS = ServletUtil.getParameterIgnoreCase(req, "south");
                String eastS = ServletUtil.getParameterIgnoreCase(req, "west");
                String westS = ServletUtil.getParameterIgnoreCase(req, "east");
                boolean bl = haveSome = northS != null && northS.trim().length() > 0 || southS != null && southS.trim().length() > 0 || eastS != null && eastS.trim().length() > 0 || westS != null && westS.trim().length() > 0;
                if (haveSome) {
                    boolean haveAll;
                    boolean bl2 = haveAll = northS != null && northS.trim().length() > 0 && southS != null && southS.trim().length() > 0 && eastS != null && eastS.trim().length() > 0 && westS != null && westS.trim().length() > 0;
                    if (!haveAll) {
                        this.addMessage("Must have all 4 north, south, west, east parameters");
                    } else {
                        try {
                            north = Double.parseDouble(northS);
                            south = Double.parseDouble(southS);
                            west = Double.parseDouble(eastS);
                            east = Double.parseDouble(westS);
                            hasBB = null == maxBB ? true : !Misc.closeEnough((double)north, (double)maxBB.getUpperRightPoint().getLatitude()) || !Misc.closeEnough((double)south, (double)maxBB.getLowerLeftPoint().getLatitude()) || !Misc.closeEnough((double)east, (double)maxBB.getUpperRightPoint().getLongitude()) || !Misc.closeEnough((double)west, (double)maxBB.getLowerLeftPoint().getLongitude());
                        }
                        catch (NumberFormatException e) {
                            this.addMessage("Must have valid (double) north, south, west, east parameters");
                        }
                    }
                }
            }
        }
        if (this.errMessage == null && hasBB) {
            this.llbb = new LatLonRect((LatLonPoint)new LatLonPointImpl(south, west), (LatLonPoint)new LatLonPointImpl(north, east));
        }
    }

    public void parseTimeRange(HttpServletRequest req) {
        boolean err = false;
        boolean hasTime = false;
        String startS = null;
        String endS = null;
        String time_range = ServletUtil.getParameterIgnoreCase(req, "time");
        if (time_range != null) {
            StringTokenizer stoke = new StringTokenizer(time_range, ",");
            if (stoke.countTokens() != 2) {
                err = true;
            } else {
                startS = stoke.nextToken();
                endS = stoke.nextToken();
                hasTime = true;
            }
        } else {
            startS = ServletUtil.getParameterIgnoreCase(req, "time_start");
            endS = ServletUtil.getParameterIgnoreCase(req, "time_end");
            boolean hasStart = startS != null && startS.trim().length() > 0;
            boolean hasEnd = endS != null && endS.trim().length() > 0;
            hasTime = hasStart && hasEnd;
            boolean bl = err = hasStart != hasEnd;
        }
        if (hasTime) {
            try {
                this.time_start = Double.parseDouble(startS);
                this.time_end = Double.parseDouble(endS);
            }
            catch (NumberFormatException e) {
                this.addMessage("Bad format for time_start and time_end parameters; must be doubles (offsets in hours)");
            }
        } else if (err) {
            this.addMessage("Must have time_start and time_end parameters as offsets in hours");
        }
    }

    public void parseDateRange(HttpServletRequest req, boolean required) {
        boolean err = false;
        boolean hasTime = false;
        String startS = null;
        String endS = null;
        String time_range = ServletUtil.getParameterIgnoreCase(req, "dates");
        if (time_range != null) {
            StringTokenizer stoke = new StringTokenizer(time_range, ",");
            if (stoke.countTokens() != 2) {
                err = true;
            } else {
                startS = stoke.nextToken();
                endS = stoke.nextToken();
                hasTime = true;
            }
        } else {
            startS = ServletUtil.getParameterIgnoreCase(req, "date_start");
            endS = ServletUtil.getParameterIgnoreCase(req, "date_end");
            boolean hasStart = startS != null && startS.trim().length() > 0;
            boolean hasEnd = endS != null && endS.trim().length() > 0;
            hasTime = hasStart && hasEnd;
            boolean bl = err = hasStart != hasEnd;
        }
        if (err || !hasTime && required) {
            this.addMessage("Must have date_start and date_end parameters as valid ISO date strings");
        } else if (hasTime) {
            DateFormatter formatter = new DateFormatter();
            this.date_start = formatter.getISODate(startS);
            this.date_end = formatter.getISODate(endS);
            if (null == this.date_start || null == this.date_end) {
                this.addMessage("Bad format for date_start and date_end parameters; must be valid ISO date strings");
            }
        }
    }
}

