/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.MDC;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.XMLEntityResolver;
import thredds.servlet.Debug;
import thredds.servlet.HtmlWriter;
import thredds.util.IO;
import ucar.unidata.io.FileCache;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil;

public class ServletUtil {
    private static Logger log;
    private static boolean isDebugInit;
    private static boolean isLogInit;
    public static final String CONTENT_TEXT = "text/plain; charset=iso-8859-1";
    private static volatile long logServerAccessId;
    private static String contextPath;
    private static String contentPath;

    public static void initDebugging(HttpServlet servlet) {
        if (isDebugInit) {
            return;
        }
        isDebugInit = true;
        ServletContext webapp = servlet.getServletContext();
        String debugOn = webapp.getInitParameter("DebugOn");
        if (debugOn != null) {
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Debug.set(toker.nextToken(), true);
            }
        }
    }

    public static void initLogging(HttpServlet servlet) {
        if (isLogInit) {
            return;
        }
        System.out.println("+++ServletUtil.initLogging");
        ServletContext servletContext = servlet.getServletContext();
        String logPath = ServletUtil.getContentPath(servlet) + "logs";
        File logPathFile = new File(logPath);
        if (!logPathFile.exists() && !logPathFile.mkdirs()) {
            throw new RuntimeException("Creation of logfile directory failed." + logPath);
        }
        System.setProperty("logdir", logPath);
        try {
            String log4Jconfig = servletContext.getInitParameter("log4j-init-file");
            if (log4Jconfig == null) {
                log4Jconfig = ServletUtil.getRootPath(servlet) + "WEB-INF/log4j.xml";
            }
            DOMConfigurator.configure((String)log4Jconfig);
            System.out.println("+++Log4j configured from file " + log4Jconfig);
        }
        catch (FactoryConfigurationError t) {
            t.printStackTrace();
        }
        log = LoggerFactory.getLogger(ServletUtil.class);
        isLogInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logServerAccessSetup(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        Class<ServletUtil> clazz = ServletUtil.class;
        synchronized (ServletUtil.class) {
            MDC.put((String)"ID", (Object)Long.toString(++logServerAccessId));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            MDC.put((String)"host", (Object)req.getRemoteHost());
            MDC.put((String)"ident", (Object)(session == null ? "-" : session.getId()));
            MDC.put((String)"userid", (Object)(req.getRemoteUser() != null ? req.getRemoteUser() : "-"));
            MDC.put((String)"startTime", (Object)new Long(System.currentTimeMillis()));
            String query = req.getQueryString();
            query = query != null ? "?" + query : "";
            StringBuffer request = new StringBuffer();
            request.append("\"").append(req.getMethod()).append(" ").append(req.getRequestURI()).append(query).append(" ").append(req.getProtocol()).append("\"");
            MDC.put((String)"request", (Object)request.toString());
            log.info("Remote host: " + req.getRemoteHost() + " - Request: " + request);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logServerSetup(String msg) {
        Class<ServletUtil> clazz = ServletUtil.class;
        synchronized (ServletUtil.class) {
            MDC.put((String)"ID", (Object)Long.toString(++logServerAccessId));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            MDC.put((String)"startTime", (Object)new Long(System.currentTimeMillis()));
            log.info(msg);
            return;
        }
    }

    public static void logServerAccess(int resCode, long resSizeInBytes) {
        long endTime = System.currentTimeMillis();
        long startTime = (Long)MDC.get((String)"startTime");
        long duration = endTime - startTime;
        log.info("Request Completed - " + resCode + " - " + resSizeInBytes + " - " + duration);
    }

    public static String getRootPath(HttpServlet servlet) {
        ServletContext sc = servlet.getServletContext();
        String rootPath = sc.getRealPath("/");
        rootPath = rootPath.replace('\\', '/');
        return rootPath;
    }

    public static String getPath(HttpServlet servlet, String path) {
        ServletContext sc = servlet.getServletContext();
        String spath = sc.getRealPath(path);
        spath = spath.replace('\\', '/');
        return spath;
    }

    public static String getContextPath() {
        return contextPath;
    }

    public static void setContextPath(HttpServlet servlet) {
        ServletContext servletContext = servlet.getServletContext();
        String tmpContextPath = servletContext.getInitParameter("ContextPath");
        if (tmpContextPath == null) {
            tmpContextPath = "thredds";
        }
        contextPath = "/" + tmpContextPath;
    }

    public static String getContentPath(HttpServlet servlet) {
        if (contentPath == null) {
            String tmpContentPath = "../../content" + ServletUtil.getContextPath() + "/";
            File cf = new File(ServletUtil.getRootPath(servlet) + tmpContentPath);
            try {
                contentPath = cf.getCanonicalPath() + "/";
                contentPath = contentPath.replace('\\', '/');
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return contentPath;
    }

    public static String getInitialContentPath(HttpServlet servlet) {
        return ServletUtil.getRootPath(servlet) + "WEB-INF/initialContent/";
    }

    public static String formFilename(String dirPath, String filePath) {
        if (dirPath == null || filePath == null) {
            return null;
        }
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return dirPath.endsWith("/") ? dirPath + filePath : dirPath + "/" + filePath;
    }

    public static void handleRequestForRawFile(String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        File rFile;
        if (path.indexOf("/../") != -1 || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            res.sendError(403, "Path cannot contain \"..\" directory.");
            ServletUtil.logServerAccess(403, -1L);
            return;
        }
        String upper = path.toUpperCase();
        if (upper.indexOf("WEB-INF") != -1 || upper.indexOf("META-INF") != -1) {
            res.sendError(403, "Path cannot contain \"WEB-INF\" or \"META-INF\".");
            ServletUtil.logServerAccess(403, -1L);
            return;
        }
        File regFile = null;
        File cFile = new File(ServletUtil.formFilename(ServletUtil.getContentPath(servlet), path));
        if (cFile.exists()) {
            if (cFile.isDirectory()) {
                if (!path.endsWith("/")) {
                    String newPath = req.getRequestURL().append("/").toString();
                    ServletUtil.sendPermanentRedirect(newPath, req, res);
                }
                if ((cFile = new File(cFile, "index.html")).exists() && !cFile.isDirectory()) {
                    regFile = cFile;
                }
            } else {
                regFile = cFile;
            }
        }
        if (regFile == null && (rFile = new File(ServletUtil.formFilename(ServletUtil.getRootPath(servlet), path))).exists()) {
            if (rFile.isDirectory()) {
                if (!path.endsWith("/")) {
                    String newPath = req.getRequestURL().append("/").toString();
                    ServletUtil.sendPermanentRedirect(newPath, req, res);
                }
                if ((rFile = new File(rFile, "index.html")).exists() && !rFile.isDirectory()) {
                    regFile = rFile;
                }
            } else {
                regFile = rFile;
            }
        }
        if (regFile == null) {
            res.sendError(404);
            ServletUtil.logServerAccess(404, -1L);
            return;
        }
        ServletUtil.returnFile(servlet, req, res, regFile, null);
    }

    public static void handleRequestForContentFile(String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletUtil.handleRequestForContentOrRootFile("/content/", path, servlet, req, res);
    }

    public static void handleRequestForRootFile(String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletUtil.handleRequestForContentOrRootFile("/root/", path, servlet, req, res);
    }

    private static void handleRequestForContentOrRootFile(String pathPrefix, String path, HttpServlet servlet, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!pathPrefix.equals("/content/") && !pathPrefix.equals("/root/")) {
            log.error("handleRequestForContentFile(): The path prefix <" + pathPrefix + "> must be \"/content/\" or \"/root/\".");
            throw new IllegalArgumentException("Path prefix must be \"/content/\" or \"/root/\".");
        }
        if (!path.startsWith(pathPrefix)) {
            log.error("handleRequestForContentFile(): path <" + path + "> must start with \"" + pathPrefix + "\".");
            throw new IllegalArgumentException("Path must start with \"" + pathPrefix + "\".");
        }
        if (path.indexOf("/../") != -1 || path.equals("..") || path.startsWith("../") || path.endsWith("/..")) {
            res.sendError(403, "Path cannot contain \"..\" directory.");
            ServletUtil.logServerAccess(403, -1L);
            return;
        }
        File file = new File(ServletUtil.formFilename(ServletUtil.getContentPath(servlet), path.substring(pathPrefix.length() - 1)));
        if (file.exists()) {
            if (file.isDirectory()) {
                if (!path.endsWith("/")) {
                    String redirectPath = req.getRequestURL().append("/").toString();
                    ServletUtil.sendPermanentRedirect(redirectPath, req, res);
                    return;
                }
                HtmlWriter.getInstance().writeDirectory(res, file, path);
                return;
            }
            ServletUtil.returnFile(servlet, req, res, file, null);
        } else {
            ServletUtil.logServerAccess(404, -1L);
            res.sendError(404);
        }
    }

    public static void sendPermanentRedirect(String targetPath, HttpServletRequest req, HttpServletResponse res) throws IOException {
        URI uri = null;
        try {
            uri = new URI(req.getRequestURL().toString());
        }
        catch (URISyntaxException e) {
            log.error("sendPermanentRedirect(): Bad syntax on request URL <" + req.getRequestURL() + ">.", (Throwable)e);
            ServletUtil.logServerAccess(500, 0L);
            res.sendError(500);
            return;
        }
        String absolutePath = uri.resolve(targetPath).toString();
        absolutePath = res.encodeRedirectURL(absolutePath);
        res.setStatus(301);
        res.addHeader("Location", absolutePath);
        String title = "Permanently Moved - 301";
        String body = new StringBuffer().append("<p>").append("The requested URL <").append(req.getRequestURL()).append("> has been permanently moved (HTTP status code 301).").append(" Instead, please use the following URL: <a href=\"").append(absolutePath).append("\">").append(absolutePath).append("</a>.").append("</p>").toString();
        String htmlResp = new StringBuffer().append(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag()).append("<head><title>").append(title).append("</title></head><body>").append("<h1>").append(title).append("</h1>").append(body).append("</body></html>").toString();
        ServletUtil.logServerAccess(301, htmlResp.length());
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        out.print(htmlResp);
        out.flush();
    }

    public static void returnFile(HttpServlet servlet, String contentPath, String path, HttpServletRequest req, HttpServletResponse res, String contentType) throws IOException {
        String filename = ServletUtil.formFilename(contentPath, path);
        log.debug("returnFile(): returning file <" + filename + ">.");
        if (filename == null) {
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404);
            return;
        }
        if (filename.indexOf("..") != -1) {
            ServletUtil.logServerAccess(403, 0L);
            res.sendError(403);
            return;
        }
        String upper = filename.toUpperCase();
        if (upper.indexOf("WEB-INF") != -1 || upper.indexOf("META-INF") != -1) {
            ServletUtil.logServerAccess(403, 0L);
            res.sendError(403);
            return;
        }
        ServletUtil.returnFile(servlet, req, res, new File(filename), contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnFile(HttpServlet servlet, HttpServletRequest req, HttpServletResponse res, File file, String contentType) throws IOException {
        int pos2;
        int pos;
        if (file == null) {
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404);
            return;
        }
        if (!file.exists()) {
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404);
            return;
        }
        if (!file.isFile()) {
            ServletUtil.logServerAccess(400, 0L);
            res.sendError(400);
            return;
        }
        String filename = file.getPath();
        if (null == contentType && (contentType = filename.endsWith(".html") ? "text/html; charset=iso-8859-1" : (filename.endsWith(".xml") ? "text/xml; charset=iso-8859-1" : (filename.endsWith(".txt") || filename.endsWith(".log") ? CONTENT_TEXT : (filename.indexOf(".log.") > 0 ? CONTENT_TEXT : (filename.endsWith(".nc") ? "application/x-netcdf" : servlet.getServletContext().getMimeType(filename)))))) == null) {
            contentType = "application/octet-stream";
        }
        res.setContentType(contentType);
        boolean isRangeRequest = false;
        long startPos = 0L;
        long endPos = Long.MAX_VALUE;
        String rangeRequest = req.getHeader("Range");
        if (rangeRequest != null && (pos = rangeRequest.indexOf("=")) > 0 && (pos2 = rangeRequest.indexOf("-")) > 0) {
            String startString = rangeRequest.substring(pos + 1, pos2);
            String endString = rangeRequest.substring(pos2 + 1);
            startPos = Long.parseLong(startString);
            if (endString.length() > 0) {
                endPos = Long.parseLong(endString) + 1L;
            }
            isRangeRequest = true;
        }
        long fileSize = file.length();
        int contentLength = (int)fileSize;
        if (isRangeRequest) {
            endPos = Math.min(endPos, fileSize);
            contentLength = (int)(endPos - startPos);
        }
        res.setContentLength(contentLength);
        boolean debugRequest = Debug.isSet("returnFile");
        if (debugRequest) {
            log.debug("returnFile(): filename = " + filename + " contentType = " + contentType + " contentLength = " + file.length());
        }
        res.addHeader("Accept-Ranges", "bytes");
        if (req.getMethod().equals("HEAD")) {
            ServletUtil.logServerAccess(200, 0L);
            return;
        }
        try {
            if (isRangeRequest) {
                res.addHeader("Content-Range", "bytes " + startPos + "-" + (endPos - 1L) + "/" + fileSize);
                res.setStatus(206);
                RandomAccessFile raf = null;
                try {
                    raf = FileCache.acquire((String)filename);
                    IO.copyRafB((RandomAccessFile)raf, (long)startPos, (long)contentLength, (OutputStream)res.getOutputStream(), (byte[])new byte[60000]);
                    ServletUtil.logServerAccess(206, contentLength);
                    return;
                }
                finally {
                    if (raf != null) {
                        FileCache.release((RandomAccessFile)raf);
                    }
                }
            }
            ServletOutputStream out = res.getOutputStream();
            IO.copyFileB((File)file, (OutputStream)out, (int)60000);
            res.flushBuffer();
            out.close();
            if (debugRequest) {
                log.debug("returnFile(): returnFile ok = " + filename);
            }
            ServletUtil.logServerAccess(200, contentLength);
        }
        catch (FileNotFoundException e) {
            log.error("returnFile(): FileNotFoundException= " + filename);
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404);
        }
        catch (SocketException e) {
            log.info("returnFile(): SocketException sending file: " + filename + " " + e.getMessage());
            ServletUtil.logServerAccess(1000, 0L);
        }
        catch (IOException e) {
            String eName = e.getClass().getName();
            if (eName.equals("org.apache.catalina.connector.ClientAbortException")) {
                log.info("returnFile(): ClientAbortException while sending file: " + filename + " " + e.getMessage());
                ServletUtil.logServerAccess(1000, 0L);
                return;
            }
            log.error("returnFile(): IOException (" + e.getClass().getName() + ") sending file ", (Throwable)e);
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404, "Problem sending file: " + e.getMessage());
        }
    }

    public static void returnString(String contents, HttpServletResponse res) throws IOException {
        try {
            ServletOutputStream out = res.getOutputStream();
            IO.copy((InputStream)new ByteArrayInputStream(contents.getBytes()), (OutputStream)out);
            ServletUtil.logServerAccess(200, contents.length());
        }
        catch (IOException e) {
            log.error(" IOException sending string: ", (Throwable)e);
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404, "Problem sending string: " + e.getMessage());
        }
    }

    public static String getReletiveURL(HttpServletRequest req) {
        return req.getContextPath() + req.getServletPath() + req.getPathInfo();
    }

    public static void forwardToCatalogServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String reqs = "catalog=" + ServletUtil.getReletiveURL(req);
        String query = req.getQueryString();
        if (query != null) {
            reqs = reqs + "&" + query;
        }
        log.info("forwardToCatalogServices(): request string = \"/catalog.html?" + reqs + "\"");
        RequestDispatcher dispatch = req.getRequestDispatcher("/catalog.html?" + reqs);
        if (dispatch != null) {
            dispatch.forward((ServletRequest)req, (ServletResponse)res);
        } else {
            res.sendError(404);
        }
        ServletUtil.logServerAccess(404, 0L);
    }

    public static boolean saveFile(HttpServlet servlet, String contentPath, String path, HttpServletRequest req, HttpServletResponse res) {
        boolean debugRequest = Debug.isSet("SaveFile");
        if (debugRequest) {
            log.debug(" saveFile(): path= " + path);
        }
        String filename = contentPath + path;
        File want = new File(filename);
        int version = ServletUtil.getBackupVersion(want.getParent(), want.getName());
        String fileSave = filename + "~" + version;
        File file = new File(filename);
        if (file.exists()) {
            try {
                IO.copyFile((String)filename, (String)fileSave);
            }
            catch (IOException e) {
                log.error("saveFile(): Unable to save copy of file " + filename + " to " + fileSave + "\n" + e.getMessage());
                return false;
            }
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
            IO.copy((InputStream)req.getInputStream(), (OutputStream)out);
            ((OutputStream)out).close();
            if (debugRequest) {
                log.debug("saveFile(): ok= " + filename);
            }
            res.setStatus(201);
            ServletUtil.logServerAccess(201, -1L);
            return true;
        }
        catch (IOException e) {
            log.error("saveFile(): Unable to PUT file " + filename + " to " + fileSave + "\n" + e.getMessage());
            return false;
        }
    }

    private static int getBackupVersion(String dirName, String fileName) {
        int maxN = 0;
        File dir = new File(dirName);
        if (!dir.exists()) {
            return -1;
        }
        String[] files = dir.list();
        if (null == files) {
            return -1;
        }
        for (int i = 0; i < files.length; ++i) {
            int pos;
            String name = files[i];
            if (name.indexOf(fileName) < 0 || (pos = name.indexOf(126)) < 0) continue;
            String ver = name.substring(pos + 1);
            int n = 0;
            try {
                n = Integer.parseInt(ver);
            }
            catch (NumberFormatException e) {
                log.error("Format Integer error on backup filename= " + ver);
            }
            maxN = Math.max(n, maxN);
        }
        return maxN + 1;
    }

    public static boolean copyDir(String fromDir, String toDir) throws IOException {
        File contentFile = new File(toDir + ".INIT");
        if (!contentFile.exists()) {
            IO.copyDirTree((String)fromDir, (String)toDir);
            contentFile.createNewFile();
            return true;
        }
        return false;
    }

    public static void handleException(Throwable t, HttpServletResponse res) {
        try {
            String message = t.getMessage();
            if (message == null) {
                message = "NULL message " + t.getClass().getName();
            }
            if (Debug.isSet("trustedMode")) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bs);
                t.printStackTrace(ps);
                message = new String(bs.toByteArray());
            }
            ServletUtil.logServerAccess(400, message.length());
            log.error("handleException", t);
            t.printStackTrace();
            if (!res.isCommitted()) {
                res.sendError(400, message);
            }
        }
        catch (IOException e) {
            log.error("handleException(): IOException", (Throwable)e);
            t.printStackTrace();
        }
    }

    public static void showServerInfo(HttpServlet servlet, PrintStream out) {
        out.println("Server Info");
        out.println(" getDocumentBuilderFactoryVersion(): " + XMLEntityResolver.getDocumentBuilderFactoryVersion());
        out.println();
        Properties sysp = System.getProperties();
        Enumeration<?> e = sysp.propertyNames();
        ArrayList<?> list = Collections.list(e);
        Collections.sort(list);
        out.println("System Properties:");
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            String value = System.getProperty(name);
            out.println("  " + name + " = " + value);
        }
        out.println();
    }

    public static void showServletInfo(HttpServlet servlet, PrintStream out) {
        String name;
        out.println("Servlet Info");
        out.println(" getServletName(): " + servlet.getServletName());
        out.println(" getRootPath(): " + ServletUtil.getRootPath(servlet));
        out.println(" Init Parameters:");
        Enumeration params = servlet.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name2 = (String)params.nextElement();
            out.println("  " + name2 + ": " + servlet.getInitParameter(name2));
        }
        out.println();
        ServletContext context = servlet.getServletContext();
        out.println("Context Info");
        try {
            out.println(" context.getResource('/'): " + context.getResource("/"));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        out.println(" context.getServerInfo(): " + context.getServerInfo());
        out.println("  name: " + ServletUtil.getServerInfoName(context.getServerInfo()));
        out.println("  version: " + ServletUtil.getServerInfoVersion(context.getServerInfo()));
        out.println(" context.getInitParameterNames():");
        params = context.getInitParameterNames();
        while (params.hasMoreElements()) {
            name = (String)params.nextElement();
            out.println("  " + name + ": " + context.getInitParameter(name));
        }
        out.println(" context.getAttributeNames():");
        params = context.getAttributeNames();
        while (params.hasMoreElements()) {
            name = (String)params.nextElement();
            out.println("  context.getAttribute(\"" + name + "\"): " + context.getAttribute(name));
        }
        out.println();
    }

    public static String getRequestParsed(HttpServletRequest req) {
        return req.getRequestURI() + " = " + req.getContextPath() + "(context), " + req.getServletPath() + "(servletPath), " + req.getPathInfo() + "(pathInfo), " + req.getQueryString() + "(query)";
    }

    public static String getRequestBase(HttpServletRequest req) {
        return req.getRequestURL().toString();
    }

    public static URI getRequestURI(HttpServletRequest req) {
        try {
            return new URI(ServletUtil.getRequestBase(req));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRequestPath(HttpServletRequest req) {
        StringBuffer buff = new StringBuffer();
        if (req.getServletPath() != null) {
            buff.append(req.getServletPath());
        }
        if (req.getPathInfo() != null) {
            buff.append(req.getPathInfo());
        }
        return buff.toString();
    }

    public static String getRequest(HttpServletRequest req) {
        String query = req.getQueryString();
        return ServletUtil.getRequestBase(req) + (query == null ? "" : "?" + req.getQueryString());
    }

    public static String getParameterIgnoreCase(HttpServletRequest req, String paramName) {
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equalsIgnoreCase(paramName)) continue;
            return req.getParameter(s);
        }
        return null;
    }

    public static String[] getParameterValuesIgnoreCase(HttpServletRequest req, String paramName) {
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equalsIgnoreCase(paramName)) continue;
            return req.getParameterValues(s);
        }
        return null;
    }

    public static String getFileURL(String filename) {
        filename = filename.replace('\\', '/');
        filename = StringUtil.replace((String)filename, (char)' ', (String)"+");
        return "file:" + filename;
    }

    public static String getFileURL2(String filename) {
        File f = new File(filename);
        try {
            return f.toURL().toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String showRequestDetail(HttpServlet servlet, HttpServletRequest req) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Request Info\n");
        sbuff.append(" req.getServerName(): " + req.getServerName() + "\n");
        sbuff.append(" req.getServerPort(): " + req.getServerPort() + "\n");
        sbuff.append(" req.getContextPath:" + req.getContextPath() + "\n");
        sbuff.append(" req.getServletPath:" + req.getServletPath() + "\n");
        sbuff.append(" req.getPathInfo:" + req.getPathInfo() + "\n");
        sbuff.append(" req.getQueryString:" + req.getQueryString() + "\n");
        sbuff.append(" req.getRequestURI:" + req.getRequestURI() + "\n");
        sbuff.append(" getRequestBase:" + ServletUtil.getRequestBase(req) + "\n");
        sbuff.append(" getRequest:" + ServletUtil.getRequest(req) + "\n");
        sbuff.append("\n");
        sbuff.append(" req.getPathTranslated:" + req.getPathTranslated() + "\n");
        String path = req.getPathTranslated();
        if (path != null && servlet != null) {
            ServletContext context = servlet.getServletContext();
            sbuff.append(" getMimeType:" + context.getMimeType(path) + "\n");
        }
        sbuff.append("\n");
        sbuff.append(" req.getScheme:" + req.getScheme() + "\n");
        sbuff.append(" req.getProtocol:" + req.getProtocol() + "\n");
        sbuff.append(" req.getMethod:" + req.getMethod() + "\n");
        sbuff.append("\n");
        sbuff.append(" req.getContentType:" + req.getContentType() + "\n");
        sbuff.append(" req.getContentLength:" + req.getContentLength() + "\n");
        sbuff.append(" req.getRemoteAddr():" + req.getRemoteAddr());
        try {
            sbuff.append(" getRemoteHost():" + InetAddress.getByName(req.getRemoteHost()).getHostName() + "\n");
        }
        catch (UnknownHostException e) {
            sbuff.append(" getRemoteHost():" + e.getMessage() + "\n");
        }
        sbuff.append(" getRemoteUser():" + req.getRemoteUser() + "\n");
        sbuff.append("\n");
        sbuff.append("Request Parameters:\n");
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                sbuff.append("  " + name + "  (" + i + "): " + values[i] + "\n");
            }
        }
        sbuff.append("\n");
        sbuff.append("Request Headers:\n");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                sbuff.append("  " + name + ": " + value + "\n");
            }
        }
        sbuff.append(" ------------------\n");
        return sbuff.toString();
    }

    public static String showRequestHeaders(HttpServletRequest req) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Request Headers:\n");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                sbuff.append("  " + name + ": " + value + "\n");
            }
        }
        return sbuff.toString();
    }

    public static void showSession(HttpServletRequest req, HttpServletResponse res, PrintStream out) {
        HttpSession session = req.getSession();
        Integer count = (Integer)session.getAttribute("snoop.count");
        count = count == null ? new Integer(1) : new Integer(count + 1);
        session.setAttribute("snoop.count", (Object)count);
        out.println(HtmlWriter.getInstance().getHtmlDoctypeAndOpenTag());
        out.println("<HEAD><TITLE>SessionSnoop</TITLE></HEAD>");
        out.println("<BODY><H1>Session Snoop</H1>");
        out.println("You've visited this page " + count + (count == 1 ? " time." : " times."));
        out.println("<P>");
        out.println("<H3>Here is your saved session data:</H3>");
        Enumeration atts = session.getAttributeNames();
        while (atts.hasMoreElements()) {
            String name = (String)atts.nextElement();
            out.println(name + ": " + session.getAttribute(name) + "<BR>");
        }
        out.println("<H3>Here are some vital stats on your session:</H3>");
        out.println("Session id: " + session.getId() + " <I>(keep it secret)</I><BR>");
        out.println("New session: " + session.isNew() + "<BR>");
        out.println("Timeout: " + session.getMaxInactiveInterval());
        out.println("<I>(" + session.getMaxInactiveInterval() / 60 + " minutes)</I><BR>");
        out.println("Creation time: " + session.getCreationTime());
        out.println("<I>(" + new Date(session.getCreationTime()) + ")</I><BR>");
        out.println("Last access time: " + session.getLastAccessedTime());
        out.println("<I>(" + new Date(session.getLastAccessedTime()) + ")</I><BR>");
        out.println("Requested session ID from cookie: " + req.isRequestedSessionIdFromCookie() + "<BR>");
        out.println("Requested session ID from URL: " + req.isRequestedSessionIdFromURL() + "<BR>");
        out.println("Requested session ID valid: " + req.isRequestedSessionIdValid() + "<BR>");
        out.println("<H3>Test URL Rewriting</H3>");
        out.println("Click <A HREF=\"" + res.encodeURL(req.getRequestURI()) + "\">here</A>");
        out.println("to test that session tracking works via URL");
        out.println("rewriting even when cookies aren't supported.");
        out.println("</BODY></HTML>");
    }

    public static void showSession(HttpServletRequest req, PrintStream out) {
        HttpSession session = req.getSession();
        out.println("Session id: " + session.getId());
        out.println(" session.isNew(): " + session.isNew());
        out.println(" session.getMaxInactiveInterval(): " + session.getMaxInactiveInterval() + " secs");
        out.println(" session.getCreationTime(): " + session.getCreationTime() + " (" + new Date(session.getCreationTime()) + ")");
        out.println(" session.getLastAccessedTime(): " + session.getLastAccessedTime() + " (" + new Date(session.getLastAccessedTime()) + ")");
        out.println(" req.isRequestedSessionIdFromCookie: " + req.isRequestedSessionIdFromCookie());
        out.println(" req.isRequestedSessionIdFromURL: " + req.isRequestedSessionIdFromURL());
        out.println(" req.isRequestedSessionIdValid: " + req.isRequestedSessionIdValid());
        out.println("Saved session Attributes:");
        Enumeration atts = session.getAttributeNames();
        while (atts.hasMoreElements()) {
            String name = (String)atts.nextElement();
            out.println(" " + name + ": " + session.getAttribute(name) + "<BR>");
        }
    }

    public static String showSecurity(HttpServletRequest req, String role) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Security Info\n");
        sbuff.append(" req.getRemoteUser(): " + req.getRemoteUser() + "\n");
        sbuff.append(" req.getUserPrincipal(): " + req.getUserPrincipal() + "\n");
        sbuff.append(" req.isUserInRole(" + role + "):" + req.isUserInRole(role) + "\n");
        sbuff.append(" ------------------\n");
        return sbuff.toString();
    }

    private static String getServerInfoName(String serverInfo) {
        int slash = serverInfo.indexOf(47);
        if (slash == -1) {
            return serverInfo;
        }
        return serverInfo.substring(0, slash);
    }

    private static String getServerInfoVersion(String serverInfo) {
        int slash = serverInfo.indexOf(47);
        if (slash == -1) {
            return null;
        }
        int space = serverInfo.indexOf(32, slash);
        if (space == -1) {
            space = serverInfo.length();
        }
        return serverInfo.substring(slash + 1, space);
    }

    public static void showThreads(PrintStream pw) {
        Thread current = Thread.currentThread();
        ThreadGroup group = current.getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        ServletUtil.showThreads(pw, group, current);
    }

    private static void showThreads(PrintStream pw, ThreadGroup g, Thread current) {
        int nthreads = g.activeCount();
        pw.println("\nThread Group = " + g.getName() + " activeCount= " + nthreads);
        Thread[] tarray = new Thread[nthreads];
        int n = g.enumerate(tarray, false);
        for (int i = 0; i < n; ++i) {
            Thread thread = tarray[i];
            ClassLoader loader = thread.getContextClassLoader();
            String loaderName = loader == null ? "Default" : loader.getClass().getName();
            Thread.State state = thread.getState();
            long id = thread.getId();
            pw.print("   " + id + " " + thread.getName() + " " + (Object)((Object)state) + " " + loaderName);
            if (thread == current) {
                pw.println(" **** CURRENT ***");
                continue;
            }
            pw.println();
        }
        int ngroups = g.activeGroupCount();
        ThreadGroup[] garray = new ThreadGroup[ngroups];
        int ng = g.enumerate(garray, false);
        for (int i = 0; i < ng; ++i) {
            ThreadGroup nested = garray[i];
            ServletUtil.showThreads(pw, nested, current);
        }
    }

    public static void main(String[] args) {
        String s = "C:/Program Files/you";
        System.out.println("FileURL = " + ServletUtil.getFileURL(s));
        System.out.println("FileURL2 = " + ServletUtil.getFileURL2(s));
    }

    static {
        isDebugInit = false;
        isLogInit = false;
        logServerAccessId = 0L;
        contextPath = null;
        contentPath = null;
    }
}

