/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ViewServlet;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.RuntimeConfigParser;

public class ThreddsConfig {
    private static ServletContext _context;
    private static String _filename;
    private static Logger log;
    private static Element rootElem;
    private static ArrayList catalogRoots;

    static void init(ServletContext context, String filename, Logger log) {
        _context = context;
        _filename = filename;
        ThreddsConfig.readConfig(log);
    }

    static void readConfig(Logger log) {
        Document doc;
        catalogRoots = new ArrayList();
        File file = new File(_filename);
        if (!file.exists()) {
            return;
        }
        log.debug("ThreddsConfig: reading xml file = " + _filename);
        try {
            FileInputStream is = new FileInputStream(_filename);
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)is);
        }
        catch (IOException e) {
            log.error("ThreddsConfig: incorrectly formed xml file " + _filename, (Throwable)e);
            return;
        }
        catch (JDOMException e) {
            log.error("ThreddsConfig: incorrectly formed xml file " + _filename, (Throwable)e);
            return;
        }
        rootElem = doc.getRootElement();
        List rootList = rootElem.getChildren("catalogRoot");
        for (int j = 0; j < rootList.size(); ++j) {
            Element catrootElem = (Element)rootList.get(j);
            String location = catrootElem.getText().trim();
            if (location.length() <= 0) continue;
            catalogRoots.add(location);
            log.debug("ThreddsConfig: adding catalogRoot = " + location);
        }
        List viewerList = rootElem.getChildren("Viewer");
        for (int j = 0; j < viewerList.size(); ++j) {
            Element elem = (Element)viewerList.get(j);
            String className = elem.getText().trim();
            ViewServlet.registerViewer(className);
        }
        List sourceList = rootElem.getChildren("datasetSource");
        for (int j = 0; j < sourceList.size(); ++j) {
            Element elem = (Element)sourceList.get(j);
            String className = elem.getText().trim();
            DatasetHandler.registerDatasetSource(className);
        }
        Element elem = rootElem.getChild("nj22Config");
        if (elem != null) {
            StringBuffer errlog = new StringBuffer();
            RuntimeConfigParser.read((Element)elem, (StringBuffer)errlog);
            if (errlog.length() > 0) {
                log.warn(errlog.toString());
            }
        }
    }

    static void getCatalogRoots(List extraList) {
        extraList.addAll(catalogRoots);
    }

    public static String get(String paramName, String defValue) {
        String s = ThreddsConfig.getParam(paramName);
        return s == null ? defValue : s;
    }

    public static boolean hasElement(String paramName) {
        Element elem = rootElem;
        if (elem == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(paramName, ".");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (null != (elem = elem.getChild(toke))) continue;
            return false;
        }
        return true;
    }

    public static boolean getBoolean(String paramName, boolean defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            return Boolean.valueOf(s);
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not a boolean: " + e.getMessage());
            return defValue;
        }
    }

    public static long getBytes(String paramName, long defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        String num = s;
        try {
            long factor = 1L;
            int pos = s.indexOf(32);
            if (pos > 0) {
                num = s.substring(0, pos);
                String units = s.substring(pos + 1).trim();
                char c = Character.toUpperCase(units.charAt(0));
                if (c == 'K') {
                    factor = 1000L;
                } else if (c == 'M') {
                    factor = 1000000L;
                } else if (c == 'G') {
                    factor = 1000000000L;
                } else if (c == 'T') {
                    factor = 1000000000000L;
                } else if (c == 'P') {
                    factor = 1000000000000000L;
                }
            }
            return factor * Long.parseLong(num);
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not a byte count: " + s + " " + e.getMessage());
            return defValue;
        }
    }

    public static int getInt(String paramName, int defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not an integer " + e.getMessage());
            return defValue;
        }
    }

    public static int getSeconds(String paramName, int defValue) {
        String s = ThreddsConfig.getParam(paramName);
        if (s == null) {
            return defValue;
        }
        try {
            TimeUnit tu = new TimeUnit(s);
            return (int)tu.getValueInSeconds();
        }
        catch (Exception e) {
            log.error("ThreddsConfig: param " + paramName + " not udunit time " + e.getMessage());
            return defValue;
        }
    }

    private static String getParam(String name) {
        Element elem = rootElem;
        if (elem == null) {
            return null;
        }
        StringTokenizer stoke = new StringTokenizer(name, ".");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (null != (elem = elem.getChild(toke))) continue;
            return null;
        }
        return elem.getText();
    }
}

