/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.servlet.AbstractServlet;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.Debug;
import thredds.servlet.DebugHandler;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.util.IO;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileCache;
import ucar.nc2.dataset.NetcdfDatasetCache;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationFmrc;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.io.FileCache;

public class ThreddsDefaultServlet
extends AbstractServlet {
    static String version = null;
    protected DataRootHandler catHandler;
    private Timer timer;
    private Logger cacheLog = LoggerFactory.getLogger((String)"cacheLogger");
    private DiskCache2 aggCache;

    protected String getPath() {
        return "";
    }

    protected String getContextName() {
        return "THREDDS Data Server";
    }

    protected String getDocsPath() {
        return "http://www.unidata.ucar.edu/projects/THREDDS/tech/TDS.html";
    }

    protected String getUserCssPath() {
        return "upc.css";
    }

    protected String getContextLogoPath() {
        return "thredds.jpg";
    }

    protected String getContextLogoAlt() {
        return "thredds";
    }

    protected String getInstituteLogoPath() {
        return "unidataLogo.gif";
    }

    protected String getInstituteLogoAlt() {
        return "unidata";
    }

    protected String getFolderIconPath() {
        return "folder.gif";
    }

    protected String getFolderIconAlt() {
        return "folder";
    }

    public void init() throws ServletException {
        super.init();
        super.initContent();
        String contextPath = ServletUtil.getContextPath();
        InvDatasetScan.setContext((String)contextPath);
        InvDatasetScan.setCatalogServletName((String)"/catalog");
        ThreddsConfig.init(this.getServletContext(), this.contentPath + "/threddsConfig.xml", this.log);
        if (ThreddsConfig.hasElement("Logging")) {
            String datePattern = ThreddsConfig.get("Logging.DatePattern", null);
            long maxFileSize = ThreddsConfig.getBytes("Logging.MaxFileSize", -1L);
            int maxFiles = ThreddsConfig.getInt("Logging.MaxFiles", 5);
            this.changeLogs(datePattern, maxFileSize, maxFiles);
        }
        int min = ThreddsConfig.getInt("NetcdfFileCache.minFiles", 200);
        int max = ThreddsConfig.getInt("NetcdfFileCache.maxFiles", 400);
        int secs = ThreddsConfig.getSeconds("NetcdfFileCache.scour", 600);
        if (max > 0) {
            NetcdfFileCache.init((int)min, (int)max, (long)secs);
        }
        min = ThreddsConfig.getInt("NetcdfDatasetCache.minFiles", 100);
        max = ThreddsConfig.getInt("NetcdfDatasetCache.maxFiles", 200);
        secs = ThreddsConfig.getSeconds("NetcdfDatasetCache.scour", 600);
        if (max > 0) {
            NetcdfDatasetCache.init((int)min, (int)max, (long)secs);
        }
        min = ThreddsConfig.getInt("HTTPFileCache.minFiles", 25);
        max = ThreddsConfig.getInt("HTTPFileCache.maxFiles", 40);
        secs = ThreddsConfig.getSeconds("HTTPFileCache.scour", 600);
        if (max > 0) {
            FileCache.init((int)min, (int)max, (long)secs);
        }
        boolean extendIndex = ThreddsConfig.getBoolean("GribIndexing.setExtendIndex", false);
        GribServiceProvider.setExtendIndex((boolean)extendIndex);
        boolean alwaysUseCache = ThreddsConfig.getBoolean("GribIndexing.alwaysUseCache", false);
        GribServiceProvider.setIndexAlwaysInCache((boolean)alwaysUseCache);
        NetcdfFile.setProperty((String)"syncExtendOnly", (String)"true");
        String dir = ThreddsConfig.get("AggregationCache.dir", this.contentPath + "cacheAged/");
        int scourSecs = ThreddsConfig.getSeconds("AggregationCache.scour", 86400);
        int maxAgeSecs = ThreddsConfig.getSeconds("AggregationCache.maxAge", 2592000);
        this.aggCache = new DiskCache2(dir, false, maxAgeSecs / 60, scourSecs / 60);
        Aggregation.setPersistenceCache((DiskCache2)this.aggCache);
        String typicalDataset = ThreddsConfig.get("Aggregation.typicalDataset", null);
        if (null != typicalDataset) {
            Aggregation.setTypicalDatasetMode((String)typicalDataset);
        }
        AggregationFmrc.setDefinitionDirectory((String)(this.rootPath + "idd/modelInventory/"));
        DataRootHandler.init(this.contentPath, contextPath);
        this.catHandler = DataRootHandler.getInstance();
        this.catHandler.registerConfigListener(new RestrictedAccessConfigListener());
        this.initCatalogs();
        this.catHandler.makeDebugActions();
        DatasetHandler.makeDebugActions();
        this.getVersion();
        dir = ThreddsConfig.get("DiskCache.dir", this.contentPath + "cache/");
        boolean alwaysUse = ThreddsConfig.getBoolean("DiskCache.alwaysUse", false);
        scourSecs = ThreddsConfig.getSeconds("DiskCache.scour", 3600);
        long maxSize = ThreddsConfig.getBytes("DiskCache.maxSize", 1000000000L);
        DiskCache.setRootDirectory((String)dir);
        DiskCache.setCachePolicy((boolean)alwaysUse);
        Calendar c = Calendar.getInstance();
        this.timer = new Timer("ThreddsDefaultServlet.scheduler");
        this.timer.scheduleAtFixedRate((TimerTask)new CacheScourTask(maxSize), c.getTime(), 1000L * (long)scourSecs);
        HtmlWriter.init(contextPath, this.getContextName(), this.getVersion(), this.getDocsPath(), this.getUserCssPath(), this.getContextLogoPath(), this.getContextLogoAlt(), this.getInstituteLogoPath(), this.getInstituteLogoAlt(), this.getFolderIconPath(), this.getFolderIconAlt());
        this.cacheLog.info("Restarted");
        this.log.info("init(): done initializing <context= " + contextPath + ">.");
    }

    public void destroy() {
        this.timer.cancel();
        NetcdfFileCache.exit();
        NetcdfDatasetCache.exit();
        FileCache.exit();
        this.aggCache.exit();
    }

    void initCatalogs() {
        ArrayList<String> catList = new ArrayList<String>();
        catList.add("catalog.xml");
        this.getExtraCatalogs(catList);
        this.catHandler.initCatalogs(catList);
    }

    private void getExtraCatalogs(List extraList) {
        ThreddsConfig.getCatalogRoots(extraList);
        if (extraList.size() > 0) {
            return;
        }
        File file = new File(this.contentPath + "extraCatalogs.txt");
        if (file.exists()) {
            try {
                String line;
                FileInputStream fin = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    extraList.add(line);
                }
                fin.close();
            }
            catch (IOException e) {
                this.log.error("Error on getExtraCatalogs ", (Throwable)e);
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        try {
            String path = ServletUtil.getRequestPath(req);
            if (Debug.isSet("showRequest")) {
                System.out.println("**ThreddsDefault GET req=" + ServletUtil.getRequest(req) + " path= " + path);
            }
            if (Debug.isSet("showRequestDetail")) {
                System.out.println("**ThreddsDefault GET req=" + ServletUtil.showRequestDetail(this, req));
            }
            if (path == null || path.equals("/")) {
                String newPath = ServletUtil.getContextPath() + "/catalog.html";
                res.sendRedirect(newPath);
                return;
            }
            if (path.startsWith("/dataDir/")) {
                File file = this.getMappedFile(path = path.substring(9));
                if (file != null && file.exists() && file.isDirectory()) {
                    HtmlWriter.getInstance().writeDirectory(res, file, path);
                } else {
                    res.sendError(404);
                }
                ServletUtil.logServerAccess(404, 0L);
                return;
            }
            if (!path.startsWith("/content/")) {
                if (this.catHandler.processReqForCatalog(req, res)) {
                    return;
                }
                if (path.endsWith("/") && this.getStaticFile(req) == null) {
                    ServletUtil.forwardToCatalogServices(req, res);
                    return;
                }
            }
            if (path.equals("/debug") || path.equals("/debug/")) {
                DebugHandler.doDebug(this, req, res);
                return;
            }
            if (path.equals("/catalogWait.xml")) {
                this.log.debug("sleep 10 secs");
                Thread.sleep(10000L);
                path = "/catalog.xml";
            }
            if (path.equals("/testSessions") || path.equals("/testSecurity")) {
                System.out.println(ServletUtil.showRequestDetail(this, req));
                ServletUtil.showSession(req, System.out);
                return;
            }
            File staticFile = this.getStaticFile(req);
            if (staticFile == null) {
                ServletUtil.logServerAccess(404, 0L);
                res.sendError(404);
                return;
            }
            if (staticFile.isDirectory()) {
                if (!path.endsWith("/")) {
                    String newPath = req.getRequestURI() + "/";
                    res.sendRedirect(newPath);
                    return;
                }
                File indexFile = new File(staticFile, "index.html");
                if (indexFile.exists()) {
                    staticFile = indexFile;
                } else {
                    HtmlWriter.getInstance().writeDirectory(res, staticFile, path);
                    return;
                }
            }
            ServletUtil.returnFile(this, req, res, staticFile, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.log.error("doGet req= " + ServletUtil.getRequest(req) + " got Exception", t);
            ServletUtil.handleException(t, res);
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        File staticFile = this.getStaticFile(req);
        if (staticFile == null) {
            return -1L;
        }
        return staticFile.lastModified();
    }

    private File getStaticFile(HttpServletRequest req) {
        File file;
        String filename;
        String path = req.getPathInfo();
        if (path == null) {
            return null;
        }
        boolean explicit = false;
        if (path.startsWith("/root/")) {
            explicit = true;
            path = path.substring(5);
            filename = ServletUtil.formFilename(this.rootPath, path);
        } else if (path.startsWith("/content/")) {
            explicit = true;
            path = path.substring(8);
            filename = ServletUtil.formFilename(this.contentPath, path);
        } else {
            filename = ServletUtil.formFilename(this.contentPath + "public/", path);
            if (filename != null && (file = new File(filename)).exists()) {
                return file;
            }
            filename = ServletUtil.formFilename(this.rootPath, path);
        }
        if (filename == null) {
            return null;
        }
        if (!explicit) {
            if (path.endsWith("catalog.html") || path.endsWith("catalog.xml")) {
                return null;
            }
            String upper = filename.toUpperCase();
            if (upper.indexOf("WEB-INF") != -1 || upper.indexOf("META-INF") != -1) {
                return null;
            }
        }
        if ((file = new File(filename)).exists()) {
            return file;
        }
        return null;
    }

    private File getMappedFile(String path) {
        if (path == null) {
            return null;
        }
        File file = this.catHandler.getCrawlableDatasetAsFile(path);
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        String path = ServletUtil.getRequestPath(req);
        if (Debug.isSet("showRequest")) {
            this.log.debug("ThreddsDefault PUT path= " + path);
        }
        if (!path.startsWith("/content")) {
            ServletUtil.logServerAccess(403, 0L);
            res.sendError(403);
            return;
        }
        path = path.substring(8);
        if (path != null && ServletUtil.saveFile(this, this.contentPath, path, req, res)) {
            ServletUtil.logServerAccess(200, 0L);
            return;
        }
        ServletUtil.logServerAccess(404, 0L);
        res.sendError(404);
    }

    static String getVersionStatic() {
        return version;
    }

    protected String getVersion() {
        if (version == null) {
            String readme;
            try {
                readme = IO.readFile((String)(this.rootPath + "docs/README.txt"));
            }
            catch (IOException e) {
                return "unknown version";
            }
            int pos = readme.indexOf(10);
            version = pos > 0 ? readme.substring(0, pos) : readme;
        }
        return version;
    }

    protected void makeCacheActions() {
        DebugHandler debugHandler = DebugHandler.get("Caches");
        DebugHandler.Action act = new DebugHandler.Action("showCaches", "Show All Caches"){

            public void doAction(DebugHandler.Event e) {
                Object o;
                int i;
                e.pw.println("NetcdfFileCache contents\n");
                List cacheList = NetcdfFileCache.getCache();
                for (i = 0; i < cacheList.size(); ++i) {
                    o = cacheList.get(i);
                    e.pw.println(" " + o);
                }
                e.pw.println("\nNetcdfDatasetCache contents");
                cacheList = NetcdfDatasetCache.getCache();
                for (i = 0; i < cacheList.size(); ++i) {
                    o = cacheList.get(i);
                    e.pw.println(" " + o);
                }
                e.pw.println("\nRAF Cache contents");
                cacheList = FileCache.getCache();
                for (i = 0; i < cacheList.size(); ++i) {
                    o = cacheList.get(i);
                    e.pw.println(" " + o);
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("clearCache", "Clear Caches"){

            public void doAction(DebugHandler.Event e) {
                NetcdfFileCache.clearCache((boolean)false);
                NetcdfDatasetCache.clearCache((boolean)false);
                FileCache.clearCache((boolean)false);
                e.pw.println("  ClearCache ok");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("forceNCCache", "Force clear NetcdfFileCache Cache"){

            public void doAction(DebugHandler.Event e) {
                NetcdfFileCache.clearCache((boolean)true);
                e.pw.println("  NetcdfFileCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("forceDSCache", "Force clear NetcdfDatasetCache Cache"){

            public void doAction(DebugHandler.Event e) {
                NetcdfDatasetCache.clearCache((boolean)true);
                e.pw.println("  NetcdfDatasetCache force clearCache done");
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("forceRAFCache", "Force clear RAF FileCache Cache"){

            public void doAction(DebugHandler.Event e) {
                FileCache.clearCache((boolean)true);
                e.pw.println("  RAF FileCache force clearCache done ");
            }
        };
        debugHandler.addAction(act);
    }

    protected void makeDebugActions() {
        DebugHandler debugHandler = DebugHandler.get("General");
        DebugHandler.Action act = new DebugHandler.Action("showVersion", "Show Build Version"){

            public void doAction(DebugHandler.Event e) {
                try {
                    IO.copyFile((String)(ThreddsDefaultServlet.this.rootPath + "docs/README.txt"), (OutputStream)e.pw);
                }
                catch (Exception ioe) {
                    e.pw.println(ioe.getMessage());
                }
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRuntime", "Show Runtime info"){

            public void doAction(DebugHandler.Event e) {
                Runtime runt = Runtime.getRuntime();
                double scale = 1.0E-6;
                e.pw.println(" freeMemory= " + scale * (double)runt.freeMemory() + " Mb");
                e.pw.println(" totalMemory= " + scale * (double)runt.totalMemory() + " Mb");
                e.pw.println(" maxMemory= " + scale * (double)runt.maxMemory() + " Mb");
                e.pw.println(" availableProcessors= " + runt.availableProcessors());
                e.pw.println();
                ServletUtil.showThreads(e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showFlags", "Show Debugging Flags"){

            public void doAction(DebugHandler.Event e) {
                ThreddsDefaultServlet.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("toggleFlag", null){

            public void doAction(DebugHandler.Event e) {
                if (e.target != null) {
                    String flag;
                    Debug.set(flag, !Debug.isSet(flag = e.target));
                } else {
                    e.pw.println(" Must be toggleFlag=<flagName>");
                }
                ThreddsDefaultServlet.this.showFlags(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showLoggers", "Show Log4J info"){

            public void doAction(DebugHandler.Event e) {
                ThreddsDefaultServlet.this.showLoggers(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("setLogger", null){

            public void doAction(DebugHandler.Event e) {
                if (e.target == null) {
                    e.pw.println(" Must be setLogger=loggerName");
                    return;
                }
                StringTokenizer stoker = new StringTokenizer(e.target, "&=");
                if (stoker.countTokens() < 3) {
                    e.pw.println(" Must be setLogger=loggerName&setLevel=levelName");
                    return;
                }
                String loggerName = stoker.nextToken();
                stoker.nextToken();
                String levelName = stoker.nextToken();
                boolean isRootLogger = loggerName.equals("root");
                if (!isRootLogger && LogManager.exists((String)loggerName) == null) {
                    e.pw.println(" Unknown logger=" + loggerName);
                    return;
                }
                if (Level.toLevel((String)levelName, null) == null) {
                    e.pw.println(" Unknown level=" + levelName);
                    return;
                }
                org.apache.log4j.Logger log = isRootLogger ? LogManager.getRootLogger() : LogManager.getLogger((String)loggerName);
                log.setLevel(Level.toLevel((String)levelName));
                e.pw.println(loggerName + " set to " + levelName);
                ThreddsDefaultServlet.this.showLoggers(e.req, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showRequest", "Show HTTP Request info"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println(ServletUtil.showRequestDetail(ThreddsDefaultServlet.this, e.req));
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showServerInfo", "Show Server info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showServerInfo(ThreddsDefaultServlet.this, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showServletInfo", "Show Servlet info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showServletInfo(ThreddsDefaultServlet.this, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSession", "Show HTTP Session info"){

            public void doAction(DebugHandler.Event e) {
                ServletUtil.showSession(e.req, e.res, e.pw);
            }
        };
        debugHandler.addAction(act);
        act = new DebugHandler.Action("showSecurity", "Show Security info"){

            public void doAction(DebugHandler.Event e) {
                e.pw.println(ServletUtil.showSecurity(e.req, "admin"));
            }
        };
        debugHandler.addAction(act);
        this.makeCacheActions();
        debugHandler = DebugHandler.get("catalogs");
        act = new DebugHandler.Action("reinit", "Reinitialize"){

            public void doAction(DebugHandler.Event e) {
                ThreddsDefaultServlet.this.catHandler.reinit();
                ThreddsConfig.readConfig(ThreddsDefaultServlet.this.log);
                ThreddsDefaultServlet.this.initCatalogs();
                e.pw.println("reinit ok");
            }
        };
        debugHandler.addAction(act);
    }

    void showFlags(HttpServletRequest req, PrintStream pw) {
        for (String key : Debug.keySet()) {
            String url = req.getRequestURI() + "?toggleFlag=" + key;
            pw.println("  <a href='" + url + "'>" + key + " = " + Debug.isSet(key) + "</a>");
        }
    }

    private void changeLogs(String datePattern, long maxFileSize, int maxFiles) {
        DailyRollingFileAppender newAppender;
        block5: {
            org.apache.log4j.Logger logger = LogManager.getLogger((String)"thredds");
            FileAppender fapp = (FileAppender)logger.getAppender("threddsServlet");
            PatternLayout playout = (PatternLayout)fapp.getLayout();
            String filename = fapp.getFile();
            newAppender = null;
            try {
                if (null != datePattern) {
                    newAppender = new DailyRollingFileAppender((Layout)playout, filename, datePattern);
                    break block5;
                }
                if (maxFileSize > 0L) {
                    RollingFileAppender rapp = new RollingFileAppender((Layout)playout, filename);
                    rapp.setMaximumFileSize(maxFileSize);
                    rapp.setMaxBackupIndex(maxFiles);
                    newAppender = rapp;
                    break block5;
                }
                return;
            }
            catch (IOException ioe) {
                this.log.error("Error changing the logger", (Throwable)ioe);
            }
        }
        org.apache.log4j.Logger root = LogManager.getRootLogger();
        this.replaceAppender(root, "threddsServlet", (Appender)newAppender);
        Enumeration logEnums = LogManager.getCurrentLoggers();
        while (logEnums.hasMoreElements()) {
            org.apache.log4j.Logger log = (org.apache.log4j.Logger)logEnums.nextElement();
            this.replaceAppender(log, "threddsServlet", (Appender)newAppender);
        }
    }

    private void replaceAppender(org.apache.log4j.Logger logger, String want, Appender replaceWith) {
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender app = (Appender)appenders.nextElement();
            if (!app.getName().equals(want)) continue;
            logger.removeAppender(app);
            logger.addAppender(replaceWith);
        }
    }

    void showLoggers(HttpServletRequest req, PrintStream pw) {
        org.apache.log4j.Logger root = LogManager.getRootLogger();
        this.showLogger(req, root, pw);
        Enumeration logEnums = LogManager.getCurrentLoggers();
        ArrayList<org.apache.log4j.Logger> loggersSorted = Collections.list(logEnums);
        Collections.sort(loggersSorted, new LoggerComparator());
        for (org.apache.log4j.Logger logger : loggersSorted) {
            this.showLogger(req, logger, pw);
        }
    }

    private void showLogger(HttpServletRequest req, org.apache.log4j.Logger logger, PrintStream pw) {
        pw.print(" logger = " + logger.getName() + " level= ");
        String url = req.getRequestURI() + "?setLogger=" + logger.getName() + "&level=";
        this.showLevel(url, Level.ALL, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.DEBUG, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.INFO, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.WARN, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.ERROR, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.FATAL, logger.getEffectiveLevel(), pw);
        this.showLevel(url, Level.OFF, logger.getEffectiveLevel(), pw);
        pw.println();
        Enumeration appenders = logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            AppenderSkeleton skapp;
            Appender app = (Appender)appenders.nextElement();
            pw.println("  appender= " + app.getName() + " " + app.getClass().getName());
            Layout layout = app.getLayout();
            if (layout instanceof PatternLayout) {
                PatternLayout playout = (PatternLayout)layout;
                pw.println("    layout pattern= " + playout.getConversionPattern());
            }
            if (app instanceof AppenderSkeleton && (skapp = (AppenderSkeleton)app).getThreshold() != null) {
                pw.println("    threshold=" + skapp.getThreshold());
            }
            if (!(app instanceof FileAppender)) continue;
            FileAppender fapp = (FileAppender)app;
            pw.println("    file=" + fapp.getFile());
        }
    }

    private void showLevel(String baseUrl, Level show, Level current, PrintStream pw) {
        if (show.toInt() != current.toInt()) {
            pw.print(" <a href='" + baseUrl + show + "'>" + show + "</a>");
        } else {
            pw.print(" " + show);
        }
    }

    private class RestrictedAccessConfigListener
    implements DataRootHandler.ConfigListener {
        volatile boolean initializing = false;

        public void configStart() {
            this.initializing = true;
        }

        public void configEnd() {
            this.initializing = false;
        }

        public void configCatalog(InvCatalog catalog) {
        }

        public void configDataset(InvDataset dataset) {
            if (dataset.getRestrictAccess() != null) {
                DatasetHandler.putResourceControl((InvDatasetImpl)dataset);
            }
        }
    }

    private class CacheScourTask
    extends TimerTask {
        long maxBytes;

        CacheScourTask(long maxBytes) {
            this.maxBytes = maxBytes;
        }

        public void run() {
            StringBuffer sbuff = new StringBuffer();
            DiskCache.cleanCache((long)this.maxBytes, (StringBuffer)sbuff);
            sbuff.append("----------------------\n");
            ThreddsDefaultServlet.this.cacheLog.info(sbuff.toString());
        }
    }

    private class LoggerComparator
    implements Comparator {
        private LoggerComparator() {
        }

        public int compare(Object o1, Object o2) {
            org.apache.log4j.Logger l1 = (org.apache.log4j.Logger)o1;
            org.apache.log4j.Logger l2 = (org.apache.log4j.Logger)o2;
            return l1.getName().compareTo(l2.getName());
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }
}

