/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class URLEncoder {
    protected static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected BitSet safeCharacters = new BitSet(256);

    public URLEncoder() {
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    public URLEncoder(String accept) {
        this();
        for (int i = 0; i < accept.length(); ++i) {
            char c = accept.charAt(i);
            this.addSafeCharacter(c);
        }
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public String encode(String path) {
        int maxBytesPerChar = 10;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

