/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.servlet.AbstractServlet;
import thredds.servlet.ServletUtil;
import thredds.servlet.Viewer;
import thredds.util.IO;
import ucar.unidata.util.StringUtil;

public class ViewServlet
extends AbstractServlet {
    private static Logger log = LoggerFactory.getLogger(ViewServlet.class);
    private static HashMap<String, String> templates = new HashMap();
    private static ArrayList<Viewer> viewerList = new ArrayList();

    public static void registerViewer(String className) {
        Object instance;
        Class<?> vClass;
        try {
            vClass = ViewServlet.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.error("Attempt to load Viewer class " + className + " not found");
            return;
        }
        if (!Viewer.class.isAssignableFrom(vClass)) {
            log.error("Attempt to load class " + className + " does not implement " + Viewer.class.getName());
            return;
        }
        try {
            instance = vClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Attempt to load Viewer class " + className + " cannot instantiate, probably need default Constructor.");
            return;
        }
        catch (IllegalAccessException e) {
            log.error("Attempt to load Viewer class " + className + " is not accessible.");
            return;
        }
        ViewServlet.registerViewer((Viewer)instance);
    }

    public static void registerViewer(Viewer v) {
        viewerList.add(v);
    }

    private static String getTemplate(String path) {
        String template = templates.get(path);
        if (template != null) {
            return template;
        }
        try {
            template = IO.readFile((String)path);
        }
        catch (IOException ioe) {
            return null;
        }
        templates.put(path, template);
        return template;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletUtil.logServerAccessSetup(req);
        String path = req.getPathInfo();
        int pos = path.lastIndexOf("/");
        String filename = "views/" + path.substring(pos + 1);
        log.debug("**ViewManager req= " + path + " look for " + this.rootPath + filename);
        String template = ViewServlet.getTemplate(this.rootPath + filename);
        if (template == null) {
            template = ViewServlet.getTemplate(this.contentPath + filename);
        }
        if (template == null) {
            ServletUtil.logServerAccess(404, 0L);
            res.sendError(404);
            return;
        }
        StringBuffer sbuff = new StringBuffer(template);
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String[] values = req.getParameterValues(name);
            if (values == null) continue;
            String sname = "{" + name + "}";
            for (String value : values) {
                StringUtil.substitute((StringBuffer)sbuff, (String)sname, (String)value);
            }
        }
        try {
            res.setContentType("application/x-java-jnlp-file");
            ServletUtil.returnString(sbuff.toString(), res);
        }
        catch (Throwable t) {
            log.error(" jnlp=" + sbuff.toString(), t);
            ServletUtil.logServerAccess(500, 0L);
            res.sendError(500);
        }
    }

    public static void showViewers(StringBuffer sbuff, InvDatasetImpl dataset, HttpServletRequest req) {
        int count = 0;
        for (Viewer viewer : viewerList) {
            if (!viewer.isViewable(dataset)) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        sbuff.append("<h3>Viewers:</h3><ul>\r\n");
        for (Viewer viewer : viewerList) {
            if (!viewer.isViewable(dataset)) continue;
            sbuff.append("  <li> ");
            sbuff.append(viewer.getViewerLinkHtml(dataset, req));
            sbuff.append("</li>\n");
        }
        sbuff.append("</ul>\r\n");
    }

    protected String getPath() {
        return "view/";
    }

    protected void makeDebugActions() {
    }

    static {
        ViewServlet.registerViewer(new IDV());
        ViewServlet.registerViewer(new Nj22ToolsUI());
    }

    private static class IDV
    implements Viewer {
        private IDV() {
        }

        public boolean isViewable(InvDatasetImpl ds) {
            InvAccess access = ds.getAccess(ServiceType.DODS);
            if (access == null) {
                access = ds.getAccess(ServiceType.OPENDAP);
            }
            if (access == null) {
                return false;
            }
            DataType dt = ds.getDataType();
            return dt == DataType.GRID;
        }

        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            URI dataURI;
            InvAccess access = ds.getAccess(ServiceType.DODS);
            if (access == null) {
                access = ds.getAccess(ServiceType.OPENDAP);
            }
            if (!(dataURI = access.getStandardUri()).isAbsolute()) {
                try {
                    URI base = new URI(req.getRequestURL().toString());
                    dataURI = base.resolve(dataURI);
                }
                catch (URISyntaxException e) {
                    log.error("Resolve URL with " + req.getRequestURL(), (Throwable)e);
                }
            }
            return "<a href='" + req.getContextPath() + "/view/idv.jnlp?url=" + dataURI.toString() + "'>Integrated Data Viewer (IDV) (webstart)</a>";
        }
    }

    private static class Nj22ToolsUI
    implements Viewer {
        private Nj22ToolsUI() {
        }

        public boolean isViewable(InvDatasetImpl ds) {
            String id = ds.getID();
            return id != null && ds.hasAccess();
        }

        public String getViewerLinkHtml(InvDatasetImpl ds, HttpServletRequest req) {
            return "<a href='" + req.getContextPath() + "/view/nj22UI.jnlp?" + ds.getSubsetUrl() + "'>NetCDF-Java Tools (webstart)</a>";
        }
    }
}

