/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.idd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import javax.servlet.ServletException;
import thredds.servlet.AbstractServlet;
import thredds.servlet.idd.ThreddsServerPatterns;

public class LdmServlet
extends AbstractServlet {
    protected static ThreddsServerPatterns p = new ThreddsServerPatterns();
    protected static SimpleDateFormat dateFormatISO = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected static SimpleDateFormat dateFormat;

    public void init() throws ServletException {
        super.init();
    }

    protected void makeDebugActions() {
    }

    protected String getPath() {
        return "idd/";
    }

    public String[] getDAYS(String dirS, PrintWriter pw) {
        Date now = Calendar.getInstance().getTime();
        String check = dateFormat.format(now);
        File dir = new File(dirS);
        if (!dir.exists()) {
            return null;
        }
        String[] TMP = dir.list();
        ArrayList<String> days = new ArrayList<String>();
        for (int i = 0; i < TMP.length; ++i) {
            if (!ThreddsServerPatterns.p_B_D8.matcher(TMP[i]).find() || TMP[i].compareTo(check) > 0) continue;
            days.add(TMP[i]);
        }
        Collections.sort(days, new CompareKeyDescend());
        String[] DAYS = new String[days.size()];
        DAYS = days.toArray(DAYS);
        return DAYS;
    }

    public String[] boundingBox(String y0, String y1, String x0, String x1, String dqc, PrintWriter pw) throws FileNotFoundException, IOException {
        ArrayList<String> STNSal = new ArrayList<String>();
        float minLat = Float.parseFloat(y0);
        float maxLat = Float.parseFloat(y1);
        float minLon = Float.parseFloat(x0);
        float maxLon = Float.parseFloat(x1);
        BufferedReader br = LdmServlet.getInputStreamReader(dqc);
        String input = "";
        String stn = "";
        String stnLine = "";
        while ((input = br.readLine()) != null) {
            if (!ThreddsServerPatterns.p_station_name.matcher(input).find()) {
                if (pw == null) continue;
                pw.println(input);
                continue;
            }
            Matcher m = ThreddsServerPatterns.p_value2.matcher(input);
            if (!m.find()) continue;
            stnLine = input;
            stn = m.group(1);
            input = br.readLine();
            m = ThreddsServerPatterns.p_latitude_longitude.matcher(input);
            if (!m.find()) continue;
            float lat = Float.parseFloat(m.group(1));
            float lon = Float.parseFloat(m.group(2));
            boolean inBound = true;
            if (lat < minLat || lat > maxLat) {
                inBound = false;
            }
            if (lon < minLon || lon > maxLon) {
                inBound = false;
            }
            if (inBound) {
                if (pw != null) {
                    pw.println(stnLine);
                    pw.println(input);
                    input = br.readLine();
                    if (input.contains("</station>")) {
                        pw.println(input);
                    } else {
                        pw.println(input);
                        input = br.readLine();
                        pw.println(input);
                    }
                }
                if (stn.length() == 3) {
                    stn = stnLine.lastIndexOf(" US") > 0 ? "K" + stn : (stnLine.lastIndexOf(" CN") > 0 ? "C" + stn : "K" + stn);
                }
                STNSal.add(stn);
                continue;
            }
            input = br.readLine();
            if (input.contains("</station>")) continue;
            input = br.readLine();
        }
        br.close();
        STNSal.trimToSize();
        String[] stns = new String[STNSal.size()];
        for (int i = 0; i < STNSal.size(); ++i) {
            stns[i] = (String)STNSal.get(i);
        }
        return stns;
    }

    public static BufferedReader getInputStreamReader(String filename) throws FileNotFoundException, IOException {
        return new BufferedReader(new InputStreamReader(LdmServlet.getInputStream(filename)));
    }

    public static InputStream getInputStream(String filename) throws FileNotFoundException, IOException {
        return LdmServlet.getInputStream(filename, null);
    }

    public static InputStream getInputStream(String filename, Class origin) throws FileNotFoundException, IOException {
        File f;
        InputStream s = null;
        while (origin != null && (s = origin.getResourceAsStream(filename)) == null) {
            origin = origin.getSuperclass();
        }
        if (s == null) {
            s = LdmServlet.class.getResourceAsStream(filename);
        }
        if (s == null && (f = new File(filename)).exists()) {
            try {
                s = new FileInputStream(f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (s == null) {
            try {
                String encodedUrl = ThreddsServerPatterns.p_space20.matcher(filename).replaceAll(" ");
                URL dataUrl = new URL(encodedUrl);
                URLConnection connection = dataUrl.openConnection();
                s = connection.getInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s == null) {
            throw new FileNotFoundException("Unable to open:" + filename);
        }
        return s;
    }

    public boolean isValidDay(String dateDir, String yyyymmddStart, String yyyymmddEnd) {
        return dateDir.compareTo(yyyymmddStart) >= 0 && dateDir.compareTo(yyyymmddEnd) <= 0;
    }

    public boolean isValidDate(String dateReport, String dateStart, String dateEnd) {
        return dateReport.compareTo(dateStart) >= 0 && dateReport.compareTo(dateEnd) <= 0;
    }

    static {
        dateFormatISO.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected class CompareKeyDescend
    implements Comparator {
        protected CompareKeyDescend() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s2.compareTo(s1);
        }
    }
}

