/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.idd;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetarObservation {
    static final int missingValue = -9999;
    static final Pattern Station = Pattern.compile("^(\\w{4})\\s+");
    static final Pattern ddhhmmZ = Pattern.compile("(\\d{2})(\\d{2})(\\d{2})Z\\s+");
    static final Pattern Wind_direction_speed = Pattern.compile("(E|W|N|S)?(\\d{3}|VRB)(\\d{2,3})(G)?(\\d{2,3})?(KMH|KT|MPS|MPH)\\s+");
    static final Pattern WeatherPrecip = Pattern.compile("(\\+|-|VC|PR| )(MI|BC|DR|BL|SH|TS|FZ)?(DZ|RA|SN|SG|IC|PE|PL|GR|GS|UP)\\s+");
    static final Pattern WeatherObs = Pattern.compile("(\\+|-|VC|PR| )(MI|BC|DR|BL|SH|TS|FZ)?(BR|FG|FU|VA|DU|SA|HZ|PY)\\s+");
    static final Pattern WeatherOther = Pattern.compile("(\\+|-|VC|PR| )(MI|BC|DR|BL|SH|TS|FZ)?(PO|SQ|FC|SS|DS)\\s+");
    static final Pattern Temperature_tenths = Pattern.compile("T(0|1)(\\d{3})(0|1)?(\\d{3})?\\s+");
    static final Pattern Temperature = Pattern.compile("(M|-)?(\\d{2})/(M|-)?(\\d{2})?\\s*");
    static final Pattern Altimeter = Pattern.compile("(A|Q)(\\d{4}\\.?\\d?)\\s*");
    static final Pattern SLP = Pattern.compile("SLP\\s?(\\d{3})\\s+");
    static final Pattern Hourly_precip = Pattern.compile("P ?(\\d{1,5})\\s+");
    static final Pattern Metar = Pattern.compile("^(METAR|SPECI|TESTM|TESTS) ");
    protected static SimpleDateFormat dateFormatISO = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected String key;
    protected String station = null;
    protected String dateISO = null;
    protected long timeObs;
    protected int wind_direction = -9999;
    protected float wind_speed = -9999.0f;
    protected float wind_gust = -9999.0f;
    protected String weather = "";
    protected float air_temperature = -9999.0f;
    protected float dew_point_temperature = -9999.0f;
    protected float altimeter_inches = -9999.0f;
    protected float altimeter_hectopascals = -9999.0f;
    protected float sea_level_pressure = -9999.0f;
    protected float hourly_precipitation = -9999.0f;
    protected String report;
    protected int length;

    public MetarObservation() {
    }

    public MetarObservation(MetarObservation mo) {
        this.key = mo.key;
        this.station = mo.station;
        this.dateISO = mo.dateISO;
        this.timeObs = mo.timeObs;
        this.wind_direction = mo.wind_direction;
        this.wind_speed = mo.wind_speed;
        this.wind_gust = mo.wind_gust;
        this.weather = mo.weather;
        this.air_temperature = mo.air_temperature;
        this.dew_point_temperature = mo.dew_point_temperature;
        this.altimeter_inches = mo.altimeter_inches;
        this.altimeter_hectopascals = mo.altimeter_hectopascals;
        this.sea_level_pressure = mo.sea_level_pressure;
        this.hourly_precipitation = mo.hourly_precipitation;
        this.report = mo.report;
        this.length = mo.length;
    }

    public boolean decode(String input) {
        int minute;
        int hour;
        int day;
        Matcher m = Metar.matcher(input);
        if (m.find()) {
            input = m.replaceFirst("");
        }
        this.report = input;
        this.length = input.length();
        this.key = input.substring(0, 13);
        m = Station.matcher(input);
        if (!m.find()) {
            return false;
        }
        this.station = m.group(1);
        input = m.replaceFirst("");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int year = cal.get(1);
        int month = cal.get(2);
        int curDay = cal.get(5);
        int curHour = cal.get(11);
        m = ddhhmmZ.matcher(input);
        if (m.find()) {
            day = Integer.parseInt(m.group(1));
            hour = Integer.parseInt(m.group(2));
            minute = Integer.parseInt(m.group(3));
            input = m.replaceFirst("");
            if (day == curDay) {
                if (hour > curHour) {
                    return false;
                }
            } else {
                if (day < curDay - 1) {
                    return false;
                }
                if (day > curDay) {
                    if (curDay != 1 || day < 28) {
                        return false;
                    }
                    if (month != 0) {
                        --month;
                    } else {
                        --year;
                        month = 12;
                    }
                } else if (hour < curHour) {
                    return false;
                }
            }
        } else {
            return false;
        }
        cal.set(year, month, day, hour, minute, 0);
        this.timeObs = cal.getTimeInMillis();
        this.dateISO = dateFormatISO.format(cal.getTime());
        m = Wind_direction_speed.matcher(input);
        if (m.find()) {
            if (!m.group(2).equals("VRB")) {
                this.wind_direction = Integer.parseInt(m.group(2));
            }
            this.wind_speed = Float.parseFloat(m.group(3));
            if (m.group(4) != null && m.group(4).equals("G")) {
                this.wind_gust = Float.parseFloat(m.group(5));
            }
            input = m.replaceFirst("");
        }
        boolean done = true;
        StringBuilder WX = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            m = WeatherPrecip.matcher(input);
            if (m.find()) {
                done = false;
                if (!m.group(1).equals(" ")) {
                    WX.append(m.group(1));
                }
                if (m.group(2) != null) {
                    WX.append(m.group(2));
                }
                WX.append(m.group(3));
                input = m.replaceFirst("");
            }
            if ((m = WeatherObs.matcher(input)).find()) {
                done = false;
                if (!m.group(1).equals(" ")) {
                    WX.append(m.group(1));
                }
                if (m.group(2) != null) {
                    WX.append(m.group(2));
                }
                WX.append(m.group(3));
                input = m.replaceFirst("");
            }
            if ((m = WeatherOther.matcher(input)).find()) {
                done = false;
                if (!m.group(1).equals(" ")) {
                    WX.append(m.group(1));
                }
                if (m.group(2) != null) {
                    WX.append(m.group(2));
                }
                WX.append(m.group(3));
                input = m.replaceFirst("");
            }
            if (done) break;
            done = true;
            WX.append(" ");
        }
        if (WX.length() > 0) {
            WX.setLength(WX.length() - 1);
            this.weather = WX.toString();
        }
        if ((m = Temperature_tenths.matcher(input)).find()) {
            this.air_temperature = (float)((double)Float.parseFloat(m.group(2)) * 0.1);
            if (m.group(1).equals("1")) {
                this.air_temperature *= -1.0f;
            }
            if (m.group(3) != null) {
                this.dew_point_temperature = (float)((double)Float.parseFloat(m.group(4)) * 0.1);
                if (m.group(3).equals("1")) {
                    this.dew_point_temperature *= -1.0f;
                }
            }
            input = m.replaceFirst("");
        } else {
            m = Temperature.matcher(input);
            if (m.find()) {
                this.air_temperature = Float.parseFloat(m.group(2));
                if (m.group(1) != null) {
                    this.air_temperature *= -1.0f;
                }
                if (m.group(4) != null) {
                    this.dew_point_temperature = Float.parseFloat(m.group(4));
                    if (m.group(3) != null) {
                        this.dew_point_temperature *= -1.0f;
                    }
                }
                input = m.replaceFirst("");
            }
        }
        m = Altimeter.matcher(input);
        if (m.find()) {
            if (m.group(1).equals("A")) {
                this.altimeter_inches = (float)((double)Float.parseFloat(m.group(2)) * 0.01);
            } else {
                this.altimeter_hectopascals = Float.parseFloat(m.group(2));
            }
            input = m.replaceFirst("");
        }
        if ((m = SLP.matcher(input)).find()) {
            this.sea_level_pressure = Integer.parseInt(m.group(1)) >= 550 ? (float)((double)Float.parseFloat(m.group(1)) * 0.1 + 900.0) : (float)((double)Float.parseFloat(m.group(1)) * 0.1 + 1000.0);
            input = m.replaceFirst("");
        }
        if ((m = Hourly_precip.matcher(input)).find()) {
            this.hourly_precipitation = (float)((double)Float.parseFloat(m.group(1)) * 0.01);
            input = m.replaceFirst("");
        }
        return true;
    }

    public String toString() {
        return "key =" + this.key + "\nreport =" + this.report + "\nstation =" + this.station + "\ndateISO =" + this.dateISO + "\nwind_direction =" + this.wind_direction + "\nwind_speed =" + this.wind_speed + "\nwind_gust =" + this.wind_gust + "\nweather =" + this.weather + "\nair_temperature =" + this.air_temperature + "\ndew_point_temperature =" + this.dew_point_temperature + "\naltimeter_inches =" + this.altimeter_inches + "\naltimeter_hectopascals =" + this.altimeter_hectopascals + "\nsea_level_pressure =" + this.sea_level_pressure + "\nhourly_precipitation =" + this.hourly_precipitation;
    }

    static {
        dateFormatISO.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

