/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.idd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.servlet.ServletUtil;
import thredds.servlet.idd.LdmServlet;
import thredds.servlet.idd.MetarObservation;
import thredds.servlet.idd.MetarParseReport;
import thredds.servlet.idd.ThreddsServerPatterns;

public class MetarServlet
extends LdmServlet {
    protected static String catalogVersion;
    protected static String defaultCatalog;
    protected static String backgroundImage;
    protected static String metarDQC;
    protected static String metarDir;
    protected static String metarHTTPServiceName;
    protected static String metarHTTPServiceType;
    protected static String metarHTTPServiceBase;
    protected static String metarHTTPDataFormatType;
    protected static String metarDODSServiceName;
    protected static String metarDODSServiceType;
    protected static String metarDODSServiceBase;

    protected long getLastModified(HttpServletRequest req) {
        try {
            if (metarDir == null) {
                this.contentPath = ServletUtil.getContentPath(this);
                this.getConfigurations("buoy", null);
            }
            File file = new File(metarDQC);
            return file.lastModified();
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String dateStart = null;
        String dateEnd = null;
        String y0 = null;
        String y1 = null;
        String x0 = null;
        String x1 = null;
        String serviceName = null;
        String serviceType = null;
        String serviceBase = null;
        try {
            int i;
            PrintWriter pw;
            String returns;
            String dtime;
            String[] STNS;
            if (req != null) {
                ServletUtil.logServerAccessSetup(req);
                STNS = ServletUtil.getParameterValuesIgnoreCase(req, "stn");
                String[] PRODS = ServletUtil.getParameterValuesIgnoreCase(req, "PROD");
                dtime = ServletUtil.getParameterIgnoreCase(req, "dtime");
                dateStart = ServletUtil.getParameterIgnoreCase(req, "dateStart");
                dateEnd = ServletUtil.getParameterIgnoreCase(req, "dateEnd");
                returns = ServletUtil.getParameterIgnoreCase(req, "returns");
                if (returns == null) {
                    returns = "text";
                }
                if ((serviceType = ServletUtil.getParameterIgnoreCase(req, "serviceType")) == null) {
                    serviceType = "HTTPServer";
                }
                if ((serviceName = ServletUtil.getParameterIgnoreCase(req, "serviceName")) == null) {
                    serviceName = "HTTPServer";
                }
                y0 = ServletUtil.getParameterIgnoreCase(req, "y0");
                y1 = ServletUtil.getParameterIgnoreCase(req, "y1");
                x0 = ServletUtil.getParameterIgnoreCase(req, "x0");
                x1 = ServletUtil.getParameterIgnoreCase(req, "x1");
                if (ThreddsServerPatterns.p_catalog_i.matcher(returns).find()) {
                    res.setContentType("text/xml");
                } else if (ThreddsServerPatterns.p_xml_i.matcher(returns).find()) {
                    res.setContentType("text/xml");
                } else if (ThreddsServerPatterns.p_text_i.matcher(returns).find()) {
                    res.setContentType("text/plain");
                } else if (ThreddsServerPatterns.p_qc_or_dqc_i.matcher(returns).find()) {
                    res.setContentType("text/xml");
                } else if (ThreddsServerPatterns.p_html_i.matcher(returns).find()) {
                    res.setContentType("text/html");
                } else {
                    res.setContentType("text/plain");
                }
                pw = res.getWriter();
                this.contentPath = ServletUtil.getContentPath(this);
            } else {
                this.contentPath = "/home/rkambic/code/thredds/tds/src/main/initialContent/";
                pw = new PrintWriter(System.out, true);
                pw.println("command line testing");
                STNS = new String[2];
                STNS = null;
                dtime = "latest";
                returns = "text";
                serviceType = "HTTPServer";
                serviceName = "HTTPServer";
                y0 = "39";
                y1 = "40";
                x0 = "-105";
                x1 = "-104";
            }
            if (metarDir == null) {
                this.getConfigurations("buoy", pw);
            }
            if (metarDir == null) {
                return;
            }
            if (ThreddsServerPatterns.p_qc_or_dqc_i.matcher(returns).find()) {
                BufferedReader br = MetarServlet.getInputStreamReader(metarDQC);
                String input = "";
                while (true) {
                    if ((input = br.readLine()) == null) {
                        br.close();
                        return;
                    }
                    pw.println(input);
                }
            }
            if (ThreddsServerPatterns.p_DODS_i.matcher(serviceName).find()) {
                serviceName = metarDODSServiceName;
                serviceType = metarDODSServiceType;
                serviceBase = metarDODSServiceBase;
                returns = "catalog";
            } else {
                serviceName = metarHTTPServiceName;
                serviceType = metarHTTPServiceType;
                serviceBase = metarHTTPServiceBase;
            }
            if (ThreddsServerPatterns.p_catalog_i.matcher(returns).find()) {
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.print("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"");
                pw.println(" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"Metar datasets in near real time\" version=\"" + catalogVersion + "\">");
                pw.println("");
                pw.print("  <service name=\"" + serviceName + "\" serviceType=\"" + serviceType + "\"");
                pw.println(" base=\"" + serviceBase + "\"/>");
                pw.print("    <dataset name=\"Metar datasets for available stations and times\" collectionType=\"TimeSeries\" ID=\"returns=text&amp;");
                if (STNS != null) {
                    for (int i2 = 0; i2 < STNS.length; ++i2) {
                        pw.print("stn=" + STNS[i2] + "&amp;");
                    }
                } else if (y0 != null && y1 != null && x0 != null && x1 != null) {
                    pw.print("y0=" + y0 + "&amp;y1=" + y1 + "&amp;");
                    pw.print("x0=" + x0 + "&amp;x1=" + x1 + "&amp;");
                } else {
                    pw.print("stn=all&amp;");
                }
                if (dtime != null) {
                    pw.println("dtime=" + dtime + "\">");
                } else if (dateEnd != null) {
                    pw.println("dateStart=" + dateStart + "&amp;dateEnd=" + dateEnd + "\">");
                } else {
                    pw.println("dtime=latest\">");
                    dtime = "latest";
                }
                pw.println("    <metadata inherited=\"true\">");
                pw.println("      <dataType>Station</dataType>");
                pw.println("      <dataFormat>" + returns + "</dataFormat>");
                pw.println("      <serviceName>" + serviceName + "</serviceName>");
                pw.println("    </metadata>");
                pw.println();
                pw.println("   </dataset>");
                pw.println("</catalog>");
                return;
            }
            if (ThreddsServerPatterns.p_html_i.matcher(returns).find()) {
                pw.println("<Head><Title>THREDDS Metar Server</Title></Head>");
                pw.println("<body bgcolor=\"lightblue\" link=\"red\" alink=\"red\" vlink=\"red\">");
                pw.println("<center><H1>Metar Selection Results</H1></center>");
                pw.println("<pre>");
            } else if (!ThreddsServerPatterns.p_text_i.matcher(returns).find() && ThreddsServerPatterns.p_xml_i.matcher(returns).find()) {
                pw.println("<reports>");
            }
            if (STNS != null && (i = 0) < STNS.length) {
                return;
            }
            HashMap report = null;
            if (y0 != null && y1 != null && x0 != null && x1 != null) {
                STNS = this.boundingBox(y0, y1, x0, x1, metarDQC, null);
                pw.println("STNS.length=" + STNS.length + " =" + STNS[0]);
                if (STNS.length == 0) {
                    pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                    pw.println("    </dataset>");
                    pw.println("</catalog>");
                    return;
                }
            }
            if (dateEnd == null) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                long start = cal.getTimeInMillis();
                if (dtime == null || dtime.equals("latest")) {
                    start -= 3600000L;
                } else if (dtime.equals("1hour")) {
                    start -= 3600000L;
                } else if (dtime.equals("6hour")) {
                    start -= 21600000L;
                } else if (dtime.equals("12hour")) {
                    start -= 43200000L;
                } else if (dtime.equals("1day")) {
                    start -= 86400000L;
                } else if (dtime.equals("2day")) {
                    start -= 172800000L;
                } else if (dtime.equals("3day")) {
                    start -= 259200000L;
                } else if (dtime.equals("4day")) {
                    start -= 345600000L;
                } else if (dtime.equals("5day")) {
                    start -= 432000000L;
                } else if (dtime.equals("6day")) {
                    start -= 518400000L;
                } else {
                    if (!dtime.equals("7day") && !dtime.equals("all")) {
                        pw.println("<p>time is invalid " + dtime);
                        return;
                    }
                    start -= 604800000L;
                }
                if (y0 == null) {
                    // empty if block
                }
            } else {
                Date start = dateFormatISO.parse(dateStart);
                Date end = dateFormatISO.parse(dateEnd);
                if (y0 != null) {
                    // empty if block
                }
            }
            if (ThreddsServerPatterns.p_html_i.matcher(returns).find()) {
                pw.println("</pre>");
                pw.println("</html>");
            } else if (ThreddsServerPatterns.p_xml_i.matcher(returns).find()) {
                this.outputXML(report, pw);
                pw.println("</reports>");
            }
            if (req == null) return;
            ServletUtil.logServerAccess(200, -1L);
            return;
        }
        catch (Throwable t) {
            if (req == null) return;
            ServletUtil.handleException(t, res);
        }
    }

    public void outputXML(HashMap report, PrintWriter pw) {
        for (String key2 : report.keySet()) {
            MetarObservation ob = (MetarObservation)report.get(key2);
            MetarParseReport mpr = new MetarParseReport();
            mpr.parseReport(ob.report);
            LinkedHashMap field = mpr.getFields();
            HashMap unit = mpr.getUnits();
            if (field == null) {
                pw.println("return null Hash parse");
                return;
            }
            pw.println("<station name=\"" + ob.station + "\">");
            pw.println("\t<parameter name=\"Date\" value=\"" + ob.dateISO + " units=\"\"/>");
            pw.println("\t<parameter name=\"Report\" value=\"" + ob.report + "\" units=\"\"/>");
            for (String key2 : field.keySet()) {
                if (key2.equals("Day") || key2.equals("Hour") || key2.equals("Minute") || key2.equals("Station")) continue;
                pw.println("\t<parameter name=\"" + key2 + "\" value=\"" + (String)field.get(key2) + "\" units=\"" + (String)unit.get(key2) + "\"/>");
            }
            pw.println("</station>");
        }
    }

    public void getConfigurations(String stopAt, PrintWriter pw) throws FileNotFoundException, IOException {
        BufferedReader br;
        Pattern p_stop = Pattern.compile(stopAt);
        try {
            br = MetarServlet.getInputStreamReader(this.contentPath + this.getPath() + "ThreddsIDD.cfg");
        }
        catch (FileNotFoundException fnfe) {
            pw.println("<p>config not found " + this.contentPath + this.getPath() + "ThreddsIDD.cfg");
            return;
        }
        String input = "";
        while ((input = br.readLine()) != null) {
            if (ThreddsServerPatterns.p_B_pound.matcher(input).find() || input.length() == 0) continue;
            if (p_stop.matcher(input).find()) break;
            Matcher m = ThreddsServerPatterns.p_config.matcher(input);
            if (m.find()) {
                String variable = m.group(1);
                String value = ThreddsServerPatterns.p_spaces.matcher(m.group(2)).replaceAll("");
                if (variable.equals("catalogVersion")) {
                    catalogVersion = value;
                    continue;
                }
                if (variable.equals("defaultCatalog")) {
                    defaultCatalog = value;
                    continue;
                }
                if (variable.equals("backgroundImage")) {
                    backgroundImage = this.contentPath + this.getPath() + value;
                    continue;
                }
                if (variable.equals("metarDQC")) {
                    metarDQC = this.contentPath + this.getPath() + value;
                    continue;
                }
                if (variable.equals("metarDir")) {
                    metarDir = value;
                    continue;
                }
                if (variable.equals("metarHTTPServiceName")) {
                    metarHTTPServiceName = value;
                    continue;
                }
                if (variable.equals("metarHTTPServiceType")) {
                    metarHTTPServiceType = value;
                    continue;
                }
                if (variable.equals("metarHTTPServiceBase")) {
                    metarHTTPServiceBase = value;
                    continue;
                }
                if (variable.equals("metarHTTPDataFormatType")) {
                    metarHTTPDataFormatType = value;
                    continue;
                }
                if (variable.equals("metarDODSServiceName")) {
                    metarDODSServiceName = value;
                    continue;
                }
                if (variable.equals("metarDODSServiceType")) {
                    metarDODSServiceType = value;
                    continue;
                }
                if (!variable.equals("metarDODSServiceBase")) continue;
                metarDODSServiceBase = value;
                continue;
            }
            pw.println("error in configuration line parse");
        }
        br.close();
    }

    public static void main(String[] args) throws IOException, ServletException {
        MetarServlet ms = new MetarServlet();
        ms.doGet(null, null);
    }

    static {
        metarDir = null;
    }
}

