/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.idd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import thredds.servlet.ServletUtil;
import thredds.servlet.idd.LdmServlet;
import thredds.servlet.idd.ThreddsServerPatterns;

public class RadarLevel2Servlet
extends LdmServlet {
    protected static String catalogVersion;
    protected static String defaultCatalog;
    protected static String backgroundImage;
    protected static String radarLevel2DQC;
    protected static String radarLevel2Dir;
    protected static String radarLevel2HTTPServiceName;
    protected static String radarLevel2HTTPServiceType;
    protected static String radarLevel2HTTPServiceBase;
    protected static String radarLevel2HTTPDataFormatType;
    protected static String radarLevel2ASCIIServiceName;
    protected static String radarLevel2ASCIIUrlPath;
    protected static String radarLevel2ASCIIDataFormatType;
    protected static String radarLevel2ADDEServiceName;
    protected static String radarLevel2ADDEUrlPath;
    protected static String radarLevel2DODSServiceName;
    protected static String radarLevel2DODSServiceType;
    protected static String radarLevel2DODSServiceBase;

    protected long getLastModified(HttpServletRequest req) {
        try {
            if (radarLevel2Dir == null) {
                this.contentPath = ServletUtil.getContentPath(this);
                this.getConfigurations("synoptic", null);
            }
            File file = new File(radarLevel2DQC);
            return file.lastModified();
        }
        catch (FileNotFoundException fnfe) {
            return -1L;
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block79: {
            dateStart = null;
            dateEnd = null;
            y0 = null;
            y1 = null;
            x0 = null;
            x1 = null;
            serviceName = null;
            serviceType = null;
            serviceBase = null;
            urlPath = null;
            try {
                block81: {
                    block80: {
                        if (req == null) break block80;
                        ServletUtil.logServerAccessSetup(req);
                        STNS = ServletUtil.getParameterValuesIgnoreCase(req, "stn");
                        PRODS = ServletUtil.getParameterValuesIgnoreCase(req, "PROD");
                        dtime = ServletUtil.getParameterIgnoreCase(req, "dtime");
                        dateStart = ServletUtil.getParameterIgnoreCase(req, "dateStart");
                        dateEnd = ServletUtil.getParameterIgnoreCase(req, "dateEnd");
                        returns = ServletUtil.getParameterIgnoreCase(req, "returns");
                        if (returns == null) {
                            returns = "catalog";
                        }
                        if ((serviceType = ServletUtil.getParameterIgnoreCase(req, "serviceType")) == null) {
                            serviceType = "OPENDAP";
                        }
                        serviceName = ServletUtil.getParameterIgnoreCase(req, "serviceName");
                        urlPath = ServletUtil.getParameterIgnoreCase(req, "urlPath");
                        y0 = ServletUtil.getParameterIgnoreCase(req, "y0");
                        y1 = ServletUtil.getParameterIgnoreCase(req, "y1");
                        x0 = ServletUtil.getParameterIgnoreCase(req, "x0");
                        x1 = ServletUtil.getParameterIgnoreCase(req, "x1");
                        if (!serviceType.equals("")) ** GOTO lbl-1000
                        if (ThreddsServerPatterns.p_catalog_i.matcher(returns).find()) lbl-1000:
                        // 2 sources

                        {
                            res.setContentType("text/xml");
                        } else if (ThreddsServerPatterns.p_xml_i.matcher(returns).find()) {
                            res.setContentType("text/xml");
                        } else if (ThreddsServerPatterns.p_ascii_i.matcher(returns).find()) {
                            res.setContentType("text/plain");
                        } else if (ThreddsServerPatterns.p_qc_or_dqc_i.matcher(returns).find()) {
                            res.setContentType("text/xml");
                        } else if (ThreddsServerPatterns.p_html_i.matcher(returns).find()) {
                            res.setContentType("text/html");
                        } else {
                            res.setContentType("text/plain");
                        }
                        pw = res.getWriter();
                        this.contentPath = ServletUtil.getContentPath(this);
                        break block81;
                    }
                    this.contentPath = "/home/rkambic/code/thredds/tds/src/main/initialContent/";
                    pw = new PrintWriter(System.out, true);
                    pw.println("command line testing");
                    STNS = new String[]{"KFTG", "KFTG"};
                    STNS = null;
                    dtime = "latest";
                    returns = "catalog";
                    serviceType = "HTTPServer";
                    serviceType = "OPENDAP";
                    y0 = "39";
                    y0 = null;
                    y1 = "40";
                    x0 = "-105";
                    x1 = "-100";
                }
                if (RadarLevel2Servlet.radarLevel2Dir == null) {
                    this.getConfigurations("synoptic", pw);
                }
                if (ThreddsServerPatterns.p_qc_or_dqc_i.matcher(returns).find()) {
                    br = RadarLevel2Servlet.getInputStreamReader(RadarLevel2Servlet.radarLevel2DQC);
                    input = "";
                    while ((input = br.readLine()) != null) {
                        pw.println(input);
                    }
                    br.close();
                    return;
                }
                if (ThreddsServerPatterns.p_HTTPServer_i.matcher(serviceType).find()) {
                    serviceName = RadarLevel2Servlet.radarLevel2HTTPServiceName;
                    serviceType = RadarLevel2Servlet.radarLevel2HTTPServiceType;
                    serviceBase = RadarLevel2Servlet.radarLevel2HTTPServiceBase;
                } else if (ThreddsServerPatterns.p_DODS_i.matcher(serviceType).find()) {
                    serviceName = RadarLevel2Servlet.radarLevel2DODSServiceName;
                    serviceType = RadarLevel2Servlet.radarLevel2DODSServiceType;
                    serviceBase = RadarLevel2Servlet.radarLevel2DODSServiceBase;
                }
                if (!serviceType.equals("")) {
                    pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    pw.print("<catalog xmlns=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"");
                    pw.println(" xmlns:xlink=\"http://www.w3.org/1999/xlink\" name=\"Radar Level2 datasets in near real time\" version=\"" + RadarLevel2Servlet.catalogVersion + "\">");
                    pw.println("");
                    pw.print("  <service name=\"" + serviceName + "\" serviceType=\"" + serviceType + "\"");
                    pw.println(" base=\"" + serviceBase + "\"/>");
                    pw.print("    <dataset name=\"RadarLevel2 datasets for available stations and times\" collectionType=\"TimeSeries\" ID=\"serviceType=" + serviceType + "&amp;returns=" + returns + "&amp;");
                    if (STNS != null && !STNS[0].equals("all")) {
                        for (i = 0; i < STNS.length; ++i) {
                            pw.print("stn=" + STNS[i] + "&amp;");
                        }
                    } else if (y0 != null && y1 != null && x0 != null && x1 != null) {
                        pw.print("y0=" + y0 + "&amp;y1=" + y1 + "&amp;");
                        pw.print("x0=" + x0 + "&amp;x1=" + x1 + "&amp;");
                    } else {
                        pw.print("stn=all&amp;");
                        STNS = this.boundingBox("-90", "90", "-180", "180", RadarLevel2Servlet.radarLevel2DQC, null);
                    }
                    if (dtime != null) {
                        pw.println("dtime=" + dtime + "\">");
                    } else if (dateEnd != null) {
                        pw.println("dateStart=" + dateStart + "&amp;dateEnd=" + dateEnd + "\">");
                    } else {
                        pw.println("dtime=latest\">");
                        dtime = "latest";
                    }
                    pw.println("    <metadata inherited=\"true\">");
                    pw.println("      <dataType>Radial</dataType>");
                    pw.println("      <dataFormat>NEXRAD2</dataFormat>");
                    pw.println("      <serviceName>" + serviceName + "</serviceName>");
                    pw.println("    </metadata>");
                    pw.println();
                } else if (ThreddsServerPatterns.p_html_i.matcher(returns).find()) {
                    serviceBase = "/thredds/fileServer/nexrad/level2/";
                    pw.println("<Head><Title>THREDDS RadarLevel2 Server</Title></Head>");
                    pw.println("<body bgcolor=\"lightblue\" link=\"red\" alink=\"red\" vlink=\"red\">");
                    pw.println("<center><H1>RadarLevel2 Selection Results</H1></center>");
                } else if (!ThreddsServerPatterns.p_ascii_i.matcher(returns).find()) {
                    if (ThreddsServerPatterns.p_xml_i.matcher(returns).find()) {
                        pw.println("<reports>");
                    }
                }
                if (y0 != null && y1 != null && x0 != null && x1 != null) {
                    STNS = this.boundingBox(y0, y1, x0, x1, RadarLevel2Servlet.radarLevel2DQC, null);
                }
                if (STNS == null || STNS.length == 0) {
                    pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                    pw.println("    </dataset>");
                    pw.println("</catalog>");
                    return;
                }
                if (dateEnd == null) {
                    now = Calendar.getInstance();
                    dateEnd = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    if (dtime == null || dtime.equals("latest")) {
                        now.add(10, -120);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("1hour")) {
                        now.add(10, -1);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("6hour")) {
                        now.add(10, -6);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("12hour")) {
                        now.add(10, -12);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("1day")) {
                        now.add(10, -24);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("2day")) {
                        now.add(10, -48);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("3day")) {
                        now.add(10, -72);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("4day")) {
                        now.add(10, -96);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("5day")) {
                        now.add(10, -120);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (dtime.equals("all")) {
                        now.add(10, -168);
                        dateStart = RadarLevel2Servlet.dateFormatISO.format(now.getTime());
                    } else if (ThreddsServerPatterns.p_isodate.matcher(dtime).find()) {
                        dateStart = dateEnd = dtime;
                    } else {
                        pw.println("        <p>time is invalid " + dtime + "</p>");
                        pw.println("    </dataset>");
                        pw.println("</catalog>");
                        return;
                    }
                }
                yyyymmddStart = dateStart.substring(0, 4) + dateStart.substring(5, 7) + dateStart.substring(8, 10);
                yyyymmddEnd = dateEnd.substring(0, 4) + dateEnd.substring(5, 7) + dateEnd.substring(8, 10);
                nodata = true;
                for (j = 0; j < STNS.length; ++j) {
                    station = STNS[j];
                    timeStart = "Level2_" + station + "_" + yyyymmddStart + "_" + dateStart.substring(11, 13) + dateStart.substring(14, 16) + ".ar2v";
                    timeEnd = "Level2_" + station + "_" + yyyymmddEnd + "_" + dateEnd.substring(11, 13) + dateEnd.substring(14, 16) + ".ar2v";
                    notDone = true;
                    firstTime = true;
                    key = "";
                    var1 = "";
                    var2 = "";
                    var3 = "";
                    DAYS = this.getDAYS(RadarLevel2Servlet.radarLevel2Dir + "/" + station, pw);
                    if (DAYS == null || DAYS.length == 0) continue;
                    block5: for (i = 0; i < DAYS.length && notDone; ++i) {
                        if (!this.isValidDay(DAYS[i], yyyymmddStart, yyyymmddEnd)) continue;
                        day = DAYS[i].substring(0, 4) + "-" + DAYS[i].substring(4, 6) + "-";
                        times = new ArrayList<String>();
                        dir = new File(RadarLevel2Servlet.radarLevel2Dir + "/" + station + "/" + DAYS[i]);
                        TIMES = dir.list();
                        for (t = 0; t < TIMES.length; ++t) {
                            if (!this.isValidDate(TIMES[t], timeStart, timeEnd)) continue;
                            times.add(TIMES[t]);
                        }
                        Collections.sort(times, new LdmServlet.CompareKeyDescend());
                        for (t = 0; t < times.size(); ++t) {
                            if (ThreddsServerPatterns.p_html_i.matcher(returns).find()) {
                                if (firstTime) {
                                    pw.println("<h3>Report(s) for station " + station + "</h3>");
                                    firstTime = false;
                                    nodata = false;
                                }
                                pw.print("<p><a href=\"" + serviceBase + station + "/" + DAYS[i] + "/" + times.get(t) + "\">");
                                pw.println(times.get(t) + "</a></p>\n");
                            } else if (!serviceType.equals("")) {
                                nodata = false;
                                this.catalogOut((String)times.get(t), station, pw, serviceType, serviceBase, returns);
                            } else if (ThreddsServerPatterns.p_ascii_i.matcher(returns).find()) {
                                pw.println(times.get(t));
                            } else if (returns.equals("data")) {
                                pw.println("data for file" + times.get(t));
                                file = new File((String)times.get(t));
                                ServletUtil.returnFile(this, req, res, file, null);
                            }
                            if (dtime == null || !dtime.equals("latest")) continue;
                            notDone = false;
                            continue block5;
                        }
                    }
                }
                if (ThreddsServerPatterns.p_catalog_i.matcher(returns).find()) {
                    if (nodata) {
                        pw.println("      <documentation>No data available for station(s) and time range</documentation>");
                    }
                    pw.println("    </dataset>");
                    pw.println("</catalog>");
                } else if (ThreddsServerPatterns.p_html_i.matcher(returns).find()) {
                    pw.println("</html>");
                } else if (ThreddsServerPatterns.p_xml_i.matcher(returns).find()) {
                    pw.println("</reports>");
                }
                if (req != null) {
                    ServletUtil.logServerAccess(200, -1L);
                }
            }
            catch (Throwable t) {
                if (req == null) break block79;
                ServletUtil.handleException(t, res);
            }
        }
    }

    public void catalogOut(String product, String stn, PrintWriter pw, String serviceType, String serviceBase, String returns) {
        pw.println("      <dataset name=\"" + product + "\" ID=\"" + product.hashCode() + "\"");
        String pTime = product.substring(12, 16) + "-" + product.substring(16, 18) + "-" + product.substring(18, 20) + "T" + product.substring(21, 23) + ":" + product.substring(23, 25) + ":00";
        String pDay = product.substring(12, 20);
        pw.print("        urlPath=\"");
        pw.println(stn + "/" + pDay + "/" + product + "\">");
        pw.println("<date type=\"start of ob\">" + pTime + "</date>");
        pw.println("</dataset>");
    }

    public void outputData(String fileName, PrintWriter pw) {
    }

    public void getConfigurations(String stopAt, PrintWriter pw) throws FileNotFoundException, IOException {
        Pattern p_stop = Pattern.compile(stopAt);
        BufferedReader br = RadarLevel2Servlet.getInputStreamReader(this.contentPath + this.getPath() + "ThreddsIDD.cfg");
        String input = "";
        while ((input = br.readLine()) != null) {
            if (ThreddsServerPatterns.p_B_pound.matcher(input).find() || input.length() == 0) continue;
            if (p_stop.matcher(input).find()) break;
            Matcher m = ThreddsServerPatterns.p_config.matcher(input);
            if (m.find()) {
                String variable = m.group(1);
                String value = ThreddsServerPatterns.p_spaces.matcher(m.group(2)).replaceAll("");
                if (variable.equals("catalogVersion")) {
                    catalogVersion = value;
                    continue;
                }
                if (variable.equals("defaultCatalog")) {
                    defaultCatalog = value;
                    continue;
                }
                if (variable.equals("backgroundImage")) {
                    backgroundImage = this.contentPath + this.getPath() + value;
                    continue;
                }
                if (variable.equals("radarLevel2DQC")) {
                    radarLevel2DQC = this.contentPath + this.getPath() + value;
                    continue;
                }
                if (variable.equals("radarLevel2Dir")) {
                    radarLevel2Dir = value;
                    continue;
                }
                if (variable.equals("radarLevel2HTTPServiceName")) {
                    radarLevel2HTTPServiceName = value;
                    continue;
                }
                if (variable.equals("radarLevel2HTTPServiceType")) {
                    radarLevel2HTTPServiceType = value;
                    continue;
                }
                if (variable.equals("radarLevel2HTTPServiceBase")) {
                    radarLevel2HTTPServiceBase = value;
                    continue;
                }
                if (variable.equals("radarLevel2HTTPDataFormatType")) {
                    radarLevel2HTTPDataFormatType = value;
                    continue;
                }
                if (variable.equals("radarLevel2ASCIIServiceName")) {
                    radarLevel2ASCIIServiceName = value;
                    continue;
                }
                if (variable.equals("radarLevel2ASCIIUrlPath")) {
                    radarLevel2ASCIIUrlPath = value;
                    continue;
                }
                if (variable.equals("radarLevel2ASCIIDataFormatType")) {
                    radarLevel2ASCIIDataFormatType = value;
                    continue;
                }
                if (variable.equals("radarLevel2ADDEServiceName")) {
                    radarLevel2ADDEServiceName = value;
                    continue;
                }
                if (variable.equals("radarLevel2ADDEUrlPath")) {
                    radarLevel2ADDEUrlPath = value;
                    continue;
                }
                if (variable.equals("radarLevel2DODSServiceName")) {
                    radarLevel2DODSServiceName = value;
                    continue;
                }
                if (variable.equals("radarLevel2DODSServiceType")) {
                    radarLevel2DODSServiceType = value;
                    continue;
                }
                if (!variable.equals("radarLevel2DODSServiceBase")) continue;
                radarLevel2DODSServiceBase = value;
                continue;
            }
            pw.println("error in configuration line parse");
        }
        br.close();
    }

    public static void main(String[] args) throws IOException, ServletException {
        RadarLevel2Servlet ms = new RadarLevel2Servlet();
        ms.doGet(null, null);
    }

    static {
        radarLevel2Dir = null;
    }
}

