/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.restrict;

import edu.yale.its.tp.cas.client.CASAuthenticationException;
import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.Util;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.restrict.Authorizer;
import thredds.servlet.restrict.RoleSource;

public class CASAuthorizer
implements Authorizer {
    private static Logger log = LoggerFactory.getLogger(CASAuthorizer.class);
    public static final String LOGIN_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.loginUrl";
    public static final String VALIDATE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.validateUrl";
    public static final String SERVICE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serviceUrl";
    public static final String SERVERNAME_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serverName";
    public static final String RENEW_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.renew";
    public static final String AUTHORIZED_PROXY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.authorizedProxy";
    public static final String PROXY_CALLBACK_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.proxyCallbackUrl";
    public static final String WRAP_REQUESTS_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.wrapRequest";
    public static final String GATEWAY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.gateway";
    public static final String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    public static final String CAS_FILTER_RECEIPT = "edu.yale.its.tp.cas.client.filter.receipt";
    private static final String CAS_FILTER_GATEWAYED = "edu.yale.its.tp.cas.client.filter.didGateway";
    private String casLogin;
    private String casValidate;
    private String casServiceUrl;
    private String casServerName;
    private String casProxyCallbackUrl;
    private boolean casRenew;
    private boolean wrapRequest;
    private boolean casGateway = false;
    private List<String> authorizedProxies = new ArrayList<String>();
    private RoleSource db;

    public void init(HttpServlet config) throws ServletException {
        this.casLogin = config.getInitParameter(LOGIN_INIT_PARAM);
        this.casValidate = config.getInitParameter(VALIDATE_INIT_PARAM);
        this.casServiceUrl = config.getInitParameter(SERVICE_INIT_PARAM);
        String casAuthorizedProxy = config.getInitParameter(AUTHORIZED_PROXY_INIT_PARAM);
        this.casRenew = Boolean.valueOf(config.getInitParameter(RENEW_INIT_PARAM));
        this.casServerName = config.getInitParameter(SERVERNAME_INIT_PARAM);
        this.casProxyCallbackUrl = config.getInitParameter(PROXY_CALLBACK_INIT_PARAM);
        this.wrapRequest = Boolean.valueOf(config.getInitParameter(WRAP_REQUESTS_INIT_PARAM));
        this.casGateway = Boolean.valueOf(config.getInitParameter(GATEWAY_INIT_PARAM));
        if (this.casGateway && this.casRenew) {
            throw new ServletException("gateway and renew cannot both be true in filter configuration");
        }
        if (this.casServerName != null && this.casServiceUrl != null) {
            throw new ServletException("serverName and serviceUrl cannot both be set: choose one.");
        }
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("one of serverName or serviceUrl must be set.");
        }
        if (this.casServiceUrl != null && !this.casServiceUrl.startsWith("https://") && !this.casServiceUrl.startsWith("http://")) {
            throw new ServletException("service URL must start with http:// or https://; its current value is [" + this.casServiceUrl + "]");
        }
        if (this.casValidate == null) {
            throw new ServletException("validateUrl parameter must be set.");
        }
        if (!this.casValidate.startsWith("https://")) {
            throw new ServletException("validateUrl must start with https://, its current value is [" + this.casValidate + "]");
        }
        if (casAuthorizedProxy != null) {
            StringTokenizer casProxies = new StringTokenizer(casAuthorizedProxy);
            while (casProxies.hasMoreTokens()) {
                String anAuthorizedProxy = casProxies.nextToken();
                if (!anAuthorizedProxy.startsWith("https://")) {
                    throw new ServletException("CASFilter initialization parameter for authorized proxies must be a whitespace delimited list of authorized proxies.  Authorized proxies must be secure (https) addresses.  This one wasn't: [" + anAuthorizedProxy + "]");
                }
                this.authorizedProxies.add(anAuthorizedProxy);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("CASFilter initialized as: [" + this.toString() + "]");
        }
    }

    public void setRoleSource(RoleSource db) {
        this.db = db;
    }

    public boolean authorize(HttpServletRequest request, HttpServletResponse response, String role) throws ServletException, IOException {
        boolean ok;
        HttpSession session;
        CASReceipt receipt;
        if (log.isDebugEnabled()) {
            log.debug("entering authorize()");
        }
        if ((receipt = (CASReceipt)(session = request.getSession()).getAttribute(CAS_FILTER_RECEIPT)) != null && this.isReceiptAcceptable(receipt)) {
            log.debug("CAS_FILTER_RECEIPT attribute was present and acceptable..");
            boolean ok2 = this.authorize(receipt, role);
            if (!ok2) {
                response.setStatus(401);
            }
            return ok2;
        }
        String ticket = request.getParameter("ticket");
        if (ticket == null || ticket.equals("")) {
            log.debug("CAS ticket was not present on request.");
            boolean didGateway = Boolean.valueOf((String)session.getAttribute(CAS_FILTER_GATEWAYED));
            if (this.casLogin == null) {
                log.error("casLogin was not set, so filter cannot redirect request for authentication.");
                throw new ServletException("When CASFilter protects pages that do not receive a 'ticket' parameter, it needs a edu.yale.its.tp.cas.client.filter.loginUrl filter parameter");
            }
            if (!didGateway) {
                log.debug("Did not previously gateway.  Setting session attribute to true.");
                session.setAttribute(CAS_FILTER_GATEWAYED, (Object)"true");
                this.redirectToCAS(request, response);
                return false;
            }
            log.debug("Previously gatewayed.");
            if (this.casGateway || session.getAttribute(CAS_FILTER_USER) != null) {
                log.debug("casGateway was true and CAS_FILTER_USER set: ok.");
                boolean ok3 = this.authorize(receipt, role);
                if (!ok3) {
                    response.setStatus(401);
                }
                return ok3;
            }
            session.setAttribute(CAS_FILTER_GATEWAYED, (Object)"true");
            this.redirectToCAS(request, response);
            return false;
        }
        try {
            receipt = this.getAuthenticatedUser(request);
        }
        catch (CASAuthenticationException e) {
            log.error("failed to authenticate", (Throwable)e);
            response.setStatus(401);
            return false;
        }
        if (!this.isReceiptAcceptable(receipt)) {
            log.error("Authentication was technically successful but rejected as a matter of policy. [" + receipt + "]");
            response.setStatus(401);
            return false;
        }
        if (session != null) {
            session.setAttribute(CAS_FILTER_USER, (Object)receipt.getUserName());
            session.setAttribute(CAS_FILTER_RECEIPT, (Object)receipt);
            session.removeAttribute(CAS_FILTER_GATEWAYED);
        }
        if (log.isDebugEnabled()) {
            log.debug("validated ticket to get authenticated receipt [" + receipt + "], now passing request along filter chain.");
        }
        if (!(ok = this.authorize(receipt, role))) {
            response.setStatus(401);
        }
        return ok;
    }

    private boolean authorize(CASReceipt receipt, String role) {
        if (this.db == null) {
            return true;
        }
        String username = receipt.getUserName();
        return this.db.hasRole(username, role);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
    }

    private boolean isReceiptAcceptable(CASReceipt receipt) {
        if (receipt == null) {
            throw new IllegalArgumentException("Cannot evaluate a null receipt.");
        }
        if (this.casRenew && !receipt.isPrimaryAuthentication()) {
            return false;
        }
        return !receipt.isProxied() || this.authorizedProxies.contains(receipt.getProxyingService());
    }

    private CASReceipt getAuthenticatedUser(HttpServletRequest request) throws ServletException, CASAuthenticationException {
        log.debug("entering getAuthenticatedUser()");
        ProxyTicketValidator pv = new ProxyTicketValidator();
        pv.setCasValidateUrl(this.casValidate);
        pv.setServiceTicket(request.getParameter("ticket"));
        pv.setService(this.getService(request));
        pv.setRenew(this.casRenew);
        if (this.casProxyCallbackUrl != null) {
            pv.setProxyCallbackUrl(this.casProxyCallbackUrl);
        }
        if (log.isDebugEnabled()) {
            log.debug("about to validate ProxyTicketValidator: [" + pv + "]");
        }
        return CASReceipt.getReceipt((ProxyTicketValidator)pv);
    }

    private String getService(HttpServletRequest request) throws ServletException {
        log.debug("entering getService()");
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: edu.yale.its.tp.cas.client.filter.serviceUrl or edu.yale.its.tp.cas.client.filter.serverName");
        }
        String serviceString = this.casServiceUrl != null ? URLEncoder.encode(this.casServiceUrl) : Util.getService((HttpServletRequest)request, (String)this.casServerName);
        if (log.isDebugEnabled()) {
            log.debug("returning from getService() with service [" + serviceString + "]");
        }
        return serviceString;
    }

    private void redirectToCAS(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("entering redirectToCAS()");
        }
        String casLoginString = this.casLogin + "?service=" + this.getService(request) + (this.casRenew ? "&renew=true" : "") + (this.casGateway ? "&gateway=true" : "");
        if (log.isDebugEnabled()) {
            log.debug("Redirecting browser to [" + casLoginString + ")");
        }
        response.sendRedirect(casLoginString);
        if (log.isDebugEnabled()) {
            log.debug("returning from redirectToCAS()");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[CASFilter:");
        sb.append(" casGateway=");
        sb.append(this.casGateway);
        sb.append(" wrapRequest=");
        sb.append(this.wrapRequest);
        sb.append(" casAuthorizedProxies=[");
        sb.append(this.authorizedProxies);
        sb.append("]");
        if (this.casLogin != null) {
            sb.append(" casLogin=[");
            sb.append(this.casLogin);
            sb.append("]");
        } else {
            sb.append(" casLogin=NULL!!!!!");
        }
        if (this.casProxyCallbackUrl != null) {
            sb.append(" casProxyCallbackUrl=[");
            sb.append(this.casProxyCallbackUrl);
            sb.append("]");
        }
        if (this.casRenew) {
            sb.append(" casRenew=true");
        }
        if (this.casServerName != null) {
            sb.append(" casServerName=[");
            sb.append(this.casServerName);
            sb.append("]");
        }
        if (this.casServiceUrl != null) {
            sb.append(" casServiceUrl=[");
            sb.append(this.casServiceUrl);
            sb.append("]");
        }
        if (this.casValidate != null) {
            sb.append(" casValidate=[");
            sb.append(this.casValidate);
            sb.append("]");
        } else {
            sb.append(" casValidate=NULL!!!");
        }
        return sb.toString();
    }

    public void destroy() {
    }
}

