/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.restrict;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;
import thredds.servlet.restrict.Authorizer;
import thredds.servlet.restrict.RoleDatabase;
import thredds.servlet.restrict.RoleSource;
import thredds.servlet.restrict.TomcatAuthorizer;

public class RestrictedDatasetServlet
extends HttpServlet {
    private static Logger log;
    private static Authorizer handler;
    private static boolean initOK;
    private static boolean debugResourceControl;

    public void init() throws ServletException {
        super.init();
        log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        String authName = this.getInitParameter("Authorizer");
        if (authName != null) {
            Authorizer authObject;
            block11: {
                Class<?> authClass;
                try {
                    authClass = Class.forName(authName);
                }
                catch (ClassNotFoundException e) {
                    throw new ServletException("Cant find class " + authName, (Throwable)e);
                }
                try {
                    authObject = (Authorizer)authClass.newInstance();
                    String roleSourceName = this.getInitParameter("RoleSource");
                    if (roleSourceName != null) {
                        try {
                            Class<?> clazz = Class.forName(roleSourceName);
                            RoleSource rs = (RoleSource)clazz.newInstance();
                            authObject.setRoleSource(rs);
                            break block11;
                        }
                        catch (ClassNotFoundException e) {
                            log.error("Failed to instantiate " + roleSourceName, (Throwable)e);
                            throw new ServletException("Failed to instantiate " + roleSourceName, (Throwable)e);
                        }
                    }
                    String roleDBfile = this.getInitParameter("RoleDatabase");
                    if (roleDBfile == null) break block11;
                    try {
                        RoleDatabase db = new RoleDatabase(roleDBfile);
                        authObject.setRoleSource(db);
                    }
                    catch (IOException e) {
                        log.error("Failed to read in RoleDatabase " + roleDBfile, (Throwable)e);
                        throw new ServletException("Failed to read in RoleDatabase " + roleDBfile, (Throwable)e);
                    }
                }
                catch (InstantiationException e) {
                    log.error("Cant instantiate class " + authName, (Throwable)e);
                    throw new ServletException("Cant instantiate class " + authName, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("Cant access class " + authName, (Throwable)e);
                    throw new ServletException("Cant access class " + authName, (Throwable)e);
                }
            }
            authObject.init(this);
            handler = authObject;
        }
        initOK = true;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (debugResourceControl) {
            System.out.println("RestrictedDatasetServlet = " + ServletUtil.getRequest(req));
        }
        handler.doGet(req, res);
    }

    public static boolean authorize(HttpServletRequest req, HttpServletResponse res, String role) throws IOException, ServletException {
        return initOK && handler.authorize(req, res, role);
    }

    static {
        handler = new TomcatAuthorizer();
        initOK = false;
        debugResourceControl = true;
    }
}

